/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dTree;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import oracle.bali.ewt.dTree.DTree;
import oracle.bali.ewt.dTree.DTreeDragSupport;
import oracle.bali.ewt.dTree.DTreeItem;
import oracle.bali.ewt.dTree.DTreeSelection;
import oracle.bali.ewt.dTree.DTreeSelectionManager;
import oracle.bali.ewt.graphics.ImageUtils;

class JDKDragger
implements DragSourceListener,
DragGestureListener {
    private DTreeSelection _dragItems;
    private DTreeDragSupport _dragSupport;
    DragGestureRecognizer _recognizer;

    public JDKDragger(DTreeDragSupport support) {
        this._dragSupport = support;
        DragSource source = DragSource.getDefaultDragSource();
        this._recognizer = source.createDefaultDragGestureRecognizer(support.getTree(), 0x40000003, this);
    }

    public void dispose() {
        this._recognizer.setComponent(null);
        this._recognizer.removeDragGestureListener(this);
        this._recognizer = null;
        this._dragSupport = null;
    }

    public void dragGestureRecognized(DragGestureEvent evt) {
        if (this._dragSupport.isEnabled()) {
            Transferable transferable;
            DTreeSelection selection;
            int sourceActions;
            DTree tree = this._dragSupport.getTree();
            Point dragOrigin = evt.getDragOrigin();
            Point canvascoords = tree.convertOuterToCanvas(dragOrigin.x, dragOrigin.y);
            DTreeItem item = tree.getDraggableItemAt(canvascoords.x, canvascoords.y);
            DTreeSelectionManager selManager = tree.getSelectionManager();
            if (item != null && selManager.isSelected(item) && (sourceActions = this._dragSupport.getSourceActions(selection = this._dragSupport.getTransferSelection())) != 0 && (transferable = this._dragSupport.createTransferable(selection)) != null) {
                this._setDragItems(selection);
                Image image = this._dragSupport.createDragImage(selection, item);
                if (image == null) {
                    evt.startDrag(null, transferable, this);
                    return;
                }
                Point offset = new Point(item.getX() - canvascoords.x, item.getY() - canvascoords.y);
                Dimension itemSize = item.getSize();
                ImageUtils.loadImage(image);
                int imageWidth = image.getWidth(tree);
                int imageHeight = image.getHeight(tree);
                if (imageWidth < itemSize.width || imageHeight < itemSize.height) {
                    offset.x = 10;
                    offset.y = 22;
                }
                evt.startDrag(null, image, offset, transferable, this);
            }
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        int action = dsde.getDropSuccess() ? dsde.getDropAction() : 0;
        this._dragSupport.dragDropEnd(this._getDragItems(), action);
    }

    public void dragEnter(DragSourceDragEvent dsde) {
    }

    public void dragOver(DragSourceDragEvent dsde) {
    }

    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    public void dragExit(DragSourceEvent dsde) {
    }

    private DTreeSelection _getDragItems() {
        return this._dragItems;
    }

    private void _setDragItems(DTreeSelection dragItems) {
        if (this._dragItems != dragItems) {
            DTree tree = this._dragSupport.getTree();
            if (this._dragItems != null) {
                tree.putClientProperty("_ewtDTreeDragItems", null);
                tree.__removeSelection(this._dragItems);
            }
            this._dragItems = dragItems;
            if (this._dragItems != null) {
                tree.__addSelection(this._dragItems);
                tree.putClientProperty("_ewtDTreeDragItems", this._dragItems);
            }
        }
    }
}

