/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.graphics.ColorUtils;

class HexEditor
extends JTextField {
    public static final String PROPERTY_COLOR = "color";
    private static final char _HASH = '#';
    private boolean _ignoreEvent;

    public HexEditor() {
        super(null);
        this.setColumns(7);
        this.enableEvents(4L);
    }

    public void replaceSelection(String content) {
        Document doc = this.getDocument();
        String replacedText = null;
        int p0 = -1;
        int p1 = -1;
        if (doc != null) {
            try {
                Caret caret = this.getCaret();
                p0 = Math.min(caret.getDot(), caret.getMark());
                p1 = Math.max(caret.getDot(), caret.getMark());
                if (p0 != p1) {
                    replacedText = doc.getText(p0, p1 - p0);
                    this._ignoreEvent = true;
                    doc.remove(p0, p1 - p0);
                    this._ignoreEvent = false;
                }
                if (content != null && content.length() > 0) {
                    doc.insertString(p0, content, null);
                } else if (replacedText != null) {
                    this._fireColorChanged(this.getColor());
                }
            }
            catch (BadLocationException e) {
                if (replacedText != null) {
                    try {
                        this._ignoreEvent = true;
                        doc.insertString(p0, replacedText, null);
                        this.select(p0, p1);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                }
                this.getToolkit().beep();
            }
        }
        this._ignoreEvent = false;
    }

    public Color getColor() {
        String text = this.getText();
        if (text == null) {
            return null;
        }
        return ColorUtils.htmlToColor(text);
    }

    public void setColor(Color c) {
        this._ignoreEvent = true;
        this.setText(ColorUtils.colorToHTML(c));
        this._ignoreEvent = false;
    }

    protected Document createDefaultModel() {
        return new HexDocument();
    }

    protected void processFocusEvent(FocusEvent e) {
        super.processFocusEvent(e);
        if (e.getID() == 1005) {
            int length;
            String text = this.getText();
            int n = length = text == null ? 0 : text.length();
            if (length != 7) {
                this.setColor(this.getColor());
            }
        }
    }

    private boolean _validateString(String s, int offset) {
        String oldText = this.getText();
        int oldLength = oldText.length();
        int hashIndex = oldText.indexOf(35);
        int location = 0;
        for (int i = 0; i < s.length(); ++i) {
            location = offset + i;
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                if (location != 0 || hashIndex < 0) continue;
                return false;
            }
            if (c == '#') {
                if (location == 0) continue;
                return false;
            }
            if (c >= 'a' && c <= 'f') {
                if (location != 0 || hashIndex < 0) continue;
                return false;
            }
            if (c >= 'A' && c <= 'F') {
                if (location != 0 || hashIndex < 0) continue;
                return false;
            }
            return false;
        }
        String newString = null;
        newString = offset == 0 ? s + oldText : (offset >= oldLength ? oldText + s : oldText.substring(0, offset) + s + oldText.substring(offset, oldLength));
        int length = newString.length();
        if (length > 7) {
            return false;
        }
        return length != 7 || newString.indexOf(35) != -1;
    }

    private void _fireColorChanged(Color newColor) {
        if (!this._ignoreEvent) {
            this.firePropertyChange(PROPERTY_COLOR, null, newColor);
        }
    }

    private class HexDocument
    extends PlainDocument {
        private HexDocument() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null || str.length() == 0) {
                return;
            }
            if (!HexEditor.this._validateString(str, offs)) {
                throw new BadLocationException(null, offs);
            }
            super.insertString(offs, str, a);
        }

        protected void fireInsertUpdate(DocumentEvent e) {
            super.fireInsertUpdate(e);
            HexEditor.this._fireColorChanged(HexEditor.this.getColor());
        }

        protected void fireChangedUpdate(DocumentEvent e) {
            super.fireChangedUpdate(e);
            HexEditor.this._fireColorChanged(HexEditor.this.getColor());
        }

        protected void fireRemoveUpdate(DocumentEvent e) {
            super.fireRemoveUpdate(e);
            HexEditor.this._fireColorChanged(HexEditor.this.getColor());
        }
    }
}

