/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.ColorChooserPane;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.layout.EqualColumnLayout;
import oracle.bali.ewt.model.NullTwoDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class ColorPalettePane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR_PALETTE = "colorPalette";
    public static final String PROPERTY_SELECTED_COLOR = "selectedColor";
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_COLOR_NAME = "COLORPALETTE.COLOR_NAME";
    private static final String _KEY_TITLE = "COLORPALETTE.COLOR_PALETTE_TITLE";
    private static final String _KEY_LABEL = "COLORPALETTE.AVAILABLE_COLORS";
    private static final String _KEY_CUSTOM_LABEL = "COLORPALETTE.CUSTOM_COLORS";
    private static final String _KEY_EDIT = "COLORPALETTE.EDIT_COLOR";
    private static final String _EDIT_NAME = "Edit_Custom_Color_Button";
    private static final String _GRID_NAME = "Available_Colors_Grid";
    private static final String _CUSTOM_GRID_NAME = "Custom_Colors_Grid";
    private Listener _listener = new Listener();
    private ColorGrid _grid = new ColorGrid(false);
    private JLabel _label;
    private JButton _editButton;
    private JLabel _colorName;
    private JLabel _colorNameLabel;
    private JPanel _colorNameComponent;
    private JPanel _customButtonPanel;
    private TwoDModel _names;
    private TwoDModel _customNames;
    private ColorGrid _customGrid;
    private JLabel _customLabel;
    private ColorChooserPane _colorChooserPane;
    private boolean _ignoreEvents;
    private boolean _chooserVisible;

    public static int showDialog(Component parent, ColorPalettePane pane) {
        return ColorPalettePane.showDialog(parent, pane, null, false);
    }

    public static int showDialog(Component parent, ColorPalettePane pane, String dialogTitle, boolean resizable) {
        if (pane == null) {
            throw new IllegalArgumentException("ColorPalettePane must be non-null");
        }
        Locale l = LocaleUtils.getDefaultableLocale((Component)pane);
        if (dialogTitle == null) {
            ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, l);
            dialogTitle = b.getString(_KEY_TITLE);
        }
        JEWTDialog d = JEWTDialog.createDialog(parent, dialogTitle, 7);
        d.setLocale(l);
        d.setContent(pane);
        d.setCenterOver(parent);
        d.setResizable(resizable);
        d.setInitialFocus(pane._getInitialFocus());
        int ret = d.runDialog() ? 1 : 2;
        d.dispose();
        return ret;
    }

    public ColorPalettePane() {
        this(null);
    }

    public ColorPalettePane(TwoDModel colorPalette) {
        this(colorPalette, null, false);
    }

    public ColorPalettePane(TwoDModel colorPalette, Color selectedColor, boolean editButtonVisible) {
        this(colorPalette, selectedColor, editButtonVisible, null);
    }

    public ColorPalettePane(TwoDModel colorPalette, Color selectedColor, boolean editButtonVisible, TwoDModel customPalette) {
        this._grid.__setSelectedSlotEnabled(true);
        this._grid.addPropertyChangeListener(this._listener);
        this._grid.setName(_GRID_NAME);
        this._label = new JLabel("");
        this._label.setLabelFor(this._grid);
        this._editButton = new JButton("");
        this._editButton.setActionCommand(_KEY_EDIT);
        this._editButton.addActionListener(this._listener);
        this._editButton.setName(_EDIT_NAME);
        this._customGrid = new ColorGrid(true);
        this._customGrid.__setSelectedSlotEnabled(true);
        this._customGrid.addPropertyChangeListener(this._listener);
        this._customGrid.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (ColorPalettePane.this.isEnabled() && !e.isConsumed() && e.getClickCount() == 2) {
                    ColorPalettePane.this._editColor();
                }
            }
        });
        this._customGrid.setName(_CUSTOM_GRID_NAME);
        this._customLabel = new JLabel("");
        this._customLabel.setLabelFor(this._customGrid);
        this._customButtonPanel = new JPanel(new EqualColumnLayout(5));
        this._colorName = new JLabel("");
        this._colorNameLabel = new JLabel("");
        this._colorNameComponent = new JPanel();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this.setLayout(new BorderLayout(5, 5));
        JPanel bottomLeft = new JPanel();
        bottomLeft.setLayout(new BorderLayout(0, 3));
        bottomLeft.add("North", this._customLabel);
        JPanel temp = new JPanel();
        temp.setLayout(new BorderLayout(0, 3));
        temp.add("North", this._customGrid);
        temp.add("Center", this._editButton);
        bottomLeft.add("Center", temp);
        JPanel gridPanel = new JPanel(new BorderLayout());
        gridPanel.add((Component)this._grid, "West");
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout(0, 5));
        leftPanel.add("North", gridPanel);
        leftPanel.add("South", bottomLeft);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout(5, 5));
        mainPanel.add("West", leftPanel);
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout(5, 5));
        rightPanel.add("North", this._customButtonPanel);
        mainPanel.add("Center", rightPanel);
        this.add("North", this._label);
        this.add("Center", mainPanel);
        this.add("South", this._colorNameComponent);
        this.setColorNameVisible(false);
        this.setColorPalette(colorPalette);
        this.setCustomColorsVisible(customPalette != null);
        this.setCustomColorPalette(customPalette);
        this.setSelectedColor(selectedColor);
        this.setEditVisible(editButtonVisible);
    }

    public void setColorPalette(TwoDModel colors) {
        this._grid.setColorPalette(colors);
    }

    public TwoDModel getColorPalette() {
        return this._grid.getColorPalette();
    }

    public void setCustomColorPalette(TwoDModel colors) {
        TwoDModel old = this._customGrid.getColorPalette();
        if (colors == null) {
            colors = NullTwoDModel.getTwoDModel();
        }
        this._customGrid.setColorPalette(colors);
        this.firePropertyChange(PROPERTY_COLOR_PALETTE, old, colors);
    }

    public TwoDModel getCustomColorPalette() {
        TwoDModel colors = this._customGrid.getColorPalette();
        if (colors == NullTwoDModel.getTwoDModel()) {
            colors = null;
        }
        return colors;
    }

    public void setEditVisible(boolean visible) {
        this._editButton.setVisible(visible);
        this._revalidate();
    }

    public boolean isEditVisible() {
        return this._editButton.isVisible();
    }

    public void setSelectedColor(Color c) {
        this.setSelectedColor(c, false);
    }

    public Color getSelectedColor() {
        if (this.isCustomColorSelected()) {
            return this._customGrid.getSelectedColor();
        }
        return this._grid.getSelectedColor();
    }

    public boolean isCustomColorSelected() {
        return this._customGrid.isVisible() && this._customGrid.__getSelectedColumn() != -1 && this._customGrid.__getSelectedRow() != -1;
    }

    public void setSelectedColor(Color c, boolean colorInCustomPalette) {
        if (colorInCustomPalette) {
            this._grid.setSelectedColor(null);
            this._customGrid.setSelectedColor(c);
        } else {
            this._customGrid.setSelectedColor(null);
            this._grid.setSelectedColor(c);
        }
        this._updateEditButton();
    }

    public void setColorNames(TwoDModel names) {
        if (this._names != names) {
            if (this._names != null) {
                this._names.removeModelListener(this._listener);
            }
            this._names = names;
            this._grid.__setColorNames(this._names);
            if (this._names != null) {
                this._names.addModelListener(this._listener);
            }
        }
    }

    public TwoDModel getColorNames() {
        return this._names;
    }

    public void setCustomColorNames(TwoDModel names) {
        if (this._customNames != names) {
            if (this._customNames != null) {
                this._customNames.removeModelListener(this._listener);
            }
            this._customNames = names;
            this._customGrid.__setColorNames(this._names);
            if (this._customNames != null) {
                this._customNames.addModelListener(this._listener);
            }
        }
    }

    public TwoDModel getCustomColorNames() {
        return this._customNames;
    }

    public void setColorName(String name) {
        Color selectedColor = this.getSelectedColor();
        if (selectedColor != null) {
            this._colorName.setText(name);
            boolean isCustom = this.isCustomColorSelected();
            TwoDModel ds = isCustom ? this.getCustomColorNames() : this.getColorNames();
            ColorGrid source = isCustom ? this._customGrid : this._grid;
            int x = source.__getSelectedColumn();
            int y = source.__getSelectedRow();
            if (x != -1 && y != -1 && ds != null && x < ds.getColumnCount() && y < ds.getRowCount()) {
                ds.setData(x, y, name);
            }
        }
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setCustomColorsVisible(boolean visible) {
        this._customLabel.setVisible(visible);
        this._customGrid.setVisible(visible);
        if (!visible) {
            this._customGrid.__setSelectedSlot(-1, -1, false);
        }
        this._revalidate();
    }

    public boolean isCustomColorsVisible() {
        return this._customGrid.isVisible();
    }

    public void setColorNameVisible(boolean visible) {
        this._colorNameComponent.setVisible(visible);
        this._revalidate();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void addCustomComponent(Component component) {
        this._customButtonPanel.add(component);
        this._revalidate();
    }

    public void removeCustomComponent(Component component) {
        this._customButtonPanel.remove(component);
        this._revalidate();
    }

    public int getCustomComponentCount() {
        return this._customButtonPanel.getComponentCount();
    }

    public Component getCustomComponent(int index) {
        return this._customButtonPanel.getComponent(index);
    }

    public ColorChooserPane getColorChooserPane() {
        if (this._colorChooserPane == null) {
            this._colorChooserPane = new ColorChooserPane();
            this._colorChooserPane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        }
        return this._colorChooserPane;
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        if (this._names != null) {
            this._names.removeModelListener(this._listener);
        }
        if (this._customNames != null) {
            this._customNames.removeModelListener(this._listener);
        }
        this._listener = null;
        this._names = null;
        this._customNames = null;
        this._grid.dispose();
        this._grid = null;
        this._customGrid.dispose();
        this._customGrid = null;
        this._label = null;
        this._colorName = null;
        this._colorNameLabel = null;
        this._customLabel = null;
        this._colorNameComponent = null;
        this._customButtonPanel = null;
        this._editButton = null;
        if (this._colorChooserPane != null) {
            this._colorChooserPane.dispose();
        }
        this._colorChooserPane = null;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._grid.setEnabled(enabled);
        this._customGrid.setEnabled(enabled);
        this._updateEditButton();
        this._label.setEnabled(enabled);
        this._customLabel.setEnabled(enabled);
        this._colorNameLabel.setEnabled(enabled);
        this._colorName.setEnabled(enabled);
    }

    public void addNotify() {
        super.addNotify();
        Font f = this._colorNameLabel.getFont();
        if (f != null && !f.isBold()) {
            int style = f.getStyle() | 1;
            f = new Font(f.getName(), style, f.getSize());
            this._colorNameLabel.setFont(f);
        }
        this._setText(this.getLocale());
    }

    public void updateUI() {
        super.updateUI();
        if (this._colorChooserPane != null) {
            SwingUtilities.updateComponentTreeUI(this._colorChooserPane);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColorPalettePane();
        }
        return this.accessibleContext;
    }

    public void setLocale(Locale newLocale) {
        super.setLocale(newLocale);
        if (this._label != null) {
            this._setText(newLocale);
        }
    }

    private void _setText(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
        String translatedText = b.getString(_KEY_LABEL);
        this._label.setText(StringUtils.stripMnemonic((String)translatedText));
        this._label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = b.getString(_KEY_EDIT);
        this._editButton.setText(StringUtils.stripMnemonic((String)translatedText));
        this._editButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = b.getString(_KEY_CUSTOM_LABEL);
        this._customLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._customLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        translatedText = b.getString(_KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._grid.setLocale(locale);
        this._customGrid.setLocale(locale);
    }

    private void _updateEditButton() {
        boolean enabled = this.isCustomColorSelected() && this.isEnabled();
        this._editButton.setEnabled(enabled);
    }

    private void _updateColorName() {
        String name = null;
        boolean isCustom = this.isCustomColorSelected();
        TwoDModel ds = isCustom ? this.getCustomColorNames() : this.getColorNames();
        ColorGrid source = isCustom ? this._customGrid : this._grid;
        int x = source.__getSelectedColumn();
        int y = source.__getSelectedRow();
        if (x != -1 && y != -1 && ds != null && x < ds.getColumnCount() && y < ds.getRowCount()) {
            Object data = ds.getData(x, y);
            name = data instanceof String ? data.toString() : null;
        }
        this._colorName.setText(name);
    }

    private void _editColor() {
        if (this._chooserVisible) {
            return;
        }
        this._chooserVisible = true;
        ColorChooserPane pane = this.getColorChooserPane();
        pane.setLocale(LocaleUtils.getDefaultableLocale((Component)this));
        String oldName = this.getColorName();
        Color c = this.getSelectedColor();
        if (c == null) {
            c = Color.gray;
        }
        pane.setOriginalColor(c);
        pane.setColor(c);
        pane.setColorNameVisible(this.isColorNameVisible());
        pane.setColorName(oldName);
        if (ColorChooserPane.showDialog(this, pane) == 1) {
            String newName;
            Color oldColor = this._customGrid.getSelectedColor();
            Color newColor = pane.getColor();
            this._customGrid.__replaceSelectedSlotColor(newColor);
            this.firePropertyChange(PROPERTY_COLOR_PALETTE, null, this.getColorPalette());
            this.firePropertyChange(PROPERTY_SELECTED_COLOR, oldColor, newColor);
            if (this.isColorNameVisible() && oldName != (newName = pane.getColorName())) {
                this.setColorName(newName);
            }
        }
        this._chooserVisible = false;
    }

    private void _selectedColorChanged(ColorGrid source, Color oldColor, Color newColor) {
        boolean colorSelected;
        if (this._ignoreEvents) {
            return;
        }
        boolean bl = colorSelected = source.__getSelectedColumn() != -1 && source.__getSelectedRow() != -1;
        if (colorSelected) {
            this._ignoreEvents = true;
            if (source == this._grid) {
                this._customGrid.setSelectedColor(null);
            } else {
                this._grid.setSelectedColor(null);
            }
            this._ignoreEvents = false;
            this.repaint();
        }
        this._updateSelectedSlots();
        this._updateColorName();
        this._updateEditButton();
        this.firePropertyChange(PROPERTY_SELECTED_COLOR, oldColor, newColor);
    }

    private void _updateSelectedSlots() {
        int col = this._grid.__getSelectedColumn();
        int row = this._grid.__getSelectedRow();
        this._grid.__setSelectedSlot(col, row, false);
        col = this._customGrid.__getSelectedColumn();
        row = this._customGrid.__getSelectedRow();
        this._customGrid.__setSelectedSlot(col, row, false);
    }

    private void _revalidate() {
        this.invalidate();
        this.repaint();
    }

    private Component _getInitialFocus() {
        return this.isCustomColorSelected() ? this._customGrid : this._grid;
    }

    private class Listener
    extends TwoDModelAdapter
    implements ActionListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (ColorPalettePane.PROPERTY_SELECTED_COLOR.equals(name)) {
                ColorPalettePane.this._selectedColorChanged((ColorGrid)e.getSource(), (Color)e.getOldValue(), (Color)e.getNewValue());
            }
        }

        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (ColorPalettePane._KEY_EDIT.equals(cmd)) {
                ColorPalettePane.this._editColor();
            }
        }

        public void rowsAdded(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }

        public void rowsRemoved(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateRows(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }

        public void columnsAdded(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }

        public void columnsRemoved(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateColumns(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }

        public void invalidateCells(TwoDModelEvent e) {
            ColorPalettePane.this._updateColorName();
        }
    }

    private class AccessibleColorPalettePane
    extends JComponent.AccessibleJComponent {
        private AccessibleColorPalettePane() {
            super(ColorPalettePane.this);
        }
    }
}

