/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.ewt.chooser.color.ColorChoice;
import oracle.bali.ewt.chooser.color.ColorGrid;
import oracle.bali.ewt.chooser.color.ColorPalettePane;
import oracle.bali.ewt.chooser.color.ColorPickerPane;
import oracle.bali.ewt.chooser.color.ColorPickerUtils;
import oracle.bali.ewt.chooser.color.CustomColorPane;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.GridKeyHandler;
import oracle.bali.ewt.grid.NullInputHandler;
import oracle.bali.ewt.grid.ProxyInputHandler;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.FocusUtils;

class ColorChoiceListener
extends MouseInputAdapter
implements KeyListener,
ItemListener,
PropertyChangeListener,
FocusListener {
    private static final String _LABELED_BY_PROPERTY = "labeledBy";
    private static GridKeyHandler _sColorGridKeyHandler;
    private ColorChoice _colorChoice;
    private boolean _customPaletteDirty;
    private boolean _selectedColorDirty;

    public ColorChoiceListener(ColorChoice choice) {
        this._colorChoice = choice;
        this._registerColorChoice();
    }

    public void unregisterColorChoice() {
        this._colorChoice.removeKeyListener(this);
        this._colorChoice.removeMouseListener(this);
        this._colorChoice.removeMouseMotionListener(this);
        this._colorChoice.removeFocusListener(this);
        this._colorChoice.removePropertyChangeListener(this);
        this._colorChoice = null;
    }

    public void registerColorPickerPane(ColorPickerPane pane) {
        pane.addPropertyChangeListener(this);
    }

    public void unregisterColorPickerPane(ColorPickerPane pane) {
        pane.removePropertyChangeListener(this);
    }

    public void registerToggleButtons(JToggleButton button) {
        InputMap inputMap = button.getInputMap();
        if (inputMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(10, 0, false), inputMap.get(KeyStroke.getKeyStroke(32, 0, false)));
            inputMap.put(KeyStroke.getKeyStroke(10, 0, true), inputMap.get(KeyStroke.getKeyStroke(32, 0, true)));
        }
        button.addKeyListener(this);
        button.addItemListener(this);
    }

    public void unregisterToggleButtons(JToggleButton button) {
        button.removeKeyListener(this);
        button.removeItemListener(this);
    }

    public void registerColorGrid(ColorGrid grid) {
        grid.addKeyListener(this);
        grid.addFocusListener(this);
        grid.addPropertyChangeListener(this);
        CellInputHandler handler = grid.getDefaultInputHandler();
        grid.setDefaultInputHandler(new ColorGridInputHandler(handler));
        grid.setGridKeyHandler(ColorChoiceListener._getWrappingColorGridKeyHandler());
    }

    public void unregisterColorGrid(ColorGrid grid) {
        grid.removeKeyListener(this);
        grid.removeFocusListener(this);
        grid.removePropertyChangeListener(this);
    }

    public void registerCustomButton(JButton button) {
        button.addKeyListener(this);
    }

    public void unregisterCustomButton(JButton button) {
        button.removeKeyListener(this);
    }

    public boolean showColorPalettePane(ColorPalettePane pane) {
        boolean ok;
        pane.addPropertyChangeListener(this);
        this._customPaletteDirty = false;
        this._selectedColorDirty = false;
        this._colorChoice.__setCustomDialogVisible(true);
        this._colorChoice.__setDropDownVisible(false);
        boolean bl = ok = ColorPalettePane.showDialog(this._colorChoice, pane) == 1;
        if (ok) {
            this._colorChoice.requestFocus();
            this._colorChoice.__setCustomDialogVisible(false);
            this._colorChoice.firePropertyChange("popupVisible", Boolean.TRUE, Boolean.FALSE);
            if (this._customPaletteDirty) {
                TwoDModel customPalette = this._colorChoice.getCustomColorPalette();
                ColorPickerUtils.copyModel(pane.getCustomColorPalette(), customPalette);
                this._colorChoice.firePropertyChange("customColorPalette", null, customPalette);
            }
            if (this._selectedColorDirty) {
                this._colorChoice.setSelectedColor(pane.getSelectedColor());
            }
        } else {
            this._colorChoice.__setDropDownVisible(true);
            this._colorChoice.__setCustomDialogVisible(false);
            this._setFocusOnCustomButton();
        }
        pane.removePropertyChangeListener(this);
        return ok;
    }

    public boolean showCustomColorPane(CustomColorPane pane) {
        boolean ok;
        this._colorChoice.__setCustomDialogVisible(true);
        this._colorChoice.__setDropDownVisible(false);
        boolean bl = ok = CustomColorPane.showDialog(this._colorChoice, pane) == 1;
        if (ok) {
            this._colorChoice.requestFocus();
            this._colorChoice.__setCustomDialogVisible(false);
            this._colorChoice.firePropertyChange("popupVisible", Boolean.TRUE, Boolean.FALSE);
        } else {
            this._colorChoice.__setDropDownVisible(true);
            this._colorChoice.__setCustomDialogVisible(false);
            this._setFocusOnCustomButton();
        }
        return ok;
    }

    public void mousePressed(MouseEvent me) {
        if (me.getComponent() == this._colorChoice && !me.isConsumed() && this._colorChoice.isEnabled() && SwingUtilities.isLeftMouseButton(me) && this._colorChoice.contains(me.getX(), me.getY())) {
            this._colorChoice.__setDropDownVisible(!this._colorChoice.__isDropDownVisible());
            me.consume();
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (me.getComponent() == this._colorChoice && this._colorChoice.isEnabled() && !me.isConsumed() && this._colorChoice.__isDropDownVisible() && (!this._colorChoice.__canDispatchMouseEventToGrid() || this._dispatchMouseEventToGrid(me))) {
            me.consume();
        }
    }

    public void mouseDragged(MouseEvent me) {
        if (me.getComponent() == this._colorChoice && this._colorChoice.isEnabled() && !me.isConsumed() && this._colorChoice.__isDropDownVisible() && this._dispatchMouseEventToGrid(me)) {
            me.consume();
        }
    }

    public void keyPressed(KeyEvent ke) {
        Component comp = ke.getComponent();
        if (!comp.isEnabled()) {
            return;
        }
        int modifiers = ke.getModifiers();
        int keyCode = ke.getKeyCode();
        boolean consume = false;
        switch (keyCode) {
            case 32: {
                if (modifiers != 0 || comp != this._colorChoice || this._colorChoice.__isDropDownVisible()) break;
                this._colorChoice.__setDropDownVisible(true);
                consume = true;
                break;
            }
            case 38: 
            case 40: {
                if (modifiers != 8) break;
                this._colorChoice.__setDropDownVisible(!this._colorChoice.__isDropDownVisible());
                consume = true;
                break;
            }
            case 27: {
                if (modifiers != 0 || !this._colorChoice.__isDropDownVisible()) break;
                this._colorChoice.__setDropDownVisible(false);
                consume = true;
                break;
            }
            case 9: {
                if (ke.isMetaDown() || !this._colorChoice.__isDropDownVisible()) break;
                consume = this._transferFocus(comp, !ke.isShiftDown());
            }
        }
        if (!consume && this._colorChoice.__isDropDownVisible()) {
            if (comp instanceof ColorGrid) {
                consume = ColorChoiceListener._handleKeyEventInGrid((ColorGrid)comp, ke);
            }
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(ke);
            if (!consume) {
                consume = ColorChoiceListener._processKeyBinding((JComponent)comp, ks, ke, 0);
            }
            ColorPickerPane pane = this._colorChoice.__getColorPickerPane();
            if (!consume && comp == this._colorChoice) {
                ColorGrid colorGrid = pane.__getStandardGrid();
                consume = this._dispatchKeyEventToGrid(colorGrid, ke);
            }
            if (!consume) {
                consume = ColorChoiceListener._processWindowBinding(pane, ks, ke);
            }
        }
        if (consume || this._colorChoice.__isDropDownVisible()) {
            ke.consume();
        }
    }

    public void keyReleased(KeyEvent ke) {
        Component comp = ke.getComponent();
        if (comp == this._colorChoice.getClientProperty(_LABELED_BY_PROPERTY)) {
            int keyCode;
            if (!ke.isConsumed() && ke.getModifiers() == 8 && this._colorChoice.isShowing() && this._colorChoice.isEnabled() && ((keyCode = ke.getKeyCode()) == 0 || keyCode == ((JLabel)comp).getDisplayedMnemonic())) {
                this._colorChoice.__setDropDownVisible(true);
            }
        } else if (this._colorChoice.__isDropDownVisible()) {
            KeyStroke ks = KeyStroke.getKeyStrokeForEvent(ke);
            if (!ColorChoiceListener._processKeyBinding((JComponent)comp, ks, ke, 0)) {
                ColorChoiceListener._processWindowBinding(this._colorChoice.__getColorPickerPane(), ks, ke);
            }
            ke.consume();
        }
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void focusGained(FocusEvent fe) {
        Component comp = fe.getComponent();
        if (comp instanceof ColorGrid) {
            ColorGrid grid = (ColorGrid)comp;
            Cell focusCell = grid.getFocusCell();
            if (focusCell == null) {
                int col = grid.getNextVisibleColumn(-1);
                int row = grid.getNextVisibleRow(-1);
                if (col != -1 && row != -1) {
                    grid.scrollCellIntoView(col, row);
                }
            } else {
                grid.scrollCellIntoView(focusCell.column, focusCell.row);
            }
        }
    }

    public void focusLost(FocusEvent fe) {
        if (fe.getComponent() == this._colorChoice && this._colorChoice.__isDropDownVisible()) {
            Cell cell;
            ColorGrid grid = this._colorChoice.__getColorPickerPane().__getStandardGrid();
            if (FocusUtils.getOppositeComponent(fe) != grid && (cell = grid.getFocusCell()) != null) {
                CellInputHandler hand = grid.getColumnCellInputHandler(cell.column);
                hand.focusLost(null, grid, cell.column, cell.row);
            }
        }
    }

    public void itemStateChanged(ItemEvent ie) {
        this._colorChoice.__setDropDownVisible(false);
    }

    public void propertyChange(PropertyChangeEvent pe) {
        Object source = pe.getSource();
        String name = pe.getPropertyName();
        Object oldValue = pe.getOldValue();
        Object newValue = pe.getNewValue();
        if (source instanceof ColorPickerPane) {
            String property = null;
            if ("automaticSelected".equals(name)) {
                property = "automaticSelected";
            } else if ("customColorPalette".equals(name)) {
                property = "customColorPalette";
            } else if ("defaultSelected".equals(name)) {
                property = "defaultSelected";
            } else if ("selectedColor".equals(name)) {
                property = "selectedColor";
            } else if ("customColorNames".equals(name)) {
                property = "customColorNames";
            }
            if (property != null) {
                this._colorChoice.firePropertyChange(property, oldValue, newValue);
            }
        } else if (source instanceof ColorPalettePane) {
            if ("colorPalette".equals(name)) {
                this._customPaletteDirty = true;
            } else if ("selectedColor".equals(name)) {
                this._selectedColorDirty = true;
            }
        } else if (source instanceof ColorGrid) {
            Cell cell;
            ColorGrid grid = (ColorGrid)source;
            if (!grid.isCustomGrid() && "focusCell".equals(name) && this._colorChoice.hasFocus() && this._colorChoice.__isDropDownVisible() && (cell = (Cell)newValue) != null) {
                Color c = (Color)grid.getModel().getData(cell.column, cell.row);
                String accName = grid.getAccessibleName(cell.column, cell.row, c);
                this._colorChoice.__fireAccessibleEvent(accName);
            }
        } else if (source == this._colorChoice) {
            if (_LABELED_BY_PROPERTY.equals(name)) {
                if (oldValue instanceof JLabel) {
                    ((JLabel)oldValue).removeKeyListener(this);
                }
                if (newValue instanceof JLabel) {
                    ((JLabel)newValue).addKeyListener(this);
                }
            } else if ("popupVisible".equals(name) && Boolean.TRUE.equals(newValue) && (!FocusUtils.areNewFocusAPIsAvailable() || FocusUtils.isFocusable(this._colorChoice))) {
                ColorGrid grid = this._colorChoice.__getColorPickerPane().__getStandardGrid();
                Cell cell = grid.getFocusCell();
                if (cell == null) {
                    int col = grid.getNextVisibleColumn(-1);
                    int row = grid.getNextVisibleRow(-1);
                    if (col != -1 && row != -1) {
                        grid.requestFocus(col, row, null);
                        grid.scrollCellIntoView(col, row);
                    }
                } else {
                    CellInputHandler handler = grid.getColumnCellInputHandler(cell.column);
                    handler.focusGained(null, grid, cell.column, cell.row);
                    grid.scrollCellIntoView(cell.column, cell.row);
                }
            }
        }
    }

    private static GridKeyHandler _getWrappingColorGridKeyHandler() {
        if (_sColorGridKeyHandler == null) {
            _sColorGridKeyHandler = new WrappingColorGridKeyHandler();
        }
        return _sColorGridKeyHandler;
    }

    private static boolean _processKeyBinding(JComponent comp, KeyStroke ks, KeyEvent ke, int condition) {
        Action action;
        ActionMap am;
        Object binding;
        if (!comp.isEnabled() || !comp.isVisible()) {
            return false;
        }
        InputMap map = comp.getInputMap(condition);
        if (map != null && (binding = map.get(ks)) != null && (am = comp.getActionMap()) != null && (action = am.get(binding)) != null) {
            return SwingUtilities.notifyAction(action, ks, ke, comp, ke.getModifiers());
        }
        return false;
    }

    private static boolean _processWindowBinding(Container container, KeyStroke ks, KeyEvent ke) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof JComponent) || !ColorChoiceListener._processKeyBinding((JComponent)children[i], ks, ke, 2)) continue;
            return true;
        }
        return false;
    }

    private static final boolean _handleKeyEventInGrid(ColorGrid grid, KeyEvent ke) {
        Cell focusCell = grid.getFocusCell();
        if (focusCell != null) {
            CellInputHandler hand = grid.getColumnCellInputHandler(focusCell.column);
            hand.keyPressed(ke, grid, focusCell.column, focusCell.row);
        }
        if (ke.isConsumed()) {
            return true;
        }
        GridKeyHandler keyHandler = grid.getGridKeyHandler();
        if (keyHandler != null) {
            keyHandler.handleKeyEvent(grid, ke);
        }
        return ke.isConsumed();
    }

    private static boolean _handleMouseEventInGrid(Component source, MouseEvent me, ColorGrid grid) {
        int x = me.getX();
        int y = me.getY();
        Point p = SwingUtilities.convertPoint(source, x, y, grid);
        if (grid.contains(p.x, p.y)) {
            Point cellPoint = grid.convertOuterToCanvas(p.x, p.y);
            int col = grid.getColumnAt(cellPoint.x);
            int row = grid.getRowAt(cellPoint.y);
            if (col != -1 && row != -1) {
                CellInputHandler handler = grid.getColumnCellInputHandler(col);
                int id = me.getID();
                if (id == 506) {
                    grid.requestFocus(col, row, null);
                    return true;
                }
                if (id == 502) {
                    cellPoint.translate(-grid.getColumnPosition(col), -grid.getRowPosition(row));
                    MouseEvent event = new MouseEvent(grid, id, me.getWhen(), me.getModifiers(), cellPoint.x, cellPoint.y, me.getClickCount(), me.isPopupTrigger());
                    handler.mouseReleased(event, grid, col, row);
                    return event.isConsumed();
                }
            }
        }
        return false;
    }

    private void _registerColorChoice() {
        ColorChoice choice = this._colorChoice;
        KeyStroke enterP = KeyStroke.getKeyStroke(10, 0, true);
        choice.getInputMap(0).put(enterP, "none");
        KeyStroke renteR = KeyStroke.getKeyStroke(10, 0, false);
        choice.getInputMap(0).put(renteR, "none");
        KeyStroke spaceP = KeyStroke.getKeyStroke(32, 0, true);
        choice.getInputMap(0).put(spaceP, "none");
        KeyStroke spaceR = KeyStroke.getKeyStroke(32, 0, false);
        choice.getInputMap(0).put(spaceR, "none");
        choice.addKeyListener(this);
        choice.addMouseListener(this);
        choice.addMouseMotionListener(this);
        choice.addFocusListener(this);
        choice.addPropertyChangeListener(this);
    }

    private void _setFocusOnCustomButton() {
        final JButton b = this._colorChoice.__getColorPickerPane().__getCustomButton();
        if (FocusUtils.areNewFocusAPIsAvailable()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    b.requestFocus();
                }
            });
        } else {
            b.requestFocus();
        }
    }

    private boolean _dispatchKeyEventToGrid(ColorGrid colorGrid, KeyEvent ke) {
        KeyEvent event = new KeyEvent(colorGrid, ke.getID(), ke.getWhen(), ke.getModifiers(), ke.getKeyCode(), ke.getKeyChar());
        return ColorChoiceListener._handleKeyEventInGrid(colorGrid, event);
    }

    private boolean _dispatchMouseEventToGrid(MouseEvent me) {
        boolean consumed = false;
        int x = me.getX();
        int y = me.getY();
        ColorPickerPane pane = this._colorChoice.__getColorPickerPane();
        ColorGrid colorGrid = pane.__getStandardGrid();
        JViewport viewP = null;
        for (Container parent = colorGrid.getParent(); parent != null && parent != pane; parent = parent.getParent()) {
            if (!(parent instanceof JViewport)) continue;
            viewP = (JViewport)parent;
            break;
        }
        if (viewP != null) {
            Point p = SwingUtilities.convertPoint(this._colorChoice, x, y, viewP);
            if (!viewP.contains(p.x, p.y)) {
                return false;
            }
        }
        if (!(consumed = ColorChoiceListener._handleMouseEventInGrid(this._colorChoice, me, colorGrid))) {
            ColorGrid customGrid = pane.__getCustomGrid();
            consumed = ColorChoiceListener._handleMouseEventInGrid(this._colorChoice, me, customGrid);
        }
        return consumed;
    }

    private boolean _transferFocus(Component comp, boolean forward) {
        ColorPickerPane pane = this._colorChoice.__getColorPickerPane();
        List focusComps = pane.__getFocusCycle();
        int size = focusComps.size();
        if (size > 0) {
            int index = -1;
            if (comp == this._colorChoice) {
                comp = pane.__getStandardGrid();
            }
            if ((index = focusComps.indexOf(comp)) != -1) {
                if (forward) {
                    index = index == size - 1 ? 0 : index + 1;
                } else {
                    int n = index = index == 0 ? size - 1 : index - 1;
                }
            }
            if (index != -1) {
                ((Component)focusComps.get(index)).requestFocus();
                return true;
            }
        }
        return false;
    }

    private class ColorGridInputHandler
    extends ProxyInputHandler {
        public ColorGridInputHandler(CellInputHandler handler) {
            super(handler);
        }

        public void mousePressed(MouseEvent me, Grid grid, int column, int row) {
            CellInputHandler handler = NullInputHandler.getCellInputHandler();
            handler.mousePressed(me, grid, column, row);
        }

        public void mouseReleased(MouseEvent me, Grid grid, int column, int row) {
            super.mouseReleased(me, grid, column, row);
            if (me.isConsumed()) {
                ColorChoiceListener.this._colorChoice.__setDropDownVisible(false);
            }
        }

        public void keyPressed(KeyEvent ke, Grid grid, int col, int row) {
            int mod = ke.getModifiers();
            int code = ke.getKeyCode();
            if (mod == 0 && (code == 32 || code == 10)) {
                ColorGrid cGrid = (ColorGrid)grid;
                cGrid.__setSelectedColor(col, row);
                ColorChoiceListener.this._colorChoice.__setDropDownVisible(false);
                ke.consume();
            }
        }
    }

    private static class WrappingColorGridKeyHandler
    extends StandardGridKeyHandler {
        private WrappingColorGridKeyHandler() {
        }

        protected Cell enter(Grid grid, Cell focusCell, KeyEvent e, boolean shiftDown) {
            return focusCell;
        }

        protected Cell left(Grid grid, Cell focusCell, KeyEvent e) {
            int focusRow = -1;
            int focusColumn = -1;
            if (focusCell == null) {
                focusRow = grid.getPreviousVisibleRow(grid.getRowCount());
                focusColumn = grid.getPreviousVisibleColumn(grid.getColumnCount());
            } else {
                focusRow = focusCell.row;
                focusColumn = grid.getPreviousVisibleColumn(focusCell.column);
                if (focusColumn == -1) {
                    focusColumn = grid.getPreviousVisibleColumn(grid.getColumnCount());
                }
            }
            if (focusColumn == -1 || focusRow == -1) {
                return focusCell;
            }
            return new Cell(focusColumn, focusRow);
        }

        protected Cell right(Grid grid, Cell focusCell, KeyEvent e) {
            int focusRow = -1;
            int focusColumn = -1;
            if (focusCell == null) {
                focusRow = grid.getNextVisibleRow(-1);
                focusColumn = grid.getNextVisibleColumn(-1);
            } else {
                focusRow = focusCell.row;
                focusColumn = grid.getNextVisibleColumn(focusCell.column);
                if (focusColumn == -1) {
                    focusColumn = grid.getNextVisibleColumn(-1);
                }
            }
            if (focusColumn == -1 || focusRow == -1) {
                return focusCell;
            }
            return new Cell(focusColumn, focusRow);
        }

        protected Cell up(Grid grid, Cell focusCell, KeyEvent e) {
            int focusRow = -1;
            int focusColumn = -1;
            if (focusCell == null) {
                focusColumn = grid.getPreviousVisibleColumn(grid.getColumnCount());
                focusRow = grid.getPreviousVisibleRow(grid.getRowCount());
            } else {
                focusColumn = focusCell.column;
                focusRow = grid.getPreviousVisibleRow(focusCell.row);
                if (focusRow == -1) {
                    focusRow = grid.getPreviousVisibleColumn(grid.getRowCount());
                }
            }
            if (focusColumn == -1 || focusRow == -1) {
                return focusCell;
            }
            return new Cell(focusColumn, focusRow);
        }

        protected Cell down(Grid grid, Cell focusCell, KeyEvent e) {
            int focusRow;
            int focusColumn;
            if (focusCell == null) {
                focusColumn = grid.getNextVisibleColumn(-1);
                focusRow = grid.getNextVisibleRow(-1);
            } else {
                focusColumn = focusCell.column;
                focusRow = grid.getNextVisibleRow(focusCell.row);
                if (focusRow == -1) {
                    focusRow = grid.getNextVisibleRow(-1);
                }
            }
            if (focusColumn == -1 || focusRow == -1) {
                return focusCell;
            }
            return new Cell(focusColumn, focusRow);
        }

        protected Cell pageUp(Grid grid, Cell focusCell, KeyEvent e) {
            return this.up(grid, focusCell, e);
        }

        protected Cell pageDown(Grid grid, Cell focusCell, KeyEvent e) {
            return this.down(grid, focusCell, e);
        }

        protected Cell home(Grid grid, Cell focusCell, KeyEvent e) {
            return new Cell(grid.getNextVisibleColumn(-1), grid.getNextVisibleRow(-1));
        }

        protected Cell end(Grid grid, Cell focusCell, KeyEvent e) {
            return new Cell(grid.getPreviousVisibleColumn(grid.getColumnCount()), grid.getPreviousVisibleRow(grid.getRowCount()));
        }
    }
}

