/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.Timer;
import oracle.bali.ewt.spinBox.SpinAccelerator;

public abstract class ContinuousButtonModel
extends DefaultButtonModel
implements ActionListener {
    private AbstractButton _button;
    private SpinAccelerator _accelerator;
    private int _delay;
    private transient Timer _timer;
    private transient boolean _spinning;
    private static final int _DEFAULT_DELAY = 200;

    protected ContinuousButtonModel(AbstractButton button) {
        this(button, 200, null);
    }

    protected ContinuousButtonModel(AbstractButton button, int delay, SpinAccelerator accelerator) {
        this._button = button;
        this._delay = delay;
        this._accelerator = accelerator;
    }

    public AbstractButton getButton() {
        return this._button;
    }

    public int getDelay() {
        return this._delay;
    }

    public SpinAccelerator getAccelerator() {
        return this._accelerator;
    }

    public Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer(this.getDelay(), this);
        }
        return this._timer;
    }

    public void stopTimer() {
        Timer timer = this._timer;
        if (timer != null && timer.isRunning()) {
            timer.stop();
        }
    }

    public void setArmedState(boolean armed) {
        if (armed) {
            this.setArmed(true);
            super.setPressed(true);
        } else {
            this.setArmed(false);
            this.setPressed(false);
        }
    }

    public void setPressed(boolean isPressed) {
        if (isPressed != this.isPressed()) {
            super.setPressed(isPressed);
            this._updateSpinning(isPressed);
        }
    }

    public void actionPerformed(ActionEvent event) {
        this._doPulse(false);
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            if (!enabled) {
                this.setArmed(false);
                this.setPressed(false);
            }
            super.setEnabled(enabled);
        }
    }

    protected abstract void processPulse();

    private void _updateSpinning(boolean spinning) {
        this._spinning = spinning;
        if (spinning) {
            this._timer = this.getTimer();
            this._doPulse(true);
        } else {
            this.stopTimer();
        }
    }

    private void _doPulse(boolean firstTime) {
        boolean spinning = this._spinning;
        if (spinning) {
            SpinAccelerator accelerator = this.getAccelerator();
            int delay = this.getDelay();
            if (accelerator != null) {
                if (firstTime) {
                    accelerator.reset();
                } else {
                    accelerator.advance();
                }
                delay = accelerator.getInterval();
            }
            this.processPulse();
            if (this.isEnabled()) {
                if (firstTime) {
                    this._timer.setInitialDelay(delay);
                    this._timer.start();
                } else {
                    this._timer.setDelay(delay);
                }
            }
        }
    }
}

