/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.border.Border;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.JPaintContext;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextComponent;
import oracle.bali.ewt.util.ImmInsets;

public class BorderAdapter
implements Border {
    private BorderPainter _border;

    public BorderAdapter(BorderPainter border) {
        this._border = border;
    }

    public final BorderPainter getBorderPainter() {
        return this._border;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        PaintContext context = this.getPaintContext(c);
        this._border.paint(context, g, x, y, width, height);
    }

    public Insets getBorderInsets(Component c) {
        PaintContext context = this.getPaintContext(c);
        return this._border.getInsets(context).toInsets();
    }

    public Insets getBorderInsets(Component c, Insets insets) {
        PaintContext context = this.getPaintContext(c);
        ImmInsets imm = this._border.getInsets(context);
        insets.left = imm.left;
        insets.right = imm.right;
        insets.top = imm.top;
        insets.bottom = imm.bottom;
        return insets;
    }

    public boolean isBorderOpaque() {
        return this._border.isTransparent(null);
    }

    public String toString() {
        return "BorderAdapter[" + this._border + "]";
    }

    public PaintContext getPaintContext(Component c) {
        if (c instanceof PaintContextComponent) {
            return ((PaintContextComponent)c).getBorderContext();
        }
        PaintContext context = JPaintContext.getPaintContext((JComponent)c);
        if (context != null) {
            return context;
        }
        return new JPaintContext((JComponent)c);
    }
}

