/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.File;
import java.util.HashMap;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointIndexReader;
import oracle.sysman.oic.oics.OicsCheckPointUtil;
import oracle.sysman.oic.oics.OicsIRemoteCheckPointIndexSession;
import oracle.sysman.oic.oics.OicsIRemoteCheckPointSession;
import oracle.sysman.oic.oics.OicsRemoteCheckPointSession;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OicsRemoteCheckPointIndexSession
implements OicsIRemoteCheckPointIndexSession {
    public String component;
    public String oracleBase;
    public String indexLoc;
    public String remoteNode = null;
    public Vector checkPointSessions = null;
    private static HashMap checkPointSession_List = null;
    public HashMap m_failedCheckPointFiles = null;
    public HashMap m_allCheckPointFiles = null;
    private String sFileName = "";
    private String locOfIndex = "";
    private boolean copiedIndexToLocalNode = false;
    private boolean fileExists = false;
    private String checkpointFileOnlyForParsingonLocal = "";

    public OicsRemoteCheckPointIndexSession(String remoteNode, String oracleBase, String component) {
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        this.oracleBase = oracleBase;
        this.component = component;
        this.remoteNode = remoteNode;
        this.sFileName = OiixPathOps.concatPath((String)oracleBase, (String)"checkpoints");
        this.sFileName = OiixPathOps.concatPath((String)this.sFileName, (String)component);
        this.sFileName = OiixPathOps.concatPath((String)this.sFileName, (String)"index.xml");
        this.fileExists = true;
        if (this.fileExists) {
            try {
                this.copyIndexFileToLocalNode(remoteNode, this.sFileName);
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            }
            this.locOfIndex = OiixPathOps.concatPath((String)oracleBase, (String)"checkpoints");
            this.locOfIndex = OiixPathOps.concatPath((String)this.locOfIndex, (String)component);
            this.locOfIndex = OiixPathOps.concatPath((String)this.locOfIndex, (String)"index.xml");
            this.locOfIndex = this.locOfIndex + "." + remoteNode;
            this.copiedIndexToLocalNode = util.fileExists(this.locOfIndex);
            if (this.copiedIndexToLocalNode) {
                OiiolTextLogger.appendText((String)("Checkpoint:Index file :" + this.sFileName + " found."));
                OicsCheckPointIndexReader chkPointIndxReader = new OicsCheckPointIndexReader(this.locOfIndex);
                try {
                    chkPointIndxReader.buildIndex();
                }
                catch (OicsCheckPointException oce) {
                    OiiolTextLogger.appendText((String)("Checkpoint:" + oce.getMessage()));
                }
                if (OicsCheckPointIndexReader.m_allCheckPointFiles != null) {
                    this.m_allCheckPointFiles = new HashMap();
                    this.m_allCheckPointFiles.putAll(OicsCheckPointIndexReader.m_allCheckPointFiles);
                }
                int no_Files = this.m_allCheckPointFiles.size();
                Set keySet = this.m_allCheckPointFiles.keySet();
                for (String chkPointFile : keySet) {
                    try {
                        this.copyCheckPointFilesToLocalNode(remoteNode, chkPointFile);
                    }
                    catch (OicsCheckPointException e) {
                        OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
                    }
                }
                for (String nameOfChkPointFile : keySet) {
                    this.checkpointFileOnlyForParsingonLocal = nameOfChkPointFile + "." + remoteNode;
                    if (util.fileExists(this.checkpointFileOnlyForParsingonLocal)) {
                        OicsRemoteCheckPointSession oicsSession = new OicsRemoteCheckPointSession(remoteNode, nameOfChkPointFile);
                        if (this.m_allCheckPointFiles.get(nameOfChkPointFile) != null) {
                            oicsSession.setIndexSessionObject(this);
                        }
                        if (this.checkPointSessions == null) {
                            this.checkPointSessions = new Vector();
                        }
                        this.checkPointSessions.add(oicsSession);
                        if (checkPointSession_List == null) {
                            checkPointSession_List = new HashMap();
                        }
                        checkPointSession_List.put(nameOfChkPointFile, oicsSession);
                        if (oicsSession.getFailedCheckPointFiles() == null || this.m_failedCheckPointFiles != null) continue;
                        this.m_failedCheckPointFiles = new HashMap(oicsSession.getFailedCheckPointFiles());
                        continue;
                    }
                    OiiolTextLogger.appendText((String)("Checkpoint:Entry in index.xml for file:" + nameOfChkPointFile + " is invalid,file does not exist"));
                }
            } else {
                OiiolTextLogger.appendText((String)("Checkpoint:Index file :" + this.sFileName + " not copied to local node."));
            }
        }
    }

    @Override
    public String getRemoteNode() {
        if (this.remoteNode != null) {
            return this.remoteNode;
        }
        return null;
    }

    @Override
    public OicsIRemoteCheckPointSession getRemoteCheckPointSession(String checkPointFileLocation) {
        if (checkPointSession_List.get(checkPointFileLocation) != null) {
            return (OicsIRemoteCheckPointSession)checkPointSession_List.get(checkPointFileLocation);
        }
        return null;
    }

    @Override
    public HashMap getFailedCheckPointFiles() {
        return this.m_failedCheckPointFiles;
    }

    @Override
    public HashMap getAllCheckPointFiles() {
        return this.m_allCheckPointFiles;
    }

    private void copyIndexFileToLocalNode(String remoteNode, String sFileName) throws OicsCheckPointException {
        String folderLocation = OiixPathOps.concatPath((String)this.oracleBase, (String)"checkpoints");
        folderLocation = OiixPathOps.concatPath((String)folderLocation, (String)this.component);
        folderLocation = OiixPathOps.concatPath((String)folderLocation, (String)"index.xml");
        File oOutputFile = new File(folderLocation = folderLocation + "." + remoteNode);
        File oOutputDir = oOutputFile.getParentFile();
        if (!oOutputDir.exists()) {
            OiixFileOps.mkdirs((File)oOutputDir);
        }
        this.indexLoc = folderLocation;
        try {
            OiipgClusterOps.transferFileFromNode((String)remoteNode, (String)sFileName, (String)folderLocation);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getErrorMessage()));
            throw new OicsCheckPointException(e.getMessage());
        }
        OiiolTextLogger.appendText((String)("Checkpoint:Transferring file " + sFileName + "from remote nodes to local node at " + folderLocation));
    }

    private void copyCheckPointFilesToLocalNode(String remoteNode, String sFileName) throws OicsCheckPointException {
        String folderLocation = sFileName + "." + remoteNode;
        try {
            OiipgClusterOps.transferFileFromNode((String)remoteNode, (String)sFileName, (String)folderLocation);
        }
        catch (OiipgRemoteOpsException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getErrorMessage()));
            throw new OicsCheckPointException(e.getMessage());
        }
        OiiolTextLogger.appendText((String)("Checkpoint:Transferring file " + sFileName + "from remote nodes to local node at " + folderLocation));
    }
}

