/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.File;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointIndexSession;
import oracle.sysman.oic.oics.OicsCheckPointSession;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgClusterOps;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteFileOperationException;
import oracle.sysman.oii.oiip.oiipg.OiipgRemoteOpsException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPathOps;

public class OicsCheckPointUtil {
    public boolean fileExists(String sFileName) {
        File fMaster;
        boolean bResult = false;
        if (null != sFileName && (fMaster = new File(sFileName)).exists()) {
            bResult = true;
        }
        return bResult;
    }

    public boolean fileExists(String oracleBase, String component, String sFileName) {
        File fMaster;
        String tempName = OiixPathOps.concatPath((String)oracleBase, (String)component);
        sFileName = OiixPathOps.concatPath((String)sFileName, (String)sFileName);
        boolean bResult = false;
        if (null != sFileName && (fMaster = new File(sFileName)).exists()) {
            bResult = true;
        }
        return bResult;
    }

    public void removeFile(String sFileName) {
        File file = new File(sFileName);
        if (file.exists()) {
            if (file.delete()) {
                System.err.println("File " + sFileName + " deleted");
            } else {
                System.err.println("File " + sFileName + " could not be deleted");
            }
        } else {
            System.err.println("File " + sFileName + " does not exist.");
        }
    }

    public void transferFileToNodes(String[] nodeList, String checkPointXMLLoc, OicsCheckPointIndexSession oicsIndexSess) throws OicsCheckPointException {
        if (oicsIndexSess != null) {
            String oracleBase = oicsIndexSess.oracleBase;
            String component = oicsIndexSess.component;
            String index_fileName = "";
            index_fileName = OiixPathOps.concatPath((String)oracleBase, (String)"checkpoints");
            index_fileName = OiixPathOps.concatPath((String)index_fileName, (String)component);
            index_fileName = OiixPathOps.concatPath((String)index_fileName, (String)"index.xml");
            File indexFile = new File(index_fileName);
            File checkpointFile = new File(checkPointXMLLoc);
            if (checkpointFile.exists() && nodeList != null) {
                try {
                    OiipgClusterOps.transferFileToNodes((String[])nodeList, (String)checkPointXMLLoc, (String)new File(checkPointXMLLoc).getParent());
                }
                catch (OiipgRemoteOpsException e) {
                    OiiolTextLogger.appendText((String)("Checkpoint:" + e.getErrorMessage()));
                }
                catch (OiipgRemoteFileOperationException e) {
                    OiiolTextLogger.appendText((String)("Checkpoint:" + e.getErrorMessage()));
                }
            }
            if (indexFile.exists() && nodeList != null) {
                try {
                    OiipgClusterOps.transferFileToNodes((String[])nodeList, (String)index_fileName, (String)new File(index_fileName).getParent());
                    OiiolTextLogger.appendText((String)("Checkpoint:Index file:" + index_fileName + " copied to remote nodes"));
                }
                catch (OiipgRemoteOpsException e) {
                    OiiolTextLogger.appendText((String)("Checkpoint:" + e.getErrorMessage()));
                    throw new OicsCheckPointException(e.getMessage());
                }
                catch (OiipgRemoteFileOperationException e) {
                    OiiolTextLogger.appendText((String)("Checkpoint:" + e.getErrorMessage()));
                    throw new OicsCheckPointException(e.getMessage());
                }
            }
        }
    }

    public void removeDir(String dirName, Vector checkPointSessions) {
        if (dirName == null) {
            OiiolTextLogger.appendText((String)"Checkpoint: directory passed to removeDir() is null");
            return;
        }
        int size = checkPointSessions.size();
        for (OicsCheckPointSession oicsSession : checkPointSessions) {
            if (oicsSession.getNodeList() == null) continue;
            try {
                this.removeDirFromNodes(dirName, oicsSession.getNodeList());
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            }
        }
        File f = new File(dirName);
        OiixFileOps.recdelete((File)f);
    }

    public void removeDirFromNodes(String dirName, String[] nodeListDirRemoval) throws OicsCheckPointException {
        if (dirName == null) {
            OiiolTextLogger.appendText((String)"Checkpoint: directory passed to removeDirFromNodes() is null");
            return;
        }
        File f = new File(dirName);
        if (f.list() == null || f.list().length == 0) {
            OiiolTextLogger.appendText((String)("Checkpoint: directory '" + dirName + "' passed to removeDirFromNodes() is invalid or empty"));
            return;
        }
        int size = f.list().length;
        String[] listofFiles = f.list();
        for (int k = 0; k < size; ++k) {
            try {
                String locOfFile = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)dirName, (String)listofFiles[k]));
                OiipgClusterOps.removeFileOnNodes((String[])nodeListDirRemoval, (String)locOfFile);
                continue;
            }
            catch (OiipgRemoteOpsException e) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
                throw new OicsCheckPointException(e.getMessage());
            }
        }
    }

    public void createDirOnNodes(String oracleBase, String component, String[] listOfNodes) {
        String dirNameToCreate = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)oracleBase, (String)"checkpoints"));
        dirNameToCreate = OiixPathOps.getNativeForm((String)OiixPathOps.concatPath((String)dirNameToCreate, (String)component));
        OiipgClusterOps.createDirInNodes((String[])listOfNodes, (String)dirNameToCreate);
    }
}

