/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointFaultInjectionDesign;
import oracle.sysman.oic.oics.OicsCheckPointIndexSession;
import oracle.sysman.oic.oics.OicsCheckPointIndexWriter;
import oracle.sysman.oic.oics.OicsCheckPointReader;
import oracle.sysman.oic.oics.OicsCheckPointUtil;
import oracle.sysman.oic.oics.OicsCheckPointWriter;
import oracle.sysman.oic.oics.OicsICheckPoint;
import oracle.sysman.oic.oics.OicsICheckPointSession;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixFunctionOps;

public class OicsCheckPointSession
implements OicsICheckPointSession {
    public String checkPointXMLLoc = null;
    public Vector checkPoints = null;
    private Vector failedCheckPoints = null;
    private static HashMap failedCheckpointFiles = null;
    private HashMap faultInjectionCheckPointsList = null;
    private String[] nodeList = null;
    private boolean fileSet = true;
    private boolean isFault = false;
    private static OicsCheckPointIndexSession oicsIndexSess;

    public OicsCheckPointSession(String checkPointXMLLoc) {
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        if (util.fileExists(checkPointXMLLoc)) {
            this.checkPointXMLLoc = checkPointXMLLoc;
            OicsCheckPointReader checkpointReader = new OicsCheckPointReader(checkPointXMLLoc);
            try {
                checkpointReader.buildCheckpoint();
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            }
            if (OicsCheckPointReader.checkPoints != null) {
                this.checkPoints = new Vector(OicsCheckPointReader.checkPoints);
                Iterator itr = null;
                if (this.checkPoints != null) {
                    itr = this.checkPoints.iterator();
                    this.fileSet = true;
                    while (itr.hasNext()) {
                        OicsICheckPoint oics = (OicsICheckPoint)itr.next();
                        if (oics.getCheckPointState() != 2) continue;
                        if (this.failedCheckPoints == null) {
                            this.failedCheckPoints = new Vector();
                        }
                        if (this.fileSet) {
                            if (failedCheckpointFiles == null) {
                                failedCheckpointFiles = new HashMap();
                            }
                            failedCheckpointFiles.put(checkPointXMLLoc, this.nodeList);
                            this.fileSet = false;
                        }
                        this.failedCheckPoints.add(oics);
                    }
                }
            }
        } else {
            this.checkPointXMLLoc = checkPointXMLLoc;
            OiiolTextLogger.appendText((String)("Checkpoint:checkpointfile :" + checkPointXMLLoc + " not found,creating one for this session"));
        }
    }

    @Override
    public void saveCheckPointSession() {
        int size = this.checkPoints.size();
        for (int l = 0; l < size; ++l) {
            if (this.checkPoints.get(l) == null) continue;
            OicsCheckPointWriter checkPointWriter = new OicsCheckPointWriter(this.checkPointXMLLoc);
            try {
                checkPointWriter.updateObjects(this.checkPoints);
                continue;
            }
            catch (OicsCheckPointException e) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            }
        }
        try {
            new OicsCheckPointIndexWriter(this.getIndexSessionObject());
        }
        catch (OicsCheckPointException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
        }
        OiiolTextLogger.appendText((String)"Checkpoint:Index file written and updated");
    }

    @Override
    public void closeCheckPointSession() throws OicsCheckPointException {
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        try {
            new OicsCheckPointIndexWriter(this.getIndexSessionObject());
        }
        catch (OicsCheckPointException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
        }
        this.testForFaultOccurrence("POSTCOMMIT");
        try {
            util.transferFileToNodes(this.getNodeList(), this.checkPointXMLLoc, this.getIndexSessionObject());
        }
        catch (OicsCheckPointException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
        }
        this.testForFaultOccurrence("POSTTRANSFER");
    }

    @Override
    public OicsICheckPoint getCheckPoint(String checkPointName) {
        if (this.checkPoints != null) {
            int sizeofList = this.checkPoints.size();
            for (int k = 0; k < sizeofList; ++k) {
                OicsICheckPoint obj = (OicsICheckPoint)this.checkPoints.get(k);
                if (!obj.getCheckPointName().equalsIgnoreCase(checkPointName)) continue;
                return obj;
            }
        }
        return null;
    }

    @Override
    public void addCheckPoint(OicsICheckPoint checkPoint) {
        OicsCheckPointFaultInjectionDesign oicsFault;
        if (this.getFaultMap() != null && checkPoint != null) {
            oicsFault = new OicsCheckPointFaultInjectionDesign();
            oicsFault.checkFaultInjectionScenario(checkPoint, this.getFaultMap(), "BEFORE");
        }
        if (this.checkPoints == null) {
            this.checkPoints = new Vector();
            this.checkPoints.add(checkPoint);
        } else if (this.checkPoints.contains(checkPoint)) {
            int indexOfCheckPoint = this.checkPoints.indexOf(checkPoint);
            this.checkPoints.removeElementAt(indexOfCheckPoint);
            this.checkPoints.add(indexOfCheckPoint, checkPoint);
        } else {
            this.checkPoints.add(checkPoint);
        }
        if (this.getFaultMap() != null && checkPoint != null) {
            oicsFault = new OicsCheckPointFaultInjectionDesign();
            oicsFault.checkFaultInjectionScenario(checkPoint, this.getFaultMap(), "POST");
        }
    }

    @Override
    public List getAllCheckPoints() {
        return this.checkPoints;
    }

    @Override
    public List getAllFailedCheckPoints() {
        if (this.checkPoints != null) {
            for (OicsICheckPoint oics : this.checkPoints) {
                if (oics.getCheckPointState() != 2) continue;
                if (this.failedCheckPoints == null) {
                    this.failedCheckPoints = new Vector();
                }
                this.failedCheckPoints.add(oics);
            }
        }
        if (this.failedCheckPoints != null && this.failedCheckPoints.size() > 0) {
            OiiolTextLogger.appendText((String)"Checkpoint:Failed Checkpoint found returning it for getAllFailedCheckPoints.");
            return this.failedCheckPoints;
        }
        return null;
    }

    @Override
    public OicsICheckPoint getLastFailedCheckPoint() {
        List l = this.getAllFailedCheckPoints();
        if (l != null) {
            Iterator i = l.iterator();
            if (i.hasNext()) {
                OiiolTextLogger.appendText((String)"Checkpoint:Failed Checkpoint found returning it for getLastFailedCheckPoint.");
                return (OicsICheckPoint)i.next();
            }
            return null;
        }
        return null;
    }

    @Override
    public String[] getNodeList() {
        if (this.nodeList != null) {
            return this.nodeList;
        }
        return null;
    }

    public void setNodeList(String listOfNodes) {
        if (listOfNodes != null) {
            this.nodeList = OiixFunctionOps.explodeString((String)listOfNodes, (String)",");
        }
    }

    public HashMap getFailedCheckPointFiles() {
        return failedCheckpointFiles;
    }

    public void setIndexSessionObject(OicsCheckPointIndexSession oicsIndexSessref) {
        oicsIndexSess = oicsIndexSessref;
    }

    private OicsCheckPointIndexSession getIndexSessionObject() {
        return oicsIndexSess;
    }

    @Override
    public void registerFaultInjectionFile(String faultInjectionFileName) throws OicsCheckPointException {
        this.setFaultFlag(true);
        OicsCheckPointUtil util = new OicsCheckPointUtil();
        if (util.fileExists(faultInjectionFileName)) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(faultInjectionFileName));
            }
            catch (IOException io) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + io.getMessage()));
                throw new OicsCheckPointException(io.getMessage());
            }
            OicsCheckPointFaultInjectionDesign oicsFault = new OicsCheckPointFaultInjectionDesign();
            HashMap setOfValsFromPropFile = new HashMap(oicsFault.HashMapFromPropFile(prop));
            this.faultInjectionCheckPointsList = new HashMap(setOfValsFromPropFile);
        } else {
            OiiolTextLogger.appendText((String)("Checkpoint:File:" + faultInjectionFileName + " not found,not setting faults hashmap."));
            this.setFaultFlag(false);
        }
    }

    @Override
    public void registerFault(String checkPointName, int FaultToOccurAt) {
        this.setFaultFlag(true);
        OicsCheckPointFaultInjectionDesign oicsFault = new OicsCheckPointFaultInjectionDesign();
        String faultAt = oicsFault.getStringEquivalent(FaultToOccurAt);
        if (this.faultInjectionCheckPointsList != null) {
            this.faultInjectionCheckPointsList.put(checkPointName, faultAt);
        } else {
            this.faultInjectionCheckPointsList = new HashMap();
            this.faultInjectionCheckPointsList.put(checkPointName, faultAt);
        }
    }

    private void setFaultFlag(boolean FlagVal) {
        this.isFault = FlagVal;
    }

    @Override
    public HashMap getFaultMap() {
        if (this.faultInjectionCheckPointsList != null) {
            return this.faultInjectionCheckPointsList;
        }
        return null;
    }

    private void testForFaultOccurrence(String state) {
        int count_checkpoints = this.checkPoints.size();
        for (int i = 0; i < count_checkpoints; ++i) {
            if (this.checkPoints.get(i) == null) continue;
            OicsICheckPoint oicsChkPoint = (OicsICheckPoint)this.checkPoints.get(i);
            if (this.getFaultMap() == null || oicsChkPoint == null) continue;
            OicsCheckPointFaultInjectionDesign oicsFault = new OicsCheckPointFaultInjectionDesign();
            oicsFault.checkFaultInjectionScenario(oicsChkPoint, this.getFaultMap(), state);
        }
    }
}

