/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oic.oics;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oic.oics.OicsCheckPoint;
import oracle.sysman.oic.oics.OicsCheckPointException;
import oracle.sysman.oic.oics.OicsCheckPointProperty;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OicsCheckPointReader {
    public static Vector checkPoints = null;
    public static String m_checkPointXMLLoc;
    public HashMap m_properties = null;
    private static int countOfCheckpoints;
    private static OicsCheckPoint oicsMainCheckpoint;

    public OicsCheckPointReader(String checkPointXMLLoc) {
        m_checkPointXMLLoc = checkPointXMLLoc;
    }

    public void buildCheckpoint() throws OicsCheckPointException {
        try {
            Document oDoc = OixdDOMReader.getDocument((String)m_checkPointXMLLoc);
            this.build(oDoc, m_checkPointXMLLoc);
        }
        catch (IOException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            Object[] args = new String[]{m_checkPointXMLLoc, e.getMessage()};
            throw new OicsCheckPointException("OUI-CHK-11001", OiixResourceBundle.getString((String)"oracle.sysman.oic.oics.resources.OicsRuntimeRes", (String)"OUI-CHK-11001", (Object[])args), e);
        }
        catch (SAXException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            Object[] args = new String[]{m_checkPointXMLLoc, e.getMessage()};
            throw new OicsCheckPointException("OUI-CHK-11002", OiixResourceBundle.getString((String)"oracle.sysman.oic.oics.resources.OicsRuntimeRes", (String)"OUI-CHK-11002", (Object[])args), e);
        }
        catch (OixdInvalidDocumentException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            String[] args = new String[]{m_checkPointXMLLoc, e.getMessage()};
            throw new OicsCheckPointException(e);
        }
        catch (ParserConfigurationException e) {
            OiiolTextLogger.appendText((String)("Checkpoint:" + e.getMessage()));
            Object[] args = new String[]{m_checkPointXMLLoc, e.getMessage()};
            throw new OicsCheckPointException("OUI-CHK-11003", OiixResourceBundle.getString((String)"oracle.sysman.oic.oics.resources.OicsRuntimeRes", (String)"OUI-CHK-11003", (Object[])args), e);
        }
    }

    private void build(Document oDoc, String sFileName) throws OicsCheckPointException, OixdInvalidDocumentException {
        if (oDoc != null) {
            Element root = oDoc.getDocumentElement();
            if (!root.getTagName().equalsIgnoreCase("CHECKPOINTS")) {
                OiiolTextLogger.appendText((String)("Checkpoint:" + sFileName + " has invalid checkpoint format"));
                Object[] args = new String[]{sFileName};
                throw new OixdInvalidDocumentException("OUI-CHK-11021", OiixResourceBundle.getString((String)"oracle.sysman.oic.oics.resources.OicsRuntimeRes", (String)"OUI-CHK-11021", (Object[])args));
            }
            NodeList oCheckpointsDetailNodes = root.getChildNodes();
            if (oCheckpointsDetailNodes != null) {
                this.constructCheckPoints(oCheckpointsDetailNodes);
            }
        }
    }

    private void constructCheckPoints(NodeList oCheckpointsDetailNodes) throws OicsCheckPointException {
        if (oCheckpointsDetailNodes != null) {
            int nCheckpointsDetailNodes = oCheckpointsDetailNodes.getLength();
            for (int i = 0; i < nCheckpointsDetailNodes; ++i) {
                NodeList oCheckpointNodes;
                oicsMainCheckpoint = null;
                Node oCheckpointDetailNode = oCheckpointsDetailNodes.item(i);
                if (oCheckpointDetailNode.getNodeType() != 1 || oCheckpointDetailNode == null || !oCheckpointDetailNode.getNodeName().equalsIgnoreCase("CHECKPOINT") || (oCheckpointNodes = oCheckpointDetailNode.getChildNodes()) == null) continue;
                int nCheckpointNodes = oCheckpointNodes.getLength();
                oicsMainCheckpoint = this.constructCheckpointList(oCheckpointDetailNode);
                for (int j = 0; j < nCheckpointNodes; ++j) {
                    NodeList oCheckpointNodes1;
                    Node oChildCheckpointDetailNode = oCheckpointNodes.item(j);
                    if (oChildCheckpointDetailNode == null || oChildCheckpointDetailNode.getNodeType() != 1) continue;
                    if (oChildCheckpointDetailNode.getNodeName().equalsIgnoreCase("PROPERTY_LIST")) {
                        oicsMainCheckpoint = this.constructPropertyList(oicsMainCheckpoint, oChildCheckpointDetailNode);
                        continue;
                    }
                    if (!oChildCheckpointDetailNode.getNodeName().equalsIgnoreCase("CHECKPOINTS") || (oCheckpointNodes1 = oChildCheckpointDetailNode.getChildNodes()) == null) continue;
                    int nCheckpointsDetailNodes1 = oCheckpointNodes1.getLength();
                    for (int g = 0; g < nCheckpointsDetailNodes1; ++g) {
                        Node oCheckpointDetailNode1 = oCheckpointNodes1.item(g);
                        OicsCheckPoint childChkPointObj = null;
                        if (oCheckpointDetailNode1 == null || (childChkPointObj = this.constructChildCheckPoints(oCheckpointDetailNode1)) == null) continue;
                        oicsMainCheckpoint.addChildCheckPoint(childChkPointObj);
                    }
                }
                if (checkPoints == null) {
                    checkPoints = new Vector();
                }
                checkPoints.add(countOfCheckpoints++, oicsMainCheckpoint);
            }
        }
    }

    private OicsCheckPoint constructCheckpointList(Node oCheckpointDetailNode) throws OicsCheckPointException {
        Node oAttrib = null;
        NamedNodeMap oCheckpointNodeAttribs = oCheckpointDetailNode.getAttributes();
        if (oCheckpointNodeAttribs != null) {
            String attrLevel = "";
            int attrLevelInt = -1;
            String attrName = "";
            String attrDesc = "";
            String attrState = "";
            oAttrib = oCheckpointNodeAttribs.getNamedItem("LEVEL");
            if (oAttrib != null) {
                attrLevel = oAttrib.getNodeValue();
            }
            if ((oAttrib = oCheckpointNodeAttribs.getNamedItem("NAME")) != null) {
                attrName = oAttrib.getNodeValue();
            }
            if ((oAttrib = oCheckpointNodeAttribs.getNamedItem("DESC")) != null) {
                attrDesc = oAttrib.getNodeValue();
            }
            if ((oAttrib = oCheckpointNodeAttribs.getNamedItem("STATE")) != null) {
                attrState = oAttrib.getNodeValue();
            }
            if (attrLevel.equalsIgnoreCase("MAJOR")) {
                attrLevelInt = 1;
            } else if (attrLevel.equalsIgnoreCase("MINOR")) {
                attrLevelInt = 2;
            }
            OicsCheckPoint oicsChkPoint = null;
            oicsChkPoint = new OicsCheckPoint(attrName, attrDesc, attrLevelInt);
            oicsChkPoint.setCheckPointName(attrName);
            oicsChkPoint.setCheckPointDesc(attrDesc);
            oicsChkPoint.setCheckPointLevel(attrLevelInt);
            if (attrState.equalsIgnoreCase("SUCCESS")) {
                oicsChkPoint.setCheckPointState(3);
            } else if (attrState.equalsIgnoreCase("FAIL")) {
                oicsChkPoint.setCheckPointState(2);
            } else if (attrState.equalsIgnoreCase("START")) {
                oicsChkPoint.setCheckPointState(1);
            } else {
                oicsChkPoint.setCheckPointState(1);
            }
            return oicsChkPoint;
        }
        return null;
    }

    private OicsCheckPoint constructPropertyList(OicsCheckPoint checkPoint, Node oChildCheckpointDetailNodeProp) throws OicsCheckPointException {
        Node oAttrib = null;
        OicsCheckPointProperty oPropertyChkPoint = null;
        NodeList oPropertyNodes = oChildCheckpointDetailNodeProp.getChildNodes();
        int nPropertyNodes = oPropertyNodes.getLength();
        for (int k = 0; k < nPropertyNodes; ++k) {
            Node oPropertyNode = oPropertyNodes.item(k);
            if (oPropertyNode.getNodeType() != 1 || !oPropertyNode.getNodeName().equalsIgnoreCase("PROPERTY")) continue;
            NamedNodeMap oPropertyNodeAttribs = oPropertyNode.getAttributes();
            if (oPropertyNodeAttribs != null) {
                String attrNameProp = "";
                String attrTypeProp = "";
                int attrTypePropInt = -1;
                String attrValueProp = "";
                oAttrib = oPropertyNodeAttribs.getNamedItem("NAME");
                if (oAttrib != null) {
                    attrNameProp = oAttrib.getNodeValue();
                }
                if ((oAttrib = oPropertyNodeAttribs.getNamedItem("TYPE")) != null) {
                    attrTypeProp = oAttrib.getNodeValue();
                }
                if (attrTypeProp != null) {
                    attrTypePropInt = this.propertyType(attrTypeProp);
                }
                if ((oAttrib = oPropertyNodeAttribs.getNamedItem("VAL")) != null) {
                    attrValueProp = oAttrib.getNodeValue();
                }
                oPropertyChkPoint = new OicsCheckPointProperty(attrNameProp, attrTypePropInt, attrValueProp);
            }
            if (oPropertyChkPoint == null) continue;
            checkPoint.addCheckPointProperty(oPropertyChkPoint);
        }
        return checkPoint;
    }

    private OicsCheckPoint constructChildCheckPoints(Node oCheckpointDetailNode) throws OicsCheckPointException {
        OicsCheckPoint ochildCheckPoint = null;
        if (oCheckpointDetailNode.getNodeType() == 1 && oCheckpointDetailNode != null) {
            NodeList oCheckpointNodes;
            if (oCheckpointDetailNode.getNodeName().equalsIgnoreCase("CHECKPOINT") && (oCheckpointNodes = oCheckpointDetailNode.getChildNodes()) != null) {
                int nCheckpointNodes = oCheckpointNodes.getLength();
                ochildCheckPoint = this.constructCheckpointList(oCheckpointDetailNode);
                for (int j = 0; j < nCheckpointNodes; ++j) {
                    Node oChildCheckpointDetailNode = oCheckpointNodes.item(j);
                    if (oChildCheckpointDetailNode == null || oChildCheckpointDetailNode.getNodeType() != 1 || !oChildCheckpointDetailNode.getNodeName().equalsIgnoreCase("PROPERTY_LIST")) continue;
                    ochildCheckPoint = this.constructPropertyList(ochildCheckPoint, oChildCheckpointDetailNode);
                }
            }
            return ochildCheckPoint;
        }
        return null;
    }

    private int propertyType(String property) {
        int attrTypePropInt = -1;
        attrTypePropInt = property.equalsIgnoreCase("STRING") ? 1 : (property.equalsIgnoreCase("NUMBER") ? 2 : (property.equalsIgnoreCase("BOOLEAN") ? 3 : (property.equalsIgnoreCase("STRINGLIST") ? 4 : 1)));
        return attrTypePropInt;
    }

    static {
        countOfCheckpoints = 0;
        oicsMainCheckpoint = null;
    }
}

