/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcc;

import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiic.OiicISession;
import oracle.sysman.oii.oiic.OiicSystemPropertyOps;
import oracle.sysman.oii.oiif.oiifb.OiifbEndIterateException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixJarClassLoader;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcc.OipccEndPrereqSessionException;
import oracle.sysman.oip.oipc.oipcc.OipccPrereqContextBuilder;
import oracle.sysman.oip.oipc.oipcc.OipccPrereqSessionContext;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpGenerator;
import oracle.sysman.oip.oipc.oipcl.OipclPrereqLogger;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqChecker;
import oracle.sysman.oip.oipc.oipcp.OipcpIPrereqResultsSummary;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqCheckerFactory;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqExecException;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqProgress;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqWriter;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcr.OipcrRulesEngineInitException;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;
import oracle.sysman.oip.oipf.oipfc.OipfcSilentModePrereqException;

public class OipccPreReqSession
implements OiicISession {
    private OipcuPrereqProps m_oPrereqProps;
    private OipccPrereqSessionContext m_oPrereqContext;
    private OipcpPrereqProgress m_oProgress;
    private Thread m_oPrereqThread;
    private OipcpPrereqExecException m_oPrereqException = null;
    private static final String PREREQ_PROPS_FILENAME = "prerequisite.properties";
    private static final String PREREQ_RESULTS_DIR = "results";
    private static final int PREREQ_SUCCESS = 0;
    private static final int PREREQ_FAIL = 1;
    private static final int PREREQ_OPTIONAL_FAIL = 2;
    public static final int SILENT_MODE = 0;
    public static final int GUI_MODE = 1;
    public static final int CONSOLE_MODE = 2;
    private OiiiInstallAreaControl m_oInstallAreaControl = null;
    private OipcpIPrereqChecker oPrereqChecker = null;
    private Collection listresultFile = null;
    private boolean m_remotePrereqFlag = false;
    private String[] asRemoteNodes = null;

    public OipccPreReqSession(Map oCmdLineVars) throws OipccEndPrereqSessionException {
        OipccPrereqContextBuilder oContextBuilder = OipccPrereqContextBuilder.getBuilder();
        this.m_oPrereqContext = (OipccPrereqSessionContext)((Object)oContextBuilder.build());
        this.m_oPrereqContext.initVariables();
        this.m_oPrereqContext.setCommandLineArgsMap(oCmdLineVars);
        try {
            this.m_oPrereqContext.setVariables();
        }
        catch (OiifbEndIterateException e) {
            e.printStackTrace();
        }
        String sPrereqDir = System.getProperty("oracle.installer.prereqConfigLoc");
        sPrereqDir = sPrereqDir.trim();
        String sPrereqPropsFile = OiixPathOps.concatPath((String)sPrereqDir, (String)PREREQ_PROPS_FILENAME);
        String sLogLoc = System.getProperty("oracle.installer.prereqLogLoc");
        String sPrereqResultsLoc = OiixPathOps.concatPath((String)sLogLoc, (String)PREREQ_RESULTS_DIR);
        this.m_oPrereqProps = new OipcuPrereqProps(sPrereqPropsFile, sPrereqDir, sPrereqResultsLoc);
        OiicSystemPropertyOps.setPrereqLoc((String)sPrereqDir);
        Iterator oJavaLibs = this.m_oPrereqProps.getFilesListForProperty("javalibs");
        while (oJavaLibs.hasNext()) {
            String sLibrary = (String)oJavaLibs.next();
            try {
                OiixJarClassLoader.createLoader((String)OiixPathOps.concatPath((String)sPrereqDir, (String)sLibrary), (boolean)true, (boolean)true);
            }
            catch (IOException e) {
                throw new OipccEndPrereqSessionException(e);
            }
        }
    }

    public OipcuPrereqProps getPrereqProps() {
        return this.m_oPrereqProps;
    }

    public OipccPrereqSessionContext getPrereqContext() {
        return this.m_oPrereqContext;
    }

    public int executePrereqs() throws OipccEndPrereqSessionException {
        OipcpIPrereqChecker oPrereqChecker = null;
        try {
            oPrereqChecker = OipcpPrereqCheckerFactory.getPrereqChecker(this.getPrereqProps());
            oPrereqChecker.initialize();
            OipclPrereqLogger oLogListener = OipclPrereqLogger.getLogger();
            oPrereqChecker.addPrereqListener(oLogListener);
            int sessionMode = this.getSessionMode();
            this.m_oProgress = OipcpPrereqProgress.getPrereqProgress(sessionMode, oPrereqChecker.getProgressUIListener());
            this.m_oProgress.setGUIMode(1);
            oPrereqChecker.addPrereqListener(this.m_oProgress);
            this.m_oProgress.setPrereqCheckerObj(oPrereqChecker);
            this.m_oProgress.initialize(this.m_oPrereqProps);
            OipcpPrereqWriter oWriter = new OipcpPrereqWriter(this.m_oPrereqProps);
            oPrereqChecker.addPrereqListener(oWriter);
            boolean bFixUpEnable = Boolean.getBoolean("oracle.installer.fixUpEnable");
            if (bFixUpEnable) {
                OipcfFixUpGenerator oFixUpGenerator = OipcfFixUpGenerator.getFixUpGenerator();
                oPrereqChecker.addPrereqListener(oFixUpGenerator);
                oFixUpGenerator.registerChecker(oPrereqChecker);
            }
            this.m_oPrereqThread = this.startPrereqs(oPrereqChecker);
            this.waitForSessionEnd();
            if (this.m_oPrereqException != null) {
                throw this.m_oPrereqException;
            }
        }
        catch (OipfcSilentModePrereqException oLogListener) {
        }
        catch (OipcrRulesEngineInitException re) {
            throw new OipccEndPrereqSessionException(re.getMessage(), (Throwable)((Object)re));
        }
        catch (OipcpPrereqExecException e) {
            throw new OipccEndPrereqSessionException(e.getMessage(), (Throwable)((Object)e));
        }
        int iRetCode = 0;
        iRetCode = oPrereqChecker.getResultsSummary().getFailedCount() > 0 ? 1 : (oPrereqChecker.getResultsSummary().getWarningsCount() > 0 ? 2 : 0);
        return iRetCode;
    }

    public int getSessionMode() {
        if (Boolean.getBoolean("oracle.installer.silent")) {
            return 0;
        }
        return 1;
    }

    private Thread startPrereqs(final OipcpIPrereqChecker oPrereqChecker) throws OipcpPrereqExecException {
        String sEntryPointVal;
        String invLoc;
        boolean nodeNameLen = false;
        String nodeName = "";
        String STRINGLIST_DELIMITER = ",";
        String sLogLoc = "";
        String str1brace = "{";
        String newVal = "";
        if (this.m_oPrereqContext.getVarValue("REMOTE_NODES") != null) {
            String sNodeList = (String)this.m_oPrereqContext.getVarValue("REMOTE_NODES");
            sNodeList = sNodeList.replace(str1brace, newVal);
            str1brace = "}";
            sNodeList = sNodeList.replace(str1brace, newVal);
            this.asRemoteNodes = OiixFunctionOps.explodeString((String)sNodeList, (String)STRINGLIST_DELIMITER);
            oPrereqChecker.setRemoteNodes(this.asRemoteNodes);
        }
        if (System.getProperty("oracle.installer.executeRemotePrereqs") != null && this.asRemoteNodes != null) {
            String boolVal = System.getProperty("oracle.installer.executeRemotePrereqs");
            this.m_remotePrereqFlag = boolVal.equalsIgnoreCase("true");
        }
        if (!this.m_remotePrereqFlag) {
            OiiolTextLogger.appendText((String)"Execute Remode Nodes Flag Set To False,Not executing prereqsesssion");
        }
        oPrereqChecker.setExecuteRemotePrereqs(this.m_remotePrereqFlag);
        OiisVariable oPrereqEntryPoint = this.m_oPrereqContext.getVariable("PREREQ_ENTRY_POINT");
        if (this.m_oPrereqContext.getVariable("INVENTORY_LOCATION") != null && (invLoc = (String)this.m_oPrereqContext.getVariable("INVENTORY_LOCATION").getValue()) != null) {
            System.setProperty("oracle.installer.inventory_location", invLoc);
        }
        final String sEntryPoint = (sEntryPointVal = (String)oPrereqEntryPoint.getValue()) == null ? System.getProperty("oracle.installer.entryPoint", "") : sEntryPointVal;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    oPrereqChecker.executePrereqs(sEntryPoint);
                    if (OipccPreReqSession.this.m_remotePrereqFlag && Boolean.getBoolean("oracle.installer.clusterEnabled") && OipccPreReqSession.this.asRemoteNodes != null && OipccPreReqSession.this.asRemoteNodes.length != 0) {
                        oPrereqChecker.executeRemotePrereqs(sEntryPoint);
                        if (!System.getProperty("oracle.installer.silent", "false").equalsIgnoreCase("true")) {
                            OipccPreReqSession.this.m_oProgress.callPaintRemoteUI();
                        }
                        OipccPreReqSession.this.LogResults(oPrereqChecker, OipccPreReqSession.this.asRemoteNodes);
                    }
                }
                catch (OipcpPrereqExecException e) {
                    OipccPreReqSession.this.m_oPrereqException = e;
                }
            }
        };
        Thread prereqThread = new Thread(runnable);
        prereqThread.start();
        return prereqThread;
    }

    private void waitForSessionEnd() throws OipfcSilentModePrereqException {
        if (this.m_oPrereqThread.isAlive()) {
            try {
                this.m_oPrereqThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.m_oProgress.waitForSessionEnd();
    }

    public OiisVariableOwner getContext() {
        return this.m_oPrereqContext;
    }

    public OiiiInstallInventory getInstallInventory() {
        if (this.m_oInstallAreaControl == null) {
            this.initInstallInventory();
        }
        if (this.m_oInstallAreaControl != null) {
            return this.m_oInstallAreaControl.getInstallInventory();
        }
        return null;
    }

    private void initInstallInventory() {
        try {
            OiiiInstallAreaControl.initAreaControl((int)0);
            this.m_oInstallAreaControl = OiiiInstallAreaControl.getInstallAreaControl();
            this.m_oInstallAreaControl.grabReaderLock();
        }
        catch (OiitTargetLockNotAvailableException e) {
            this.m_oInstallAreaControl = null;
        }
        catch (IOException e) {
            this.m_oInstallAreaControl = null;
        }
        catch (OiiiInventoryDoesNotExistException e) {
            this.m_oInstallAreaControl = null;
        }
    }

    void endSession() {
        if (this.m_oInstallAreaControl != null) {
            this.m_oInstallAreaControl.releaseReaderLock();
        }
        this.m_oInstallAreaControl = null;
    }

    public OiiiInstallAreaControl getInstallAreaControl() {
        return this.m_oInstallAreaControl;
    }

    public void LogResults(OipcpIPrereqChecker oPrereqChecker, String[] nodeNames) {
        String NEW_LINE = System.getProperty("line.separator");
        String S_LINE = "-----------------------------------------------------------------------------";
        String S_ERR_MSG = "Prerequisite Execution Failed.";
        int nodeNameLen = nodeNames.length;
        String nodeName = null;
        for (int i = 0; i < nodeNameLen; ++i) {
            nodeName = nodeNames[i];
            if (oPrereqChecker.getPrereqResultObj(nodeName) != null) {
                OipcpIPrereqResultsSummary resObj = oPrereqChecker.getPrereqResultObj(nodeName);
                Object[] args = new String[]{new Date().toString()};
                String sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13002", (Object[])args);
                if (this.getSessionMode() == 0) {
                    OiiolTextLogger.writeToLogAndConsole((String)sMsg);
                    OiiolTextLogger.writeToLogAndConsole((String)S_LINE);
                    OiiolTextLogger.writeToLogAndConsole((String)("Prerequisite Checks for Remote Node " + nodeName));
                    OiiolTextLogger.writeToLogAndConsole((String)S_LINE);
                } else {
                    OiiolTextLogger.appendText((String)sMsg);
                    OiiolTextLogger.appendText((String)S_LINE);
                    OiiolTextLogger.appendText((String)("Prerequisite Checks for Remote Node " + nodeName));
                    OiiolTextLogger.appendText((String)S_LINE);
                }
                Vector vList = new Vector();
                int lengthofVector = vList.size();
                int j = 0;
                vList = resObj.getAllPrereqChecks();
                lengthofVector = vList.size();
                for (j = 0; j < lengthofVector; ++j) {
                    args = new String[]{new Date().toString()};
                    sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13002", (Object[])args);
                    if (this.getSessionMode() == 0) {
                        OiiolTextLogger.writeToLogAndConsole((String)sMsg);
                    } else {
                        OiiolTextLogger.appendText((String)sMsg);
                    }
                    args = new String[]{((OipcpPrerequisiteCheck)vList.get(j)).getName(), ((OipcpPrerequisiteCheck)vList.get(j)).getDescription()};
                    sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13004", (Object[])args);
                    if (this.getSessionMode() == 0) {
                        OiiolTextLogger.writeToLogAndConsole((String)sMsg);
                        OiiolTextLogger.writeToLogAndConsole((String)((OipcpPrerequisiteCheck)vList.get(j)).getResult().getFormattedResultText());
                        OiiolTextLogger.writeToLogAndConsole((String)S_LINE);
                        continue;
                    }
                    OiiolTextLogger.appendText((String)sMsg);
                    OiiolTextLogger.appendText((String)((OipcpPrerequisiteCheck)vList.get(j)).getResult().getFormattedResultText());
                    OiiolTextLogger.appendText((String)S_LINE);
                }
                args = new String[]{new Date().toString()};
                sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcl.resources.OipclRuntimeRes", (String)"13003", (Object[])args);
                if (this.getSessionMode() == 0) {
                    OiiolTextLogger.writeToLogAndConsole((String)sMsg);
                    OiiolTextLogger.writeToLogAndConsole((String)S_LINE);
                    continue;
                }
                OiiolTextLogger.appendText((String)sMsg);
                OiiolTextLogger.appendText((String)S_LINE);
                continue;
            }
            if (this.getSessionMode() == 0) {
                OiiolTextLogger.writeToLogAndConsole((String)S_LINE);
                OiiolTextLogger.writeToLogAndConsole((String)("Prerequisite Checks for Remote Node " + nodeName));
                OiiolTextLogger.writeToLogAndConsole((String)S_ERR_MSG);
                continue;
            }
            OiiolTextLogger.appendText((String)S_LINE);
            OiiolTextLogger.appendText((String)("Prerequisite Checks for Remote Node " + nodeName));
            OiiolTextLogger.appendText((String)S_ERR_MSG);
        }
    }
}

