/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.util.Stack;
import oracle.sysman.ois.oisc.oiscx.OiscxAttributeListImpl;
import oracle.sysman.ois.oisc.oiscx.OiscxElementHandler;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class OiscxUnknownElementHandler
extends OiscxElementHandler {
    private XMLElement m_element;
    private XMLElement m_currentElement;
    private Stack m_parentElements;

    public OiscxUnknownElementHandler() {
        this.m_element = new XMLElement("");
        this.m_parentElements = new Stack();
    }

    public OiscxUnknownElementHandler(String sName) {
        this.m_element = new XMLElement(sName);
        this.m_parentElements = new Stack();
    }

    public void startElement(String name, Attributes attributes, Stack handlers) {
        handlers.push(this);
        this.onStart(name, new OiscxAttributeListImpl(attributes));
    }

    @Override
    public void onStart(String name, Attributes atts) {
        if (this.m_currentElement == null) {
            this.m_currentElement = new XMLElement(name);
        } else {
            XMLElement parent = this.m_parentElements.push(this.m_currentElement);
            this.m_currentElement = new XMLElement(name);
            parent.appendChild((Node)this.m_currentElement);
        }
        if (atts != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                this.m_currentElement.setAttribute(attName, attValue);
            }
        }
    }

    @Override
    public void onText(char[] chars, int start, int length) {
        String text = new String(chars, start, length);
        if (this.m_currentElement != null) {
            this.m_currentElement.addText(chars, start, length);
        }
    }

    @Override
    public void onEnd(String name) {
        if (this.m_parentElements.empty()) {
            if (this.m_currentElement != null) {
                this.m_element.appendChild((Node)this.m_currentElement);
                this.m_currentElement = null;
            }
        } else {
            this.m_currentElement = (XMLElement)this.m_parentElements.pop();
        }
    }

    public XMLElement getElement() {
        return this.m_element;
    }

    public void setElementAttributes(Attributes atts) {
        if (atts != null && this.m_element != null) {
            for (int i = 0; i < atts.getLength(); ++i) {
                String attName = atts.getLocalName(i);
                String attValue = atts.getValue(i);
                this.m_element.setAttribute(attName, attValue);
            }
        }
    }

    @Override
    void setUnknownElementHandler(String name, Attributes atts) {
    }
}

