/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import oracle.sysman.ois.oisc.oiscu.OiscuErrorInformationBase;
import oracle.sysman.ois.oisc.oiscu.OiscuProgressAltMessage;
import oracle.sysman.ois.oisc.oiscu.OiscuProgressMessagesBase;
import oracle.sysman.ois.oisc.oiscx.OiscxHelper;
import oracle.sysman.ois.oisr.oisrb.OisrbResourceLoader;

public class OiscxLogUtil {
    private static OiscuProgressMessagesBase s_oLogFileListener;
    private static OiscuProgressMessagesBase s_oFoundFileListener;
    private static OiscuProgressMessagesBase s_oMissingFileListener;
    private static int[] s_aiFdbk;
    public static int FOUND_FILE;
    public static int MISSING_FILE;
    public static int LOG_FILE;

    public OiscxLogUtil(OiscuProgressMessagesBase oML) {
        if (oML == null) {
            oML = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
        }
        if (s_oLogFileListener == null) {
            s_oLogFileListener = oML;
        }
    }

    public static void setLogMessageListener(OiscuProgressMessagesBase oML) {
        s_oLogFileListener = oML;
    }

    public static void setMessageListener(int type, OiscuProgressMessagesBase oML) {
        if (type == FOUND_FILE) {
            s_oFoundFileListener = oML;
        } else if (type == MISSING_FILE) {
            s_oMissingFileListener = oML;
        } else {
            s_oLogFileListener = oML;
        }
    }

    public static void logErr(String sKey, Object[] args, int iStatus, boolean bUseResourceLoader) {
        int type = LOG_FILE;
        OiscxLogUtil.logErr(sKey, args, iStatus, bUseResourceLoader, type);
    }

    public static void logErr(String sKey, Object[] args, int iStatus, boolean bUseResourceLoader, int type) {
        OiscuProgressMessagesBase oML = null;
        oML = type == FOUND_FILE ? s_oFoundFileListener : (type == MISSING_FILE ? s_oMissingFileListener : s_oLogFileListener);
        String s = "";
        s = bUseResourceLoader ? (args != null ? OisrbResourceLoader.getString(sKey, args) : OisrbResourceLoader.getString(sKey)) : (args == null ? sKey : MessageFormat.format(sKey, args));
        OiscuErrorInformationBase err = new OiscuErrorInformationBase(iStatus, s);
        OiscxHelper.logError(err, oML, s_aiFdbk);
    }

    public static void logFoundMessage(String sMessage) {
        OiscxLogUtil.logErr(sMessage, null, 2, false, FOUND_FILE);
    }

    public static void logMissingMessage(String sMessage) {
        OiscxLogUtil.logErr(sMessage, null, 2, false, MISSING_FILE);
    }

    static {
        s_aiFdbk = new int[]{0, 0, 0};
        FOUND_FILE = 0;
        MISSING_FILE = 1;
        LOG_FILE = 2;
    }
}

