/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import oracle.sysman.ois.oisc.oiscu.OiscuException;
import oracle.sysman.ois.oisc.oiscu.OiscuFatalException;
import oracle.sysman.ois.oisc.oiscx.OiscxDefaultHandler;
import oracle.sysman.ois.oisc.oiscx.OiscxLanguagesHandler;
import oracle.sysman.ois.oisc.oiscx.OiscxLogUtil;
import oracle.sysman.ois.oisc.oiscx.OiscxNLSRTLMapHandler;
import oracle.sysman.ois.oisc.oiscx.OiscxXMLOps;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OiscxLanguagesReader {
    public static final String DEFAULT = "default";
    private static OiscxLanguagesReader m_oLangReader;
    private String m_sLocation;
    private String m_defaultLang = "";
    private Collection m_adminLangsList = new ArrayList();
    private Collection m_runtimeLangsList = new ArrayList();
    private Map m_NLSRTLMap;
    private boolean bRuntimeLoaded = false;
    private boolean bAdminLoaded = false;
    private boolean bNLSMappingLoaded = false;

    protected OiscxLanguagesReader() {
    }

    public static OiscxLanguagesReader getLanguagesReader() {
        if (m_oLangReader == null) {
            m_oLangReader = new OiscxLanguagesReader();
        }
        return m_oLangReader;
    }

    public Collection getAdminLangsList() {
        return this.m_adminLangsList;
    }

    public Collection getRuntimeLangsList() {
        return this.m_runtimeLangsList;
    }

    public String getDefaultLang() {
        return this.m_defaultLang;
    }

    public Map getNLSRTLMap() {
        return this.m_NLSRTLMap;
    }

    public void loadLanguageEntries(String sAdminLangLoc, String sRuntimeLangLoc, String sNLSRTLMapLoc) throws OiscuFatalException {
        String sErrCode = "S_NO_ADMINLANGS_ENTRY";
        this.m_adminLangsList = this.readLanguageEntries(sAdminLangLoc, sErrCode);
        this.bAdminLoaded = true;
        Iterator it = this.m_adminLangsList.iterator();
        if (it.hasNext()) {
            this.m_defaultLang = (String)it.next();
        }
        sErrCode = "S_NO_RUNTIMELANGS_ENTRY";
        this.m_runtimeLangsList = this.readLanguageEntries(sRuntimeLangLoc, sErrCode);
        this.bRuntimeLoaded = true;
        this.m_NLSRTLMap = this.readNLSRTLMappings(sNLSRTLMapLoc);
        this.bNLSMappingLoaded = true;
    }

    private Collection readLanguageEntries(String location, String sErrCode) throws OiscuFatalException {
        try {
            OiscxLanguagesHandler handler = new OiscxLanguagesHandler();
            this.readLanguageEntries(location, handler);
            return handler.getLanguageEntries();
        }
        catch (SAXException e) {
            OiscxLogUtil.logErr(e.getMessage(), null, 0, false);
            OiscxLogUtil.logErr(sErrCode, null, 1, true);
            throw new OiscuFatalException(e);
        }
        catch (OiscuException e) {
            OiscxLogUtil.logErr(sErrCode, null, 1, true);
            throw new OiscuFatalException(e);
        }
    }

    private Map readNLSRTLMappings(String location) throws OiscuFatalException {
        try {
            OiscxNLSRTLMapHandler handler = new OiscxNLSRTLMapHandler();
            this.readLanguageEntries(location, handler);
            return handler.getLanguageMappings();
        }
        catch (SAXException e) {
            OiscxLogUtil.logErr(e.getMessage(), null, 1, false);
            throw new OiscuFatalException(e);
        }
        catch (OiscuException e) {
            OiscxLogUtil.logErr("S_NO_NLSRTL_MAPPINGS", null, 1, true);
            throw new OiscuFatalException(e);
        }
    }

    private void readLanguageEntries(String location, OiscxDefaultHandler handler) throws OiscuFatalException {
        Object fReader = null;
        Object bReader = null;
        try {
            XMLReader parser = OiscxXMLOps.createSAXParser(false, false);
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(new InputSource(this.createURL(location).toString()));
        }
        catch (SAXException e) {
            OiscxLogUtil.logErr(e.getMessage(), null, 0, false);
            throw new OiscuFatalException(e);
        }
        catch (IOException e) {
            OiscxLogUtil.logErr("S_IO_EXCEPTION", null, 0, true);
            throw new OiscuFatalException(e);
        }
    }

    private URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                OiscxLogUtil.logErr("S_IO_EXCEPTION_FILE_NOT_FOUND", null, 0, true);
                return null;
            }
        }
        return url;
    }

    public boolean isAdminLoaded() {
        return this.bAdminLoaded;
    }

    public boolean isNLSMappingLoaded() {
        return this.bNLSMappingLoaded;
    }

    public boolean isRuntimeLoaded() {
        return this.bRuntimeLoaded;
    }
}

