/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.sysman.ois.oisc.oiscu.OiscuCannotAddException;
import oracle.sysman.ois.oisc.oiscu.OiscuDebug;
import oracle.sysman.ois.oisc.oiscu.OiscuErrorInformationBase;
import oracle.sysman.ois.oisc.oiscu.OiscuParseException;
import oracle.sysman.ois.oisc.oiscu.OiscuProgressMessagesBase;
import oracle.sysman.ois.oisc.oiscu.OiscuTextException;
import oracle.sysman.ois.oisc.oiscu.OiscuUniqueVector;
import oracle.sysman.ois.oisr.oisrb.OisrbResourceLoader;

public class OiscxHelper {
    public static String ADE_PATH = ".ade_path";
    public static final Locale OLD_US_ENGLISH = new Locale("US", "en");
    public static final Locale US_ENGLISH = Locale.US;
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale DEFAULT_LOCALE = new Locale("", "");
    public static final Locale OLD_FR_FRENCH = new Locale("FR", "fr");
    public static final Locale FR_FRENCH = Locale.FRANCE;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale ARABIC = new Locale("ar", "");
    public static final Locale IN_BENGALI = new Locale("bn", "");
    public static final Locale BR_PORTUGUESE = new Locale("pt", "BR");
    public static final Locale BULGARIAN = new Locale("bg", "");
    public static final Locale OLD_BULGARIAN = new Locale("bg", "bd");
    public static final Locale CA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CATALAN = new Locale("ca", "");
    public static final Locale CROATIAN = new Locale("hr", "");
    public static final Locale OLD_CROATIAN = new Locale("co", "");
    public static final Locale CZEH = new Locale("cs", "");
    public static final Locale DANISH = new Locale("da", "");
    public static final Locale DUTCH = new Locale("nl", "");
    public static final Locale EGYPTIAN = new Locale("ar", "EG");
    public static final Locale GB_ENGLISH = new Locale("en", "GB");
    public static final Locale ESTONIAN = new Locale("et", "");
    public static final Locale FINNISH = new Locale("fi", "");
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GREEK = new Locale("el", "");
    public static final Locale HEBREW = new Locale("iw", "");
    public static final Locale HUNGARIAN = new Locale("hu", "");
    public static final Locale ICELANDIC = new Locale("is", "");
    public static final Locale INDONESIAN = new Locale("id", "");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale AR_SPANISH = new Locale("es", "");
    public static final Locale LATVIAN = new Locale("lv", "");
    public static final Locale LITHUANIAN = new Locale("lt", "");
    public static final Locale MALAY = new Locale("ms", "");
    public static final Locale MX_SPANISH = new Locale("es", "MX");
    public static final Locale NORWEGIAN = new Locale("no", "");
    public static final Locale POLISH = new Locale("pl", "");
    public static final Locale PORTUGUESE = new Locale("pt", "");
    public static final Locale ROMANIAN = new Locale("ro", "");
    public static final Locale RUSSIAN = new Locale("ru", "");
    public static final Locale SMP_CHIN = Locale.SIMPLIFIED_CHINESE;
    public static final Locale SLOVAK = new Locale("sk", "");
    public static final Locale SLOVENIAN = new Locale("sl", "");
    public static final Locale SPANISH = new Locale("es", "ES");
    public static final Locale SWEDISH = new Locale("sv", "");
    public static final Locale TAMIL = new Locale("ta", "");
    public static final Locale THAI = new Locale("th", "");
    public static final Locale TR_CHIN = Locale.TRADITIONAL_CHINESE;
    public static final Locale TURKISH = new Locale("tr", "");
    public static final Locale UKRANINAN = new Locale("uk", "");
    public static final Locale VIETNAMESE = new Locale("vi", "");
    static final Locale[] m_oSupportedLanguages = new Locale[]{ENGLISH, FRENCH, ARABIC, IN_BENGALI, BR_PORTUGUESE, BULGARIAN, CA_FRENCH, CATALAN, CROATIAN, CZEH, DANISH, DUTCH, EGYPTIAN, GB_ENGLISH, ESTONIAN, FINNISH, GERMAN, GREEK, HEBREW, HUNGARIAN, ICELANDIC, INDONESIAN, ITALIAN, JAPANESE, KOREAN, AR_SPANISH, LATVIAN, LITHUANIAN, MALAY, MX_SPANISH, NORWEGIAN, POLISH, PORTUGUESE, ROMANIAN, RUSSIAN, SMP_CHIN, SLOVAK, SLOVENIAN, SPANISH, SWEDISH, THAI, TR_CHIN, TURKISH, UKRANINAN, VIETNAMESE};
    public static char[] escapeChars = new char[]{'-', '\\', '.', '?', '*', '+'};

    public static String stripBraces(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.startsWith("{") && s.endsWith("}")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static String stripQuotes(String s) {
        if (s == null) {
            return null;
        }
        String sTemp = s;
        if (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            sTemp = s.substring(1, s.length() - 1);
        }
        return sTemp;
    }

    public static String extractFilePath(String sFile) {
        if (sFile == null) {
            return null;
        }
        String newPath = sFile.replace('/', File.separatorChar);
        newPath = newPath.replace('\\', File.separatorChar);
        String sFilePath = new String();
        int offset = newPath.lastIndexOf(File.separatorChar);
        if (offset != -1) {
            sFilePath = newPath.substring(0, offset);
        }
        return sFilePath;
    }

    public static boolean isRelativePath(String sDirName) throws OiscuTextException {
        if (sDirName.length() == 0) {
            return true;
        }
        OiscxHelper.validatePath(sDirName);
        return sDirName.charAt(0) != '/' && (sDirName.length() <= 2 || sDirName.charAt(1) != ':' || !Character.isLetter(sDirName.charAt(0)));
    }

    public static void validatePath(String sPath) throws OiscuTextException {
        String path = sPath;
        int iTokenNum = 0;
        int iParentDirPathCount = 0;
        int iRegDirNameCount = 0;
        int i = path.indexOf(47);
        if (i != 0) {
            String subPath;
            if (i != -1) {
                subPath = path.substring(0, i);
                ++iRegDirNameCount;
                path = sPath.substring(i);
            } else {
                subPath = path;
            }
            int iFindColon = subPath.indexOf(58);
            if (iFindColon != -1 && iFindColon != 1) {
                throw new OiscuTextException("S_INVALID_DRIVE_NAME");
            }
            if (subPath == path && iFindColon != -1 && iFindColon == 1) {
                path = path.substring(2);
            }
        }
        StringTokenizer stPath = new StringTokenizer(path, "/");
        while (stPath.hasMoreTokens()) {
            String sDirName = stPath.nextToken();
            ++iTokenNum;
            if (OiscxHelper.containsIllegalChars(sDirName)) {
                throw new OiscuTextException("S_PATH_CONTAINS_ILLEGAL_CHARS");
            }
            if (sDirName.equals("..")) {
                ++iParentDirPathCount;
                continue;
            }
            ++iRegDirNameCount;
        }
        if (iParentDirPathCount > iRegDirNameCount) {
            throw new OiscuTextException("S_DIRECTORY_OUT_OF_BOUNDS");
        }
        if (sPath.lastIndexOf("//") > 0) {
            throw new OiscuTextException("S_DOUBLE_SLASHES_NOT_ALLOWED_IN_PATH");
        }
    }

    private static boolean containsIllegalChars(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char temchar = str.charAt(i);
            if (temchar != ':' && temchar != '*' && temchar != '?' && temchar != '\"' && temchar != '<' && temchar != '>' && temchar != '|' && temchar != '\\' && temchar != '/' && temchar != ';' && temchar != '\'' && temchar != '`' && temchar != '&' && temchar != '(' && temchar != ')' && temchar != '=' && temchar != '{' && temchar != '}' && temchar != '[' && temchar != ']' || i == 1 && temchar == ':' && Character.isLetter(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static void logError(OiscuErrorInformationBase oErr, OiscuProgressMessagesBase ml, int[] aiFdbk) {
        if (oErr == null) {
            return;
        }
        String sMsg = oErr.getErrorType() == 0 ? OisrbResourceLoader.getString("S_LOG_ALERT_ERROR") + oErr.getError() : (oErr.getErrorType() == 1 ? OisrbResourceLoader.getString("S_WARNING_TAG") + oErr.getError() : oErr.getError());
        OiscuErrorInformationBase oNewErrInfo = new OiscuErrorInformationBase(oErr.getErrorType(), sMsg);
        if (ml != null) {
            ml.logProgressMessage(oNewErrInfo);
        }
        int iErrType = oErr.getErrorType();
        if (aiFdbk != null && aiFdbk.length > iErrType) {
            int n = iErrType;
            aiFdbk[n] = aiFdbk[n] + 1;
        }
    }

    public static void logError(String sMesg, int iStatus) {
        if (sMesg == null) {
            return;
        }
        String sMsg = iStatus == 0 ? OisrbResourceLoader.getString("S_LOG_ALERT_ERROR") + sMesg : (iStatus == 1 ? OisrbResourceLoader.getString("S_WARNING_TAG") + sMesg : sMesg);
        OiscuDebug.print(sMsg);
    }

    public static OiscuUniqueVector LocaleArrtoVector(Locale[] vin) {
        if (vin == null) {
            return null;
        }
        int len = vin.length;
        OiscuUniqueVector vect = new OiscuUniqueVector("java.util.Locale");
        for (int i = 0; i < len; ++i) {
            try {
                vect.addElement(vin[i]);
                continue;
            }
            catch (OiscuCannotAddException e) {
                OiscuDebug.print("Cannot add Locale");
            }
        }
        return vect;
    }

    public static Locale StringToLocale(String localeString) throws OiscuTextException {
        StringTokenizer sToken = new StringTokenizer(localeString, "_");
        Vector<String> language = new Vector<String>();
        boolean i = false;
        Locale langLocale = new Locale("en", "US");
        while (sToken.hasMoreTokens()) {
            language.addElement(sToken.nextToken());
        }
        if (language.size() < 1 || language.size() > 2) {
            throw new OiscuTextException("S_LANGUAGE_ERROR");
        }
        langLocale = language.size() == 1 ? new Locale((String)language.elementAt(0), "") : new Locale((String)language.elementAt(0), (String)language.elementAt(1));
        return langLocale;
    }

    public static void checkLanguageSupported(String lang) throws OiscuParseException {
        boolean bSupported = false;
        try {
            Locale langlocale = OiscxHelper.StringToLocale(lang);
            if (langlocale != null) {
                for (int i = 0; i < m_oSupportedLanguages.length; ++i) {
                    if (!langlocale.equals(m_oSupportedLanguages[i])) continue;
                    bSupported = true;
                    break;
                }
                if (!bSupported) {
                    Object[] data = new Object[]{lang};
                    OiscxHelper.logError(MessageFormat.format(OisrbResourceLoader.getString("S_TEXT_LANGUAGES_INVALID_GENERIC"), data), 1);
                }
            }
        }
        catch (OiscuTextException e) {
            throw new OiscuParseException(e.getMessage());
        }
    }

    public static OiscuUniqueVector getLanguagesfromShortNames(String sLanguagesName) throws OiscuParseException {
        OiscuUniqueVector vLanguages = new OiscuUniqueVector("java.util.locale");
        if (sLanguagesName == null || sLanguagesName.equals("")) {
            return vLanguages;
        }
        if (sLanguagesName != null) {
            sLanguagesName = OiscxHelper.stripQuotes(sLanguagesName);
            sLanguagesName = OiscxHelper.stripBraces(sLanguagesName);
        }
        if (sLanguagesName.equalsIgnoreCase("ALL_LANGUAGES")) {
            vLanguages = OiscxHelper.LocaleArrtoVector(m_oSupportedLanguages);
            return vLanguages;
        }
        Vector<String> vLangs = new Vector<String>(0, 1);
        if (sLanguagesName.indexOf(",") != -1) {
            StringTokenizer st = new StringTokenizer(sLanguagesName, ",");
            while (st.hasMoreTokens()) {
                vLangs.addElement(st.nextToken());
            }
        } else if (sLanguagesName.trim().indexOf(" ") != -1) {
            StringTokenizer st = new StringTokenizer(sLanguagesName, " ");
            while (st.hasMoreTokens()) {
                vLangs.addElement(st.nextToken());
            }
        } else {
            vLangs.addElement(sLanguagesName);
        }
        return OiscxHelper.getLanguagesfromShortNames(vLangs);
    }

    public static OiscuUniqueVector getLanguagesfromShortNames(Vector vLangStrings) throws OiscuParseException {
        OiscuUniqueVector vLanguages = new OiscuUniqueVector("java.lang.String");
        if (vLangStrings.size() == 0) {
            return vLanguages;
        }
        String sCheck = "ALL_LANGUAGES";
        if (vLangStrings.size() == 1 && ((String)vLangStrings.elementAt(0)).equalsIgnoreCase(sCheck)) {
            vLanguages = OiscxHelper.LocaleArrtoVector(m_oSupportedLanguages);
            return vLanguages;
        }
        sCheck = "COMPONENT_LANGUAGES";
        if (vLangStrings.size() == 1 && ((String)vLangStrings.elementAt(0)).equalsIgnoreCase(sCheck)) {
            return vLanguages;
        }
        try {
            return OiscxHelper.getLangFromISONames(vLangStrings);
        }
        catch (OiscuTextException e) {
            throw new OiscuParseException(e.getMessage());
        }
    }

    private static OiscuUniqueVector getLangFromISONames(Vector v) throws OiscuTextException, OiscuParseException {
        if (v == null) {
            return new OiscuUniqueVector("java.util.Locale");
        }
        int vlength = v.size();
        OiscuUniqueVector out = new OiscuUniqueVector("java.util.Locale");
        String lang = "";
        try {
            for (int i = 0; i < vlength; ++i) {
                lang = (String)v.elementAt(i);
                Locale langlocale = OiscxHelper.StringToLocale(lang);
                OiscxHelper.checkLanguageSupported(lang);
                out.addElement(langlocale);
            }
        }
        catch (OiscuCannotAddException e) {
            Object[] args = new String[]{lang};
            throw new OiscuParseException("S_TEXT_LANGUAGES_DUPLICATE", args);
        }
        return out;
    }

    public static OiscuUniqueVector getFiltersFromString(String sFilters, String sGrpName, String sSrc) throws OiscuTextException {
        OiscuUniqueVector vFilters = new OiscuUniqueVector("java.lang.String");
        if (sFilters == null || sFilters.equals("")) {
            return vFilters;
        }
        if (sFilters != null) {
            sFilters = OiscxHelper.stripQuotes(sFilters);
            sFilters = sFilters.trim();
        }
        if (sFilters.equals("")) {
            try {
                vFilters.addElement("[.]*");
            }
            catch (OiscuCannotAddException oiscuCannotAddException) {
                // empty catch block
            }
            return vFilters;
        }
        if (sFilters.indexOf(";") != -1) {
            throw new OiscuTextException("S_TEXT_FILE_INVALID_FILTER_FORMAT");
        }
        if (sFilters.indexOf(",") != -1) {
            StringTokenizer st = new StringTokenizer(sFilters, ",");
            if (st.countTokens() == 0) {
                throw new OiscuTextException("S_TEXT_FILE_INVALID_FILTER_FORMAT");
            }
            boolean bMultipleFiltersSpecified = false;
            if (st.countTokens() > 1) {
                bMultipleFiltersSpecified = true;
            }
            Vector<String> vDuplicateFilters = new Vector<String>();
            while (st.hasMoreTokens()) {
                String sFilter = st.nextToken();
                sFilter = sFilter.trim();
                try {
                    vFilters.addElement(sFilter);
                    Pattern.compile(sFilter);
                }
                catch (OiscuCannotAddException excep) {
                    if (vDuplicateFilters.contains(sFilter)) continue;
                    vDuplicateFilters.addElement(sFilter);
                }
                catch (PatternSyntaxException pExcpn) {
                    throw new OiscuTextException("S_TEXT_FILE_INVALID_FILTER_FORMAT");
                }
            }
        } else {
            try {
                vFilters.addElement(sFilters);
                Pattern.compile(sFilters);
            }
            catch (OiscuCannotAddException st) {
            }
            catch (PatternSyntaxException pExcpn) {
                throw new OiscuTextException("S_TEXT_FILE_INVALID_FILTER_FORMAT");
            }
        }
        return vFilters;
    }

    public static Vector getFileSourceLocations(File sDir, OiscuUniqueVector uvFilters, OiscuUniqueVector excludeFilters, OiscuUniqueVector excludeDir, boolean bRecurse, Vector vFileSources) {
        if (sDir == null) {
            return vFileSources;
        }
        if (!sDir.exists()) {
            return vFileSources;
        }
        if (!sDir.isDirectory()) {
            return vFileSources;
        }
        if (!sDir.canRead()) {
            return vFileSources;
        }
        if (sDir.list().length == 0) {
            String sDirPath = "";
            sDirPath = sDir.getAbsolutePath();
            if (sDirPath.endsWith("/") || sDirPath.endsWith("\\")) {
                sDirPath = sDirPath.substring(0, sDirPath.length() - 1);
            }
            if (!vFileSources.contains(sDirPath)) {
                int iSize = uvFilters.size();
                for (int i = 0; i < iSize; ++i) {
                    String sFilter = (String)uvFilters.elementAt(i);
                    Pattern p = Pattern.compile(sFilter);
                    Matcher m = p.matcher(sDir.getName());
                    boolean b = m.matches();
                    if (!b) continue;
                    int iExcludeSz = excludeDir.size();
                    boolean bExclude = false;
                    for (int sz = 0; sz < iExcludeSz; ++sz) {
                        String sExclFilter = (String)excludeDir.elementAt(sz);
                        Pattern pExcl = Pattern.compile(sExclFilter);
                        Matcher mExcl = pExcl.matcher(sDir.getName());
                        if (!mExcl.matches()) continue;
                        bExclude = true;
                        break;
                    }
                    if (bExclude) break;
                    vFileSources.addElement(sDirPath);
                    break;
                }
            }
            return vFileSources;
        }
        if (bRecurse) {
            vFileSources = OiscxHelper.getFileSourcesFromDir(sDir, uvFilters, excludeFilters, vFileSources);
            File[] f_arr = sDir.listFiles();
            for (int i = 0; i < f_arr.length; ++i) {
                if (!f_arr[i].isDirectory() || !f_arr[i].isDirectory() || f_arr[i].getName().equalsIgnoreCase(ADE_PATH)) continue;
                int iExcludeDirSz = excludeDir.size();
                boolean bExclude = false;
                for (int sz = 0; sz < iExcludeDirSz; ++sz) {
                    String sExclFilter = (String)excludeDir.elementAt(sz);
                    Pattern pExcl = Pattern.compile(sExclFilter);
                    Matcher mExcl = pExcl.matcher(f_arr[i].getName());
                    if (!mExcl.matches()) continue;
                    bExclude = true;
                    break;
                }
                if (bExclude) continue;
                vFileSources = OiscxHelper.getFileSourceLocations(f_arr[i], uvFilters, excludeFilters, excludeDir, bRecurse, vFileSources);
            }
            return vFileSources;
        }
        vFileSources = OiscxHelper.getFileSourcesFromDir(sDir, uvFilters, excludeFilters, vFileSources);
        return vFileSources;
    }

    public static Vector getFileSourcesFromDir(File sDir, OiscuUniqueVector uvFilters, OiscuUniqueVector excludeFilters, Vector vFileSources) {
        int i;
        if (sDir == null) {
            return vFileSources;
        }
        if (!sDir.exists()) {
            return vFileSources;
        }
        if (!sDir.isDirectory()) {
            return vFileSources;
        }
        if (!sDir.canRead()) {
            return vFileSources;
        }
        if (sDir.list().length == 0) {
            return vFileSources;
        }
        if (uvFilters == null || uvFilters.size() == 0) {
            return vFileSources;
        }
        File[] f_arr = sDir.listFiles();
        boolean b_allFiles = false;
        String sExtn = "";
        for (i = 0; i < uvFilters.size(); ++i) {
            if (!uvFilters.elementAt(i).equals("[.]*")) continue;
            b_allFiles = true;
            for (int j = 0; j < f_arr.length; ++j) {
                if (!f_arr[j].isFile()) continue;
                String sPath = f_arr[j].getAbsolutePath();
                int iExcludeSz = excludeFilters.size();
                boolean bExclude = false;
                for (int sz = 0; sz < iExcludeSz; ++sz) {
                    String sExclFilter = (String)excludeFilters.elementAt(sz);
                    Pattern pExcl = Pattern.compile(sExclFilter);
                    Matcher mExcl = pExcl.matcher(f_arr[j].getName());
                    if (!mExcl.matches()) continue;
                    bExclude = true;
                    break;
                }
                if (bExclude || vFileSources.contains(sPath)) continue;
                vFileSources.addElement(sPath);
            }
            break;
        }
        if (b_allFiles) {
            return vFileSources;
        }
        for (i = 0; i < uvFilters.size(); ++i) {
            String sFilter = (String)uvFilters.elementAt(i);
            for (int j = 0; j < f_arr.length; ++j) {
                if (!f_arr[j].isFile()) continue;
                String sPath = f_arr[j].getAbsolutePath();
                Pattern p = Pattern.compile(sFilter);
                Matcher m = p.matcher(f_arr[j].getName());
                boolean b = m.matches();
                if (!b) continue;
                int iExcludeSz = excludeFilters.size();
                boolean bExclude = false;
                for (int sz = 0; sz < iExcludeSz; ++sz) {
                    String sExclFilter = (String)excludeFilters.elementAt(sz);
                    Pattern pExcl = Pattern.compile(sExclFilter);
                    Matcher mExcl = pExcl.matcher(f_arr[j].getName());
                    if (!mExcl.matches()) continue;
                    bExclude = true;
                }
                if (bExclude || vFileSources.contains(sPath)) continue;
                vFileSources.addElement(sPath);
            }
        }
        return vFileSources;
    }

    public static HashMap getMacrosCharsEscaped(HashMap macros) {
        HashMap<String, String> macrosEscaped = new HashMap<String, String>(macros);
        Set entries = macros.entrySet();
        for (Map.Entry ent : entries) {
            String key = (String)ent.getKey();
            String val = (String)ent.getValue();
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < val.length(); ++i) {
                for (int j = 0; j < escapeChars.length; ++j) {
                    if (val.charAt(i) != escapeChars[j]) continue;
                    sb.append("\\\\");
                    break;
                }
                sb.append(val.charAt(i));
            }
            macrosEscaped.put(key, sb.toString());
        }
        return macrosEscaped;
    }

    public static String substituteMacrosInString(HashMap macros, String sPath) {
        Set entries = macros.entrySet();
        Iterator setIter = entries.iterator();
        if (sPath.indexOf("($") != -1) {
            while (setIter.hasNext()) {
                Map.Entry ent = setIter.next();
                String key = (String)ent.getKey();
                String val = (String)ent.getValue();
                sPath = sPath.replaceAll(key, val);
            }
        }
        return sPath;
    }
}

