/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.sysman.ois.oisc.oiscu.OiscuCannotAddException;
import oracle.sysman.ois.oisc.oiscu.OiscuParseException;
import oracle.sysman.ois.oisc.oiscu.OiscuTextException;
import oracle.sysman.ois.oisc.oiscu.OiscuUniqueVector;
import oracle.sysman.ois.oisc.oiscx.OiscxComponentBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxHelper;
import oracle.sysman.ois.oisc.oiscx.OiscxIncludeData;
import oracle.sysman.ois.oisc.oiscx.OiscxLanguagesReader;
import oracle.sysman.ois.oisc.oiscx.OiscxLogUtil;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OiscxFilesListBuilder
extends OiscxComponentBuilder {
    ArrayList m_foundFiles = null;
    ArrayList m_missingFiles = null;
    ArrayList filesList = null;
    boolean m_bGenerated = false;
    private Set m_stageLangs = new HashSet();
    private String m_sExcludePattern = "";
    private String m_sExcludeDirPattern = "";
    private String m_sCompLangs = "";
    private Properties m_oSLVPairs;

    public OiscxFilesListBuilder(Properties slvpairs, String sCompLangs) {
        this.m_oSLVPairs = slvpairs;
        this.m_sCompLangs = sCompLangs;
        this.filesList = new ArrayList();
        this.m_foundFiles = new ArrayList();
        this.m_missingFiles = new ArrayList();
    }

    @Override
    public void init(boolean bImport) {
        this.reader = OiscxLanguagesReader.getLanguagesReader();
        this.m_nlsMap = this.reader.getNLSRTLMap();
        this.m_sDefaultLang = this.reader.getDefaultLang();
        if (!this.reader.isAdminLoaded()) {
            OiscxLogUtil.logErr("S_NO_WILDCARD_LANG", null, 0, true);
        }
        this.m_adminLangList = this.reader.getAdminLangsList();
        if (!this.reader.isRuntimeLoaded()) {
            OiscxLogUtil.logErr("S_NO_WILDCARD_LANG", null, 0, true);
        }
        this.m_runtimeLangList = this.reader.getRuntimeLangsList();
        this.m_bImported = bImport;
        if (bImport) {
            OiscxLogUtil.logErr("S_INVALID_IMPORT_OPERATION", null, 0, true);
        }
    }

    public void setStageLangs(String stageLangs) {
        try {
            OiscuUniqueVector vStageLangs = OiscxHelper.getLanguagesfromShortNames(stageLangs);
            this.m_stageLangs.addAll(vStageLangs.toVector());
        }
        catch (OiscuParseException e) {
            e.printStackTrace();
            this.m_stageLangs.add("en");
        }
    }

    @Override
    public void addExclude(String exclude) {
        if (this.m_sExcludePattern.length() > 0) {
            this.m_sExcludePattern = this.m_sExcludePattern + ",";
        }
        this.m_sExcludePattern = this.m_sExcludePattern + exclude;
    }

    @Override
    public void addExcludeDir(String exclude) {
        if (this.m_sExcludeDirPattern.length() > 0) {
            this.m_sExcludeDirPattern = this.m_sExcludeDirPattern + ",";
        }
        this.m_sExcludeDirPattern = this.m_sExcludeDirPattern + exclude;
    }

    private String getFiltersString(OiscuUniqueVector filters) {
        String sFilters = "";
        if (filters == null) {
            return sFilters;
        }
        int nFilters = filters.size();
        for (int i = 0; i < nFilters; ++i) {
            sFilters = sFilters + filters.elementAt(i).toString();
            if (i >= nFilters - 1) continue;
            sFilters = sFilters + ",";
        }
        return sFilters;
    }

    @Override
    public void addMacro(String macroName, String value) {
        this.m_macros.put(macroName, value);
    }

    @Override
    public void addInclude(OiscxIncludeData incl) throws SAXException {
        OiscuUniqueVector vLangs = new OiscuUniqueVector("java.util.Locale");
        boolean bSetGenericLangs = false;
        Object vList = null;
        String source = incl.getSource();
        String dest = incl.getDest();
        if ("ADMIN_LANGUAGES".equals(incl.m_sLangs) || "RUNTIME_LANGUAGES".equals(incl.m_sLangs)) {
            try {
                if ("ADMIN_LANGUAGES".equals(incl.m_sLangs)) {
                    vLangs = OiscxHelper.getLanguagesfromShortNames(new Vector(this.m_adminLangList));
                }
                vLangs = OiscxHelper.getLanguagesfromShortNames(new Vector(this.m_runtimeLangList));
            }
            catch (OiscuParseException e) {
                e.printStackTrace();
                throw new SAXParseException(null, this.m_locator, e);
            }
        } else {
            incl.m_sLangs.replace(' ', ',');
            try {
                vLangs = OiscxHelper.getLanguagesfromShortNames(incl.m_sLangs);
            }
            catch (OiscuParseException e) {
                e.printStackTrace();
                throw new SAXParseException(null, this.m_locator, e);
            }
        }
        if (vLangs.isEmpty()) {
            try {
                this.m_sCompLangs = "ALL_LANGUAGES";
                vLangs = OiscxHelper.getLanguagesfromShortNames(this.m_sCompLangs);
            }
            catch (OiscuParseException e) {
                e.printStackTrace();
                throw new SAXParseException(null, this.m_locator, e);
            }
        }
        boolean bNLSRTLWildcard = false;
        boolean bLocaleIDWildCard = false;
        boolean bNLSMapLoaded = false;
        if (this.containsLocaleWildcard(source) || this.containsLocaleWildcard(dest) || this.containsLocaleWildcard(incl.m_sDestRename) || this.containsLocaleWildcard(incl.m_sIncludePattern)) {
            bLocaleIDWildCard = true;
        }
        if (this.containsNLSRTLWildcard(source) || this.containsNLSRTLWildcard(dest) || this.containsNLSRTLWildcard(incl.m_sDestRename) || this.containsNLSRTLWildcard(incl.m_sIncludePattern)) {
            bNLSRTLWildcard = true;
            bNLSMapLoaded = this.reader.isNLSMappingLoaded();
            if (!bNLSMapLoaded) {
                OiscxLogUtil.logErr("S_NO_WILDCARD_NLSMAP", null, 0, true);
            }
        }
        try {
            for (int i = 0; i < vLangs.size(); ++i) {
                OiscxInclude file;
                boolean bDefaultLang = false;
                String sFileSource = source;
                String sFileDest = dest;
                String sFileIncludePattern = incl.m_sIncludePattern;
                String sFileRenamedDest = incl.m_sDestRename;
                OiscuUniqueVector vFileLangs = new OiscuUniqueVector("java.util.Locale");
                String isoname = ((Locale)vLangs.elementAt(i)).toString();
                if (!this.m_stageLangs.contains((Locale)vLangs.elementAt(i))) continue;
                if (isoname.equals(this.m_sDefaultLang)) {
                    bDefaultLang = true;
                }
                if (bLocaleIDWildCard) {
                    String substitute = isoname;
                    if (bDefaultLang) {
                        substitute = "";
                    }
                    sFileSource = this.substituteJavaLocaleWildcards(sFileSource, substitute);
                    sFileDest = this.substituteJavaLocaleWildcards(sFileDest, substitute);
                    sFileIncludePattern = this.substituteJavaLocaleWildcards(sFileIncludePattern, substitute);
                    sFileRenamedDest = this.substituteJavaLocaleWildcards(sFileRenamedDest, substitute);
                }
                if (bNLSRTLWildcard) {
                    String nlsname;
                    if (!bNLSMapLoaded) break;
                    if (isoname == null || this.m_nlsMap == null || (nlsname = bDefaultLang ? (String)this.m_nlsMap.get("default") : (String)this.m_nlsMap.get(isoname)) == null) continue;
                    sFileSource = this.substituteNLSRTLWildcards(sFileSource, nlsname);
                    sFileDest = this.substituteNLSRTLWildcards(sFileDest, nlsname);
                    sFileIncludePattern = this.substituteNLSRTLWildcards(sFileIncludePattern, nlsname);
                    sFileRenamedDest = this.substituteNLSRTLWildcards(sFileRenamedDest, nlsname);
                }
                try {
                    if (bDefaultLang || !bLocaleIDWildCard && !bNLSRTLWildcard) {
                        vFileLangs = (OiscuUniqueVector)vLangs.clone();
                    } else {
                        vFileLangs.addElement((Locale)vLangs.elementAt(i));
                    }
                }
                catch (OiscuCannotAddException e) {
                    e.printStackTrace();
                    throw new SAXParseException(null, this.m_locator, e);
                }
                if (incl.m_bDirectory) {
                    file = new OiscxInclude(sFileSource, sFileDest, incl.m_bDirectory, incl.m_bRecurse, OiscxHelper.getFiltersFromString(sFileIncludePattern, null, sFileSource));
                } else {
                    String destFile = sFileDest + File.separator + sFileRenamedDest;
                    String sourceFile = sFileSource + File.separator + sFileIncludePattern;
                    file = new OiscxInclude(sourceFile, destFile, incl.m_bDirectory, false, null);
                }
                file.setLanguages(vFileLangs);
                if (this.filesList.contains(file)) {
                    Object[] args = new String[]{file.getDest() + file.getFilters()};
                    OiscuCannotAddException e = new OiscuCannotAddException("S_DUPLICATE_FILE_OR_DIR", args);
                    throw new SAXParseException(null, this.m_locator, e);
                }
                this.filesList.add(file);
                if (bLocaleIDWildCard || bNLSRTLWildcard) {
                    continue;
                }
                break;
            }
        }
        catch (OiscuTextException e) {
            e.printStackTrace();
            throw new SAXParseException(null, this.m_locator, e);
        }
    }

    @Override
    public void addEmptyDir(String src, String dest, String sDirPerm) throws SAXException {
        String sDest = dest + "/";
        OiscxInclude file = new OiscxInclude(src, sDest, true, false, null);
        file.setEmptyDirFlag(true);
        if (this.filesList.contains(file)) {
            Object[] args = new String[]{file.getDest()};
            OiscuCannotAddException e = new OiscuCannotAddException("S_DUPLICATE_FILE_OR_DIR", args);
            throw new SAXParseException(null, this.m_locator, e);
        }
        this.filesList.add(file);
    }

    public ArrayList getFoundFilesList() {
        if (!this.m_bGenerated) {
            this.generateFileLists();
        }
        return this.m_foundFiles;
    }

    public ArrayList getMissingFilesList() {
        if (!this.m_bGenerated) {
            this.generateFileLists();
        }
        return this.m_missingFiles;
    }

    public void generateFileLists() {
        OiscuUniqueVector excludeFilters = null;
        OiscuUniqueVector excludeDirFilters = null;
        this.m_sExcludePattern = this.substituteMacrosInString(this.m_sExcludePattern);
        this.m_sExcludeDirPattern = this.substituteMacrosInString(this.m_sExcludeDirPattern);
        try {
            excludeFilters = OiscxHelper.getFiltersFromString(this.m_sExcludePattern, "", "");
            excludeDirFilters = OiscxHelper.getFiltersFromString(this.m_sExcludeDirPattern, "", "");
        }
        catch (OiscuTextException oiscuTextException) {
            // empty catch block
        }
        for (OiscxInclude oFileInclude : this.filesList) {
            OiscxInclude currFile;
            String filename = oFileInclude.getSourceFileName();
            String filedest = oFileInclude.getDest();
            Enumeration<?> slvEnum = this.m_oSLVPairs.propertyNames();
            while (slvEnum.hasMoreElements()) {
                String SLV = (String)slvEnum.nextElement();
                String value = this.m_oSLVPairs.getProperty(SLV);
                if (filename.indexOf("%" + SLV + "%") >= 0) {
                    filename = filename.replaceAll("%" + SLV + "%", SLV);
                }
                filename = filename.replaceAll(SLV, value);
                filedest = filedest.replaceAll(SLV, value);
                oFileInclude.setSource(filename);
            }
            HashMap macroEscaped = OiscxHelper.getMacrosCharsEscaped(this.m_macros);
            if (oFileInclude.isDirectory()) {
                OiscuUniqueVector oFilters = oFileInclude.getFilters();
                String sFileIncludePattern = OiscxHelper.substituteMacrosInString(macroEscaped, this.getFiltersString(oFilters));
                try {
                    OiscuUniqueVector newFilters = OiscxHelper.getFiltersFromString(sFileIncludePattern, null, filename);
                    oFileInclude.setFilters(newFilters);
                }
                catch (OiscuTextException newFilters) {
                    // empty catch block
                }
            }
            filename = OiscxHelper.substituteMacrosInString(this.m_macros, filename);
            filedest = OiscxHelper.substituteMacrosInString(this.m_macros, filedest);
            oFileInclude.setSource(filename);
            oFileInclude.setDest(filedest);
            if (oFileInclude.isDirectory()) {
                File location;
                Vector oFileLocsV = new Vector();
                OiscuUniqueVector oFilters = oFileInclude.getFilters();
                String sFiltersV = "";
                if (oFilters != null) {
                    Vector vFilters = oFilters.toVector();
                    sFiltersV = OiscxFilesListBuilder.objToString(vFilters);
                }
                File canonicalLoc = location = oFileInclude.getSource();
                try {
                    canonicalLoc = location.getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                String so = oFileInclude.getSourceFileName();
                String de = oFileInclude.getDest();
                if (canonicalLoc.exists() && canonicalLoc.canRead()) {
                    if (oFileInclude.isEmptyDirectory()) {
                        OiscxInclude matchedFile = new OiscxInclude(oFileInclude.getSourceFileName(), "", true, false, null);
                        this.m_foundFiles.add(matchedFile);
                        continue;
                    }
                    OiscxHelper.getFileSourceLocations(location, oFilters, excludeFilters, excludeDirFilters, oFileInclude.isRecursed(), oFileLocsV);
                    int matches = oFileLocsV.size();
                    if (matches == 0) {
                        OiscxInclude missingFile = new OiscxInclude(oFileInclude.getSourceFileName(), "", true, false, oFilters);
                        this.m_missingFiles.add(missingFile);
                    }
                    for (int i = 0; i < matches; ++i) {
                        String destfilename = (String)oFileLocsV.elementAt(i);
                        boolean fFound = true;
                        File fToAdd = new File(destfilename);
                        try {
                            fToAdd = fToAdd.getCanonicalFile();
                        }
                        catch (IOException e) {
                            fFound = false;
                        }
                        int k = location.getAbsolutePath().length();
                        if (de.endsWith("\\") || de.endsWith("/")) {
                            de = de.substring(0, de.length() - 1);
                        }
                        if (fToAdd.isDirectory()) {
                            if (k < destfilename.length()) {
                                destfilename = de + "/" + destfilename.substring(k + 1);
                            }
                            destfilename = destfilename + "/";
                        } else {
                            destfilename = de + "/" + destfilename.substring(k + 1);
                        }
                        OiscxInclude matchedFile = new OiscxInclude((String)oFileLocsV.elementAt(i), destfilename, false, false, null);
                        if (!(fToAdd.exists() && fFound && fToAdd.canRead())) {
                            this.m_missingFiles.add(matchedFile);
                            continue;
                        }
                        this.m_foundFiles.add(matchedFile);
                    }
                    continue;
                }
                OiscxInclude missingFile = new OiscxInclude(oFileInclude.getSourceFileName(), "", true, false, null);
                missingFile.setEmptyDirFlag(oFileInclude.isEmptyDirectory());
                this.m_missingFiles.add(missingFile);
                continue;
            }
            File location = oFileInclude.getSource();
            String destination = oFileInclude.getDest();
            if (!location.exists()) {
                currFile = new OiscxInclude(oFileInclude.getSourceFileName(), destination, false, false, null);
                this.m_missingFiles.add(currFile);
                continue;
            }
            currFile = new OiscxInclude(location.getAbsolutePath(), destination, false, false, null);
            this.m_foundFiles.add(currFile);
        }
        this.m_bGenerated = true;
    }

    public static String objToString(Object obj) {
        String retStr;
        if (obj == null) {
            return String.valueOf(obj);
        }
        boolean isArr = obj.getClass().isArray();
        if (isArr) {
            StringBuffer objStr = new StringBuffer();
            objStr.append("[ ");
            int arrLength = Array.getLength(obj);
            for (int i = 0; i < arrLength; ++i) {
                objStr.append(OiscxFilesListBuilder.objToString(Array.get(obj, i)));
                objStr.append(" ");
            }
            objStr.append("]");
            retStr = objStr.toString();
        } else if (obj instanceof Vector) {
            StringBuffer objStr = new StringBuffer();
            objStr.append("[ ");
            int vectLength = ((Vector)obj).size();
            for (int i = 0; i < vectLength; ++i) {
                objStr.append(OiscxFilesListBuilder.objToString(((Vector)obj).elementAt(i)));
                objStr.append(" ");
            }
            objStr.append("]");
            retStr = objStr.toString();
        } else {
            retStr = obj.toString();
        }
        return retStr;
    }

    public class OiscxInclude {
        String m_sSource;
        String m_sDest;
        OiscuUniqueVector m_uvFilters;
        OiscuUniqueVector m_langs;
        boolean m_bIsDirectory;
        boolean m_bIsEmptyDirectory = false;
        boolean m_bRecurse;
        String m_sPerm;

        public OiscxInclude(String sFileSource, String sFileDest, boolean bDirectory, boolean bRecurse, OiscuUniqueVector filters) {
            this.m_sSource = sFileSource;
            this.m_sDest = sFileDest;
            this.m_bIsDirectory = bDirectory;
            this.m_bRecurse = bRecurse;
            this.m_uvFilters = filters;
        }

        public String getPerms() {
            return this.m_sPerm;
        }

        public void setPerms(String sPerms) {
            this.m_sPerm = sPerms;
        }

        public boolean isRecursed() {
            return this.m_bRecurse;
        }

        public boolean isDirectory() {
            return this.m_bIsDirectory;
        }

        public boolean isEmptyDirectory() {
            return this.m_bIsEmptyDirectory;
        }

        public void setEmptyDirFlag(boolean empty) {
            this.m_bIsEmptyDirectory = empty;
        }

        public void setRecursed(boolean recurse) {
            this.m_bRecurse = recurse;
        }

        public void setSource(String source) {
            this.m_sSource = source;
        }

        public void setDest(String dest) {
            this.m_sDest = dest;
        }

        public void setFilters(OiscuUniqueVector filters) {
            this.m_uvFilters = filters;
        }

        public void setLanguages(OiscuUniqueVector langs) {
            this.m_langs = langs;
        }

        public File getSource() {
            return new File(this.m_sSource);
        }

        public String getSourceFileName() {
            return this.m_sSource;
        }

        public String getDest() {
            return this.m_sDest;
        }

        public OiscuUniqueVector getFilters() {
            return this.m_uvFilters;
        }

        public boolean equals(Object incl) {
            if (!(incl instanceof OiscxInclude)) {
                return false;
            }
            OiscxInclude oIncl = (OiscxInclude)incl;
            return oIncl.isDirectory() && this.isDirectory() ? (oIncl.isEmptyDirectory() && this.isEmptyDirectory() ? oIncl.getDest().equals(this.getDest()) : !this.isEmptyDirectory() && oIncl.getDest().equals(this.getDest()) && oIncl.getSourceFileName().equals(this.getSourceFileName()) && this.getFilters().equals(oIncl.getFilters())) : !this.isDirectory() && oIncl.getDest().equals(this.getDest()) && oIncl.getSourceFileName().equals(this.getSourceFileName());
        }
    }
}

