/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import oracle.sysman.ois.oisc.oiscu.OiscuFatalException;
import oracle.sysman.ois.oisc.oiscx.OiscxComponentBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxFileMapHandler;
import oracle.sysman.ois.oisc.oiscx.OiscxLogUtil;
import oracle.sysman.ois.oisc.oiscx.OiscxTextManagerBase;
import oracle.sysman.ois.oisc.oiscx.OiscxXMLOps;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.schema.XSDException;
import oracle.xml.parser.v2.SAXParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class OiscxFileMapReader {
    public static final String S_MAPFILE_EXT = ".map.xml";
    public static final int NOT_LOADED = 0;
    public static final int LOADED = 1;
    private OiscxComponentBuilder m_oBuilder = null;

    public OiscxFileMapReader(OiscxComponentBuilder builder) throws NullPointerException {
        if (builder == null) {
            throw new NullPointerException();
        }
        this.m_oBuilder = builder;
    }

    public void parse(String sFileName, String sComponentTextLocation) throws OiscuFatalException {
        boolean bImportFileMap = false;
        if (sFileName != null) {
            bImportFileMap = true;
        } else {
            sFileName = sComponentTextLocation + S_MAPFILE_EXT;
        }
        OiscxFileMapHandler handler = null;
        Object fReader = null;
        Object bReader = null;
        if (!OiscxTextManagerBase.checkForExistingFiles(1, sFileName)) {
            this.m_oBuilder.createEmptyFilemap();
            Object[] sArgs = new String[]{sFileName};
            OiscxLogUtil.logErr("S_IO_EXCEPTION_FILE_NOT_FOUND", sArgs, 1, true);
            return;
        }
        try {
            XSDBuilder builder = new XSDBuilder();
            String schemaLoc = System.getProperty("OSP_Schema_Location");
            URL url = this.createURL(schemaLoc);
            XMLSchema schemadoc = builder.build(url);
            XMLReader parser = OiscxXMLOps.createSAXParser(false, true);
            handler = new OiscxFileMapHandler(this.m_oBuilder, bImportFileMap);
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.setEntityResolver(handler);
            ((SAXParser)parser).setXMLSchema((Object)schemadoc);
            parser.parse(new InputSource(this.createURL(sFileName).toString()));
        }
        catch (SAXException e) {
            OiscxLogUtil.logErr(e.getMessage(), null, 0, false);
            throw new OiscuFatalException(e);
        }
        catch (IOException e) {
            Object[] sArgs = new String[]{sFileName};
            OiscxLogUtil.logErr("S_IO_EXCEPTION_FILEMAP", sArgs, 0, true);
            throw new OiscuFatalException(e);
        }
        catch (XSDException e) {
            OiscxLogUtil.logErr(e.getMessage(), null, 0, false);
            throw new OiscuFatalException((Exception)((Object)e));
        }
    }

    private URL createURL(String fileName) {
        URL url = null;
        try {
            url = new URL(fileName);
        }
        catch (MalformedURLException ex) {
            File f = new File(fileName);
            try {
                String path = f.getAbsolutePath();
                String fs = System.getProperty("file.separator");
                if (fs.length() == 1) {
                    char sep = fs.charAt(0);
                    if (sep != '/') {
                        path = path.replace(sep, '/');
                    }
                    if (path.charAt(0) != '/') {
                        path = '/' + path;
                    }
                }
                path = "file://" + path;
                url = new URL(path);
            }
            catch (MalformedURLException e) {
                Object[] sArgs = new String[]{fileName};
                OiscxLogUtil.logErr("S_IO_EXCEPTION_FILE_NOT_FOUND", sArgs, 0, true);
                return null;
            }
        }
        return url;
    }
}

