/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.util.HashMap;
import oracle.sysman.ois.oisc.oiscx.OiscxComponentBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxDefaultHandler;
import oracle.sysman.ois.oisc.oiscx.OiscxElementHandler;
import oracle.sysman.ois.oisc.oiscx.OiscxIncludeData;
import oracle.sysman.ois.oisc.oiscx.OiscxLanguagesReader;
import oracle.sysman.ois.oisc.oiscx.OiscxLogUtil;
import oracle.sysman.ois.oisc.oiscx.OiscxTextElementHandler;
import oracle.sysman.ois.oisr.oisrb.OisrbResourceLoader;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OiscxFileMapHandler
extends OiscxDefaultHandler {
    private OiscxElementHandler m_handlerFileMap;
    private OiscxElementHandler m_handlerExclude;
    private OiscxElementHandler m_handlerExcludeDir;
    private OiscxElementHandler m_handlerFileMapGenElement;
    private OiscxElementHandler m_handlerFileMapPlatElement;
    private OiscxElementHandler m_handlerFileMapEntryElement;
    private OiscxTextElementHandler m_handlerFileMapEntrySource;
    private OiscxTextElementHandler m_handlerFileMapEntryDestination;
    private OiscxElementHandler m_handlerFileMapInclude;
    private OiscxElementHandler m_handlerFileMapMacrosElement;
    private OiscxElementHandler m_handlerFileMapMacro;
    private String m_sPlat = "ALL_PLATFORMS";
    public static final String S_ALL_LANGUAGES = "ALL_LANGUAGES";
    public String IS_DIRECTORY_ENTRY = "isDirectory";
    public String IS_EMPTY_DIRECTORY = "isEmptyDir";
    private String m_sExcludePattern = "";
    private String m_sExcludeDirPattern = "";
    private String m_Source = "";
    private String m_sDest = "";
    private String m_sDestPermission = "";
    private boolean m_bIsEmptyDir = true;
    private Locator m_locator = null;
    private boolean m_bImported = false;
    HashMap m_fileGroupMap = new HashMap();
    public OiscxLanguagesReader reader = null;
    private OiscxComponentBuilder m_oBuilder = null;

    public OiscxFileMapHandler(OiscxComponentBuilder oBuilder, boolean bImport) throws SAXException {
        this.m_oBuilder = oBuilder;
        this.m_oBuilder.init(bImport);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
        this.m_oBuilder.setDocumentLocator(locator);
    }

    @Override
    protected OiscxElementHandler createElementHandlers() {
        this.m_handlerFileMap = new OiscxElementHandler("filemap"){

            @Override
            public void onStart(String name, Attributes atts) throws SAXException {
                super.onStart(name, atts);
                String sSchemaLoc = atts.getValue(1);
                String sAttName = atts.getQName(1);
                if (sAttName != null && sAttName.startsWith("xsi")) {
                    System.setProperty("SchemaLoc", sSchemaLoc);
                }
            }
        };
        this.m_handlerExclude = new OiscxElementHandler("exclude"){

            @Override
            public void onStart(String name, Attributes atts) throws SAXException {
                super.onStart(name, atts);
                String exclude = atts.getValue("pattern");
                if (exclude != null) {
                    OiscxFileMapHandler.this.m_oBuilder.addExclude(exclude);
                }
            }
        };
        this.m_handlerExcludeDir = new OiscxElementHandler("exclude_directory"){

            @Override
            public void onStart(String name, Attributes atts) throws SAXException {
                super.onStart(name, atts);
                String exclude = atts.getValue("pattern");
                if (exclude != null) {
                    OiscxFileMapHandler.this.m_oBuilder.addExcludeDir(exclude);
                }
            }
        };
        this.m_handlerFileMapMacrosElement = new OiscxElementHandler("macros");
        this.m_handlerFileMapMacro = new OiscxElementHandler("macro"){

            @Override
            public void onStart(String name, Attributes atts) throws SAXException {
                super.onStart(name, atts);
                String macroName = "\\(\\$" + atts.getValue("name") + "\\)";
                String macroValue = atts.getValue("value");
                OiscxFileMapHandler.this.m_oBuilder.addMacro(macroName, macroValue);
            }
        };
        this.m_handlerFileMapGenElement = new OiscxFileMapElementHandler("filemap_generic");
        this.m_handlerFileMapPlatElement = new OiscxFileMapElementHandler("filemap_osd");
        this.m_handlerFileMapEntryElement = new OiscxElementHandler("entry"){

            @Override
            public void onStart(String name, Attributes atts) throws SAXException {
                super.onStart(name, atts);
                OiscxFileMapHandler.this.m_oBuilder.createNewGroup();
            }

            @Override
            public void onEnd(String name) throws SAXException {
                if (OiscxFileMapHandler.this.m_bIsEmptyDir) {
                    try {
                        OiscxFileMapHandler.this.m_Source = OiscxFileMapHandler.this.m_handlerFileMapEntrySource.getText();
                        OiscxFileMapHandler.this.m_sDest = OiscxFileMapHandler.this.m_handlerFileMapEntryDestination.getText();
                        OiscxFileMapHandler.this.m_oBuilder.addEmptyDir(OiscxFileMapHandler.this.m_Source, OiscxFileMapHandler.this.m_sDest, OiscxFileMapHandler.this.m_sDestPermission);
                    }
                    catch (IllegalStateException e) {
                        String sLine = String.valueOf(OiscxFileMapHandler.this.m_locator.getLineNumber());
                        Object[] sArgs = new String[]{sLine};
                        OiscxLogUtil.logErr("S_FILEMAP_PARSE_FAILED", sArgs, 0, true);
                        throw new SAXParseException(null, OiscxFileMapHandler.this.m_locator);
                    }
                }
                OiscxFileMapHandler.this.m_Source = "";
                OiscxFileMapHandler.this.m_bIsEmptyDir = true;
                OiscxFileMapHandler.this.m_sDest = "";
                OiscxFileMapHandler.this.m_sDestPermission = "";
            }
        };
        this.m_handlerFileMapEntrySource = new OiscxTextElementHandler("source");
        this.m_handlerFileMapEntryDestination = new OiscxTextElementHandler("destination");
        this.m_handlerFileMapInclude = new OiscxElementHandler("include"){
            private String m_sIncludePattern;
            private String m_sDestRename;
            private String m_sPerm;
            private String m_sIncludeDirPerm;
            private boolean m_bRecurse;
            private boolean m_bDirectory;
            private String m_sCheckVer;
            private boolean m_bArchive;
            private boolean m_bAsText;
            private boolean m_bParseErr;
            private String m_StageDir;
            private boolean m_bCopyAsZeroBytes;
            private String m_sLangs;
            private boolean m_bInstantiate;
            {
                this.m_sIncludePattern = "[.]*";
                this.m_sDestRename = "";
                this.m_sPerm = "";
                this.m_sIncludeDirPerm = "";
                this.m_bRecurse = false;
                this.m_bDirectory = false;
                this.m_sCheckVer = "";
                this.m_bArchive = true;
                this.m_bAsText = false;
                this.m_bParseErr = false;
                this.m_StageDir = "";
                this.m_bCopyAsZeroBytes = false;
                this.m_sLangs = "";
                this.m_bInstantiate = false;
            }

            @Override
            public void onStart(String name, Attributes atts) throws SAXException {
                String sInstantiate;
                String sZero;
                String sStage;
                String sAsText;
                String sArchive;
                String sChkver;
                super.onStart(name, atts);
                String sAttVal = null;
                OiscxFileMapHandler.this.m_bIsEmptyDir = false;
                sAttVal = atts.getValue("pattern");
                if (sAttVal != null) {
                    String sDirPerm;
                    this.m_sIncludePattern = sAttVal;
                    String sRecurse = atts.getValue("recurse");
                    if (sRecurse != null && sRecurse.equalsIgnoreCase("true")) {
                        this.m_bRecurse = true;
                    }
                    if ((sDirPerm = atts.getValue("directory_permission")) != null) {
                        this.m_sIncludeDirPerm = sDirPerm;
                    } else if (!OiscxFileMapHandler.this.m_sDestPermission.equals("")) {
                        this.m_sIncludeDirPerm = OiscxFileMapHandler.this.m_sDestPermission;
                    }
                    this.m_bDirectory = true;
                } else {
                    sAttVal = atts.getValue("file");
                    if (sAttVal == null) {
                        this.m_bParseErr = true;
                        Object[] asElems = new String[]{"pattern", "file"};
                        OiscxLogUtil.logErr("S_TEXT_WARN_INCLUDE_PATTERN_EMPTY", asElems, 1, true);
                        return;
                    }
                    this.m_sIncludePattern = sAttVal;
                    sAttVal = atts.getValue("rename");
                    this.m_sDestRename = sAttVal != null ? sAttVal : this.m_sIncludePattern;
                }
                sAttVal = atts.getValue("permission");
                if (sAttVal != null) {
                    this.m_sPerm = sAttVal;
                }
                if ((sChkver = atts.getValue("checkver")) != null) {
                    this.m_sCheckVer = sChkver;
                }
                if ((sArchive = atts.getValue("archive")) != null && sArchive.equalsIgnoreCase("false")) {
                    this.m_bArchive = false;
                }
                if ((sAsText = atts.getValue("astext")) != null && sAsText.equalsIgnoreCase("true")) {
                    this.m_bAsText = true;
                }
                if ((sStage = atts.getValue("stagedir")) != null) {
                    this.m_StageDir = sStage;
                }
                if ((sZero = atts.getValue("copyAsZeroBytes")) != null && sZero.equalsIgnoreCase("true")) {
                    this.m_bCopyAsZeroBytes = true;
                }
                if ((sAttVal = atts.getValue("langs")) != null) {
                    this.m_sLangs = sAttVal;
                }
                if ((sInstantiate = atts.getValue("copyAsZeroBytes")) != null && sInstantiate.equalsIgnoreCase("true")) {
                    this.m_bInstantiate = true;
                }
            }

            @Override
            public void onEnd(String name) throws SAXException {
                int line = OiscxFileMapHandler.this.m_locator.getLineNumber();
                if (this.m_bParseErr) {
                    this.reset();
                    return;
                }
                try {
                    OiscxFileMapHandler.this.m_Source = OiscxFileMapHandler.this.m_handlerFileMapEntrySource.getText();
                    OiscxFileMapHandler.this.m_sDest = OiscxFileMapHandler.this.m_handlerFileMapEntryDestination.getText();
                }
                catch (IllegalStateException e) {
                    String sLine = String.valueOf(line);
                    Object[] sArgs = new String[]{sLine};
                    throw new SAXParseException(OisrbResourceLoader.getString("S_FILEMAP_PARSE_FAILED", sArgs), OiscxFileMapHandler.this.m_locator);
                }
                OiscxIncludeData include = new OiscxIncludeData();
                include.setArchive(this.m_bArchive);
                include.setAsText(this.m_bAsText);
                include.setChkver(this.m_sCheckVer);
                include.setDest(OiscxFileMapHandler.this.m_sDest);
                include.setSource(OiscxFileMapHandler.this.m_Source);
                include.setIncludePattern(this.m_sIncludePattern);
                include.setCopyAsZeroBytes(this.m_bCopyAsZeroBytes);
                include.setDirectoryFlag(this.m_bDirectory);
                include.setRecurse(this.m_bRecurse);
                include.setPerm(this.m_sPerm);
                include.setDirPerm(this.m_sIncludeDirPerm);
                include.setLangs(this.m_sLangs);
                include.setDestRename(this.m_sDestRename);
                include.setStageDir(this.m_StageDir);
                include.setInstantiate(this.m_bInstantiate);
                OiscxFileMapHandler.this.m_oBuilder.addInclude(include);
                this.reset();
            }

            private void reset() {
                this.m_sIncludePattern = "[.]*";
                this.m_bDirectory = false;
                this.m_sPerm = "";
                this.m_sIncludeDirPerm = "";
                this.m_sDestRename = "";
                this.m_bRecurse = false;
                this.m_sCheckVer = "";
                this.m_bArchive = true;
                this.m_bAsText = false;
                this.m_sLangs = "";
                this.m_bParseErr = false;
                this.m_StageDir = "";
                this.m_bCopyAsZeroBytes = false;
            }
        };
        this.m_handlerFileMapEntryElement.addChildHandler("source", this.m_handlerFileMapEntrySource);
        this.m_handlerFileMapEntryElement.addChildHandler("include", this.m_handlerFileMapInclude);
        this.m_handlerFileMapEntryElement.addChildHandler("destination", this.m_handlerFileMapEntryDestination);
        this.m_handlerFileMapGenElement.addChildHandler("entry", this.m_handlerFileMapEntryElement);
        this.m_handlerFileMapPlatElement.addChildHandler("entry", this.m_handlerFileMapEntryElement);
        this.m_handlerFileMap.addChildHandler("filemap_osd", this.m_handlerFileMapPlatElement);
        this.m_handlerFileMap.addChildHandler("exclude", this.m_handlerExclude);
        this.m_handlerFileMap.addChildHandler("exclude_directory", this.m_handlerExcludeDir);
        this.m_handlerFileMap.addChildHandler("filemap_generic", this.m_handlerFileMapGenElement);
        this.m_handlerFileMap.addChildHandler("macros", this.m_handlerFileMapMacrosElement);
        this.m_handlerFileMapMacrosElement.addChildHandler("macro", this.m_handlerFileMapMacro);
        return this.m_handlerFileMap;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        this.m_oBuilder.addEntity(systemId);
        return null;
    }

    class OiscxFileMapElementHandler
    extends OiscxElementHandler {
        OiscxFileMapElementHandler(String name) {
            super(name);
        }

        @Override
        public void onStart(String name, Attributes atts) throws SAXException {
            super.onStart(name, atts);
        }

        @Override
        public void onEnd(String name) throws SAXException {
            OiscxFileMapHandler.this.m_sPlat = "ALL_PLATFORMS";
        }
    }
}

