/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.util.Hashtable;
import java.util.Stack;
import oracle.sysman.ois.oisc.oiscx.OiscxAttributeListImpl;
import oracle.sysman.ois.oisc.oiscx.OiscxUnknownElementHandler;
import oracle.xml.parser.v2.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class OiscxElementHandler {
    private Hashtable m_childHandlers = new Hashtable();
    private String m_sName;
    private OiscxUnknownElementHandler m_unknownElementHandler;

    public OiscxElementHandler() {
    }

    public OiscxElementHandler(String name) {
        this.m_sName = name;
    }

    public void addChildHandler(String name, OiscxElementHandler handler) {
        this.m_childHandlers.put(name, handler);
    }

    public String getName() {
        return this.m_sName;
    }

    public void startElement(String uri, String localname, String qName, Attributes attributes, Stack handlers) throws SAXException {
        OiscxElementHandler childHandler = (OiscxElementHandler)this.m_childHandlers.get(localname);
        if (childHandler == null) {
            if (this.m_unknownElementHandler == null) {
                throw new SAXException("Unknown tag " + localname + " encountered");
            }
            childHandler = this.m_unknownElementHandler;
        }
        handlers.push(childHandler);
        OiscxAttributeListImpl oai = new OiscxAttributeListImpl(attributes);
        childHandler.onStart(localname, oai);
        childHandler.setUnknownElementHandler(localname, oai);
    }

    public void endElement(String name, Stack handlers) throws SAXException {
        this.onEnd(name);
        handlers.pop();
    }

    public void onText(char[] chars, int start, int length) {
    }

    public Object getObject() {
        return null;
    }

    public void onStart(String name, Attributes atts) throws SAXException {
    }

    public void onEnd(String name) throws SAXException {
    }

    protected OiscxElementHandler getChildHandler(String name) {
        OiscxElementHandler handler = null;
        handler = (OiscxElementHandler)this.m_childHandlers.get(name);
        return handler;
    }

    void setUnknownElementHandler(String name, Attributes atts) {
        this.m_unknownElementHandler = new OiscxUnknownElementHandler(name);
        this.m_unknownElementHandler.setElementAttributes(atts);
    }

    public XMLElement getUnknownXMLElement() {
        if (this.m_unknownElementHandler != null) {
            return this.m_unknownElementHandler.getElement();
        }
        return null;
    }
}

