/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscx;

import java.util.Stack;
import oracle.sysman.ois.oisc.oiscx.OiscxElementHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class OiscxDefaultHandler
extends DefaultHandler {
    private Stack m_handlers = new Stack();
    private boolean m_bRootHandled = false;

    public OiscxDefaultHandler() throws SAXException {
        OiscxElementHandler root = this.createElementHandlers();
        if (root == null) {
            throw new SAXException("Null root handler");
        }
        this.m_handlers.push(root);
    }

    @Override
    public void startElement(String uri, String localname, String qName, Attributes attributes) throws SAXException {
        OiscxElementHandler handler = (OiscxElementHandler)this.m_handlers.peek();
        if (!this.m_bRootHandled) {
            handler.onStart(localname, attributes);
            handler.setUnknownElementHandler(localname, attributes);
            this.m_bRootHandled = true;
        } else {
            handler.startElement(uri, localname, qName, attributes, this.m_handlers);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        OiscxElementHandler handler = (OiscxElementHandler)this.m_handlers.peek();
        handler.endElement(localName, this.m_handlers);
    }

    protected OiscxElementHandler createElementHandlers() {
        return null;
    }

    @Override
    public void characters(char[] chars, int nStart, int nLength) throws SAXException {
        OiscxElementHandler handler = (OiscxElementHandler)this.m_handlers.peek();
        handler.onText(chars, nStart, nLength);
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        e.printStackTrace();
        super.warning(e);
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(e.getMessage());
    }
}

