/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscu;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.sysman.ois.oisc.oiscs.OiscsIOrderedElement;
import oracle.sysman.ois.oisc.oiscu.OiscuCannotAddException;
import oracle.sysman.ois.oisc.oiscu.OiscuDebug;

public final class OiscuUniqueVector
implements Serializable,
Cloneable {
    static final long serialVersionUID = -8609369131508347785L;
    private Vector m_vVector;
    private String m_sElementClassName;
    private Class m_classElementType;
    private final int INIT_SIZE = 5;
    private final int INIT_INCR_CAPACITY = 5;

    public OiscuUniqueVector(String sElementClassName, Hashtable oTable) {
        this.m_vVector = oTable != null ? new Vector(oTable.size(), 5) : new Vector(5, 5);
        this.m_sElementClassName = sElementClassName;
        this.m_classElementType = null;
        if (oTable != null) {
            Enumeration enumObject = oTable.elements();
            while (enumObject.hasMoreElements()) {
                Object o = enumObject.nextElement();
                if (o == null || !o.getClass().getName().equals(sElementClassName)) continue;
                this.m_vVector.addElement(o);
            }
        }
    }

    public OiscuUniqueVector(String sElementClassName) {
        this.m_vVector = new Vector(5, 5);
        this.m_sElementClassName = sElementClassName;
        this.m_classElementType = null;
    }

    public OiscuUniqueVector(String sElementClassName, int initial, int inc) {
        this.m_vVector = new Vector(initial, inc);
        this.m_sElementClassName = sElementClassName;
        this.m_classElementType = null;
    }

    public String getElementClassName() {
        return this.m_sElementClassName;
    }

    private void validateElementType(Object oObject) throws OiscuCannotAddException {
        try {
            if (this.m_classElementType == null) {
                this.m_classElementType = Class.forName(this.m_sElementClassName);
            }
        }
        catch (ClassNotFoundException exception) {
            OiscuCannotAddException e = new OiscuCannotAddException("S_INCORRECT_OBJECT_TYPE");
            throw e;
        }
        if (!this.m_classElementType.isInstance(oObject)) {
            OiscuCannotAddException e = new OiscuCannotAddException("S_INCORRECT_OBJECT_TYPE");
            throw e;
        }
    }

    public void addElement(Object oObject) throws OiscuCannotAddException {
        this.validateElementType(oObject);
        int nIndex = this.m_vVector.indexOf(oObject);
        if (nIndex != -1) {
            OiscuCannotAddException e = new OiscuCannotAddException("S_ALREADY_EXISTING");
            throw e;
        }
        this.m_vVector.addElement(oObject);
    }

    public void addElements(OiscuUniqueVector uniqueVector) throws OiscuCannotAddException {
        if (uniqueVector == null) {
            return;
        }
        int size = uniqueVector.size();
        for (int i = 0; i < size; ++i) {
            this.addElement(uniqueVector.m_vVector.elementAt(i));
        }
    }

    public void addAscending(OiscsIOrderedElement oOrderedElement) throws OiscuCannotAddException {
        this.validateElementType(oOrderedElement);
        int iSize = this.m_vVector.size();
        int insertAtIndex = 0;
        boolean bFoundIndexToInsertAt = false;
        for (int i = 0; i < iSize; ++i) {
            OiscsIOrderedElement oNextElement = (OiscsIOrderedElement)this.m_vVector.elementAt(i);
            int iCompare = oOrderedElement.compareTo(oNextElement);
            if (iCompare == 0) {
                OiscuCannotAddException e = new OiscuCannotAddException("S_ALREADY_EXISTING");
                throw e;
            }
            if (iCompare > -1) continue;
            insertAtIndex = i;
            bFoundIndexToInsertAt = true;
            break;
        }
        if (bFoundIndexToInsertAt) {
            this.m_vVector.insertElementAt(oOrderedElement, insertAtIndex);
        } else {
            this.m_vVector.addElement(oOrderedElement);
        }
    }

    public int indexOf(Object oElement) {
        return this.m_vVector.indexOf(oElement);
    }

    public void removeAllElements() {
        this.m_vVector.removeAllElements();
    }

    public boolean removeElement(Object obj) {
        return this.m_vVector.removeElement(obj);
    }

    public void removeElementAt(int index) throws ArrayIndexOutOfBoundsException {
        this.m_vVector.removeElementAt(index);
    }

    public void insertElementAt(Object oObject, int nIndex) throws OiscuCannotAddException {
        this.validateElementType(oObject);
        int nReturnedIndex = this.m_vVector.indexOf(oObject);
        if (nReturnedIndex != -1) {
            OiscuCannotAddException e = new OiscuCannotAddException("S_ALREADY_EXISTING");
            throw e;
        }
        this.m_vVector.insertElementAt(oObject, nIndex);
    }

    public void setElementAt(Object oObject, int nIndex) throws OiscuCannotAddException {
        this.validateElementType(oObject);
        int nReturnedIndex = this.m_vVector.indexOf(oObject);
        if (nReturnedIndex != -1) {
            OiscuCannotAddException e = new OiscuCannotAddException("S_ALREADY_EXISTING");
            throw e;
        }
        this.m_vVector.setElementAt(oObject, nIndex);
    }

    public int indexOf(String sName) {
        int nSize = this.m_vVector.size();
        for (int nCnt = 0; nCnt < nSize; ++nCnt) {
            if (!this.m_vVector.elementAt(nCnt).toString().equals(sName)) continue;
            return nCnt;
        }
        return -1;
    }

    public boolean contains(Object oElement) {
        return this.m_vVector.contains(oElement);
    }

    public boolean containsUniqueVector(OiscuUniqueVector uniqVect) throws ClassCastException {
        if (uniqVect == null) {
            return false;
        }
        int size = uniqVect.size();
        if (size > this.size()) {
            return false;
        }
        try {
            for (int i = 0; i < size; ++i) {
                if (this.indexOf(uniqVect.elementAt(i)) != -1) continue;
                return false;
            }
        }
        catch (ClassCastException e) {
            OiscuDebug.log("exception : trying to compare vectors of unequal class types");
            throw e;
        }
        return true;
    }

    public synchronized Object elementAt(int nIndex) {
        return this.m_vVector.elementAt(nIndex);
    }

    public synchronized Object firstElement() {
        return this.m_vVector.firstElement();
    }

    public boolean isEmpty() {
        return this.m_vVector.isEmpty();
    }

    public int size() {
        return this.m_vVector.size();
    }

    public synchronized String toString() {
        return this.m_vVector.toString();
    }

    public boolean equals(Object oOtherObject) {
        int nSize2;
        if (!(oOtherObject instanceof OiscuUniqueVector)) {
            return false;
        }
        OiscuUniqueVector oOtherVector = (OiscuUniqueVector)oOtherObject;
        int nSize1 = this.m_vVector.size();
        if (nSize1 != (nSize2 = oOtherVector.size())) {
            return false;
        }
        for (int nCnt = 0; nCnt < nSize1; ++nCnt) {
            if (this.m_vVector.contains(oOtherVector.elementAt(nCnt))) continue;
            return false;
        }
        return true;
    }

    public Vector toVector() {
        return this.m_vVector;
    }

    public final synchronized Enumeration elements() {
        return this.toVector().elements();
    }

    public void setClassType(String className, int initial, int inc) {
        this.m_vVector = new Vector(initial, inc);
        this.m_sElementClassName = className;
        this.m_classElementType = null;
    }

    public synchronized Object clone() {
        OiscuUniqueVector tempVector;
        block11: {
            tempVector = null;
            try {
                tempVector = (OiscuUniqueVector)super.clone();
                tempVector.setClassType(new String(this.getElementClassName()), this.m_vVector.size(), 5);
                int iSize = this.size();
                Method setter = null;
                if (iSize <= 0) break block11;
                try {
                    try {
                        if (this.m_classElementType == null) {
                            this.m_classElementType = Class.forName(this.m_sElementClassName);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        OiscuDebug.log(e);
                        return null;
                    }
                    setter = this.m_classElementType.getMethod("clone", null);
                    for (int i = 0; i < iSize; ++i) {
                        Object newElem = null;
                        try {
                            newElem = setter.invoke(this.m_vVector.elementAt(i), null);
                        }
                        catch (InvocationTargetException e) {
                            OiscuDebug.log(e.getTargetException());
                        }
                        catch (IllegalAccessException e) {
                            OiscuDebug.log(e);
                        }
                        tempVector.m_vVector.addElement(newElem);
                    }
                }
                catch (NoSuchMethodException e) {
                    tempVector.m_vVector = (Vector)this.m_vVector.clone();
                    tempVector.m_vVector.trimToSize();
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return tempVector;
    }

    public static void main(String[] args) throws Exception {
    }
}

