/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.ois.oisc.oiscu;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import oracle.sysman.ois.oisc.oiscu.OiscuDebug;
import oracle.sysman.ois.oisc.oiscu.OiscuErrorInformationBase;
import oracle.sysman.ois.oisc.oiscu.OiscuProgressMessagesBase;
import oracle.sysman.ois.oisc.oiscu.OiscuTextException;
import oracle.sysman.ois.oisc.oiscx.OiscxHelper;
import oracle.sysman.ois.oisr.oisrb.OisrbResourceLoader;

public class OiscuProgressAltMessage
extends OiscuProgressMessagesBase {
    protected BufferedWriter m_oBufferedWriter = null;
    protected static final int DEFAULT_BUF_LEN = 512;

    public OiscuProgressAltMessage(String filename) throws IOException, OiscuTextException {
        this(filename, 512);
    }

    public OiscuProgressAltMessage(String filename, int bufLength) throws IOException, OiscuTextException {
        String dir = OiscxHelper.extractFilePath(filename);
        File file = new File(dir);
        if (!(dir != null && dir.length() == 0 || file.exists() || file.mkdirs())) {
            throw new OiscuTextException("S_STAGE_COULD_NOT_CREATE_DIR");
        }
        this.m_oBufferedWriter = new BufferedWriter(new FileWriter(filename), bufLength);
    }

    public OiscuProgressAltMessage(String filename, boolean append) throws IOException, OiscuTextException {
        this(filename, 512, append);
    }

    public OiscuProgressAltMessage(String filename, int bufLength, boolean append) throws IOException, OiscuTextException {
        this.m_oBufferedWriter = new BufferedWriter(new FileWriter(filename, append), bufLength);
    }

    public OiscuProgressAltMessage(OutputStreamWriter out) {
        this.m_oBufferedWriter = new BufferedWriter(out);
    }

    @Override
    public void displayProgressMessage(String s) {
        if (s == null) {
            return;
        }
        try {
            this.m_oBufferedWriter.write(s, 0, s.length());
            this.m_oBufferedWriter.newLine();
            this.m_oBufferedWriter.flush();
        }
        catch (IOException e) {
            OiscuDebug.log("ERROR : Can't write " + e.getMessage());
        }
    }

    @Override
    public void logProgressMessage(OiscuErrorInformationBase oErr) {
        if (oErr != null) {
            this.displayProgressMessage(oErr.getError());
        }
    }

    public void displayProgressMessage(String sMesg, int iStatus) {
        if (sMesg == null) {
            return;
        }
        String sMsg = iStatus == 0 ? OisrbResourceLoader.getString("S_LOG_ALERT_ERROR") + sMesg : (iStatus == 1 ? OisrbResourceLoader.getString("S_WARNING_TAG") + sMesg : sMesg);
        try {
            this.m_oBufferedWriter.write(sMsg, 0, sMsg.length());
            this.m_oBufferedWriter.newLine();
            this.m_oBufferedWriter.flush();
        }
        catch (IOException e) {
            OiscuDebug.log("ERROR : Can't write " + e.getMessage());
        }
    }

    public void close() {
        try {
            this.m_oBufferedWriter.close();
        }
        catch (IOException e) {
            OiscuDebug.log("ERROR : Can't close " + e.getMessage());
        }
    }

    public void flush() {
        try {
            this.m_oBufferedWriter.flush();
        }
        catch (IOException e) {
            OiscuDebug.log("ERROR : Can't close " + e.getMessage());
        }
    }

    public void appendToMessage(String msg) {
        this.displayProgressMessage(msg);
    }
}

