/*
 * Decompiled with CFR 0.152.
 */
package FilesTool;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import oracle.sysman.oii.oiif.oiifb.OiifbCancelException;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.ois.oisc.oiscs.OiscsFile;
import oracle.sysman.ois.oisc.oiscu.OiscuFatalException;
import oracle.sysman.ois.oisc.oiscu.OiscuProgressAltMessage;
import oracle.sysman.ois.oisc.oiscu.OiscuTextException;
import oracle.sysman.ois.oisc.oiscu.OiscuUniqueVector;
import oracle.sysman.ois.oisc.oiscx.OiscxFileMapReader;
import oracle.sysman.ois.oisc.oiscx.OiscxFilesListBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxHelper;
import oracle.sysman.ois.oisc.oiscx.OiscxLanguagesReader;
import oracle.sysman.ois.oisc.oiscx.OiscxLogUtil;
import oracle.sysman.ois.oisr.oisrb.OisrbResourceLoader;

public class FilesTool {
    private static int[] s_aiFdbk = new int[]{0, 0, 0};
    public static final int S_BUFFERED_STREAM_SIZE = 8192;
    private static final int BUFF_SIZE = 512;
    private static final byte[] buffer = new byte[512];
    private static String m_sSLVPropLoc = "";
    private static String m_sPropLoc = "filesList.properties";
    public CmdOptions options = new CmdOptions();
    private OiscuProgressAltMessage mesgFile = null;
    private OiscuProgressAltMessage m_foundLogFile = null;
    private OiscuProgressAltMessage m_missingLogFile = null;
    private String m_sOutputLogFile = null;
    public boolean m_bIsValid;
    private String SRCHOME_PROPERTY = "SRCHOME";
    Properties m_oProperties = new Properties();
    Properties m_oSLVProps = new Properties();
    private MapFileProcessor processor = null;

    public CmdOptions getOptions() {
        return this.options;
    }

    public void setSLVPropertiesFile(String sSLVPropFileLoc) {
        if (null != sSLVPropFileLoc) {
            m_sSLVPropLoc = this.options.sSLVPropFile = sSLVPropFileLoc;
        } else {
            this.options.sSLVPropFile = null;
            m_sSLVPropLoc = null;
        }
    }

    public void setMessageListener(OiscuProgressAltMessage sMsgFile) {
        this.mesgFile = sMsgFile;
    }

    public void setSLVProperties(Hashtable sProp) {
        if (this.m_oSLVProps.isEmpty()) {
            Enumeration sKeys = sProp.keys();
            while (sKeys.hasMoreElements()) {
                String sKey = (String)sKeys.nextElement();
                System.out.println("KEY = " + sKey + " Value = " + sProp.get(sKey));
                this.m_oSLVProps.setProperty(sKey, (String)sProp.get(sKey));
            }
        }
    }

    public void setMapFile(String sMapFile) {
        if (null != sMapFile) {
            this.options.sMapfile = sMapFile;
        }
    }

    public void setOracleHome(String sOH) {
        this.options.sOHLoc = null != sOH ? sOH : (OiixPlatform.isPlatInGroup((int)-1, (int)OiixPlatform.getCurrentPlatform()) ? "/usr/lib/oracle" : ".");
    }

    public void setStageLangs(String sLangs) {
        if (null != sLangs) {
            this.options.sStageLangs = sLangs;
        }
    }

    public void setCompLangs(String sCompLangs) {
        if (null != sCompLangs) {
            System.out.println("SETTING THE COMP LANGS TO " + sCompLangs);
            this.options.sCompLangs = sCompLangs;
        }
    }

    public OiscuUniqueVector getFilesFoundList() {
        OiscuUniqueVector alResult = new OiscuUniqueVector("oracle.sysman.ois.oisc.oiscs.OiscsFile");
        ArrayList fList = this.processor.getFilesFoundList();
        if (null != fList) {
            for (int i = 0; i < fList.size(); ++i) {
                OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)fList.get(i);
                System.out.println("Source = " + oFile.getSource() + "\n SourceFileName = " + oFile.getSourceFileName() + "\n Dest = " + oFile.getDest() + "\n" + oFile.getPerms());
                try {
                    String sDest = oFile.getDest();
                    sDest = sDest.replaceFirst("%ORACLE_HOME%", this.options.sOHLoc);
                    OiscsFile oFileObj = new OiscsFile(oFile.getSourceFileName(), sDest);
                    oFileObj.setPermission(oFile.getPerms());
                    alResult.addElement(oFileObj);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return alResult;
    }

    public OiscuUniqueVector getFilesMissingList() {
        OiscuUniqueVector alResult = new OiscuUniqueVector("oracle.sysman.ois.oisc.oiscs.OiscsFile");
        ArrayList fList = this.processor.getFilesMissingList();
        if (null != fList) {
            for (int i = 0; i < fList.size(); ++i) {
                OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)fList.get(i);
                System.out.println("Source = " + oFile.getSource() + "\n SourceFileName = " + oFile.getSourceFileName() + "\n Dest = " + oFile.getDest() + "\n" + oFile.getPerms());
                try {
                    String sDest = oFile.getDest();
                    sDest = sDest.replaceFirst("%ORACLE_HOME%", this.options.sOHLoc);
                    OiscsFile oFileObj = new OiscsFile(oFile.getSourceFileName(), sDest);
                    oFileObj.setPermission(oFile.getPerms());
                    alResult.addElement(oFileObj);
                    continue;
                }
                catch (FileNotFoundException fnfe) {
                    fnfe.printStackTrace();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return alResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        if (this.options.bShowDest) {
            this.options.bVerbose = false;
        }
        this.processor = this.options.bCopyDest ? new MapFilesCopier() : new MapFileLister();
        String sLoc = System.getProperty("osp.properties.file");
        if (sLoc != null) {
            m_sPropLoc = sLoc;
        }
        if (this.options.bVerbose) {
            System.out.println("Going to use property file:" + sLoc);
        }
        try {
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(new FileInputStream(m_sPropLoc));
                this.m_oProperties.load(bis);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String schemaLoc = this.m_oProperties.getProperty("OSP_Schema_Location");
            schemaLoc = this.computePath(this.getStandardForm(schemaLoc.trim()));
            if (this.options.bVerbose) {
                System.out.println("Schema file location is :" + schemaLoc);
            }
            System.setProperty("OSP_Schema_Location", schemaLoc);
            this.setupOutputRedirection();
            String oui_lib_loc = System.getProperty("oracle.installer.library_loc");
            System.out.println("OUI library loc is set to " + oui_lib_loc);
            if (null != oui_lib_loc) {
                System.setProperty("oracle.installer.library_loc", oui_lib_loc);
                System.out.println("OUI library location is " + oui_lib_loc);
            } else {
                OiscxLogUtil.logErr("oracle.installer.library_loc not set:", null, 0, false);
            }
            OiscxLogUtil.logErr("Going to load language XML files", null, 2, false);
            this.loadWPTGinfo();
            if (null != this.options.sCompLangs && this.options.sCompLangs.length() == 0) {
                OiscxLogUtil.logErr("No component languages specified,component language will be set to the all languages.", null, 1, false);
            } else {
                OiscxLogUtil.logErr("Component languages specified:" + this.options.sCompLangs, null, 2, false);
            }
            if (this.m_oSLVProps.isEmpty() && this.options.sSLVPropFile != null) {
                File fSLV = new File(this.options.sSLVPropFile);
                if (!fSLV.exists() || !fSLV.isFile()) {
                    OiscxLogUtil.logErr("Invalid SLV property file:" + this.options.sSLVPropFile, null, 0, false);
                    OiscxLogUtil.logErr("Exiting" + this.options.sSLVPropFile, null, 0, false);
                    return false;
                }
                OiscxLogUtil.logErr("Going to load SLV's from property file:" + this.options.sSLVPropFile, null, 2, false);
                m_sSLVPropLoc = this.options.sSLVPropFile;
                this.LoadSLVPairs();
            }
            String key = "%" + this.SRCHOME_PROPERTY + "%";
            String srchome = this.m_oSLVProps.getProperty(key);
            OiscxLogUtil.logErr("srchome value read from slv properties:" + srchome, null, 2, false);
            if (srchome == null || srchome == "") {
                OiscxLogUtil.logErr("$SRCHOME will be picked up from the command line", null, 2, false);
                srchome = System.getProperty(this.SRCHOME_PROPERTY);
                if (null == srchome) {
                    srchome = "";
                }
                OiscxLogUtil.logErr("srchome value read from command line:" + srchome, null, 2, false);
                this.m_oSLVProps.setProperty(key, srchome);
            }
            OiscxLogUtil.logErr("$SRCHOME will be set to:" + srchome, null, 2, false);
            ArrayList<File> filenames = new ArrayList<File>();
            if (this.options.bMapDir) {
                File fMapFile;
                CMapFilter filterObj = new CMapFilter();
                filterObj.setFileName(this.options.sMapDirFilter);
                File fMapDir = new File(this.options.sMapDir);
                if (fMapDir.isDirectory() && null == this.options.sCompsfile) {
                    File[] files = fMapDir.listFiles(filterObj);
                    List<File> fileList = Arrays.asList(files);
                    filenames.addAll(fileList);
                } else if (fMapDir.isDirectory() && null != this.options.sCompsfile && (fMapFile = new File(this.options.sCompsfile)).isFile()) {
                    String currentLine;
                    ArrayList<String> comps = new ArrayList<String>();
                    BufferedReader reader = new BufferedReader(new FileReader(this.options.sCompsfile));
                    while ((currentLine = reader.readLine()) != null) {
                        comps.add(currentLine);
                    }
                    File[] files = fMapDir.listFiles(filterObj);
                    block14: for (String compName : comps) {
                        for (int f = 0; f < files.length; ++f) {
                            if (files[f].getName().indexOf(compName) == -1) continue;
                            filenames.add(files[f]);
                            continue block14;
                        }
                    }
                }
            } else if (null != this.options.sMapfile) {
                File temp = new File(this.options.sMapfile);
                filenames.add(temp);
            }
            for (int i = 0; i < filenames.size(); ++i) {
                File fMAP = (File)filenames.get(i);
                String sCurrFile = fMAP.getAbsolutePath();
                if (!fMAP.exists() || !fMAP.isFile()) {
                    OiscxLogUtil.logErr("Invalid MAP file:" + sCurrFile, null, 0, false);
                    return false;
                }
                this.processor.processFile(sCurrFile);
            }
            return this.processor.FinalOutput();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean isValid() {
        return this.m_bIsValid;
    }

    private String computePath(String sLoc) throws OiscuTextException {
        if (sLoc == null) {
            return null;
        }
        File temp = new File(m_sPropLoc);
        String sOSPTestProp = temp.getAbsolutePath().replace(File.separatorChar, '/');
        String sBaseDir = this.getParentDir(sOSPTestProp);
        if (sBaseDir == null) {
            sBaseDir = ".";
        }
        String tempLoc = sLoc.replace(File.separatorChar, '/');
        if (sLoc.equals("..") || OiscxHelper.isRelativePath(tempLoc)) {
            sLoc = sBaseDir + "/" + sLoc;
        }
        return sLoc;
    }

    private void loadWPTGinfo() {
        OiscxLanguagesReader reader = OiscxLanguagesReader.getLanguagesReader();
        try {
            String sNLSRTLMapLoc;
            String sRuntimeLangLoc;
            String sAdminLangLoc;
            String sLocation = (String)this.m_oProperties.get("Admin_Langs_Location");
            if (sLocation == null) {
                OiscxLogUtil.logErr("S_NO_ADMINLANGS_ENTRY", null, 1, true);
                sAdminLangLoc = "";
            } else {
                sAdminLangLoc = this.computePath(this.getStandardForm(sLocation.trim()));
            }
            OiscxLogUtil.logErr("Admin language locations will be loaded from:" + sAdminLangLoc, null, 2, false);
            sLocation = (String)this.m_oProperties.get("Runtime_Langs_Location");
            if (sLocation == null) {
                OiscxLogUtil.logErr("S_NO_RUNTIMELANGS_ENTRY", null, 1, true);
                sRuntimeLangLoc = "";
            } else {
                sRuntimeLangLoc = this.computePath(this.getStandardForm(sLocation.trim()));
            }
            OiscxLogUtil.logErr("Runtime languages will be loaded from:" + sRuntimeLangLoc, null, 2, false);
            sLocation = (String)this.m_oProperties.get("NlsrtlMap_Location");
            if (sLocation == null) {
                OiscxLogUtil.logErr("S_NO_NLSRTL_MAPPINGS", null, 0, true);
                sNLSRTLMapLoc = "";
            } else {
                sNLSRTLMapLoc = this.computePath(this.getStandardForm(sLocation.trim()));
            }
            OiscxLogUtil.logErr("NLSRTL language mappings will be loaded from:" + sNLSRTLMapLoc, null, 2, false);
            reader.loadLanguageEntries(sAdminLangLoc, sRuntimeLangLoc, sNLSRTLMapLoc);
        }
        catch (OiscuFatalException e) {
            System.err.println(e.getMessage());
        }
        catch (OiscuTextException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        FilesTool filesTool = new FilesTool();
        filesTool.options.bIsHelp = args.length > 13 || args.length < 2;
        for (int i = 0; !filesTool.options.bIsHelp && i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-slvfile") && filesTool.options.sSLVPropFile == null) {
                filesTool.options.sSLVPropFile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-mapfile") && filesTool.options.sMapfile == null) {
                filesTool.options.sMapfile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-compsfile") && filesTool.options.sCompsfile == null) {
                filesTool.options.sCompsfile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-srchome") && filesTool.options.sPathToSourceHome == null) {
                filesTool.options.sPathToSourceHome = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-langs") && filesTool.options.sCompLangs == null) {
                filesTool.options.sCompLangs = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-log")) {
                filesTool.options.bRedirect = true;
                filesTool.options.sLogLoc = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-verbose")) {
                filesTool.options.bVerbose = true;
            } else if (args[i].equalsIgnoreCase("-showdest")) {
                filesTool.options.bShowDest = true;
            } else if (args[i].equalsIgnoreCase("-copyDest")) {
                filesTool.options.bCopyDest = true;
            } else if (args[i].equalsIgnoreCase("-destHome")) {
                filesTool.options.sOHLoc = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-dirFilemap")) {
                filesTool.options.sMapDir = args[++i].trim();
                filesTool.options.bMapDir = true;
            } else if (args[i].equalsIgnoreCase("-filter")) {
                filesTool.options.sMapDirFilter = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-stageLang")) {
                filesTool.options.sStageLangs = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-createLink")) {
                filesTool.options.sCreateLinkFile = args[++i].trim();
                filesTool.options.bCreateLink = true;
            }
            if (!args[i].trim().equalsIgnoreCase("-help")) continue;
            filesTool.options.bIsHelp = true;
            break;
        }
        if (filesTool.options.bIsHelp) {
            System.out.println("Input Parameters:  -mapfile <map file name>");
            System.out.println("optional Input Parameters:");
            System.out.println("-slvfile <slv properties file path>");
            System.out.println("-langs <comma separated lang ids>");
            System.out.println("-stageLang <comma separated stage lang ids>");
            System.out.println("-log (logs to file)");
            System.out.println("-verbose (additional data on files found/missing)");
            System.out.println("-showdest (shows output destination files also)");
            System.out.println("-copydest (copy destination files to output directory)");
            System.out.println("-destHome (Oracle Home destination directory)");
            System.out.println("-dirFilemap (file map directory)");
            System.out.println("-compsFile (file with components map files to use)");
            System.out.println("-filter (filter to select mapfiles from filemap directory)");
            return;
        }
        if (filesTool.process()) {
            OiscxLogUtil.logErr("Finished processing XML filemap.", null, 2, false);
        } else {
            OiscxLogUtil.logErr("XML mapfile file listing failed", null, 2, false);
        }
    }

    private void LoadSLVPairs() {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(m_sSLVPropLoc));
            this.m_oSLVProps.load(bis);
        }
        catch (IOException e) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setupOutputRedirection() {
        String sErrFile;
        String sMissingFile;
        String sFoundFile;
        String sLogFile;
        String sOSPLogLoc = this.m_oProperties.getProperty("OSP_Log_Location");
        try {
            sOSPLogLoc = this.computePath(this.getStandardForm(sOSPLogLoc));
        }
        catch (OiscuTextException e) {
            System.err.println(e.getMessage());
        }
        if (sOSPLogLoc == null) {
            sLogFile = "osp.log";
            sFoundFile = "foundfiles.log";
            sMissingFile = "missingfiles.log";
            sErrFile = "osp.err";
        } else {
            boolean bStatus;
            File fLog = new File(sOSPLogLoc = sOSPLogLoc.trim());
            if (!fLog.exists() && !(bStatus = fLog.mkdir())) {
                System.out.println("Unable to create the log directory .\nInsufficient disk space or write permission not available.\n Using console for logging.");
                return;
            }
            sLogFile = sOSPLogLoc + "/osp.log";
            sErrFile = sOSPLogLoc + "/osp.err";
            sMissingFile = sOSPLogLoc + "/missing.log";
            sFoundFile = sOSPLogLoc + "/found.log";
        }
        if (null != this.options.sLogLoc && this.options.sLogLoc.length() > 0) {
            sLogFile = this.options.sLogLoc;
        }
        if (this.options.bRedirect) {
            System.out.println("List of selected files will be logged to :" + sFoundFile);
            System.out.println("List of missing files will be logged to :" + sMissingFile);
            System.out.println("Output Logfile :" + sLogFile);
            System.out.println("Exceptions will be logged to :" + sErrFile);
        } else if (this.options.bVerbose) {
            System.out.println("Selected/missing file listings will go to standard out/error");
            System.out.println("Output Logfile :" + sLogFile);
        }
        if (this.options.bRedirect) {
            PrintStream ps;
            try {
                ps = new PrintStream(new FileOutputStream(sLogFile), true);
                System.setOut(ps);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            try {
                ps = new PrintStream(new FileOutputStream(sErrFile), true);
                System.setErr(ps);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            if (!this.OpenlogFile(sFoundFile, OiscxLogUtil.FOUND_FILE)) {
                this.m_foundLogFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
                if (sFoundFile != null && sFoundFile.trim().length() != 0) {
                    this.display(OisrbResourceLoader.getString("S_UNABLE_CREATE_LOG_FILE") + sFoundFile);
                }
            } else {
                OiscxLogUtil.setMessageListener(OiscxLogUtil.FOUND_FILE, this.m_foundLogFile);
            }
            if (!this.OpenlogFile(sMissingFile, OiscxLogUtil.MISSING_FILE)) {
                this.m_missingLogFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.err));
                if (sMissingFile != null && sMissingFile.trim().length() != 0) {
                    this.display(OisrbResourceLoader.getString("S_UNABLE_CREATE_LOG_FILE") + sMissingFile);
                }
            } else {
                OiscxLogUtil.setMessageListener(OiscxLogUtil.MISSING_FILE, this.m_missingLogFile);
            }
        } else {
            OiscuProgressAltMessage log = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
            OiscuProgressAltMessage errlog = new OiscuProgressAltMessage(new OutputStreamWriter(System.err));
            OiscxLogUtil.setMessageListener(OiscxLogUtil.MISSING_FILE, errlog);
            OiscxLogUtil.setMessageListener(OiscxLogUtil.FOUND_FILE, log);
        }
        if (this.mesgFile == null && !this.OpenlogFile(sLogFile, OiscxLogUtil.LOG_FILE)) {
            this.mesgFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
            if (sLogFile != null && sLogFile.trim().length() != 0) {
                this.display(OisrbResourceLoader.getString("S_UNABLE_CREATE_LOG_FILE") + sLogFile);
            }
            this.display(OisrbResourceLoader.getString("S_STANDARD_LOG"));
        } else {
            OiscxLogUtil.setMessageListener(OiscxLogUtil.LOG_FILE, this.mesgFile);
        }
    }

    boolean OpenlogFile(String sLogFile, int type) {
        boolean bLogFileSuccess = false;
        if (sLogFile != null && sLogFile.trim().length() > 0) {
            try {
                OiscuProgressAltMessage messageFile = new OiscuProgressAltMessage(sLogFile);
                if (type == OiscxLogUtil.MISSING_FILE) {
                    this.m_missingLogFile = messageFile;
                } else if (type == OiscxLogUtil.FOUND_FILE) {
                    this.m_foundLogFile = messageFile;
                } else if (type == OiscxLogUtil.LOG_FILE) {
                    this.mesgFile = messageFile;
                }
                bLogFileSuccess = true;
            }
            catch (IOException e) {
                OiscxHelper.logError(OisrbResourceLoader.getString("S_CANT_OPEN_FILE") + e.getMessage(), 0);
            }
            catch (OiscuTextException e) {
                OiscxHelper.logError(OisrbResourceLoader.getString("S_CANT_OPEN_FILE") + e.getMessage(), 0);
            }
        }
        return bLogFileSuccess;
    }

    void display(String s) {
        if (this.mesgFile == null) {
            this.mesgFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
        }
        this.mesgFile.displayProgressMessage(s);
        this.mesgFile.flush();
    }

    private String getParentDir(String path) {
        int pathLen = path.length();
        int lastSepPos = path.lastIndexOf(47, pathLen - 2);
        if (lastSepPos != -1) {
            return path.substring(0, lastSepPos);
        }
        return null;
    }

    private String getStandardForm(String nativePath) {
        return nativePath.replace(File.separatorChar, '/');
    }

    public class CMapFilter
    implements FilenameFilter {
        private String m_sFilename = "";

        public void setFileName(String filter) {
            this.m_sFilename = filter;
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean flag = true;
            File file = new File(dir, name);
            if (file.isFile()) {
                flag = name.endsWith(".map.xml") && !name.startsWith("s_") && !name.startsWith("ss_");
                if (null != this.m_sFilename && this.m_sFilename.length() > 0 && flag) {
                    String[] result = this.m_sFilename.split(",");
                    int x = 0;
                    for (x = 0; x < result.length; ++x) {
                        if (name.indexOf(result[x]) == -1) continue;
                        flag = true;
                        break;
                    }
                    if (x == result.length) {
                        flag = false;
                    }
                }
            } else {
                return false;
            }
            return flag;
        }
    }

    class MapFileLister
    extends MapFileProcessor {
        MapFileLister() {
        }

        @Override
        boolean processFile(String sCurrFile) {
            boolean ret = super.processFile(sCurrFile);
            return ret;
        }

        @Override
        boolean FinalOutput() {
            int iSize1 = this.allResults != null ? this.allResults.size() : 0;
            OiscxLogUtil.logErr("Found " + String.valueOf(iSize1) + " files.", null, 2, false);
            if (FilesTool.this.options.bVerbose) {
                System.out.println("Found " + String.valueOf(iSize1) + " files.");
                OiscxLogUtil.logFoundMessage("----------------------------------------------");
                OiscxLogUtil.logFoundMessage("TYPE\t\t NAME");
                OiscxLogUtil.logFoundMessage("----------------------------------------------");
            }
            for (int i = 0; i < iSize1; ++i) {
                OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)this.allResults.get(i);
                if (oFile == null) continue;
                String sSource = oFile.getSourceFileName();
                String sDest = oFile.getDest();
                sDest.replaceFirst("%ORACLE_HOME%", FilesTool.this.options.sOHLoc);
                boolean bIsDirEntry = oFile.isDirectory();
                String sMessage = "";
                if (FilesTool.this.options.bShowDest) {
                    sMessage = "SOURCE:";
                }
                if (FilesTool.this.options.bVerbose) {
                    sMessage = bIsDirEntry ? (oFile.isEmptyDirectory() ? "EMPTYDIR\t" : "DIR\t\t") : "FILE\t";
                    sMessage = sMessage + "\t";
                }
                sMessage = sMessage + sSource;
                OiscxLogUtil.logFoundMessage(sMessage);
                if (!FilesTool.this.options.bShowDest) continue;
                sMessage = "DEST:" + sDest;
                OiscxLogUtil.logFoundMessage(sMessage);
            }
            ArrayList missing = this.oFileListBuilder.getMissingFilesList();
            int missingCount = missing != null ? missing.size() : 0;
            OiscxLogUtil.logErr("Missing " + String.valueOf(missingCount) + " files.", null, 2, false);
            if (FilesTool.this.options.bVerbose) {
                System.out.println("Missing " + String.valueOf(missingCount) + " files.");
                OiscxLogUtil.logMissingMessage("----------------------------------------------");
                OiscxLogUtil.logMissingMessage("TYPE\t\t NAME ");
                OiscxLogUtil.logMissingMessage("----------------------------------------------");
            }
            for (int i = 0; i < missingCount; ++i) {
                OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)missing.get(i);
                if (oFile == null) continue;
                String sSource = oFile.getSourceFileName();
                boolean bIsDirEntry = oFile.isDirectory();
                String sMessage = "missing:";
                if (bIsDirEntry) {
                    OiscuUniqueVector filters;
                    if (FilesTool.this.options.bVerbose) {
                        sMessage = oFile.isEmptyDirectory() ? "EMPTYDIR\t" : "DIR\t\t";
                    }
                    if ((filters = oFile.getFilters()) != null) {
                        String filterStr = OiscxFilesListBuilder.objToString(filters);
                        int len = filterStr.length();
                        sSource = sSource + File.separator + filterStr.substring(1, len - 1);
                    }
                } else if (FilesTool.this.options.bVerbose) {
                    sMessage = "FILE\t";
                    sMessage = sMessage + "\t";
                }
                sMessage = sMessage + sSource;
                OiscxLogUtil.logMissingMessage(sMessage);
            }
            return true;
        }
    }

    class MapFilesCopier
    extends MapFileProcessor {
        MapFilesCopier() {
        }

        @Override
        boolean processFile(String sCurrFile) {
            boolean ret = super.processFile(sCurrFile);
            return ret;
        }

        @Override
        boolean FinalOutput() {
            int iSize1 = this.allResults != null ? this.allResults.size() : 0;
            OiscxLogUtil.logErr("Found " + String.valueOf(iSize1) + " files.", null, 2, false);
            StringBuffer sBuf = new StringBuffer();
            for (int i = 0; i < iSize1; ++i) {
                OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)this.allResults.get(i);
                if (oFile == null) continue;
                String sSource = oFile.getSourceFileName();
                String sDest = oFile.getDest();
                sDest = sDest.replaceFirst("%ORACLE_HOME%", FilesTool.this.options.sOHLoc);
                boolean bIsDirEntry = oFile.isDirectory();
                File dest = new File(sDest);
                File fSrc = new File(sSource);
                try {
                    if (fSrc.isFile()) {
                        if (FilesTool.this.options.bCreateLink) {
                            System.out.println("ln -s " + sSource + " to " + sDest);
                            OiixFileOps.mkdirs((String)dest.getParent(), null, null);
                            sBuf.append("ln -s " + sSource + " " + sDest + "\n");
                        } else {
                            System.out.println("Ready to copy file " + sSource + " to " + sDest);
                            OiixFileOps.copyFile((String)sSource, (String)sDest, (boolean)true, (boolean)true, (boolean)true, (boolean)false, null, null, null, null, (boolean)false);
                            System.out.println("File copied");
                        }
                    }
                    if (!fSrc.isDirectory()) continue;
                    OiixFileOps.mkdirs((String)sDest, null, null);
                    System.out.println("Directories created");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (OiifbCancelException ex) {
                    ex.printStackTrace();
                }
            }
            if (sBuf.length() > 0) {
                try {
                    BufferedWriter out = new BufferedWriter(new FileWriter(FilesTool.this.options.sCreateLinkFile, true));
                    out.write(sBuf.toString());
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
    }

    abstract class MapFileProcessor {
        ArrayList allResults = new ArrayList();
        OiscxFilesListBuilder oFileListBuilder;

        MapFileProcessor() {
            this.oFileListBuilder = new OiscxFilesListBuilder(FilesTool.this.m_oSLVProps, FilesTool.this.options.sCompLangs);
        }

        public ArrayList getFilesFoundList() {
            if (null != this.oFileListBuilder) {
                return this.oFileListBuilder.getFoundFilesList();
            }
            return null;
        }

        public ArrayList getFilesMissingList() {
            if (null != this.oFileListBuilder) {
                return this.oFileListBuilder.getMissingFilesList();
            }
            return null;
        }

        private boolean generateFilesList(String sCurrFile) {
            ArrayList results = null;
            this.oFileListBuilder = new OiscxFilesListBuilder(FilesTool.this.m_oSLVProps, FilesTool.this.options.sCompLangs);
            if (null != FilesTool.this.options.sStageLangs && FilesTool.this.options.sStageLangs.length() > 0) {
                this.oFileListBuilder.setStageLangs(FilesTool.this.options.sStageLangs);
            }
            OiscxLogUtil.logErr("Preparing to read mapfile:" + sCurrFile + "...", null, 2, false);
            OiscxFileMapReader oFileMapReader = new OiscxFileMapReader(this.oFileListBuilder);
            int pos = sCurrFile.lastIndexOf(".map.xml");
            String textLocation = sCurrFile.substring(0, pos);
            try {
                oFileMapReader.parse(null, textLocation);
            }
            catch (OiscuFatalException e) {
                e.printStackTrace();
                OiscxLogUtil.logErr("Fatal Exception occured :" + e.getMessage(), null, 0, false);
                OiscxLogUtil.logErr("Failed to parse mapfile.Exiting", null, 0, false);
                return false;
            }
            OiscxLogUtil.logErr("Generating files list for:" + sCurrFile + "...", null, 2, false);
            results = this.oFileListBuilder.getFoundFilesList();
            this.allResults.addAll(results);
            for (int j = 0; j < results.size(); ++j) {
                OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)results.get(j);
                if (oFile == null) continue;
                String sSource = oFile.getSourceFileName();
                String string = oFile.getDest();
            }
            return true;
        }

        boolean processFile(String sCurrFile) {
            return this.generateFilesList(sCurrFile);
        }

        abstract boolean FinalOutput();
    }

    class CmdOptions {
        public String sMapfile = null;
        public String sCompsfile = null;
        public String sSLVPropFile = null;
        public String sPathToSourceHome = null;
        public String sCompPath = null;
        public String sCompLangs = "";
        public String sStageLangs = "ALL_LANGUAGES";
        public String sMapDir = null;
        public String sMapDirFilter = null;
        public String sMsiProjDir = null;
        public String sOHLoc = null;
        public String sLogLoc = null;
        public String sCreateLinkFile = null;
        public boolean bMapDir = false;
        public boolean bCopyDest = false;
        public boolean bVerbose = false;
        public boolean bRedirect = false;
        public boolean bShowDest = false;
        public boolean bIsHelp = false;
        public boolean bCreateLink = false;

        CmdOptions() {
        }
    }
}

