/*
 * Decompiled with CFR 0.152.
 */
package FilesTool;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Properties;
import oracle.sysman.ois.oisc.oiscu.OiscuFatalException;
import oracle.sysman.ois.oisc.oiscu.OiscuProgressAltMessage;
import oracle.sysman.ois.oisc.oiscu.OiscuTextException;
import oracle.sysman.ois.oisc.oiscu.OiscuUniqueVector;
import oracle.sysman.ois.oisc.oiscx.OiscxFileMapReader;
import oracle.sysman.ois.oisc.oiscx.OiscxFilesListBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxHelper;
import oracle.sysman.ois.oisc.oiscx.OiscxLanguagesReader;
import oracle.sysman.ois.oisc.oiscx.OiscxLogUtil;
import oracle.sysman.ois.oisr.oisrb.OisrbResourceLoader;

public class BuildToolsFilesTool {
    String m_sMapFile = "";
    String m_sCompName = null;
    String m_sPathToSourceHome = null;
    String m_sCompLangs = "";
    boolean m_bShowDest = false;
    boolean m_bShip_it = false;
    boolean m_bIsValid = false;
    boolean m_bRedirectLog = false;
    boolean m_bVerbose = false;
    private static int[] s_aiFdbk = new int[]{0, 0, 0};
    private OiscuProgressAltMessage mesgFile = null;
    private OiscuProgressAltMessage m_foundLogFile = null;
    private OiscuProgressAltMessage m_missingLogFile = null;
    private String m_sOutputLogFile = null;
    private static String m_sSLVPropLoc = "";
    private static String m_sPropLoc = "filesList.properties";
    private String SRCHOME_PROPERTY = "SRCHOME";
    Properties m_oProperties = new Properties();
    Properties m_oSLVProps = new Properties();

    BuildToolsFilesTool(String sMapFile, String sSLVPropFile, String sPathToSourceHome, String sCompLangs, boolean bRedirectLog, boolean bVerbose, boolean bShowDest, boolean bShip_it) {
        this.m_sMapFile = sMapFile;
        this.m_bRedirectLog = bRedirectLog;
        this.m_bVerbose = bVerbose;
        this.m_bShowDest = bShowDest;
        this.m_bShip_it = bShip_it;
        if (bShowDest || bShip_it) {
            this.m_bVerbose = false;
        }
        if (sCompLangs != null) {
            this.m_sCompLangs = sCompLangs;
        }
        m_sSLVPropLoc = sSLVPropFile;
        this.m_sPathToSourceHome = sPathToSourceHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process() {
        String sLoc = System.getProperty("osp.properties.file");
        if (sLoc != null) {
            m_sPropLoc = sLoc;
        }
        if (this.m_bVerbose) {
            System.out.println("Going to use property file:" + sLoc);
        }
        try {
            BufferedInputStream bis = null;
            try {
                bis = new BufferedInputStream(new FileInputStream(m_sPropLoc));
                this.m_oProperties.load(bis);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            String schemaLoc = this.m_oProperties.getProperty("OSP_Schema_Location");
            schemaLoc = this.computePath(this.getStandardForm(schemaLoc.trim()));
            if (this.m_bVerbose) {
                System.out.println("Schema file location is :" + schemaLoc);
            }
            System.setProperty("OSP_Schema_Location", schemaLoc);
            this.setupOutputRedirection();
            File fMAP = new File(this.m_sMapFile);
            if (!fMAP.exists() || !fMAP.isFile()) {
                OiscxLogUtil.logErr("Invalid MAP file:" + this.m_sMapFile, null, 0, false);
                return false;
            }
            OiscxLogUtil.logErr("Map file:" + this.m_sMapFile, null, 2, false);
            OiscxLogUtil.logErr("Going to load language XML files", null, 2, false);
            this.loadWPTGinfo();
            if (this.m_sCompLangs.length() == 0) {
                OiscxLogUtil.logErr("No component languages specified,component language will be set to the all languages.", null, 1, false);
            } else {
                OiscxLogUtil.logErr("Component languages specified:" + this.m_sCompLangs, null, 2, false);
            }
            if (m_sSLVPropLoc != null) {
                File fSLV = new File(m_sSLVPropLoc);
                if (!fSLV.exists() || !fSLV.isFile()) {
                    OiscxLogUtil.logErr("Invalid SLV property file:" + m_sSLVPropLoc, null, 0, false);
                    OiscxLogUtil.logErr("Exiting" + m_sSLVPropLoc, null, 0, false);
                    return false;
                }
                OiscxLogUtil.logErr("Going to load SLV's from property file:" + m_sSLVPropLoc, null, 2, false);
                this.LoadSLVPairs();
            }
            String key = "%" + this.SRCHOME_PROPERTY + "%";
            String srchome = this.m_oSLVProps.getProperty(key);
            OiscxLogUtil.logErr("srchome value read from slv properties:" + srchome, null, 2, false);
            if (srchome == null || srchome == "") {
                OiscxLogUtil.logErr("$SRCHOME will be picked up from the command line", null, 2, false);
                srchome = System.getProperty(this.SRCHOME_PROPERTY);
                if (null == srchome) {
                    srchome = "";
                }
                OiscxLogUtil.logErr("srchome value read from command line:" + srchome, null, 2, false);
                this.m_oSLVProps.setProperty(key, srchome);
            }
            OiscxLogUtil.logErr("$SRCHOME will be set to:" + srchome, null, 2, false);
            return this.generateFileList();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    public boolean isValid() {
        return this.m_bIsValid;
    }

    private boolean generateFileList() {
        OiscxLogUtil.logErr("Preparing to read mapfile...", null, 2, false);
        OiscxFilesListBuilder oFileListBuilder = new OiscxFilesListBuilder(this.m_oSLVProps, this.m_sCompLangs);
        oFileListBuilder.setStageLangs("ALL_LANGUAGES");
        OiscxFileMapReader oFileMapReader = new OiscxFileMapReader(oFileListBuilder);
        int pos = this.m_sMapFile.lastIndexOf(".map.xml");
        String textLocation = this.m_sMapFile.substring(0, pos);
        try {
            oFileMapReader.parse(null, textLocation);
        }
        catch (OiscuFatalException e) {
            OiscxLogUtil.logErr("Fatal Exception occured :" + e.getMessage(), null, 0, false);
            OiscxLogUtil.logErr("Failed to parse mapfile.Exiting", null, 0, false);
            return false;
        }
        OiscxLogUtil.logErr("Generating files list...", null, 2, false);
        ArrayList results = oFileListBuilder.getFoundFilesList();
        int iSize1 = results != null ? results.size() : 0;
        OiscxLogUtil.logErr("Found " + String.valueOf(iSize1) + " files.", null, 2, false);
        if (this.m_bVerbose) {
            System.out.println("Found " + String.valueOf(iSize1) + " files.");
            OiscxLogUtil.logFoundMessage("----------------------------------------------");
            OiscxLogUtil.logFoundMessage("TYPE\t\t NAME");
            OiscxLogUtil.logFoundMessage("----------------------------------------------");
        }
        for (int i = 0; i < iSize1; ++i) {
            OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)results.get(i);
            if (oFile == null) continue;
            String sSource = oFile.getSourceFileName();
            String sDest = oFile.getDest();
            boolean bIsDirEntry = oFile.isDirectory();
            String sMessage = "";
            if (this.m_bShowDest) {
                sMessage = "SOURCE:";
            }
            if (this.m_bVerbose) {
                sMessage = bIsDirEntry ? (oFile.isEmptyDirectory() ? "EMPTYDIR\t" : "DIR\t\t") : "FILE\t";
                sMessage = sMessage + "\t";
            }
            sMessage = sMessage + sSource;
            if (this.m_bShip_it) {
                sMessage = sMessage + " " + sDest;
            }
            OiscxLogUtil.logFoundMessage(sMessage);
            if (!this.m_bShowDest) continue;
            sMessage = "DEST:" + sDest;
            OiscxLogUtil.logFoundMessage(sMessage);
        }
        ArrayList missing = oFileListBuilder.getMissingFilesList();
        int missingCount = missing != null ? missing.size() : 0;
        OiscxLogUtil.logErr("Missing " + String.valueOf(missingCount) + " files.", null, 2, false);
        if (this.m_bVerbose) {
            System.out.println("Missing " + String.valueOf(missingCount) + " files.");
            OiscxLogUtil.logMissingMessage("----------------------------------------------");
            OiscxLogUtil.logMissingMessage("TYPE\t\t NAME ");
            OiscxLogUtil.logMissingMessage("----------------------------------------------");
        }
        for (int i = 0; i < missingCount; ++i) {
            OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)missing.get(i);
            if (oFile == null) continue;
            String sSource = oFile.getSourceFileName();
            String sDest = oFile.getDest();
            boolean bIsDirEntry = oFile.isDirectory();
            String sMessage = "missing:";
            if (bIsDirEntry) {
                OiscuUniqueVector filters;
                if (this.m_bVerbose) {
                    sMessage = oFile.isEmptyDirectory() ? "EMPTYDIR\t" : "DIR\t\t";
                }
                if ((filters = oFile.getFilters()) != null) {
                    String filterStr = OiscxFilesListBuilder.objToString(filters);
                    int len = filterStr.length();
                    sSource = sSource + File.separator + filterStr.substring(1, len - 1);
                }
            } else if (this.m_bVerbose) {
                sMessage = "FILE\t";
                sMessage = sMessage + "\t";
            }
            sMessage = sMessage + sSource;
            OiscxLogUtil.logMissingMessage(sMessage);
        }
        return true;
    }

    private String computePath(String sLoc) throws OiscuTextException {
        if (sLoc == null) {
            return null;
        }
        File temp = new File(m_sPropLoc);
        String sOSPTestProp = temp.getAbsolutePath().replace(File.separatorChar, '/');
        String sBaseDir = this.getParentDir(sOSPTestProp);
        if (sBaseDir == null) {
            sBaseDir = ".";
        }
        String tempLoc = sLoc.replace(File.separatorChar, '/');
        if (sLoc.equals("..") || OiscxHelper.isRelativePath(tempLoc)) {
            sLoc = sBaseDir + "/" + sLoc;
        }
        return sLoc;
    }

    private void loadWPTGinfo() {
        OiscxLanguagesReader reader = OiscxLanguagesReader.getLanguagesReader();
        try {
            String sNLSRTLMapLoc;
            String sRuntimeLangLoc;
            String sAdminLangLoc;
            String sLocation = (String)this.m_oProperties.get("Admin_Langs_Location");
            if (sLocation == null) {
                OiscxLogUtil.logErr("S_NO_ADMINLANGS_ENTRY", null, 1, true);
                sAdminLangLoc = "";
            } else {
                sAdminLangLoc = this.computePath(this.getStandardForm(sLocation.trim()));
            }
            OiscxLogUtil.logErr("Admin language locations will be loaded from:" + sAdminLangLoc, null, 2, false);
            sLocation = (String)this.m_oProperties.get("Runtime_Langs_Location");
            if (sLocation == null) {
                OiscxLogUtil.logErr("S_NO_RUNTIMELANGS_ENTRY", null, 1, true);
                sRuntimeLangLoc = "";
            } else {
                sRuntimeLangLoc = this.computePath(this.getStandardForm(sLocation.trim()));
            }
            OiscxLogUtil.logErr("Runtime languages will be loaded from:" + sRuntimeLangLoc, null, 2, false);
            sLocation = (String)this.m_oProperties.get("NlsrtlMap_Location");
            if (sLocation == null) {
                OiscxLogUtil.logErr("S_NO_NLSRTL_MAPPINGS", null, 0, true);
                sNLSRTLMapLoc = "";
            } else {
                sNLSRTLMapLoc = this.computePath(this.getStandardForm(sLocation.trim()));
            }
            OiscxLogUtil.logErr("NLSRTL language mappings will be loaded from:" + sNLSRTLMapLoc, null, 2, false);
            reader.loadLanguageEntries(sAdminLangLoc, sRuntimeLangLoc, sNLSRTLMapLoc);
        }
        catch (OiscuFatalException e) {
            System.err.println(e.getMessage());
        }
        catch (OiscuTextException e) {
            System.err.println(e.getMessage());
        }
    }

    public static void main(String[] args) {
        String sMapfile = null;
        String sSLVPropFile = null;
        String sPathToSourceHome = null;
        Object sCompPath = null;
        String sCompLangs = null;
        boolean bVerbose = false;
        boolean bRedirect = false;
        boolean bShowDest = false;
        boolean bShip_it = false;
        boolean bIsHelp = args.length > 13 || args.length < 2;
        for (int i = 0; !bIsHelp && i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-slvfile") && sSLVPropFile == null) {
                sSLVPropFile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-mapfile") && sMapfile == null) {
                sMapfile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-srchome") && sPathToSourceHome == null) {
                sPathToSourceHome = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-langs") && sCompLangs == null) {
                sCompLangs = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-log")) {
                bRedirect = true;
            } else if (args[i].equalsIgnoreCase("-verbose")) {
                bVerbose = true;
            } else if (args[i].equalsIgnoreCase("-showdest")) {
                bShowDest = true;
            } else if (args[i].equalsIgnoreCase("-ship_it")) {
                bShip_it = true;
            } else {
                bIsHelp = true;
                break;
            }
            if (!args[i].trim().equalsIgnoreCase("-help")) continue;
            bIsHelp = true;
            break;
        }
        if (bIsHelp) {
            System.out.println("Input Parameters:  -mapfile <map file name>");
            System.out.println("optional Input Parameters:");
            System.out.println("-slvfile <slv properties file path>");
            System.out.println("-langs <comma separated lang ids>");
            System.out.println("-log (logs to file)");
            System.out.println("-verbose (additional data on files found/missing)");
            System.out.println("-showdest (shows output destination files also)");
            System.out.println("-ship_it (shows output in ship_it file format)");
            return;
        }
        BuildToolsFilesTool filesTool = new BuildToolsFilesTool(sMapfile, sSLVPropFile, sPathToSourceHome, sCompLangs, bRedirect, bVerbose, bShowDest, bShip_it);
        if (filesTool.process()) {
            OiscxLogUtil.logErr("Finished processing XML filemap.", null, 2, false);
        } else {
            OiscxLogUtil.logErr("XML mapfile file listing failed", null, 2, false);
        }
    }

    private void LoadSLVPairs() {
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(m_sSLVPropLoc));
            this.m_oSLVProps.load(bis);
        }
        catch (IOException e) {
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void setupOutputRedirection() {
        OiscuProgressAltMessage log;
        String sErrFile;
        String sMissingFile;
        String sFoundFile;
        String sLogFile;
        String sOSPLogLoc = this.m_oProperties.getProperty("OSP_Log_Location");
        try {
            if (sOSPLogLoc != null) {
                sOSPLogLoc = this.computePath(this.getStandardForm(sOSPLogLoc));
            }
        }
        catch (OiscuTextException e) {
            System.err.println(e.getMessage());
        }
        if (sOSPLogLoc == null) {
            sLogFile = "osp.log";
            sFoundFile = "foundfiles.log";
            sMissingFile = "missingfiles.log";
            sErrFile = "osp.err";
        } else {
            sOSPLogLoc = sOSPLogLoc.trim();
            boolean bStatus = true;
            File fLog = new File(sOSPLogLoc);
            if (!fLog.exists()) {
                bStatus = fLog.mkdir();
                if (!bStatus) {
                    System.err.println("Unable to create the log directory .\nInsufficient disk space or write permission not available.\n Using console for logging.");
                }
            } else if (fLog.isDirectory() && fLog.canWrite()) {
                bStatus = true;
                try {
                    new FileWriter(sOSPLogLoc + "/osp.log").close();
                }
                catch (IOException e) {
                    bStatus = false;
                }
            } else {
                bStatus = false;
            }
            if (!bStatus) {
                sLogFile = "osp.log";
                sFoundFile = "foundfiles.log";
                sMissingFile = "missingfiles.log";
                sErrFile = "osp.err";
            } else {
                sLogFile = sOSPLogLoc + "/osp.log";
                sErrFile = sOSPLogLoc + "/osp.err";
                sMissingFile = sOSPLogLoc + "/missing.log";
                sFoundFile = sOSPLogLoc + "/found.log";
            }
        }
        if (this.m_bRedirectLog) {
            System.out.println("List of selected files will be logged to :" + sFoundFile);
            System.out.println("List of missing files will be logged to :" + sMissingFile);
            System.out.println("Output Logfile :" + sLogFile);
            System.out.println("Exceptions will be logged to :" + sErrFile);
        } else if (this.m_bVerbose) {
            System.out.println("Selected/missing file listings will go to standard out/error");
            System.out.println("Output Logfile :" + sLogFile);
        }
        if (this.m_bRedirectLog) {
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(sLogFile), true);
                System.setOut(ps);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            try {
                PrintStream ps = new PrintStream(new FileOutputStream(sErrFile), true);
                System.setErr(ps);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
            if (!this.OpenlogFile(sFoundFile, OiscxLogUtil.FOUND_FILE)) {
                this.m_foundLogFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
                if (sFoundFile != null && sFoundFile.trim().length() != 0) {
                    this.display(OisrbResourceLoader.getString("S_UNABLE_CREATE_LOG_FILE") + sFoundFile);
                }
            } else {
                OiscxLogUtil.setMessageListener(OiscxLogUtil.FOUND_FILE, this.m_foundLogFile);
            }
            if (!this.OpenlogFile(sMissingFile, OiscxLogUtil.MISSING_FILE)) {
                this.m_missingLogFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.err));
                if (sMissingFile != null && sMissingFile.trim().length() != 0) {
                    this.display(OisrbResourceLoader.getString("S_UNABLE_CREATE_LOG_FILE") + sMissingFile);
                }
            } else {
                OiscxLogUtil.setMessageListener(OiscxLogUtil.MISSING_FILE, this.m_missingLogFile);
            }
        } else {
            log = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
            OiscuProgressAltMessage errlog = new OiscuProgressAltMessage(new OutputStreamWriter(System.err));
            OiscxLogUtil.setMessageListener(OiscxLogUtil.MISSING_FILE, errlog);
            OiscxLogUtil.setMessageListener(OiscxLogUtil.FOUND_FILE, log);
        }
        if (!this.OpenlogFile(sLogFile, OiscxLogUtil.LOG_FILE)) {
            this.mesgFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.err));
            if (sLogFile != null && sLogFile.trim().length() != 0) {
                this.display(OisrbResourceLoader.getString("S_UNABLE_CREATE_LOG_FILE") + sLogFile);
            }
            this.display(OisrbResourceLoader.getString("S_STANDARD_LOG"));
            log = new OiscuProgressAltMessage(new OutputStreamWriter(System.out));
            OiscxLogUtil.setMessageListener(OiscxLogUtil.LOG_FILE, log);
        } else {
            OiscxLogUtil.setMessageListener(OiscxLogUtil.LOG_FILE, this.mesgFile);
        }
    }

    boolean OpenlogFile(String sLogFile, int type) {
        boolean bLogFileSuccess = false;
        if (sLogFile != null && sLogFile.trim().length() > 0) {
            try {
                OiscuProgressAltMessage messageFile = new OiscuProgressAltMessage(sLogFile);
                if (type == OiscxLogUtil.MISSING_FILE) {
                    this.m_missingLogFile = messageFile;
                } else if (type == OiscxLogUtil.FOUND_FILE) {
                    this.m_foundLogFile = messageFile;
                } else if (type == OiscxLogUtil.LOG_FILE) {
                    this.mesgFile = messageFile;
                }
                bLogFileSuccess = true;
            }
            catch (IOException e) {
                OiscxHelper.logError(OisrbResourceLoader.getString("S_CANT_OPEN_FILE") + e.getMessage(), 0);
            }
            catch (OiscuTextException e) {
                OiscxHelper.logError(OisrbResourceLoader.getString("S_CANT_OPEN_FILE") + e.getMessage(), 0);
            }
        }
        return bLogFileSuccess;
    }

    void display(String s) {
        if (this.mesgFile == null) {
            this.mesgFile = new OiscuProgressAltMessage(new OutputStreamWriter(System.err));
        }
        this.mesgFile.displayProgressMessage(s);
        this.mesgFile.flush();
    }

    private String getParentDir(String path) {
        int pathLen = path.length();
        int lastSepPos = path.lastIndexOf(47, pathLen - 2);
        if (lastSepPos != -1) {
            return path.substring(0, lastSepPos);
        }
        return null;
    }

    private String getStandardForm(String nativePath) {
        return nativePath.replace(File.separatorChar, '/');
    }
}

