/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.osi.osif;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Iterator;
import java.util.List;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.osi.osif.OsifIRuntimeProperty;
import oracle.sysman.osi.osif.OsifInvalidInputException;
import oracle.sysman.osi.osif.OsifSuiteMetadataXMLHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class OsifSuiteMetadataReader {
    private OsifSuiteMetadataXMLHandler handler = null;

    public OsifSuiteMetadataXMLHandler getXmlHandler() {
        return this.handler;
    }

    public void parse(String sFile) throws OsifInvalidInputException {
        try {
            FileReader fReader = new FileReader(sFile);
            BufferedReader bReader = new BufferedReader(fReader);
            Parser parser = OixsXMLOps.createSAXParser();
            try {
                this.handler = new OsifSuiteMetadataXMLHandler();
                parser.setDocumentHandler((DocumentHandler)((Object)this.handler));
                parser.setErrorHandler((ErrorHandler)((Object)this.handler));
                parser.parse(new InputSource(bReader));
            }
            catch (SAXException e) {
                e.printStackTrace();
                throw new OsifInvalidInputException(e.getMessage());
            }
            bReader.close();
            fReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new OsifInvalidInputException(e.getMessage());
        }
    }

    public String getSuiteName() {
        if (this.handler != null) {
            return this.handler.getSuiteName();
        }
        return null;
    }

    public String getSuiteVersion() {
        if (this.handler != null) {
            return this.handler.getSuiteVersion();
        }
        return null;
    }

    public String getSuiteDesc() {
        if (this.handler != null) {
            return this.handler.getSuiteDesc();
        }
        return null;
    }

    public String getPrereqConfigLocation() {
        if (this.handler != null) {
            return this.handler.getPrereqConfigLocation();
        }
        return null;
    }

    public String getPrereqEntryPoint() {
        if (this.handler != null) {
            return this.handler.getPrereqEntryPoint();
        }
        return null;
    }

    public List getSuiteRuntimeProperties() {
        if (this.handler != null) {
            return this.handler.getSuiteRuntimeProperties();
        }
        return null;
    }

    public OsifIRuntimeProperty getSuiteRuntimeProperty(String propName) {
        List pList = null;
        if (this.handler != null) {
            pList = this.handler.getSuiteRuntimeProperties();
            if (pList != null) {
                Iterator iter = pList.iterator();
                OsifIRuntimeProperty p = null;
                while (iter.hasNext() && !(p = (OsifIRuntimeProperty)iter.next()).getPropName().equals(propName)) {
                }
                return p;
            }
            return null;
        }
        return null;
    }

    public String getSuiteRuntimePropertyValue(String propName) {
        List pList = null;
        if (this.handler != null) {
            pList = this.handler.getSuiteRuntimeProperties();
            if (pList != null) {
                Iterator iter = pList.iterator();
                String retVal = null;
                while (iter.hasNext()) {
                    OsifIRuntimeProperty p = (OsifIRuntimeProperty)iter.next();
                    if (!p.getPropName().equals(propName)) continue;
                    retVal = p.getPropValue();
                    break;
                }
                return retVal;
            }
            return null;
        }
        return null;
    }

    public List getRootBeforeConfig() {
        if (this.handler != null) {
            return this.handler.getRootBeforeConfig();
        }
        return null;
    }

    public List getRootAfterConfig() {
        if (this.handler != null) {
            return this.handler.getRootAfterConfig();
        }
        return null;
    }

    public List getActionList() {
        if (this.handler != null) {
            return this.handler.getActionList();
        }
        return null;
    }

    public List getConfigList() {
        if (this.handler != null) {
            return this.handler.getConfigList();
        }
        return null;
    }
}

