/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.osi.osif;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.sysman.oii.oiio.oiiol.OiiolTextLogger;
import oracle.sysman.oii.oiip.oiipg.OiipgBootstrap;
import oracle.sysman.oii.oiix.OiixFileOps;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixTeePrintStream;
import oracle.sysman.oix.oixs.OixsXMLOps;
import oracle.sysman.osi.osif.OsifIAction;
import oracle.sysman.osi.osif.OsifIActionResult;
import oracle.sysman.osi.osif.OsifIRuntimeProperty;
import oracle.sysman.osi.osif.OsifISuiteInstallListener;
import oracle.sysman.osi.osif.OsifISuiteInstaller;
import oracle.sysman.osi.osif.OsifISuiteResultSummary;
import oracle.sysman.osi.osif.OsifSuiteExecException;
import oracle.sysman.osi.osif.OsifSuiteMetadataReader;
import oracle.sysman.osi.osif.OsifSuiteMetadataXMLHandler;
import oracle.sysman.osi.osif.OsifSuiteResultSummary;
import oracle.xml.parser.v2.XMLElement;
import org.w3c.dom.Node;

public class OsifSuiteInstaller
implements OsifISuiteInstaller {
    private String checkPointLoc = null;
    private String logLoc = null;
    private String invLoc = null;
    private Vector listeners = null;
    private OsifSuiteResultSummary resultSummary = null;
    private String metadataXml = null;
    private String defaultLoc = new OiipgBootstrap().getDefaultLocationFileLoc();
    private String suiteName = null;
    private OsifSuiteMetadataXMLHandler handler = null;
    private Map runtimeProperties = null;

    public OsifSuiteInstaller(String metadata) {
        this.metadataXml = metadata;
    }

    @Override
    public void setCheckPointLocation(String location) {
        this.checkPointLoc = location;
    }

    @Override
    public void setLogLocation(String location) {
        this.logLoc = location;
    }

    @Override
    public void setInventoryLocation(String location) {
        this.invLoc = location;
    }

    @Override
    public void addSuiteInstallListener(OsifISuiteInstallListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(listener);
    }

    @Override
    public void execute(Map properties) throws OsifSuiteExecException {
        this.execute(properties, null);
    }

    @Override
    public void execute(Map properties, int[] excludeList) throws OsifSuiteExecException {
        this.runtimeProperties = properties;
        if (this.logLoc == null) {
            this.logLoc = OiixPathOps.concatPath((String)this.defaultLoc, (String)"suiteInstallLogs");
        }
        if (this.invLoc == null) {
            this.invLoc = this.defaultLoc;
        }
        try {
            OiiolTextLogger.setLogLoc((String)this.logLoc, (String)"suiteInstallActions");
            File dupOut = new File(this.logLoc, "suiteInstall.out");
            File dupErr = new File(this.logLoc, "suiteInstall.err");
            OiixTeePrintStream.setOutputTee((String)dupOut.getPath());
            OiixTeePrintStream.setErrorTee((String)dupErr.getPath());
        }
        catch (Exception dupOut) {
            // empty catch block
        }
        if (this.logLoc == null) {
            this.checkPointLoc = OiixPathOps.concatPath((String)this.defaultLoc, (String)"suiteInstallCheckpoints");
        }
        OsifSuiteMetadataReader suiteReader = new OsifSuiteMetadataReader();
        try {
            suiteReader.parse(this.metadataXml);
            OiiolTextLogger.appendText((String)"After parsing metadata xml");
            this.handler = suiteReader.getXmlHandler();
            this.suiteName = suiteReader.getSuiteName();
            List aList = suiteReader.getActionList();
            OiiolTextLogger.appendText((String)("Action list size=" + aList.size()));
            this.notifySuiteInstallStart();
            int progress = 0;
            this.notifyProgress(progress);
            this.resultSummary = new OsifSuiteResultSummary();
            if (aList != null && aList.size() > 0) {
                int totalProgressWeight = this.getTotalProgressWeight(aList, excludeList);
                for (int i = 0; i < aList.size(); ++i) {
                    OsifIAction a = (OsifIAction)aList.get(i);
                    int pWeight = a.getActionProgressWeight();
                    int seq = a.getActionSequence();
                    boolean exclude = false;
                    if (excludeList != null) {
                        for (int j = 0; j < excludeList.length; ++j) {
                            if (j != seq) continue;
                            exclude = true;
                            break;
                        }
                    }
                    if (exclude) continue;
                    this.notifyActionStart(a);
                    OsifIActionResult result = null;
                    String cs = a.getActionPluginClass();
                    String ms = a.getActionPluginMethod();
                    Class[] m_oExecuteRuleParams = new Class[]{Class.forName("oracle.sysman.osi.osif.OsifIAction"), Class.forName("java.util.Map"), Class.forName("java.lang.String"), Class.forName("java.lang.String")};
                    Class<?> p = Class.forName(cs);
                    Method m = p.getDeclaredMethod("execute", m_oExecuteRuleParams);
                    Object[] args = new Object[]{a, properties, this.metadataXml, this.checkPointLoc};
                    result = (OsifIActionResult)m.invoke(null, args);
                    this.resultSummary.addActionResult(result);
                    int aProgress = this.getProgress(pWeight, totalProgressWeight);
                    this.notifyProgress(aProgress);
                    this.notifyActionEnd(result);
                    String dest = OiixPathOps.concatPath((String)this.checkPointLoc, (String)this.suiteName) + ".xml";
                    FileWriter fWriter = new FileWriter(dest);
                    BufferedWriter bWriter = new BufferedWriter(fWriter);
                    PrintWriter pWriter = new PrintWriter(bWriter);
                    pWriter.println(OixsXMLOps.createXMLDirective((boolean)true));
                    pWriter.println(OixsXMLOps.getStandardHeader());
                    this.writeXML(pWriter);
                    OiixFileOps.changePermissions((String)dest, (String)"0660");
                }
                String sUnknown = OiixResourceBundle.getString((String)"S_LOG_UNKNOWN");
                String sLogLoc = OiiolTextLogger.getCurLogFileName();
                sLogLoc = sLogLoc == null || sLogLoc.equals("") ? sUnknown : sLogLoc;
                this.resultSummary.setLogLocation(sLogLoc);
                String sOutLoc = OiixTeePrintStream.getOutFileLoc();
                sOutLoc = sOutLoc == null || sOutLoc.equals("") ? sUnknown : sOutLoc;
                this.resultSummary.setOutLocation(sOutLoc);
                String sErrLoc = OiixTeePrintStream.getErrFileLoc();
                sErrLoc = sErrLoc == null || sErrLoc.equals("") ? sUnknown : sErrLoc;
                this.resultSummary.setErrLocation(sErrLoc);
            }
            if (this.resultSummary.getSuiteInstallResult() == 0) {
                String suites = OiixPathOps.concatPath((String)this.invLoc, (String)"suites");
                File f = new File(suites);
                if (!f.exists()) {
                    if (!f.mkdir()) {
                        String exStr = "Unable to create directory '" + suites + "'";
                        throw new OsifSuiteExecException(exStr);
                    }
                    OiixFileOps.changePermissions((String)suites, (String)"0770");
                }
                String dest = OiixPathOps.concatPath((String)suites, (String)this.suiteName) + ".xml";
                FileWriter fWriter = new FileWriter(dest);
                BufferedWriter bWriter = new BufferedWriter(fWriter);
                PrintWriter pWriter = new PrintWriter(bWriter);
                pWriter.println(OixsXMLOps.createXMLDirective((boolean)true));
                pWriter.println(OixsXMLOps.getStandardHeader());
                this.writeXML(pWriter);
                pWriter.close();
                bWriter.close();
                fWriter.close();
                OiixFileOps.changePermissions((String)dest, (String)"0660");
                String delFile = OiixPathOps.concatPath((String)this.checkPointLoc, (String)this.suiteName) + ".xml";
                File tmpFile = new File(delFile);
                if (tmpFile.exists()) {
                    tmpFile.delete();
                }
            }
            progress = 100;
            this.notifyProgress(progress);
            this.notifySuiteInstallEnd(this.resultSummary);
        }
        catch (Exception e) {
            System.out.println("Exception occured: " + e.getMessage());
        }
    }

    @Override
    public OsifISuiteResultSummary getResultSummary() {
        return this.resultSummary;
    }

    private void notifySuiteInstallStart() {
        if (this.listeners != null) {
            int numListeners = this.listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                OsifISuiteInstallListener oListener = (OsifISuiteInstallListener)this.listeners.get(i);
                oListener.onSuiteInstallStart();
            }
        }
    }

    private void notifyActionStart(OsifIAction action) {
        if (this.listeners != null) {
            int numListeners = this.listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                OsifISuiteInstallListener oListener = (OsifISuiteInstallListener)this.listeners.get(i);
                oListener.onActionStart(action);
            }
        }
    }

    private void notifyActionEnd(OsifIActionResult actionRes) {
        if (this.listeners != null) {
            int numListeners = this.listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                OsifISuiteInstallListener oListener = (OsifISuiteInstallListener)this.listeners.get(i);
                oListener.onActionEnd(actionRes);
            }
        }
    }

    private void notifySuiteInstallEnd(OsifISuiteResultSummary summary) {
        if (this.listeners != null) {
            int numListeners = this.listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                OsifISuiteInstallListener oListener = (OsifISuiteInstallListener)this.listeners.get(i);
                oListener.onSuiteInstallEnd(summary);
            }
        }
    }

    private void notifyProgress(int progress) {
        if (this.listeners != null) {
            int numListeners = this.listeners.size();
            for (int i = 0; i < numListeners; ++i) {
                OsifISuiteInstallListener oListener = (OsifISuiteInstallListener)this.listeners.get(i);
                oListener.onProgressUpdate(progress);
            }
        }
    }

    private int getTotalProgressWeight(List aList, int[] exclude) {
        int total = 0;
        for (int i = 0; i < aList.size(); ++i) {
            OsifIAction a = (OsifIAction)aList.get(i);
            int seq = a.getActionSequence();
            boolean found = false;
            if (exclude != null) {
                for (int j = 0; j < exclude.length; ++j) {
                    if (j != seq) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            total += a.getActionProgressWeight();
        }
        return total;
    }

    private int getProgress(int action, int total) {
        return (int)Math.floor(action / total * 100);
    }

    public void writeXML(PrintWriter out) throws IOException {
        XMLElement element = this.buildDOMTree();
        element.print(out);
    }

    private XMLElement buildDOMTree() {
        XMLElement suiteElement = new XMLElement("suite");
        suiteElement.setAttribute("name", this.handler.getSuiteName());
        suiteElement.setAttribute("version", this.handler.getSuiteVersion());
        suiteElement.setAttribute("desc", this.handler.getSuiteDesc());
        XMLElement prereqsElement = new XMLElement("prereqs");
        prereqsElement.setAttribute("prereq_config_location", this.handler.getPrereqConfigLocation());
        prereqsElement.setAttribute("entry_point", this.handler.getPrereqEntryPoint());
        suiteElement.appendChild((Node)prereqsElement);
        List actionList = this.handler.getActionList();
        if (actionList != null && actionList.size() > 0) {
            XMLElement installPatchingListElement = new XMLElement("install_patching_list");
            for (int i = 0; i < actionList.size(); ++i) {
                List rootAfterConfigList;
                List props;
                OsifIActionResult r;
                OsifIAction a = (OsifIAction)actionList.get(i);
                String resultStr = null;
                if (this.resultSummary != null && (r = this.resultSummary.getActionResult(a.getActionSequence())) != null) {
                    int result = r.getResult();
                    resultStr = new Integer(result).toString();
                }
                XMLElement actionElement = new XMLElement("action");
                actionElement.setAttribute("desc_id", a.getActionDescId());
                if (resultStr != null) {
                    actionElement.setAttribute("result", resultStr);
                }
                if ((props = a.getActionRuntimeProperties()) != null && props.size() > 0) {
                    XMLElement actionRuntimPropertiesElement = new XMLElement("action_runtime_properties");
                    for (int j = 0; j < props.size(); ++j) {
                        OsifIRuntimeProperty p = (OsifIRuntimeProperty)props.get(j);
                        XMLElement propertyElement = new XMLElement("property");
                        propertyElement.setAttribute("name", p.getPropName());
                        propertyElement.setAttribute("value", p.getPropValue());
                        boolean secure = p.isSecure();
                        String secVal = "false";
                        if (secure) {
                            secVal = "true";
                        }
                        propertyElement.setAttribute("secure", secVal);
                        actionRuntimPropertiesElement.appendChild((Node)propertyElement);
                    }
                    actionElement.appendChild((Node)actionRuntimPropertiesElement);
                }
                XMLElement actionProgressWeightElement = new XMLElement("action_progress_weight");
                actionProgressWeightElement.addText(new Integer(a.getActionProgressWeight()).toString());
                actionElement.appendChild((Node)actionProgressWeightElement);
                XMLElement actionSeqElement = new XMLElement("action_sequence");
                actionSeqElement.addText(new Integer(a.getActionSequence()).toString());
                actionElement.appendChild((Node)actionSeqElement);
                XMLElement actionCommandElement = new XMLElement("action_command");
                actionCommandElement.addText(a.getActionCommand());
                actionElement.appendChild((Node)actionCommandElement);
                XMLElement undoActionCommandSequenceElement = new XMLElement("undo_action_sequence");
                undoActionCommandSequenceElement.addText(new Integer(a.getUndoActionSequence()).toString());
                actionElement.appendChild((Node)undoActionCommandSequenceElement);
                XMLElement undoActionCommandElement = new XMLElement("undo_action_command");
                String undoCmd = OiixInstantiateOps.processString((String)a.getUndoActionCommand(), (HashMap)((HashMap)this.runtimeProperties), (String)"%");
                undoActionCommandElement.addText(undoCmd);
                actionElement.appendChild((Node)undoActionCommandElement);
                XMLElement actionPluginElement = new XMLElement("action_execute_plugin");
                actionPluginElement.setAttribute("class", a.getActionPluginClass());
                actionPluginElement.setAttribute("method", a.getActionPluginMethod());
                actionElement.appendChild((Node)actionPluginElement);
                List rootBeforeConfigList = this.handler.getRootBeforeConfig();
                if (rootBeforeConfigList != null && rootBeforeConfigList.size() > 0) {
                    XMLElement rootBeforeConfigElement = new XMLElement("root_before_config");
                    for (int k = 0; k < rootBeforeConfigList.size(); ++k) {
                        String script = (String)rootBeforeConfigList.get(k);
                        XMLElement scriptElement = new XMLElement("script");
                        scriptElement.addText(script);
                        rootBeforeConfigElement.appendChild((Node)scriptElement);
                    }
                    suiteElement.appendChild((Node)rootBeforeConfigElement);
                }
                if ((rootAfterConfigList = this.handler.getRootAfterConfig()) != null && rootAfterConfigList.size() > 0) {
                    XMLElement rootAfterConfigElement = new XMLElement("root_after_config");
                    for (int k = 0; k < rootAfterConfigList.size(); ++k) {
                        String script = (String)rootAfterConfigList.get(k);
                        XMLElement scriptElement = new XMLElement("script");
                        scriptElement.addText(script);
                        rootAfterConfigElement.appendChild((Node)scriptElement);
                    }
                    suiteElement.appendChild((Node)rootAfterConfigElement);
                }
                installPatchingListElement.appendChild((Node)actionElement);
            }
            suiteElement.appendChild((Node)installPatchingListElement);
        }
        return suiteElement;
    }
}

