/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.osi.osif;

import java.util.HashMap;
import java.util.Map;
import oracle.sysman.oii.oiix.OiixInstantiateOps;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;
import oracle.sysman.osi.osif.OsifActionResult;
import oracle.sysman.osi.osif.OsifIAction;
import oracle.sysman.osi.osif.OsifIActionResult;
import oracle.sysman.osi.osif.OsifSuiteMetadataReader;

public class OsifOUIInstallPlugin {
    private static final String OUI_EXEC_UNIX = "runInstaller";
    private static final String OUI_EXEC_WINDOWS = "setup.exe";
    public static final int s_curPlatformId = OiixPlatform.getCurrentPlatform();
    public static final int s_curPlatformGroup = OiixPlatform.getPlatGroup((int)s_curPlatformId);

    public static OsifIActionResult execute(OsifIAction action, Map suiteRuntimeProperties, String metadataXML, String checkPointLocation) {
        Object logLoc = null;
        Object outLoc = null;
        Object errLoc = null;
        OsifIActionResult result = OsifActionResult.NOT_EXECUTED_RESULT;
        String cmd = action.getActionCommand();
        System.out.println("Executing command:" + cmd);
        cmd = OiixInstantiateOps.processString((String)cmd, (HashMap)((HashMap)suiteRuntimeProperties), (String)"%");
        System.out.println("Instantiated command:" + cmd);
        if (cmd.toLowerCase().indexOf("-waitforcompletion") < 0) {
            cmd = cmd + " -waitforcompletion";
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec(cmd);
            int exitVal = process.waitFor();
            if (exitVal == 0) {
                String oracleHome = action.getActionRuntimePropertyValue("ORACLE_HOME");
                oracleHome = OiixInstantiateOps.processString((String)oracleHome, (HashMap)((HashMap)suiteRuntimeProperties), (String)"%");
                OsifSuiteMetadataReader suiteReader = new OsifSuiteMetadataReader();
                suiteReader.parse(metadataXML);
                String suite = suiteReader.getSuiteName();
                String sOUIExecLoc = null;
                String ouiLoc = OiixPathOps.concatPath((String)oracleHome, (String)"oui");
                String sExecLoc = OiixPathOps.concatPath((String)ouiLoc, (String)"bin");
                if (s_curPlatformGroup == -1) {
                    sOUIExecLoc = OiixPathOps.concatPath((String)sExecLoc, (String)OUI_EXEC_UNIX);
                    String invPtrLoc = OiixPathOps.concatPath((String)oracleHome, (String)"oraInst.loc");
                    sOUIExecLoc = sOUIExecLoc + " -invPtrLoc " + invPtrLoc;
                } else if (s_curPlatformGroup == -3) {
                    sOUIExecLoc = OiixPathOps.concatPath((String)sExecLoc, (String)OUI_EXEC_WINDOWS);
                }
                String attachSuiteCmd = sOUIExecLoc + " -attachSuite SUITE_NAME=" + suite + " ORACLE_HOME=" + oracleHome + " -silent -waitforcompletion";
                process = runtime.exec(attachSuiteCmd);
                exitVal = process.waitFor();
                System.out.println("Running Attach Suite command:" + attachSuiteCmd);
            }
            result = new OsifActionResult(action, null, null, null, exitVal);
        }
        catch (Exception e) {
            System.out.println("Exception occured while executing command," + e.getMessage());
        }
        return result;
    }
}

