/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.utils.FixedByteArrayOutputStream;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.Streamable;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.UnsyncByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigInteger;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.Vector;

public class Utils {
    public static short rotlShort(int n, int n2) {
        int n3 = n & 0xFFFF;
        return (short)(n3 << n2 | n3 >> 16 - n2);
    }

    public static short rotrShort(int n, int n2) {
        int n3 = n & 0xFFFF;
        return (short)(n3 >> n2 | n3 << 16 - n2);
    }

    public static void setArray(byte[] byArray, byte by) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = by;
        }
    }

    public static void setArray(short[] sArray, short s) {
        if (sArray == null) {
            return;
        }
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            sArray[i] = s;
        }
    }

    public static void setArray(int[] nArray, int n) {
        if (nArray == null) {
            return;
        }
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static void setArray(byte[] byArray, int n, int n2, byte by) {
        if (byArray == null) {
            return;
        }
        for (int i = n; i < n + n2; ++i) {
            byArray[i] = by;
        }
    }

    public static int rotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    public static int rotr(int n, int n2) {
        return n >>> n2 | n << 32 - n2;
    }

    public static int bytesToWord(int n, int n2, int n3, int n4) {
        return n4 & 0xFF | (n3 & 0xFF) << 8 | (n2 & 0xFF) << 16 | (n & 0xFF) << 24;
    }

    public static short bytesToShort(int n, int n2) {
        return (short)(n2 & 0xFF | (n & 0xFF) << 8);
    }

    public static void bytesToWords(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        int n4 = n;
        for (int i = n2; i < n2 + n3; ++i) {
            nArray[i] = (byArray[n4++] & 0xFF) << 24 | (byArray[n4++] & 0xFF) << 16 | (byArray[n4++] & 0xFF) << 8 | byArray[n4++] & 0xFF;
        }
    }

    public static void bytesToWords(byte[] byArray, int[] nArray) {
        Utils.bytesToWords(byArray, 0, nArray, 0, nArray.length);
    }

    public static void bytesToLongs(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        int n4 = n;
        for (int i = n2; i < n2 + n3; ++i) {
            lArray[i] = ((long)byArray[n4++] & 0xFFL) << 56 | ((long)byArray[n4++] & 0xFFL) << 48 | ((long)byArray[n4++] & 0xFFL) << 40 | ((long)byArray[n4++] & 0xFFL) << 32 | ((long)byArray[n4++] & 0xFFL) << 24 | ((long)byArray[n4++] & 0xFFL) << 16 | ((long)byArray[n4++] & 0xFFL) << 8 | (long)byArray[n4++] & 0xFFL;
        }
    }

    public static void bytesToShorts(byte[] byArray, short[] sArray) {
        int n = 0;
        int n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            sArray[i] = (short)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        }
    }

    public static void bytesToChars(byte[] byArray, char[] cArray) {
        int n = 0;
        int n2 = byArray.length / 2;
        for (int i = 0; i < n2; ++i) {
            cArray[i] = (char)((byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF);
        }
        if (byArray.length % 2 == 1) {
            cArray[byArray.length / 2] = (char)(byArray[byArray.length - 1] & 0xFF);
        }
    }

    public static byte[] longToBytes(long l) {
        byte[] byArray = new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
        return byArray;
    }

    public static byte[] wordToBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
        return byArray;
    }

    public static byte[] shortToBytes(short s) {
        byte[] byArray = new byte[]{(byte)(s >> 8), (byte)s};
        return byArray;
    }

    public static void longsToBytes(long[] lArray, byte[] byArray) {
        Utils.longsToBytes(lArray, 0, byArray, 0, lArray.length);
    }

    public static void longsToBytes(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n; i < n + n3; ++i) {
            byArray[n4++] = (byte)(lArray[i] >> 56);
            byArray[n4++] = (byte)(lArray[i] >> 48);
            byArray[n4++] = (byte)(lArray[i] >> 40);
            byArray[n4++] = (byte)(lArray[i] >> 32);
            byArray[n4++] = (byte)(lArray[i] >> 24);
            byArray[n4++] = (byte)(lArray[i] >> 16);
            byArray[n4++] = (byte)(lArray[i] >> 8);
            byArray[n4++] = (byte)lArray[i];
        }
    }

    public static void wordsToBytes(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        int n4 = n2;
        for (int i = n; i < n + n3; ++i) {
            byArray[n4++] = (byte)(nArray[i] >> 24);
            byArray[n4++] = (byte)(nArray[i] >> 16);
            byArray[n4++] = (byte)(nArray[i] >> 8);
            byArray[n4++] = (byte)nArray[i];
        }
    }

    public static void wordsToBytes(int[] nArray, byte[] byArray) {
        Utils.wordsToBytes(nArray, 0, byArray, 0, nArray.length);
    }

    public static void shortsToBytes(short[] sArray, byte[] byArray) {
        int n = 0;
        int n2 = sArray.length;
        for (int i = 0; i < n2; ++i) {
            byArray[n++] = (byte)(sArray[i] >> 8);
            byArray[n++] = (byte)sArray[i];
        }
    }

    public static void charsToBytes(char[] cArray, byte[] byArray) {
        int n = 0;
        int n2 = cArray.length;
        for (int i = 0; i < n2; ++i) {
            byArray[n++] = (byte)(cArray[i] >> 8);
            byArray[n++] = (byte)cArray[i];
        }
    }

    public static byte[] unicodeToBytes(String string) {
        char[] cArray = new char[string.length()];
        byte[] byArray = new byte[cArray.length << 1];
        string.getChars(0, cArray.length, cArray, 0);
        Utils.charsToBytes(cArray, byArray);
        return byArray;
    }

    public static String bytesToUnicode(byte[] byArray) {
        char[] cArray = new char[(byArray.length - 1) / 2 + 1];
        Utils.bytesToChars(byArray, cArray);
        return new String(cArray);
    }

    public static byte[] toByteArray(BigInteger bigInteger) {
        byte[] byArray = bigInteger.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static void toByteArray(BigInteger bigInteger, byte[] byArray, int n, int n2) throws ArithmeticException {
        byte[] byArray2 = Utils.toByteArray(bigInteger);
        if (byArray2.length > n2) {
            throw new ArithmeticException("The argument is too big to fit in the destination buffer");
        }
        Utils.setArray(byArray, n, n2, (byte)0);
        System.arraycopy(byArray2, 0, byArray, n + (n2 - byArray2.length), byArray2.length);
    }

    public static int length(BigInteger bigInteger) {
        int n = bigInteger.bitLength();
        if (n == 0) {
            return 1;
        }
        return (n - 1) / 8 + 1;
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n4 = n + n3;
        while (n < n3) {
            if (byArray[n] != byArray2[n2]) {
                return false;
            }
            ++n;
            ++n2;
        }
        return true;
    }

    public static String plural(int n, String string) {
        return n + " " + string + (n == 1 ? "" : "s");
    }

    public static String fromUTF8(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = byArray[i] & 0xFF;
            if (n4 < 128) {
                stringBuffer.append((char)n4);
                continue;
            }
            if ((n4 & 0xE0) == 192) {
                if (i == byArray.length - 1) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                if (((n3 = byArray[++i] & 0xFF) & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n4 & 0x1F) << 6 | n3 & 0x3F));
                continue;
            }
            if ((n4 & 0xF0) == 224) {
                if (i >= byArray.length - 2) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n3 = byArray[++i] & 0xFF;
                n2 = byArray[++i] & 0xFF;
                if ((n3 & 0xC0) != 128 || (n2 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                stringBuffer.append((char)((n4 & 0xF) << 12 | (n3 & 0x3F) << 6 | n2 & 0x3F));
                continue;
            }
            if ((n4 & 0xF8) == 240) {
                if (i >= byArray.length - 3) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                n3 = byArray[++i] & 0xFF;
                n2 = byArray[++i] & 0xFF;
                int n5 = byArray[++i] & 0xFF;
                if ((n3 & 0xC0) != 128 || (n2 & 0xC0) != 128 || (n5 & 0xC0) != 128) {
                    throw new InvalidFormatException("Illegal UTF encoding");
                }
                int n6 = ((n4 & 1) << 20 | (n3 & 0x3F) << 12 | (n2 & 0x3F) << 6 | n5 & 0x3F) - 65536;
                stringBuffer.append((char)(55296 + (n6 >> 10)));
                stringBuffer.append((char)(56320 + (n6 & 0x3FF)));
                continue;
            }
            throw new InvalidFormatException("Illegal UTF encoding");
        }
        return stringBuffer.toString();
    }

    public static byte[] toUTF8(String string) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(string.length() * 2);
        try {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c < '\u0080') {
                    unsyncByteArrayOutputStream.write((byte)c);
                    continue;
                }
                if (c < '\u0800') {
                    unsyncByteArrayOutputStream.write(0xC0 | c >> 6);
                    unsyncByteArrayOutputStream.write(0x80 | c & 0x3F);
                    continue;
                }
                if (c >= '\ud800' && c < '\udc00' && i != string.length() - 1 && string.charAt(i + 1) >= '\udc00' && string.charAt(i + 1) < '\ue000') {
                    int n2 = c - 55296 << 10 + (string.charAt(i + 1) - 56320) + 65536;
                    unsyncByteArrayOutputStream.write(0xF0 | n2 >> 18);
                    unsyncByteArrayOutputStream.write(0x80 | n2 >> 12 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | n2 >> 6 & 0x3F);
                    unsyncByteArrayOutputStream.write(0x80 | n2 & 0x3F);
                    continue;
                }
                unsyncByteArrayOutputStream.write(0xE0 | c >> 12);
                unsyncByteArrayOutputStream.write(0x80 | c >> 6 & 0x3F);
                unsyncByteArrayOutputStream.write(0x80 | c & 0x3F);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static int inputWord(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        if (n == -1 || n2 == -1 || n3 == -1 || n4 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToWord(n, n2, n3, n4);
    }

    public static int input24bit(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        if (n == -1 || n2 == -1 || n3 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToWord(0, n, n2, n3);
    }

    public static short inputShort(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        if (n == -1 || n2 == -1) {
            throw new EOFException();
        }
        return Utils.bytesToShort(n, n2);
    }

    public static byte inputByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        return (byte)n;
    }

    public static byte[] inputBytes(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        return Utils.inputByteArray(byArray, inputStream);
    }

    public static byte[] inputByteArray(byte[] byArray, InputStream inputStream) throws IOException {
        Utils.inputByteArray(byArray, 0, byArray.length, inputStream);
        return byArray;
    }

    public static void inputByteArray(byte[] byArray, int n, int n2, InputStream inputStream) throws IOException {
        int n3;
        int n4 = n + n2;
        for (int i = n; i < n4; i += n3) {
            n3 = inputStream.read(byArray, i, n4 - i);
            if (n3 != -1) continue;
            throw new IOException("End of stream reached before all " + n2 + " expected bytes could be read. Only received " + (i - n) + " bytes before the end of the stream was reached");
        }
    }

    public static byte[] toBytes(InputStream inputStream) throws IOException {
        int n;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        while ((n = inputStream.read(byArray)) != -1) {
            unsyncByteArrayOutputStream.write(byArray, 0, n);
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    public static void output(long l, OutputStream outputStream) throws IOException {
        Utils.outputLong(l, outputStream);
    }

    public static void output(int n, OutputStream outputStream) throws IOException {
        Utils.outputWord(n, outputStream);
    }

    public static void output(short s, OutputStream outputStream) throws IOException {
        Utils.outputShort(s, outputStream);
    }

    public static void output(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        Utils.outputBignum(bigInteger, outputStream);
    }

    public static void outputLong(long l, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(l >> 56));
        outputStream.write((byte)(l >> 48));
        outputStream.write((byte)(l >> 40));
        outputStream.write((byte)(l >> 32));
        outputStream.write((byte)(l >> 24));
        outputStream.write((byte)(l >> 16));
        outputStream.write((byte)(l >> 8));
        outputStream.write((byte)l);
    }

    public static void outputWord(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 24));
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static void output24bit(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 16));
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static void outputShort(int n, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(n >> 8));
        outputStream.write((byte)n);
    }

    public static void outputBignum(BigInteger bigInteger, OutputStream outputStream) throws IOException {
        outputStream.write(Utils.toByteArray(bigInteger));
    }

    public static BigInteger inputBignum(int n, InputStream inputStream) throws IOException {
        byte[] byArray = new byte[n];
        Utils.inputByteArray(byArray, inputStream);
        BigInteger bigInteger = BigInteger.valueOf(0L);
        try {
            bigInteger = new BigInteger(1, byArray);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(numberFormatException.toString());
        }
        return bigInteger;
    }

    public static void outputString(String string, OutputStream outputStream) throws IOException {
        outputStream.write(string.getBytes());
    }

    public static void dumpHex(PrintStream printStream, byte[] byArray) {
        String string = "";
        String string2 = "";
        byte[] byArray2 = new byte[]{0};
        int n = byArray.length + (byArray.length % 16 == 0 ? 0 : 16 - byArray.length % 16);
        int n2 = 0;
        while (n2 < n) {
            if (n2 < byArray.length) {
                byArray2[0] = byArray[n2];
                string = string + Utils.toHexString(byArray2);
                string2 = byArray[n2] >= 32 && byArray[n2] <= 125 ? string2 + (char)(byArray[n2] & 0xFF) : string2 + ".";
            } else {
                string = string + "  ";
            }
            if (++n2 % 16 == 0) {
                printStream.println(string + "\t" + string2);
                string2 = "";
                string = "";
                continue;
            }
            string = string + " ";
        }
    }

    public static String toHexString(byte[] byArray, int n, int n2) {
        String string = "0123456789abcdef";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n + n2; ++i) {
            stringBuffer.append(string.charAt((byArray[i] & 0xFF) >> 4));
            stringBuffer.append(string.charAt(byArray[i] & 0xF));
        }
        return stringBuffer.toString();
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        return Utils.toHexString(byArray, 0, byArray.length);
    }

    public static byte[] fromHexString(String string) {
        if (string.length() % 2 != 0) {
            throw new NumberFormatException("malformed hex string (non-even length)");
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = string.length() / 2;
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    public static String toBase64(byte[] byArray) {
        return Utils.toBase64(byArray, true);
    }

    public static String toBase64(byte[] byArray, boolean bl) {
        String string = bl ? System.getProperty("line.separator") : "";
        return Utils.toBase64(byArray, string);
    }

    public static String toBase64(byte[] byArray, String string) {
        int n = (byArray.length + 2) / 3 * 4 + (byArray.length / 48 + 1) * string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = byArray.length;
        for (int i = 0; i < n2; i += 3) {
            int n3 = Math.min(byArray.length - i, 3);
            stringBuffer.append(Utils.base64_encode((byArray[i] & 0xFC) >> 2));
            switch (n3) {
                case 2: 
                case 3: {
                    stringBuffer.append(Utils.base64_encode(((byArray[i] & 3) << 4) + ((byArray[i + 1] & 0xF0) >> 4)));
                    break;
                }
                case 1: {
                    stringBuffer.append(Utils.base64_encode((byArray[i] & 3) << 4));
                }
            }
            switch (n3) {
                case 3: {
                    stringBuffer.append(Utils.base64_encode(((byArray[i + 1] & 0xF) << 2) + ((byArray[i + 2] & 0xC0) >> 6)));
                    break;
                }
                case 2: {
                    stringBuffer.append(Utils.base64_encode((byArray[i + 1] & 0xF) << 2));
                    break;
                }
                case 1: {
                    stringBuffer.append('=');
                }
            }
            switch (n3) {
                case 3: {
                    stringBuffer.append(Utils.base64_encode(byArray[i + 2] & 0x3F));
                    break;
                }
                case 1: 
                case 2: {
                    stringBuffer.append('=');
                }
            }
            if (i % 48 != 45) continue;
            stringBuffer.append(string);
        }
        if (byArray.length % 48 <= 45) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static byte[] fromBase64(String string) {
        int n = string.length() / 4 * 3;
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(n);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            if (n3 < string.length() && (string.charAt(n3) == '\r' || string.charAt(n3) == '\n')) {
                ++n3;
                continue;
            }
            if (n3 + 4 > string.length()) break;
            int n4 = string.charAt(n3 + 2) == '=' ? 1 : (string.charAt(n3 + 3) == '=' ? 2 : 3);
            int n5 = Utils.base64_decode(string.charAt(n3));
            int n6 = Utils.base64_decode(string.charAt(n3 + 1));
            int n7 = 0;
            int n8 = 0;
            switch (n4) {
                case 3: {
                    n8 = Utils.base64_decode(string.charAt(n3 + 3));
                }
                case 2: {
                    n7 = Utils.base64_decode(string.charAt(n3 + 2));
                }
            }
            try {
                unsyncByteArrayOutputStream.write((n5 << 2) + ((n6 & 0x30) >> 4));
                if (n4 != 1) {
                    unsyncByteArrayOutputStream.write(((n6 & 0xF) << 4) + ((n7 & 0x3C) >> 2));
                }
                if (n4 == 3) {
                    unsyncByteArrayOutputStream.write(((n7 & 3) << 6) + n8);
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
            n2 += 3;
            n3 += 4;
        }
        return unsyncByteArrayOutputStream.toByteArray();
    }

    private static char base64_encode(int n) {
        if (n < 26) {
            return (char)(65 + n);
        }
        if (n < 52) {
            return (char)(97 + n - 26);
        }
        if (n < 62) {
            return (char)(48 + n - 52);
        }
        if (n == 62) {
            return '+';
        }
        if (n == 63) {
            return '/';
        }
        throw new IllegalArgumentException();
    }

    private static int base64_decode(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'z') {
            return c - 97 + 26;
        }
        if (c >= '0' && c <= '9') {
            return c - 48 + 52;
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        throw new IllegalArgumentException();
    }

    public static String stripEOL(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\r' || c == '\n') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String fromURLEncoded(String string) {
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream(string.length());
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            if (n == 43) {
                n = 32;
            } else if (n == 37) {
                n = string.charAt(++i);
                int n2 = Character.digit((char)n, 16);
                n = string.charAt(++i);
                int n3 = Character.digit((char)n, 16);
                n = (n2 & 0xF) << 4 | n3 & 0xF;
            }
            try {
                unsyncByteArrayOutputStream.write(n);
                continue;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException.toString());
            }
        }
        return unsyncByteArrayOutputStream.toString();
    }

    public static String toURLEncoded(String string) {
        return URLEncoder.encode(string);
    }

    public static Date parseDate(String string) {
        return Utils.parseDate(string, false);
    }

    public static Date parseDate(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        int n = -2;
        int n2 = 0;
        if (bl || string.indexOf(90) == 14 || string.indexOf(43) == 14 || string.indexOf(45) == 14) {
            n2 = 100 * Utils.parseDateInt(string, n += 2);
            n2 += Utils.parseDateInt(string, n += 2);
        } else {
            n2 = 1900 + Utils.parseDateInt(string, n += 2);
            if (n2 < 1950) {
                n2 += 100;
            }
        }
        int n3 = Utils.parseDateInt(string, n += 2);
        int n4 = Utils.parseDateInt(string, n += 2);
        int n5 = Utils.parseDateInt(string, n += 2);
        int n6 = Utils.parseDateInt(string, n += 2);
        int n7 = 0;
        if (string.charAt(n + 2) >= '0' && string.charAt(n + 2) <= '9') {
            n7 = Utils.parseDateInt(string, n += 2);
        }
        int n8 = 0;
        if (string.charAt(n += 2) != 'Z') {
            int n9 = Utils.parseDateInt(string, n + 1);
            int n10 = Utils.parseDateInt(string, n + 3);
            n8 = (n9 * 60 + n10) * 60 * 1000;
            if (string.charAt(n) == '-') {
                n8 = -n8;
            }
        }
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n8, "");
        Calendar calendar = Calendar.getInstance(simpleTimeZone);
        calendar.set(n2, n3 - 1, n4, n5, n6, n7);
        return calendar.getTime();
    }

    static int parseDateInt(String string, int n) {
        return 10 * (string.charAt(n) - 48) + (string.charAt(n + 1) - 48);
    }

    public static String formatDate(Date date) {
        return Utils.formatDate(date, false);
    }

    public static String formatDate(Date date, boolean bl) {
        if (date == null) {
            return null;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(new SimpleTimeZone(0, ""));
        gregorianCalendar.setTime(date);
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(Utils.formatDateInt(gregorianCalendar.get(1) / 100));
        }
        stringBuffer.append(Utils.formatDateInt(gregorianCalendar.get(1) % 100));
        stringBuffer.append(Utils.formatDateInt(gregorianCalendar.get(2) + 1));
        stringBuffer.append(Utils.formatDateInt(gregorianCalendar.get(5)));
        int n = gregorianCalendar.get(10);
        if (gregorianCalendar.get(9) == 1) {
            n += 12;
        }
        stringBuffer.append(Utils.formatDateInt(n));
        stringBuffer.append(Utils.formatDateInt(gregorianCalendar.get(12)));
        stringBuffer.append(Utils.formatDateInt(gregorianCalendar.get(13)));
        return stringBuffer.append("Z").toString();
    }

    static String formatDateInt(int n) {
        String string = Integer.toString(n);
        if (string.length() == 2) {
            return string;
        }
        return "0" + string;
    }

    public static Date daysFrom(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static Date daysFromNow(int n) {
        return Utils.daysFrom(new Date(), n);
    }

    public static Date minutesFrom(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, n);
        return calendar.getTime();
    }

    public static byte[] toBytes(Streamable streamable) {
        try {
            FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(streamable.length());
            streamable.output(fixedByteArrayOutputStream);
            return fixedByteArrayOutputStream.getBytes();
        }
        catch (IOException iOException) {
            throw new StreamableOutputException(iOException);
        }
    }

    public static byte[] toBytesUnsafe(Streamable streamable) throws IOException {
        FixedByteArrayOutputStream fixedByteArrayOutputStream = new FixedByteArrayOutputStream(streamable.length());
        streamable.output(fixedByteArrayOutputStream);
        return fixedByteArrayOutputStream.getBytes();
    }

    public static InputStream toStream(Streamable streamable) {
        return new UnsyncByteArrayInputStream(Utils.toBytes(streamable));
    }

    public static int hashBytes(Streamable streamable) {
        return new String(Utils.toBytes(streamable)).hashCode();
    }

    public static String toString(Vector vector) {
        if (vector == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{ ");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(vector.elementAt(i).toString());
            if (i == n - 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append(" }");
        return stringBuffer.toString();
    }

    public static byte[] xor(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n >= n2) {
            byte[] byArray3 = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray3[i] = i < n2 ? (byte)(byArray[i] ^ byArray2[i]) : byArray[i];
            }
            return byArray3;
        }
        return Utils.xor(byArray2, byArray);
    }
}

