/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import java.io.IOException;
import java.io.OutputStream;

public class UnsyncByteArrayOutputStream
extends OutputStream {
    private static final int INITIAL_SIZE = 64;
    protected byte[] buf;
    protected int count;
    private boolean isClosed;

    public UnsyncByteArrayOutputStream() {
        this(64);
    }

    public UnsyncByteArrayOutputStream(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n);
        }
        this.buf = new byte[n];
    }

    @Override
    public void write(int n) throws IOException {
        this.assertOpen();
        if (this.count == this.buf.length) {
            byte[] byArray = new byte[this.buf.length << 1];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
        this.buf[this.count++] = (byte)n;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return;
        }
        int n3 = this.count + n2;
        if (n3 > this.buf.length) {
            byte[] byArray2 = new byte[Math.max(this.buf.length << 1, n3)];
            System.arraycopy(this.buf, 0, byArray2, 0, this.count);
            this.buf = byArray2;
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count = n3;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    public void reset() throws IOException {
        this.assertOpen();
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("output stream closed");
        }
    }
}

