/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import java.io.IOException;
import java.io.InputStream;

public class UnsyncByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int pos;
    protected int mark;
    protected int count;
    private boolean isClosed;

    public UnsyncByteArrayInputStream(byte[] byArray) {
        this.buf = byArray;
        this.count = byArray.length;
    }

    public UnsyncByteArrayInputStream(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = this.mark = n;
        this.count = Math.min(n + n2, byArray.length);
    }

    @Override
    public int read() throws IOException {
        this.assertOpen();
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    @Override
    public long skip(long l) throws IOException {
        this.assertOpen();
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l <= 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    @Override
    public int available() throws IOException {
        this.assertOpen();
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.pos;
    }

    @Override
    public void reset() throws IOException {
        this.assertOpen();
        this.pos = this.mark;
    }

    @Override
    public void close() throws IOException {
        this.isClosed = true;
    }

    private void assertOpen() throws IOException {
        if (this.isClosed) {
            throw new IOException("input stream closed");
        }
    }
}

