/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import java.util.Hashtable;

public class ObjectPool {
    private static int DEFAULT_START_SIZE = 64;
    private static int GROWTH_FACTOR = 2;
    private Class type;
    private Link pool = null;
    private Hashtable inUse = new Hashtable();
    private int startSize;
    private int size;
    private Object lock = new Object();

    public ObjectPool(Class clazz) {
        this(DEFAULT_START_SIZE, clazz);
    }

    public ObjectPool(int n, Class clazz) {
        if (n <= 0) {
            throw new IllegalArgumentException("Start size must be > 0");
        }
        this.startSize = n;
        this.type = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        Object object = this.lock;
        synchronized (object) {
            if (this.size == 0) {
                this.size = this.startSize;
                this.fillPool();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() {
        Object object = this.lock;
        synchronized (object) {
            if (this.pool == null) {
                this.size = this.size > 0 ? this.size * GROWTH_FACTOR : this.startSize;
                this.fillPool();
            }
            Link link = this.pool;
            this.pool = this.pool.next;
            link.next = null;
            this.inUse.put(link.obj, link);
            return link.obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseObject(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            Link link = (Link)this.inUse.remove(object);
            if (link != null) {
                link.next = this.pool;
                this.pool = link;
            }
        }
    }

    public int size() {
        return this.size;
    }

    public int available() {
        return this.size - this.inUse.size();
    }

    public Class getObjectType() {
        return this.type;
    }

    protected Object newObject() {
        try {
            return this.type.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalStateException(instantiationException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillPool() {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.size; ++i) {
                this.pool = new Link(this.newObject(), this.pool);
            }
        }
    }

    private static class Link {
        Object obj = null;
        Link next = null;

        public Link(Object object, Link link) {
            this.obj = object;
            this.next = link;
        }
    }
}

