/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.cert.PKIX;
import com.phaos.cert.extension.AuthorityInfoAccessExtension;
import com.phaos.cert.extension.AuthorityKeyIDExtension;
import com.phaos.cert.extension.BasicConstraintsExtension;
import com.phaos.cert.extension.CRLCertificateIssuerExtension;
import com.phaos.cert.extension.CRLDistPointExtension;
import com.phaos.cert.extension.CRLHoldInstructionExtension;
import com.phaos.cert.extension.CRLInvalidityDateExtension;
import com.phaos.cert.extension.CRLNumberExtension;
import com.phaos.cert.extension.CRLReasonExtension;
import com.phaos.cert.extension.CertificatePoliciesExtension;
import com.phaos.cert.extension.DeltaCRLIndicatorExtension;
import com.phaos.cert.extension.ExtKeyUsageExtension;
import com.phaos.cert.extension.IssuerAltNameExtension;
import com.phaos.cert.extension.IssuingDistPointExtension;
import com.phaos.cert.extension.KeyUsageExtension;
import com.phaos.cert.extension.NameConstraintsExtension;
import com.phaos.cert.extension.NetscapeCertTypeExtension;
import com.phaos.cert.extension.PolicyConstraintsExtension;
import com.phaos.cert.extension.SubjectAltNameExtension;
import com.phaos.cert.extension.SubjectKeyIDExtension;
import com.phaos.crypto.AES;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.Arcfour;
import com.phaos.crypto.Blowfish;
import com.phaos.crypto.DES;
import com.phaos.crypto.DES_EDE;
import com.phaos.crypto.DHKeyAgreement;
import com.phaos.crypto.DHKeyPairGenerator;
import com.phaos.crypto.DHPrivateKey;
import com.phaos.crypto.DHPublicKey;
import com.phaos.crypto.DSA;
import com.phaos.crypto.DSAKeyPairGenerator;
import com.phaos.crypto.DSAPrivateKey;
import com.phaos.crypto.DSAPublicKey;
import com.phaos.crypto.DiffieHellman;
import com.phaos.crypto.HMAC;
import com.phaos.crypto.MD2;
import com.phaos.crypto.MD5;
import com.phaos.crypto.PasswordBasedMAC;
import com.phaos.crypto.RC2;
import com.phaos.crypto.RSAKeyPairGenerator;
import com.phaos.crypto.RSAMDSignature;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RSApkcs1;
import com.phaos.crypto.SHA;
import com.phaos.crypto.SymmetricKeyGenerator;
import com.phaos.crypto.cryptoki.CkiPrivateKey;
import com.phaos.crypto.cryptoki.CkiPublicKey;
import com.phaos.crypto.cryptoki.CkiRSApkcs1;
import com.phaos.crypto.cryptoki.CkiSignature;
import com.phaos.utils.InvalidFormatException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class OIDManager {
    private static OIDManager defaultOIDManager = null;
    private Hashtable oidmap = new Hashtable();
    private Hashtable attTypemap = new Hashtable();
    private Hashtable attNamemap = new Hashtable();
    protected OIDManager parent = null;
    public static final AlgorithmIdentifier cryptokiPrivateKey = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.phaosID, 2, 1));
    public static final AlgorithmIdentifier cryptokiPublicKey = new AlgorithmIdentifier(new ASN1ObjectID(ASN1Utils.phaosID, 2, 2));
    private static final Object lockDefault = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOIDManager(OIDManager oIDManager) {
        Object object = lockDefault;
        synchronized (object) {
            defaultOIDManager = oIDManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OIDManager getOIDManager() {
        Object object = lockDefault;
        synchronized (object) {
            if (defaultOIDManager == null) {
                defaultOIDManager = OIDManager.getDefaultOIDManager();
            }
        }
        return defaultOIDManager;
    }

    private static OIDManager getDefaultOIDManager() {
        OIDManager oIDManager = new OIDManager();
        oIDManager.mapDefaults();
        return oIDManager;
    }

    public OIDManager() {
    }

    public OIDManager(OIDManager oIDManager) {
        this.parent = oIDManager;
    }

    public Properties setProperties(ASN1ObjectID aSN1ObjectID, Properties properties) {
        Object object;
        Object object2;
        Hashtable hashtable = new Hashtable();
        try {
            object2 = properties.keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                hashtable.put((String)object, Class.forName((String)properties.get(object)));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.toString());
        }
        object2 = this.setMappings(aSN1ObjectID, hashtable);
        object = new Properties();
        Enumeration enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            ((Properties)object).put(string, ((Class)((Hashtable)object2).get(string)).getName());
        }
        return object;
    }

    public Hashtable setMappings(ASN1ObjectID aSN1ObjectID, Hashtable hashtable) {
        return this.oidmap.put(aSN1ObjectID, hashtable);
    }

    public Properties getProperties(ASN1ObjectID aSN1ObjectID) {
        Hashtable hashtable = this.getMappings(aSN1ObjectID);
        Properties properties = new Properties();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            properties.put(string, ((Class)hashtable.get(string)).getName());
        }
        return properties;
    }

    public Hashtable getMappings(ASN1ObjectID aSN1ObjectID) {
        Hashtable hashtable = (Hashtable)this.oidmap.get(aSN1ObjectID);
        if (hashtable == null && this.parent != null) {
            hashtable = this.parent.getMappings(aSN1ObjectID);
        } else if (hashtable == null && this.parent == null) {
            hashtable = new Hashtable();
            this.oidmap.put(aSN1ObjectID, hashtable);
            this.mapTable(aSN1ObjectID, hashtable);
            hashtable = (Hashtable)this.oidmap.get(aSN1ObjectID);
        }
        return hashtable;
    }

    public String setProperty(ASN1ObjectID aSN1ObjectID, String string, String string2) {
        String string3;
        if (string.equals("attributeTypeName")) {
            this.setAttributeTypeName(string2, aSN1ObjectID);
            Hashtable<String, String> hashtable = (Hashtable<String, String>)this.oidmap.get(aSN1ObjectID);
            if (hashtable == null) {
                hashtable = new Hashtable<String, String>();
                this.oidmap.put(aSN1ObjectID, hashtable);
            }
            return hashtable.put(string, string2);
        }
        Hashtable<String, String> hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            hashtable = new Hashtable<String, String>();
            this.setMappings(aSN1ObjectID, hashtable);
        }
        if ((string3 = hashtable.put(string, string2)) == null) {
            return null;
        }
        if (string3 instanceof String) {
            return string3;
        }
        return ((Class)((Object)string3)).getName();
    }

    public Class setMapping(ASN1ObjectID aSN1ObjectID, String string, Class clazz) {
        Class clazz2;
        Hashtable<String, Class> hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            hashtable = new Hashtable<String, Class>();
            this.setMappings(aSN1ObjectID, hashtable);
        }
        if ((clazz2 = hashtable.put(string, clazz)) == null) {
            return null;
        }
        if (clazz2 instanceof String) {
            try {
                return Class.forName((String)((Object)clazz2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
        }
        return clazz2;
    }

    public String getProperty(ASN1ObjectID aSN1ObjectID, String string) {
        if (string.equals("attributeTypeName")) {
            Hashtable hashtable = (Hashtable)this.oidmap.get(aSN1ObjectID);
            if (hashtable == null) {
                return null;
            }
            return (String)hashtable.get(string);
        }
        Hashtable hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null && this.parent != null) {
            return this.parent.getProperty(aSN1ObjectID, string);
        }
        if (v == null && this.parent == null) {
            this.mapTable(aSN1ObjectID, hashtable);
            v = hashtable.get(string);
        }
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            return (String)v;
        }
        return ((Class)v).getName();
    }

    public Class getMapping(ASN1ObjectID aSN1ObjectID, String string) {
        Hashtable hashtable = this.getMappings(aSN1ObjectID);
        if (hashtable == null) {
            return null;
        }
        Object v = hashtable.get(string);
        if (v == null && this.parent != null) {
            return this.parent.getMapping(aSN1ObjectID, string);
        }
        if (v == null && this.parent == null) {
            this.mapTable(aSN1ObjectID, hashtable);
            v = hashtable.get(string);
        }
        if (v == null) {
            return null;
        }
        if (v instanceof String) {
            try {
                return Class.forName((String)v);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(classNotFoundException.toString());
            }
        }
        return (Class)v;
    }

    public ASN1ObjectID setAttributeTypeName(String string, ASN1ObjectID aSN1ObjectID) {
        this.attNamemap.put(aSN1ObjectID, string);
        return this.attTypemap.put(string.toUpperCase(), aSN1ObjectID);
    }

    public ASN1ObjectID getAttributeType(String string) {
        ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)this.attTypemap.get(string.toUpperCase());
        if (aSN1ObjectID == null && this.parent != null) {
            aSN1ObjectID = this.parent.getAttributeType(string.toUpperCase());
        }
        return aSN1ObjectID;
    }

    public String getAttributeName(ASN1ObjectID aSN1ObjectID) {
        String string = (String)this.attNamemap.get(aSN1ObjectID);
        if (string == null && this.parent != null) {
            string = this.parent.getAttributeName(aSN1ObjectID);
        }
        return string;
    }

    public void load(InputStream inputStream) throws IOException {
        while (true) {
            String string = null;
            int n = inputStream.read();
            if (n == -1) break;
            while (Character.isWhitespace((char)n)) {
                n = inputStream.read();
            }
            if (n == 35 || n == 33) {
                while ((n = inputStream.read()) != -1 && n != 13 && n != 10) {
                }
                continue;
            }
            StringBuffer stringBuffer = new StringBuffer();
            do {
                stringBuffer.append((char)n);
            } while ((n = inputStream.read()) != -1 && n != 13 && n != 10);
            string = stringBuffer.toString();
            if (string.length() <= 0) continue;
            char c = string.charAt(0);
            if (c == '&') {
                string = string.substring(1);
            }
            try {
                ASN1ObjectID aSN1ObjectID = new ASN1ObjectID(OIDManager.rTrim(OIDManager.lTrim(string)));
                Properties properties = new Properties();
                properties.load(new OIDManagerInputStream(inputStream));
                this.setProperties(aSN1ObjectID, properties);
            }
            catch (InvalidFormatException invalidFormatException) {
                throw new IOException(invalidFormatException.toString());
            }
        }
    }

    private static String lTrim(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return n < string.length() ? string.substring(n) : "";
    }

    private static String rTrim(String string) {
        int n;
        for (n = string.length(); n > 0 && Character.isWhitespace(string.charAt(n - 1)); --n) {
        }
        return n > 0 ? string.substring(0, n) : "";
    }

    private void mapDefaults() {
        this.setAttributeTypeName("CN", PKIX.id_at_commonName);
        this.setAttributeTypeName("L", PKIX.id_at_localityName);
        this.setAttributeTypeName("ST", PKIX.id_at_stateOrProvinceName);
        this.setAttributeTypeName("O", PKIX.id_at_organizationName);
        this.setAttributeTypeName("OU", PKIX.id_at_organizationalUnitName);
        this.setAttributeTypeName("C", PKIX.id_at_countryName);
        this.setAttributeTypeName("Email", PKIX.emailAddress);
        this.setAttributeTypeName("DC", PKIX.id_domainComponent);
    }

    private void mapTable(ASN1ObjectID aSN1ObjectID, Hashtable hashtable) {
        if (aSN1ObjectID.equals(AlgID.rsaEncryption.getOID()) || aSN1ObjectID.equals(AlgID.rsaWithOAEPEncoding.getOID())) {
            this.mapRSACipher(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.md2WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.md5WithRSAEncryption.getOID()) || aSN1ObjectID.equals(AlgID.sha_1WithRSAEncryption.getOID())) {
            this.mapRSASignature(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dsa.getOID()) || aSN1ObjectID.equals(AlgID.dsaOld.getOID())) {
            this.mapDSACipher(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dsaWithSHA1.getOID()) || aSN1ObjectID.equals(AlgID.dsaWithSHA.getOID()) || aSN1ObjectID.equals(AlgID.dsaWithSHA1Old.getOID())) {
            this.mapDSASignature(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dh.getOID())) {
            this.mapDHKeyAgreement(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.dhKeyAgreement.getOID())) {
            this.mapDiffieHellman(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.blowfishECB.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID())) {
            this.mapBlowfish(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
            this.mapRC2(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
            this.mapRC4(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.map3DES(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
            this.mapDES(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes128_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID()) || aSN1ObjectID.equals(AlgID.aes256_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID())) {
            this.mapAES(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.md2.getOID())) {
            this.mapMD2(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.md5.getOID())) {
            this.mapMD5(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.sha_1.getOID()) || aSN1ObjectID.equals(AlgID.sha1.getOID()) || aSN1ObjectID.equals(AlgID.sha.getOID()) || aSN1ObjectID.equals(AlgID.sha_256.getOID()) || aSN1ObjectID.equals(AlgID.sha_384.getOID()) || aSN1ObjectID.equals(AlgID.sha_512.getOID())) {
            this.mapSHA(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.hmacMD5.getOID()) || aSN1ObjectID.equals(AlgID.hmacSHA.getOID())) {
            this.mapHMAC(hashtable);
        } else if (aSN1ObjectID.equals(AlgID.PasswordBasedMac.getOID())) {
            this.mapBasedMACAlgorithms(hashtable);
        } else if (aSN1ObjectID.equals(cryptokiPrivateKey.getOID()) || aSN1ObjectID.equals(cryptokiPublicKey.getOID())) {
            this.mapCryptoki(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_subjectKeyIdentifier)) {
            this.mapX509SubjectKeyIDExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_keyUsage)) {
            this.mapX509KeyUsageExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_subjectAltName)) {
            this.mapX509SubjectAltNameExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_issuerAltName)) {
            this.mapX509IssuerAltNameExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_basicConstraints)) {
            this.mapX509BasicConstraintsExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_cRLNumber)) {
            this.mapX509CRLNumberExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_cRLReason)) {
            this.mapX509CRLReasonExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_holdInstructionCode)) {
            this.mapX509CRLHoldInstructionExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_invalidityDate)) {
            this.mapX509CRLInvalidityDateExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_deltaCRLIndicator)) {
            this.mapX509DeltaCRLIndicatorExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_issuingDistributionPoint)) {
            this.mapX509IssuingDistPointExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_certificateIssuer)) {
            this.mapX509CRLCertificateIssuerExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_nameConstraints)) {
            this.mapX509NameConstraintsExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_certificatePolicies)) {
            this.mapX509CertificatePoliciesExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_authorityKeyIdentifier)) {
            this.mapX509AuthorityKeyIDExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_policyConstraints)) {
            this.mapX509PolicyConstraintsExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_extKeyUsage)) {
            this.mapX509ExtKeyUsageExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_ce_cRLDistributionPoints)) {
            this.mapX509CRLDistPointExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_pe_authorityInfoAccess)) {
            this.mapX509AuthorityInfoAccessExtension(hashtable);
        } else if (aSN1ObjectID.equals(PKIX.id_netscape_ce_type)) {
            this.mapX509NetscapeCertTypeExtension(hashtable);
        }
    }

    private void mapRSACipher(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", RSAPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", RSAPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", RSApkcs1.class);
            }
            if (!hashtable.containsKey("useCipher")) {
                hashtable.put("useCipher", RSApkcs1.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("useSignature")) {
                hashtable.put("useSignature", RSAMDSignature.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("keyPairGenerator")) {
                hashtable.put("keyPairGenerator", RSAKeyPairGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapRSASignature(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("signature")) {
                hashtable.put("signature", RSAMDSignature.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapDSACipher(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", DSAPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", DSAPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("useSignature")) {
                hashtable.put("useSignature", DSA.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("keyPairGenerator")) {
                hashtable.put("keyPairGenerator", DSAKeyPairGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapDSASignature(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("signature")) {
                hashtable.put("signature", DSA.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapDHKeyAgreement(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", DHPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", DHPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("useKeyAgreement")) {
                hashtable.put("useKeyAgreement", DHKeyAgreement.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("keyPairGenerator")) {
                hashtable.put("keyPairGenerator", DHKeyPairGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("keyAgreement")) {
                hashtable.put("keyAgreement", DHKeyAgreement.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapDiffieHellman(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", DiffieHellman.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapSymmetricKeyGenerator(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("symmetricKeyGenerator")) {
                hashtable.put("symmetricKeyGenerator", SymmetricKeyGenerator.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapBlowfish(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", Blowfish.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapRC2(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", RC2.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapRC4(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", Arcfour.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void map3DES(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", DES_EDE.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapDES(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", DES.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapAES(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", AES.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mapSymmetricKeyGenerator(hashtable);
    }

    private void mapMD2(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", MD2.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapMD5(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", MD5.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapSHA(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", SHA.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapHMAC(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", HMAC.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapBasedMACAlgorithms(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("messageDigest")) {
                hashtable.put("messageDigest", PasswordBasedMAC.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapCryptoki(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("privateKey")) {
                hashtable.put("privateKey", CkiPrivateKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("publicKey")) {
                hashtable.put("publicKey", CkiPublicKey.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("useSignature")) {
                hashtable.put("useSignature", CkiSignature.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("useCipher")) {
                hashtable.put("useCipher", CkiRSApkcs1.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (!hashtable.containsKey("cipher")) {
                hashtable.put("cipher", CkiRSApkcs1.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509SubjectKeyIDExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", SubjectKeyIDExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509KeyUsageExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", KeyUsageExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509SubjectAltNameExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", SubjectAltNameExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509IssuerAltNameExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", IssuerAltNameExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509BasicConstraintsExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", BasicConstraintsExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CRLNumberExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CRLNumberExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CRLReasonExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CRLReasonExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CRLHoldInstructionExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CRLHoldInstructionExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CRLInvalidityDateExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CRLInvalidityDateExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509DeltaCRLIndicatorExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", DeltaCRLIndicatorExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509IssuingDistPointExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", IssuingDistPointExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CRLCertificateIssuerExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CRLCertificateIssuerExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509NameConstraintsExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", NameConstraintsExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CertificatePoliciesExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CertificatePoliciesExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509AuthorityKeyIDExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", AuthorityKeyIDExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509PolicyConstraintsExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", PolicyConstraintsExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509ExtKeyUsageExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", ExtKeyUsageExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509CRLDistPointExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", CRLDistPointExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509AuthorityInfoAccessExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", AuthorityInfoAccessExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void mapX509NetscapeCertTypeExtension(Hashtable hashtable) {
        try {
            if (!hashtable.containsKey("extension")) {
                hashtable.put("extension", NetscapeCertTypeExtension.class);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class OIDManagerInputStream
    extends FilterInputStream {
        private boolean comment;
        private boolean atEOF;

        public OIDManagerInputStream(InputStream inputStream) {
            super(inputStream);
            this.comment = false;
            this.atEOF = false;
        }

        @Override
        public int read() throws IOException {
            int n;
            if (this.atEOF || (n = this.in.read()) == -1) {
                return -1;
            }
            if (this.comment) {
                if (n == 13 || n == 10) {
                    this.comment = false;
                }
            } else if (n == 35 || n == 33) {
                this.comment = true;
            } else if (n == 38) {
                this.atEOF = true;
            }
            return this.atEOF ? -1 : n;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3;
            int n4 = -1;
            for (n3 = 0; n3 < n2 && (n4 = this.read()) != -1; ++n3) {
                byArray[n + n3] = (byte)n4;
            }
            return n3 == 0 && n4 == -1 ? -1 : n3;
        }
    }
}

