/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.utils;

import com.phaos.utils.UnsyncHashtable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;

public class HttpUtils {
    private static UnsyncHashtable _headerMap = new UnsyncHashtable();

    public static String readCanonicalLine(InputStream inputStream) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(128);
        boolean bl = true;
        do {
            n = inputStream.read();
            switch (n) {
                case -1: 
                case 10: {
                    bl = false;
                    break;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        } while (bl);
        int n2 = stringBuffer.length();
        if (n == -1 && n2 == 0) {
            return null;
        }
        if (n2 > 0 && stringBuffer.charAt(n2 - 1) == '\r') {
            stringBuffer.setLength(n2 - 1);
        }
        return stringBuffer.toString();
    }

    public static String toTitleCase(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.toLowerCase());
        stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
        int n = string.length();
        for (int i = 1; i < n; ++i) {
            if (stringBuffer.charAt(i - 1) != '-') continue;
            stringBuffer.setCharAt(i, Character.toUpperCase(stringBuffer.charAt(i)));
        }
        return stringBuffer.toString();
    }

    public static void parseHeaderStream(InputStream inputStream, Hashtable hashtable, Vector vector) throws IOException {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        while ((string = HttpUtils.readCanonicalLine(inputStream)) != null) {
            int n = -1;
            if (string.length() == 0) {
                if (string2 == null || string3 == null) break;
                string4 = (String)hashtable.get(string2);
                if (string4 != null && !HttpUtils.requiresSingleValue(string2)) {
                    string3 = string4 + ", " + string3;
                } else if (vector != null) {
                    if (string4 != null) {
                        vector.removeElement(string2);
                    }
                    vector.addElement(string2);
                }
                hashtable.put(string2, string3);
                break;
            }
            if (string.charAt(0) == ' ' || string.charAt(0) == '\t') {
                string3 = string3 + "\r\n " + string.trim();
                continue;
            }
            n = string.indexOf(":");
            if (n == -1) continue;
            if (string2 != null && string3 != null) {
                string4 = (String)hashtable.get(string2);
                if (string4 != null && !HttpUtils.requiresSingleValue(string2)) {
                    string3 = string4 + ", " + string3;
                } else if (vector != null) {
                    if (string4 != null) {
                        vector.removeElement(string2);
                    }
                    vector.addElement(string2);
                }
                hashtable.put(string2, string3);
            }
            string2 = HttpUtils.toTitleCase(string.substring(0, n++));
            string3 = string.substring(n).trim();
        }
    }

    public static boolean requiresSingleValue(String string) {
        Boolean bl = (Boolean)_headerMap.get(string);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    static {
        _headerMap.put("Accept", Boolean.FALSE);
        _headerMap.put("Accept-Charset", Boolean.FALSE);
        _headerMap.put("Accept-Encoding", Boolean.FALSE);
        _headerMap.put("Accept-Language", Boolean.FALSE);
        _headerMap.put("Accept-Ranges", Boolean.FALSE);
        _headerMap.put("Age", Boolean.TRUE);
        _headerMap.put("Allow", Boolean.FALSE);
        _headerMap.put("Authorization", Boolean.TRUE);
        _headerMap.put("Cache-Control", Boolean.FALSE);
        _headerMap.put("Connection", Boolean.FALSE);
        _headerMap.put("Content-Encoding", Boolean.FALSE);
        _headerMap.put("Content-Language", Boolean.FALSE);
        _headerMap.put("Content-Length", Boolean.TRUE);
        _headerMap.put("Content-Location", Boolean.TRUE);
        _headerMap.put("Content-Md5", Boolean.TRUE);
        _headerMap.put("Content-Range", Boolean.TRUE);
        _headerMap.put("Content-Type", Boolean.TRUE);
        _headerMap.put("Date", Boolean.TRUE);
        _headerMap.put("Etag", Boolean.TRUE);
        _headerMap.put("Expect", Boolean.FALSE);
        _headerMap.put("Expires", Boolean.TRUE);
        _headerMap.put("From", Boolean.TRUE);
        _headerMap.put("Host", Boolean.TRUE);
        _headerMap.put("If-Match", Boolean.FALSE);
        _headerMap.put("If-Modified-Since", Boolean.TRUE);
        _headerMap.put("If-None-Match", Boolean.FALSE);
        _headerMap.put("If-Range", Boolean.TRUE);
        _headerMap.put("If-Unmodified-Since", Boolean.TRUE);
        _headerMap.put("Last-Modified", Boolean.TRUE);
        _headerMap.put("Location", Boolean.TRUE);
        _headerMap.put("Max-Forwards", Boolean.TRUE);
        _headerMap.put("Pragma", Boolean.FALSE);
        _headerMap.put("Proxy-Authenticate", Boolean.FALSE);
        _headerMap.put("Proxy-Authorization", Boolean.TRUE);
        _headerMap.put("Range", Boolean.TRUE);
        _headerMap.put("Referer", Boolean.TRUE);
        _headerMap.put("Retry-After", Boolean.TRUE);
        _headerMap.put("Server", Boolean.FALSE);
        _headerMap.put("Te", Boolean.FALSE);
        _headerMap.put("Trailer", Boolean.FALSE);
        _headerMap.put("Transfer-Encoding", Boolean.FALSE);
        _headerMap.put("Upgrade", Boolean.FALSE);
        _headerMap.put("User-Agent", Boolean.FALSE);
        _headerMap.put("Vary", Boolean.FALSE);
        _headerMap.put("Via", Boolean.FALSE);
        _headerMap.put("Warning", Boolean.FALSE);
        _headerMap.put("WWW-Authenticate", Boolean.FALSE);
    }
}

