/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.DESKey;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.OIDManager;

public class SymmetricKeyGenerator {
    protected static final int BLOWFISH_DEFAULT_LENGTH = 114;
    protected static final int DES_DEFAULT_LENGTH = 8;
    protected static final int DES_EDE3_DEFAULT_LENGTH = 24;
    protected static final int ARCFOUR_DEFAULT_LENGTH = 16;
    protected static final int RC2_DEFAULT_LENGTH = 16;
    protected AlgorithmIdentifier algID;
    private int length;

    public static SymmetricKeyGenerator getInstance(AlgorithmIdentifier algorithmIdentifier) throws IllegalArgumentException {
        SymmetricKeyGenerator symmetricKeyGenerator;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "symmetricKeyGenerator");
        if (clazz == null) {
            throw new IllegalArgumentException("Can not find a symmetric key generator for this algorithm ID.");
        }
        try {
            symmetricKeyGenerator = (SymmetricKeyGenerator)clazz.newInstance();
            symmetricKeyGenerator.setAlgID(algorithmIdentifier);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Unable to access " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException.toString());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IllegalArgumentException(algorithmIdentifierException.toString());
        }
        return symmetricKeyGenerator;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        ASN1ObjectID aSN1ObjectID = algorithmIdentifier.getOID();
        if (aSN1ObjectID.equals(AlgID.RC2_CBC.getOID())) {
            int n = 0;
            if (algorithmIdentifier instanceof RC2AlgorithmIdentifier) {
                n = ((RC2AlgorithmIdentifier)algorithmIdentifier).getEffectiveKeyLength() / 8;
            }
            this.length = n > 0 ? n : 16;
        } else if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID())) {
            this.length = 8;
        } else if (aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            this.length = 24;
        } else if (aSN1ObjectID.equals(AlgID.blowfishECB.getOID()) || aSN1ObjectID.equals(AlgID.blowfishCBC.getOID())) {
            this.length = 114;
        } else if (aSN1ObjectID.equals(AlgID.RC4.getOID())) {
            this.length = 16;
        } else if (aSN1ObjectID.equals(AlgID.aes128_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes128_CBC.getOID())) {
            this.length = 16;
        } else if (aSN1ObjectID.equals(AlgID.aes192_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes192_CBC.getOID())) {
            this.length = 24;
        } else if (aSN1ObjectID.equals(AlgID.aes256_ECB.getOID()) || aSN1ObjectID.equals(AlgID.aes256_CBC.getOID())) {
            this.length = 32;
        } else {
            throw new AlgorithmIdentifierException("unknown symmetric key algorithm");
        }
        this.algID = algorithmIdentifier;
    }

    public AlgorithmIdentifier getAlgID() {
        return this.algID;
    }

    public SymmetricKey generateKey(RandomBitsSource randomBitsSource, int n) {
        byte[] byArray = new byte[n];
        ASN1ObjectID aSN1ObjectID = this.algID.getOID();
        if (aSN1ObjectID.equals(AlgID.desCBC.getOID()) || aSN1ObjectID.equals(AlgID.desECB.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_CBC.getOID()) || aSN1ObjectID.equals(AlgID.DES_EDE3_ECB.getOID())) {
            DESKey dESKey;
            do {
                randomBitsSource.randomBytes(byArray);
                dESKey = new DESKey(byArray, this.algID);
                dESKey.setParity(1);
            } while (dESKey.isWeak() || dESKey.isSemiWeak() || dESKey.isPossiblyWeak());
            return dESKey;
        }
        randomBitsSource.randomBytes(byArray);
        return new SymmetricKey(byArray, this.algID);
    }

    public SymmetricKey generateKey(RandomBitsSource randomBitsSource) {
        return this.generateKey(randomBitsSource, this.length);
    }

    public SymmetricKey generateKey(int n) {
        return this.generateKey(RandomBitsSource.getDefault(), n);
    }

    public SymmetricKey generateKey() {
        return this.generateKey(RandomBitsSource.getDefault());
    }

    static byte[] genKey(RandomBitsSource randomBitsSource, int n) {
        byte[] byArray = new byte[n];
        randomBitsSource.randomBytes(byArray);
        return byArray;
    }
}

