/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.Key;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.Utils;
import java.io.IOException;

public class SymmetricKey
implements Key {
    private AlgorithmIdentifier algID;
    byte[] keyBytes;
    private String algorithm;

    public SymmetricKey(byte[] byArray, String string) {
        this.setBytes(byArray);
        this.algorithm = string;
    }

    public SymmetricKey(byte[] byArray, AlgorithmIdentifier algorithmIdentifier) {
        this.setBytes(byArray);
        this.algID = algorithmIdentifier;
    }

    public SymmetricKey(byte[] byArray) {
        this(byArray, (AlgorithmIdentifier)null);
    }

    public SymmetricKey() {
        this(new byte[0]);
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public AlgorithmIdentifier getAlgID() {
        return this.algID;
    }

    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.algID = algorithmIdentifier;
    }

    public int keySize() {
        return this.keyBytes.length;
    }

    public void setBytes(byte[] byArray) {
        this.keyBytes = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.keyBytes, 0, byArray.length);
    }

    public byte[] getBytes() {
        return this.keyBytes;
    }

    @Override
    public byte[] getEncoded() {
        return this.getBytes();
    }

    @Override
    public int getBitLength() {
        if (this.keyBytes == null) {
            return 0;
        }
        return 8 * this.keyBytes.length;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof SymmetricKey)) {
            return false;
        }
        return Utils.areEqual(((SymmetricKey)object).getBytes(), this.getBytes());
    }

    @Override
    public void erase() {
        Utils.setArray(this.keyBytes, (byte)0);
    }

    public void finalize() {
        this.erase();
    }

    public String toString() {
        return Utils.toHexString(this.getBytes());
    }

    @Override
    public Object clone() {
        SymmetricKey symmetricKey = new SymmetricKey();
        try {
            if (this.algID != null) {
                symmetricKey.algID = new AlgorithmIdentifier(Utils.toStream(this.algID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        if (this.keyBytes != null) {
            symmetricKey.keyBytes = (byte[])this.keyBytes.clone();
        }
        if (this.algorithm != null) {
            symmetricKey.algorithm = new String(this.algorithm);
        }
        return symmetricKey;
    }
}

