/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.OIDManager;

public abstract class Signature {
    protected byte[] signatureBytes;
    protected byte[] document;

    protected Signature() {
    }

    public abstract void setAlgID(AlgorithmIdentifier var1) throws AlgorithmIdentifierException;

    public abstract AlgorithmIdentifier getAlgID();

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        throw new IllegalStateException("Method not valid for " + this.getClass().getName());
    }

    public static Signature getInstance(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        Signature signature;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "signature");
        if (clazz == null) {
            throw new AlgorithmIdentifierException("No class found for " + algorithmIdentifier.getOID());
        }
        try {
            signature = (Signature)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AlgorithmIdentifierException("Class does not implement Signature.");
        }
        signature.setAlgID(algorithmIdentifier);
        return signature;
    }

    public static Signature getInstance(PrivateKey privateKey) throws SignatureException {
        Signature signature;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(privateKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new SignatureException("Cannot find a signature algorithm for this key with " + privateKey.getAlgID().getOID());
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPrivateKey(privateKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SignatureException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new SignatureException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return signature;
    }

    public static Signature getInstance(PublicKey publicKey) throws AuthenticationException {
        Signature signature;
        OIDManager oIDManager = OIDManager.getOIDManager();
        Class clazz = oIDManager.getMapping(publicKey.getAlgID().getOID(), "useSignature");
        if (clazz == null) {
            throw new AuthenticationException("Can not find a signature algorithm for this key with " + publicKey.getAlgID().getOID());
        }
        try {
            signature = (Signature)clazz.newInstance();
            signature.setPublicKey(publicKey);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new AuthenticationException("Unable to instantiate " + clazz + ":" + instantiationException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new AuthenticationException(classCastException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new AuthenticationException(invalidKeyException.toString());
        }
        return signature;
    }

    public abstract void setPublicKey(PublicKey var1) throws InvalidKeyException;

    public abstract void setPrivateKey(PrivateKey var1) throws InvalidKeyException;

    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
    }

    public abstract byte[] sign() throws SignatureException;

    public abstract boolean verify() throws AuthenticationException;

    public void setDocument(byte[] byArray) {
        this.setHash(null);
        this.document = byArray;
    }

    public byte[] getDocument() {
        return this.document;
    }

    public byte[] getBytes() {
        return this.getSigBytes();
    }

    public void setBytes(byte[] byArray) {
        this.setSigBytes(byArray);
    }

    public byte[] getSigBytes() {
        return (byte[])this.signatureBytes.clone();
    }

    public void setSigBytes(byte[] byArray) {
        this.signatureBytes = byArray;
    }

    public abstract void setHash(byte[] var1);

    public abstract String algName();
}

