/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.EntropySource;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.SecureRandom;

public class SREntropySource
extends EntropySource {
    private Method method;
    private Object target;

    public SREntropySource() {
        this(new SecureRandom());
    }

    public SREntropySource(SecureRandom secureRandom) {
        try {
            Class<?> clazz = secureRandom.getClass();
            Class[] classArray = new Class[]{Integer.TYPE};
            Method method = null;
            try {
                method = clazz.getMethod("generateSeed", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (method != null) {
                this.method = method;
                this.target = secureRandom;
            } else {
                this.method = clazz.getMethod("getSeed", classArray);
                this.target = null;
            }
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems locating a method: " + exception.getMessage());
        }
    }

    @Override
    public byte generateByte() {
        try {
            Object object = this.method.invoke(this.target, new Integer(1));
            return Array.getByte(object, 0);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems invoking the method: " + this.method + ": " + exception.getMessage());
        }
    }

    @Override
    public void clear() {
    }

    @Override
    public synchronized byte[] generateBytes(byte[] byArray) {
        try {
            Object object = this.method.invoke(this.target, new Integer(byArray.length));
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = Array.getByte(object, i);
            }
            return byArray;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Problems invoking the method: " + this.method + ": " + exception.getMessage());
        }
    }
}

