/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;

public final class SHA
extends MessageDigest {
    private static final int SHA1 = 0;
    private static final int SHA256 = 1;
    private static final int SHA384 = 2;
    private static final int SHA512 = 3;
    private static final int[] blockSize = new int[]{64, 64, 128, 128};
    private static final int[] blockSizeBits = new int[]{512, 512, 1024, 1024};
    private static final int[] wordSize = new int[]{4, 4, 8, 8};
    private static final int[] wordSizeBits = new int[]{32, 32, 64, 64};
    private static final int[] messageDigestSize = new int[]{20, 32, 48, 64};
    private static final int[] messageScheduleSize = new int[]{80, 64, 80, 80};
    private static final int[] lengthSizeInt = new int[]{2, 2, 4, 4};
    private static final int[] lengthSizeBits = new int[]{64, 64, 128, 128};
    private static final String[] algNames = new String[]{"SHA-1", "SHA-256", "SHA-384", "SHA-512"};
    private SHAState state;
    private SHAState oldState;
    private int[] W1_256;
    private long[] W384_512;
    private static final AlgorithmIdentifier DEFAULT_HASH = AlgID.sha_1;
    private static final int K1_0_19 = 1518500249;
    private static final int K1_20_39 = 1859775393;
    private static final int K1_40_59 = -1894007588;
    private static final int K1_60_79 = -899497514;
    private static final int[] H1_init = new int[]{1732584193, -271733879, -1732584194, 271733878, -1009589776};
    private static final int[] K256 = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private static final int[] H256_init = new int[]{1779033703, -1150833019, 1013904242, -1521486534, 1359893119, -1694144372, 528734635, 1541459225};
    private static final long[] K384_512 = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private static final long[] H384_init = new long[]{-3766243637369397544L, 7105036623409894663L, -7973340178411365097L, 1526699215303891257L, 7436329637833083697L, -8163818279084223215L, -2662702644619276377L, 5167115440072839076L};
    private static final long[] H512_init = new long[]{7640891576956012808L, -4942790177534073029L, 4354685564936845355L, -6534734903238641935L, 5840696475078001361L, -7276294671716946913L, 2270897969802886507L, 6620516959819538809L};

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        int n;
        if (algorithmIdentifier.getOID().equals(AlgID.sha_1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha1.getOID()) || algorithmIdentifier.getOID().equals(AlgID.sha.getOID())) {
            n = 0;
        } else if (algorithmIdentifier.getOID().equals(AlgID.sha_256.getOID())) {
            n = 1;
        } else if (algorithmIdentifier.getOID().equals(AlgID.sha_384.getOID())) {
            n = 2;
        } else if (algorithmIdentifier.getOID().equals(AlgID.sha_512.getOID())) {
            n = 3;
        } else {
            throw new AlgorithmIdentifierException("Algorithm unknown: " + algorithmIdentifier);
        }
        this.state = new SHAState(n);
        this.oldState = new SHAState(n);
        this.digestBits = new byte[messageDigestSize[this.state.sha]];
        switch (this.state.sha) {
            case 0: 
            case 1: {
                this.W1_256 = new int[messageScheduleSize[this.state.sha]];
                break;
            }
            case 2: 
            case 3: {
                this.W384_512 = new long[messageScheduleSize[this.state.sha]];
            }
        }
        this.algID = algorithmIdentifier;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return this.algID;
    }

    @Override
    public String algName() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return algNames[this.state.sha];
    }

    @Override
    public int blockSize() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return blockSize[this.state.sha];
    }

    @Override
    public int getDigestLength() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return messageDigestSize[this.state.sha];
    }

    @Override
    public void init() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        this.state.init();
        this.digestValid = false;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        int n3;
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        for (int i = 0; i < n2; i += n3) {
            n3 = Math.min(n2 - i, this.state.buffer.length - this.state.pos);
            System.arraycopy(byArray, n, this.state.buffer, this.state.pos, n3);
            n += n3;
            this.state.pos += n3;
            if (this.state.pos != this.state.buffer.length) continue;
            this.processBlock();
        }
        this.state.addLength(n2);
        this.digestValid = false;
    }

    @Override
    public void update(byte by) {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        this.state.buffer[this.state.pos++] = by;
        if (this.state.pos == this.state.buffer.length) {
            this.processBlock();
        }
        this.state.addLength(1);
        this.digestValid = false;
    }

    @Override
    public void computeCurrent() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        this.state.copyTo(this.oldState);
        this.computeMessage();
        this.computeDigest();
        this.digestValid = true;
        SHAState sHAState = this.state;
        this.state = this.oldState;
        this.oldState = sHAState;
    }

    @Override
    public Object clone() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        SHA sHA = new SHA();
        try {
            sHA.setAlgID(this.getAlgID());
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            // empty catch block
        }
        this.state.copyTo(sHA.state);
        System.arraycopy(this.digestBits, 0, sHA.digestBits, 0, this.digestBits.length);
        sHA.digestValid = this.digestValid;
        return sHA;
    }

    private void computeMessage() {
        int n;
        for (n = blockSizeBits[this.state.sha] - lengthSizeBits[this.state.sha] - this.state.pos * 8 - 1; n < 0; n += blockSizeBits[this.state.sha]) {
        }
        this.state.buffer[this.state.pos++] = -128;
        int n2 = 7;
        if (n + 1 > blockSizeBits[this.state.sha] - lengthSizeBits[this.state.sha]) {
            Utils.setArray(this.state.buffer, this.state.pos, blockSize[this.state.sha] - this.state.pos, (byte)0);
            n2 += (blockSize[this.state.sha] - this.state.pos) * 8;
            this.state.pos = blockSize[this.state.sha];
            this.processBlock();
        }
        int n3 = (n - n2) / 8;
        Utils.setArray(this.state.buffer, this.state.pos, n3, (byte)0);
        this.state.pos += n3;
        for (int i = 0; i < this.state.len.length; ++i) {
            Utils.wordsToBytes(this.state.len, i, this.state.buffer, this.state.pos, 1);
            this.state.pos += 4;
        }
        this.processBlock();
    }

    private void processBlock() {
        switch (this.state.sha) {
            case 0: {
                this.processBlock1();
                break;
            }
            case 1: {
                this.processBlock256();
                break;
            }
            case 2: 
            case 3: {
                this.processBlock384_512();
            }
        }
    }

    private void processBlock1() {
        int n;
        int n2;
        int n3;
        Utils.bytesToWords(this.state.buffer, 0, this.W1_256, 0, 16);
        int n4 = messageScheduleSize[this.state.sha];
        for (n3 = blockSize[this.state.sha] / wordSize[this.state.sha]; n3 < n4; ++n3) {
            this.W1_256[n3] = this.ROTL(1, this.W1_256[n3 - 3] ^ this.W1_256[n3 - 8] ^ this.W1_256[n3 - 14] ^ this.W1_256[n3 - 16]);
        }
        n3 = this.state.H1_256[0];
        n4 = this.state.H1_256[1];
        int n5 = this.state.H1_256[2];
        int n6 = this.state.H1_256[3];
        int n7 = this.state.H1_256[4];
        for (n2 = 0; n2 < 20; ++n2) {
            n = this.ROTL(5, n3) + SHA.SHA1_ft1(n4, n5, n6) + n7 + 1518500249 + this.W1_256[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.ROTL(30, n4);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 20; n2 < 40; ++n2) {
            n = this.ROTL(5, n3) + SHA.SHA1_ft2(n4, n5, n6) + n7 + 1859775393 + this.W1_256[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.ROTL(30, n4);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 40; n2 < 60; ++n2) {
            n = this.ROTL(5, n3) + SHA.SHA1_ft3(n4, n5, n6) + n7 + -1894007588 + this.W1_256[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.ROTL(30, n4);
            n4 = n3;
            n3 = n;
        }
        for (n2 = 60; n2 < 80; ++n2) {
            n = this.ROTL(5, n3) + SHA.SHA1_ft4(n4, n5, n6) + n7 + -899497514 + this.W1_256[n2];
            n7 = n6;
            n6 = n5;
            n5 = this.ROTL(30, n4);
            n4 = n3;
            n3 = n;
        }
        this.state.H1_256[0] = this.state.H1_256[0] + n3;
        this.state.H1_256[1] = this.state.H1_256[1] + n4;
        this.state.H1_256[2] = this.state.H1_256[2] + n5;
        this.state.H1_256[3] = this.state.H1_256[3] + n6;
        this.state.H1_256[4] = this.state.H1_256[4] + n7;
        this.state.pos = 0;
    }

    private void processBlock256() {
        int n;
        Utils.bytesToWords(this.state.buffer, 0, this.W1_256, 0, 16);
        int n2 = messageScheduleSize[this.state.sha];
        for (n = blockSize[this.state.sha] / wordSize[this.state.sha]; n < n2; ++n) {
            this.W1_256[n] = this.SHA256_sigma1(this.W1_256[n - 2]) + this.W1_256[n - 7] + this.SHA256_sigma0(this.W1_256[n - 15]) + this.W1_256[n - 16];
        }
        n = this.state.H1_256[0];
        n2 = this.state.H1_256[1];
        int n3 = this.state.H1_256[2];
        int n4 = this.state.H1_256[3];
        int n5 = this.state.H1_256[4];
        int n6 = this.state.H1_256[5];
        int n7 = this.state.H1_256[6];
        int n8 = this.state.H1_256[7];
        int n9 = messageScheduleSize[this.state.sha];
        for (int i = 0; i < n9; ++i) {
            int n10 = n8 + this.SHA256_SIGMA1(n5) + SHA.SHA256_Ch(n5, n6, n7) + K256[i] + this.W1_256[i];
            int n11 = this.SHA256_SIGMA0(n) + SHA.SHA256_Maj(n, n2, n3);
            n8 = n7;
            n7 = n6;
            n6 = n5;
            n5 = n4 + n10;
            n4 = n3;
            n3 = n2;
            n2 = n;
            n = n10 + n11;
        }
        this.state.H1_256[0] = this.state.H1_256[0] + n;
        this.state.H1_256[1] = this.state.H1_256[1] + n2;
        this.state.H1_256[2] = this.state.H1_256[2] + n3;
        this.state.H1_256[3] = this.state.H1_256[3] + n4;
        this.state.H1_256[4] = this.state.H1_256[4] + n5;
        this.state.H1_256[5] = this.state.H1_256[5] + n6;
        this.state.H1_256[6] = this.state.H1_256[6] + n7;
        this.state.H1_256[7] = this.state.H1_256[7] + n8;
        this.state.pos = 0;
    }

    private void processBlock384_512() {
        Utils.bytesToLongs(this.state.buffer, 0, this.W384_512, 0, 16);
        int n = messageScheduleSize[this.state.sha];
        for (int i = blockSize[this.state.sha] / wordSize[this.state.sha]; i < n; ++i) {
            this.W384_512[i] = this.SHA384_512_sigma1(this.W384_512[i - 2]) + this.W384_512[i - 7] + this.SHA384_512_sigma0(this.W384_512[i - 15]) + this.W384_512[i - 16];
        }
        long l = this.state.H384_512[0];
        long l2 = this.state.H384_512[1];
        long l3 = this.state.H384_512[2];
        long l4 = this.state.H384_512[3];
        long l5 = this.state.H384_512[4];
        long l6 = this.state.H384_512[5];
        long l7 = this.state.H384_512[6];
        long l8 = this.state.H384_512[7];
        int n2 = messageScheduleSize[this.state.sha];
        for (int i = 0; i < n2; ++i) {
            long l9 = l8 + this.SHA384_512_SIGMA1(l5) + SHA.SHA384_512_Ch(l5, l6, l7) + K384_512[i] + this.W384_512[i];
            long l10 = this.SHA384_512_SIGMA0(l) + SHA.SHA384_512_Maj(l, l2, l3);
            l8 = l7;
            l7 = l6;
            l6 = l5;
            l5 = l4 + l9;
            l4 = l3;
            l3 = l2;
            l2 = l;
            l = l9 + l10;
        }
        this.state.H384_512[0] = this.state.H384_512[0] + l;
        this.state.H384_512[1] = this.state.H384_512[1] + l2;
        this.state.H384_512[2] = this.state.H384_512[2] + l3;
        this.state.H384_512[3] = this.state.H384_512[3] + l4;
        this.state.H384_512[4] = this.state.H384_512[4] + l5;
        this.state.H384_512[5] = this.state.H384_512[5] + l6;
        this.state.H384_512[6] = this.state.H384_512[6] + l7;
        this.state.H384_512[7] = this.state.H384_512[7] + l8;
        this.state.pos = 0;
    }

    private void computeDigest() {
        switch (this.state.sha) {
            case 0: 
            case 1: {
                Utils.wordsToBytes(this.state.H1_256, this.digestBits);
                break;
            }
            case 2: {
                Utils.longsToBytes(this.state.H384_512, 0, this.digestBits, 0, messageDigestSize[this.state.sha] / wordSize[this.state.sha]);
                break;
            }
            case 3: {
                Utils.longsToBytes(this.state.H384_512, 0, this.digestBits, 0, messageDigestSize[this.state.sha] / wordSize[this.state.sha]);
            }
        }
    }

    private int SHR(int n, int n2) {
        return n2 >>> n;
    }

    private int ROTL(int n, int n2) {
        return n2 << n | n2 >>> wordSizeBits[this.state.sha] - n;
    }

    private int ROTR(int n, int n2) {
        return n2 >>> n | n2 << wordSizeBits[this.state.sha] - n;
    }

    private long longSHR(long l, long l2) {
        return l2 >>> (int)l;
    }

    private long longROTL(long l, long l2) {
        return l2 << (int)l | l2 >>> (int)((long)wordSizeBits[this.state.sha] - l);
    }

    private long longROTR(long l, long l2) {
        return l2 >>> (int)l | l2 << (int)((long)wordSizeBits[this.state.sha] - l);
    }

    private static int SHA1_ft1(int n, int n2, int n3) {
        return n & n2 | ~n & n3;
    }

    private static int SHA1_ft2(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private static int SHA1_ft3(int n, int n2, int n3) {
        return n & n2 | n & n3 | n2 & n3;
    }

    private static int SHA1_ft4(int n, int n2, int n3) {
        return n ^ n2 ^ n3;
    }

    private int SHA256_SIGMA0(int n) {
        return this.ROTR(2, n) ^ this.ROTR(13, n) ^ this.ROTR(22, n);
    }

    private int SHA256_SIGMA1(int n) {
        return this.ROTR(6, n) ^ this.ROTR(11, n) ^ this.ROTR(25, n);
    }

    private int SHA256_sigma0(int n) {
        return this.ROTR(7, n) ^ this.ROTR(18, n) ^ this.SHR(3, n);
    }

    private int SHA256_sigma1(int n) {
        return this.ROTR(17, n) ^ this.ROTR(19, n) ^ this.SHR(10, n);
    }

    private static int SHA256_Ch(int n, int n2, int n3) {
        return n & n2 ^ ~n & n3;
    }

    private static int SHA256_Maj(int n, int n2, int n3) {
        return n & n2 ^ n & n3 ^ n2 & n3;
    }

    private long SHA384_512_SIGMA0(long l) {
        return this.longROTR(28L, l) ^ this.longROTR(34L, l) ^ this.longROTR(39L, l);
    }

    private long SHA384_512_SIGMA1(long l) {
        return this.longROTR(14L, l) ^ this.longROTR(18L, l) ^ this.longROTR(41L, l);
    }

    private long SHA384_512_sigma0(long l) {
        return this.longROTR(1L, l) ^ this.longROTR(8L, l) ^ this.longSHR(7L, l);
    }

    private long SHA384_512_sigma1(long l) {
        return this.longROTR(19L, l) ^ this.longROTR(61L, l) ^ this.longSHR(6L, l);
    }

    private static long SHA384_512_Ch(long l, long l2, long l3) {
        return l & l2 ^ (l ^ 0xFFFFFFFFFFFFFFFFL) & l3;
    }

    private static long SHA384_512_Maj(long l, long l2, long l3) {
        return l & l2 ^ l & l3 ^ l2 & l3;
    }

    @Override
    protected MessageDigest.MDState getState() {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        return this.state;
    }

    @Override
    protected void setState(MessageDigest.MDState mDState) {
        if (this.algID == null) {
            try {
                this.setAlgID(DEFAULT_HASH);
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                // empty catch block
            }
        }
        mDState.copyTo(this.state);
        this.digestValid = false;
    }

    final class SHAState
    extends MessageDigest.MDState {
        int[] H1_256;
        long[] H384_512;
        byte[] buffer;
        int[] len;
        int pos;
        int sha;

        SHAState() {
            super(SHA.this);
        }

        SHAState(int n) {
            super(SHA.this);
            this.sha = n;
            this.buffer = new byte[blockSize[n]];
            this.len = new int[lengthSizeInt[n]];
            switch (n) {
                case 0: {
                    this.H1_256 = (int[])H1_init.clone();
                    break;
                }
                case 1: {
                    this.H1_256 = (int[])H256_init.clone();
                    break;
                }
                case 2: {
                    this.H384_512 = (long[])H384_init.clone();
                    break;
                }
                case 3: {
                    this.H384_512 = (long[])H512_init.clone();
                }
            }
        }

        @Override
        public void init() {
            switch (this.sha) {
                case 0: {
                    System.arraycopy(H1_init, 0, this.H1_256, 0, this.H1_256.length);
                    break;
                }
                case 1: {
                    System.arraycopy(H256_init, 0, this.H1_256, 0, this.H1_256.length);
                    break;
                }
                case 2: {
                    System.arraycopy(H384_init, 0, this.H384_512, 0, this.H384_512.length);
                    break;
                }
                case 3: {
                    System.arraycopy(H512_init, 0, this.H384_512, 0, this.H384_512.length);
                }
            }
            for (int i = 0; i < this.len.length; ++i) {
                this.len[i] = 0;
            }
            this.pos = 0;
        }

        public void addLength(int n) {
            switch (this.sha) {
                case 0: 
                case 1: {
                    int n2 = this.len[1];
                    this.len[1] = n2 + (n << 3);
                    if (this.len[1] < n2) {
                        this.len[0] = this.len[0] + 1;
                    }
                    this.len[0] = this.len[0] + (n >>> 29);
                    break;
                }
                case 2: 
                case 3: {
                    int n3 = this.len[3];
                    this.len[3] = n3 + (n << 3);
                    int n4 = this.len[3] < n3 ? n >>> 30 : n >>> 29;
                    n3 = this.len[2];
                    this.len[2] = this.len[2] + (n3 + n4);
                    n4 = this.len[2] < n3 ? 1 : 0;
                    n3 = this.len[1];
                    this.len[1] = this.len[1] + (n3 + n4);
                    n4 = this.len[1] < n3 ? 1 : 0;
                    this.len[0] = this.len[0] + n4;
                    break;
                }
            }
        }

        @Override
        public Object clone() {
            SHAState sHAState = new SHAState();
            this.copyTo(sHAState);
            return sHAState;
        }

        @Override
        public void copyTo(MessageDigest.MDState mDState) {
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("SHAState required");
            }
            SHAState sHAState = (SHAState)mDState;
            sHAState.pos = this.pos;
            switch (this.sha) {
                case 0: 
                case 1: {
                    sHAState.H1_256 = (int[])this.H1_256.clone();
                    break;
                }
                case 2: 
                case 3: {
                    sHAState.H384_512 = (long[])this.H384_512.clone();
                }
            }
            sHAState.buffer = (byte[])this.buffer.clone();
            sHAState.len = (int[])this.len.clone();
            sHAState.sha = this.sha;
        }
    }
}

