/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.EntropySource;
import com.phaos.crypto.MD5RandomBitsSource;
import java.math.BigInteger;

public abstract class RandomBitsSource {
    private static RandomBitsSource defaultRBS = null;
    private static final Object obj = new Object();

    protected RandomBitsSource() {
    }

    public abstract void seed(byte[] var1);

    public abstract void seed(EntropySource var1);

    public void seed() {
        this.seed(EntropySource.getDefault());
    }

    public abstract byte randomByte();

    public byte[] randomBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = this.randomByte();
        }
        return byArray;
    }

    public BigInteger randomBigInteger(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length " + n);
        }
        byte[] byArray = new byte[n % 8 == 0 ? n / 8 : n / 8 + 1];
        this.randomBytes(byArray);
        if (n % 8 != 0) {
            byArray[0] = (byte)(byArray[0] & (1 << n % 8) - 1);
        }
        return new BigInteger(1, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomBitsSource getDefault() {
        Object object = obj;
        synchronized (object) {
            if (defaultRBS == null) {
                defaultRBS = new MD5RandomBitsSource(true);
            }
        }
        return defaultRBS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(RandomBitsSource randomBitsSource) {
        Object object = obj;
        synchronized (object) {
            defaultRBS = randomBitsSource;
        }
    }

    public abstract void clear();
}

