/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PrivateKeyPKCS8;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.Streamable;
import com.phaos.utils.UnsyncByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RSAPrivateKeyPKCS8
extends RSAPrivateKey
implements Streamable {
    private PrivateKeyPKCS8 pkcs8;

    public RSAPrivateKeyPKCS8() {
        this.pkcs8 = new PrivateKeyPKCS8();
        this.pkcs8.setMode(0);
    }

    public RSAPrivateKeyPKCS8(byte[] byArray, File file) throws FileNotFoundException, IOException {
        this(new String(byArray), file);
    }

    public RSAPrivateKeyPKCS8(String string, File file) throws FileNotFoundException, IOException {
        this.pkcs8 = new PrivateKeyPKCS8(string, file);
        super.input(new UnsyncByteArrayInputStream(this.pkcs8.getKey().getEncoded()));
    }

    public RSAPrivateKeyPKCS8(RSAPrivateKey rSAPrivateKey, RandomBitsSource randomBitsSource) throws IOException {
        this.pkcs8 = new PrivateKeyPKCS8((PrivateKey)rSAPrivateKey, 0, randomBitsSource);
        super.input(new UnsyncByteArrayInputStream(rSAPrivateKey.getEncoded()));
    }

    public void setPassword(byte[] byArray) {
        this.setPassword(new String(byArray));
    }

    public void setPassword(String string) {
        this.pkcs8.setPassword(string);
    }

    public RSAPrivateKey getKey() {
        return this;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.pkcs8.input(inputStream);
        super.input(new UnsyncByteArrayInputStream(this.pkcs8.getKey().getEncoded()));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.pkcs8.output(outputStream);
    }

    @Override
    public int length() {
        return this.pkcs8.length();
    }
}

