/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RSAKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import com.phaos.utils.VersionException;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.math.BigInteger;

public class RSAPrivateKey
extends RSAKey
implements PrivateKey,
Externalizable {
    private AlgorithmIdentifier algID = null;
    private ASN1Sequence keyContents = null;
    private BigInteger publicExponent;
    private BigInteger prime1;
    private BigInteger prime2;
    private BigInteger exponent1;
    private BigInteger exponent2;
    private BigInteger coefficient;
    private ASN1Sequence pki = null;

    public RSAPrivateKey() {
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2) {
        super(bigInteger, bigInteger2);
    }

    public RSAPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        super(bigInteger, bigInteger2);
        this.publicExponent = bigInteger3;
        this.prime1 = bigInteger4;
        this.prime2 = bigInteger5;
        this.exponent1 = bigInteger6;
        this.exponent2 = bigInteger7;
        this.coefficient = bigInteger8;
        this.getContents();
        this.checkPandQ();
    }

    public RSAPrivateKey(File file) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        this.input(fileInputStream);
    }

    public RSAPrivateKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public RSAPrivateKey(byte[] byArray) throws IOException {
        this.input(new UnsyncByteArrayInputStream(byArray));
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws AlgorithmIdentifierException, InvalidInputException {
        ASN1Object aSN1Object2 = algorithmIdentifier.getParameters();
        if (aSN1Object2 != null && !(aSN1Object2 instanceof ASN1Null)) {
            throw new AlgorithmIdentifierException();
        }
        this.initialize(aSN1Object);
        this.algID = algorithmIdentifier;
    }

    private void initialize(ASN1Object aSN1Object) throws InvalidInputException {
        ASN1Sequence aSN1Sequence;
        try {
            aSN1Sequence = (ASN1Sequence)aSN1Object;
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
            if (!aSN1Integer.equals(0)) {
                throw new VersionException(aSN1Integer.getValue(), 0);
            }
            this.modulus = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue();
            this.publicExponent = ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue();
            this.exponent = ((ASN1Integer)aSN1Sequence.elementAt(3)).getValue();
            this.prime1 = ((ASN1Integer)aSN1Sequence.elementAt(4)).getValue();
            this.prime2 = ((ASN1Integer)aSN1Sequence.elementAt(5)).getValue();
            this.exponent1 = ((ASN1Integer)aSN1Sequence.elementAt(6)).getValue();
            this.exponent2 = ((ASN1Integer)aSN1Sequence.elementAt(7)).getValue();
            this.coefficient = ((ASN1Integer)aSN1Sequence.elementAt(8)).getValue();
        }
        catch (VersionException versionException) {
            throw new InvalidInputException(versionException.toString());
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException.toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new InvalidInputException(arrayIndexOutOfBoundsException.toString());
        }
        this.keyContents = aSN1Sequence;
        this.algID = null;
        this.clearOutputCache();
        this.checkPandQ();
    }

    private void checkPandQ() {
        if (this.prime1.compareTo(this.prime2) < 0) {
            BigInteger bigInteger = this.prime1;
            this.prime1 = this.prime2;
            this.prime2 = bigInteger;
            bigInteger = this.exponent1;
            this.exponent1 = this.exponent2;
            this.exponent2 = bigInteger;
            this.coefficient = this.prime2.modInverse(this.prime1);
        }
    }

    @Override
    public void setModulusExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        super.setModulusExponent(bigInteger, bigInteger2);
        this.keyContents = null;
        this.clearOutputCache();
    }

    @Override
    public boolean isPublic() {
        return false;
    }

    public RSAPublicKey getPublicKey() {
        return new RSAPublicKey(this.modulus, this.publicExponent);
    }

    public BigInteger getPublicExponent() {
        return this.publicExponent;
    }

    public BigInteger getPrimeP() {
        return this.prime1;
    }

    public BigInteger getPrimeQ() {
        return this.prime2;
    }

    public BigInteger getPrimeExponentP() {
        return this.exponent1;
    }

    public BigInteger getPrimeExponentQ() {
        return this.exponent2;
    }

    public BigInteger getCrtCoefficient() {
        return this.coefficient;
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    @Override
    public ASN1Object getContents() {
        if (this.keyContents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            try {
                aSN1Sequence.addElement(new ASN1Integer(0L));
                aSN1Sequence.addElement(new ASN1Integer(this.modulus));
                aSN1Sequence.addElement(new ASN1Integer(this.publicExponent));
                aSN1Sequence.addElement(new ASN1Integer(this.exponent));
                aSN1Sequence.addElement(new ASN1Integer(this.prime1));
                aSN1Sequence.addElement(new ASN1Integer(this.prime2));
                aSN1Sequence.addElement(new ASN1Integer(this.exponent1));
                aSN1Sequence.addElement(new ASN1Integer(this.exponent2));
                aSN1Sequence.addElement(new ASN1Integer(this.coefficient));
            }
            catch (NullPointerException nullPointerException) {
                throw new IllegalStateException("CRT representation required for ASN.1 output");
            }
            this.keyContents = aSN1Sequence;
        }
        return this.keyContents;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        if (this.algID == null) {
            this.algID = AlgID.rsaEncryption;
        }
        return this.algID;
    }

    @Override
    public void erase() {
        super.erase();
        this.keyContents = null;
        this.publicExponent = null;
        this.prime1 = null;
        this.prime2 = null;
        this.exponent1 = null;
        this.exponent2 = null;
        this.coefficient = null;
    }

    public void finalize() {
        this.erase();
    }

    @Override
    public Object clone() {
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey();
        try {
            if (this.algID != null) {
                rSAPrivateKey.algID = new AlgorithmIdentifier(Utils.toStream(this.algID));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing algorithm identifier to stream");
        }
        try {
            if (this.keyContents != null) {
                rSAPrivateKey.keyContents = new ASN1Sequence(Utils.toStream(this.keyContents));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing key contents to stream");
        }
        try {
            if (this.pki != null) {
                rSAPrivateKey.pki = new ASN1Sequence(Utils.toStream(this.pki));
            }
        }
        catch (IOException iOException) {
            throw new StreamableOutputException("Error writing private key info to stream");
        }
        if (this.publicExponent != null) {
            rSAPrivateKey.publicExponent = new BigInteger(this.publicExponent.toByteArray());
        }
        if (this.prime1 != null) {
            rSAPrivateKey.prime1 = new BigInteger(this.prime1.toByteArray());
        }
        if (this.prime2 != null) {
            rSAPrivateKey.prime2 = new BigInteger(this.prime2.toByteArray());
        }
        if (this.exponent1 != null) {
            rSAPrivateKey.exponent1 = new BigInteger(this.exponent1.toByteArray());
        }
        if (this.exponent2 != null) {
            rSAPrivateKey.exponent2 = new BigInteger(this.exponent2.toByteArray());
        }
        if (this.coefficient != null) {
            rSAPrivateKey.coefficient = new BigInteger(this.coefficient.toByteArray());
        }
        if (this.modulus != null) {
            rSAPrivateKey.modulus = new BigInteger(this.modulus.toByteArray());
        }
        if (this.exponent != null) {
            rSAPrivateKey.exponent = new BigInteger(this.exponent.toByteArray());
        }
        return rSAPrivateKey;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        block6: {
            try {
                ASN1Sequence aSN1Sequence = new ASN1Sequence(inputStream);
                if (aSN1Sequence.size() == 3 || aSN1Sequence.size() == 4) {
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.elementAt(0);
                    if (!aSN1Integer.equals(0)) {
                        throw new VersionException(aSN1Integer.getValue(), 0);
                    }
                    AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier((ASN1Sequence)aSN1Sequence.elementAt(1));
                    ASN1Object aSN1Object = ASN1Utils.inputASN1Object(((ASN1OctetString)aSN1Sequence.elementAt(2)).getValue());
                    this.initialize(algorithmIdentifier, aSN1Object);
                    break block6;
                }
                if (aSN1Sequence.size() == 9) {
                    this.initialize(aSN1Sequence);
                    break block6;
                }
                throw new ASN1FormatException("Sequence has wrong number of components.");
            }
            catch (AlgorithmIdentifierException algorithmIdentifierException) {
                throw new InvalidInputException(algorithmIdentifierException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new InvalidInputException(classCastException.toString());
            }
        }
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.toASN1Sequence().output(outputStream);
    }

    @Override
    public int length() {
        return this.toASN1Sequence().length();
    }

    private void clearOutputCache() {
        this.pki = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.pki == null) {
            this.pki = CryptoUtils.privateKeyInfo(this);
        }
        return this.pki;
    }

    public String toString() {
        return "{ modulus = " + this.modulus + ", " + "exponent = " + this.exponent + " }";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

