/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.AuthenticationException;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.DigestInfo;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.PublicKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.Signature;
import com.phaos.crypto.SignatureException;
import com.phaos.utils.Utils;

public final class RSAMDSignature
extends Signature {
    public static final ASN1ObjectID rsaKeyOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 1);
    public static final ASN1ObjectID rsaMD2SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 2);
    public static final ASN1ObjectID rsaMD5SigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 4);
    public static final ASN1ObjectID rsaSHASigOID = new ASN1ObjectID(ASN1Utils.pkcsID, 1, 5);
    public static final ASN1ObjectID rsaSHASigOldOID = new ASN1ObjectID(ASN1Utils.oiwAlgID, 29);
    private RSAPublicKey publicKey;
    private RSAPrivateKey privateKey;
    private AlgorithmIdentifier messageDigestAlgID;
    private static AlgorithmIdentifier defaultAlgID = AlgID.md5;
    private RandomBitsSource rbs;
    private byte[] hash = null;

    public RSAMDSignature() {
        this.messageDigestAlgID = defaultAlgID;
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey) {
        this.publicKey = rSAPublicKey;
        this.privateKey = rSAPrivateKey;
        this.setMessageDigestAlgID(defaultAlgID);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this.publicKey = rSAPublicKey;
        this.privateKey = rSAPrivateKey;
        this.setMessageDigestAlgID(defaultAlgID);
        this.setDocument(byArray);
        this.sign();
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey) {
        this(rSAPublicKey, defaultAlgID);
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, ASN1ObjectID aSN1ObjectID) {
        this(rSAPublicKey, new AlgorithmIdentifier(aSN1ObjectID));
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, AlgorithmIdentifier algorithmIdentifier) {
        this.publicKey = rSAPublicKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey) {
        this(rSAPrivateKey, defaultAlgID);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier) {
        this.privateKey = rSAPrivateKey;
        this.setMessageDigestAlgID(algorithmIdentifier);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, defaultAlgID, byArray);
    }

    public RSAMDSignature(RSAPrivateKey rSAPrivateKey, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) throws SignatureException {
        this(rSAPrivateKey, algorithmIdentifier);
        this.setDocument(byArray);
        this.sign();
    }

    public RSAMDSignature(RSAPublicKey rSAPublicKey, byte[] byArray, byte[] byArray2) {
        this(rSAPublicKey);
        this.setSigBytes(byArray);
        this.setDocument(byArray2);
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (algorithmIdentifier.equals(AlgID.md2WithRSAEncryption)) {
            this.messageDigestAlgID = AlgID.md2;
        } else if (algorithmIdentifier.equals(AlgID.md5WithRSAEncryption)) {
            this.messageDigestAlgID = AlgID.md5;
        } else if (algorithmIdentifier.equals(AlgID.sha_1WithRSAEncryption)) {
            this.messageDigestAlgID = AlgID.sha_1;
        } else {
            throw new AlgorithmIdentifierException("Invalid AlgorithmIdentifier for RSAMDSignature");
        }
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        if (this.messageDigestAlgID.equals(AlgID.md2)) {
            return AlgID.md2WithRSAEncryption;
        }
        if (this.messageDigestAlgID.equals(AlgID.md5)) {
            return AlgID.md5WithRSAEncryption;
        }
        if (this.messageDigestAlgID.equals(AlgID.sha_1)) {
            return AlgID.sha_1WithRSAEncryption;
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    @Override
    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return AlgID.rsaEncryption;
    }

    public void setMessageDigestAlgID(AlgorithmIdentifier algorithmIdentifier) {
        this.messageDigestAlgID = algorithmIdentifier;
    }

    public AlgorithmIdentifier getMessageDigestAlgID() {
        return this.messageDigestAlgID;
    }

    @Override
    public String algName() {
        if (this.messageDigestAlgID.equals(AlgID.md2)) {
            return "RSA/MD2";
        }
        if (this.messageDigestAlgID.equals(AlgID.md5)) {
            return "RSA/MD5";
        }
        if (this.messageDigestAlgID.equals(AlgID.sha_1)) {
            return "RSA/SHA";
        }
        throw new IllegalStateException("No appropriate algorithm identifier.");
    }

    public ASN1ObjectID algorithmOID() {
        return this.getAlgID().getOID();
    }

    @Override
    public void setPublicKey(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof RSAPublicKey)) {
            throw new InvalidKeyException();
        }
        this.publicKey = (RSAPublicKey)publicKey;
    }

    @Override
    public void setPrivateKey(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof RSAPrivateKey)) {
            throw new InvalidKeyException();
        }
        this.privateKey = (RSAPrivateKey)privateKey;
    }

    @Override
    public void setHash(byte[] byArray) {
        this.hash = byArray;
        this.document = null;
    }

    @Override
    public void setRandomBitsSource(RandomBitsSource randomBitsSource) {
        this.rbs = randomBitsSource;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean verify() throws AuthenticationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public byte[] sign() throws SignatureException {
        try {
            Object object;
            byte[] byArray = null;
            if (this.hash != null) {
                byArray = this.hash;
            } else {
                object = MessageDigest.getInstance(this.messageDigestAlgID);
                ((MessageDigest)object).computeDigest(this.getDocument());
                byArray = Utils.toBytes(new DigestInfo(((MessageDigest)object).getAlgID(), ((MessageDigest)object).digestBits));
            }
            object = Cipher.getInstance(AlgID.rsaEncryption, this.privateKey);
            ((Cipher)object).setRandomBitsSource(this.rbs);
            this.setSigBytes(((Cipher)object).encrypt(byArray));
            ((Cipher)object).erase();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new SignatureException(algorithmIdentifierException.toString());
        }
        catch (CipherException cipherException) {
            throw new SignatureException(cipherException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.toString());
        }
        return this.getSigBytes();
    }
}

