/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.KeyPair;
import com.phaos.crypto.KeyPairGenerator;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.math.Prime;
import java.math.BigInteger;

public class RSAKeyPairGenerator
extends KeyPairGenerator {
    private int bits;

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        if (!algorithmIdentifier.getOID().equals(AlgID.rsaEncryption.getOID())) {
            throw new AlgorithmIdentifierException("Unknown RSA key algorithm identifier");
        }
    }

    @Override
    public void initialize(int n, RandomBitsSource randomBitsSource) {
        this.bits = n;
        this.setRandomBitsSource(randomBitsSource);
    }

    @Override
    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6 = BigInteger.valueOf(1L);
        BigInteger bigInteger7 = BigInteger.valueOf(65537L);
        if (this.rbs == null) {
            this.rbs = RandomBitsSource.getDefault();
        }
        while (true) {
            if ((bigInteger5 = Prime.generatePrime(this.bits / 2, this.rbs)).compareTo(bigInteger4 = Prime.generatePrime(this.bits - bigInteger5.bitLength(), this.rbs)) == 0) {
                continue;
            }
            bigInteger3 = bigInteger5.multiply(bigInteger4);
            bigInteger2 = bigInteger5.subtract(bigInteger6).multiply(bigInteger4.subtract(bigInteger6));
            if (bigInteger3.bitLength() >= this.bits && bigInteger3.gcd(bigInteger2).compareTo(bigInteger6) == 0 && bigInteger2.remainder(bigInteger7).signum() != 0) break;
        }
        if (bigInteger5.compareTo(bigInteger4) < 0) {
            bigInteger = bigInteger5;
            bigInteger5 = bigInteger4;
            bigInteger4 = bigInteger;
        }
        BigInteger bigInteger8 = bigInteger7.modInverse(bigInteger2);
        bigInteger = bigInteger8.remainder(bigInteger5.subtract(bigInteger6));
        BigInteger bigInteger9 = bigInteger8.remainder(bigInteger4.subtract(bigInteger6));
        BigInteger bigInteger10 = bigInteger4.modInverse(bigInteger5);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger3, bigInteger7);
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(bigInteger3, bigInteger8, bigInteger7, bigInteger5, bigInteger4, bigInteger, bigInteger9, bigInteger10);
        return new KeyPair(rSAPublicKey, rSAPrivateKey);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }
}

