/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.Key;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public abstract class RSAKey
implements Key,
ASN1Object {
    BigInteger modulus;
    BigInteger exponent;

    protected RSAKey() {
    }

    protected RSAKey(byte[] byArray) throws IOException {
        this.setBytes(byArray);
    }

    protected RSAKey(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    protected RSAKey(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toBytes(aSN1Sequence));
    }

    protected RSAKey(BigInteger bigInteger, BigInteger bigInteger2) {
        this.setModulusExponent(bigInteger, bigInteger2);
    }

    @Override
    public String getAlgorithm() {
        return "RSA";
    }

    public void setBytes(byte[] byArray) throws IOException {
        if (byArray.length != 0) {
            this.input(new UnsyncByteArrayInputStream(byArray));
        }
    }

    public int modulusLength() {
        return Utils.length(this.modulus);
    }

    public BigInteger getModulus() {
        return this.modulus;
    }

    public BigInteger getExponent() {
        return this.exponent;
    }

    public void setModulusExponent(BigInteger bigInteger, BigInteger bigInteger2) {
        this.modulus = bigInteger;
        this.exponent = bigInteger2;
    }

    @Override
    public byte[] getEncoded() {
        return Utils.toBytes(this);
    }

    @Override
    public int getBitLength() {
        if (this.modulus == null) {
            return 0;
        }
        return this.modulus.bitLength();
    }

    public abstract boolean isPublic();

    @Override
    public abstract Object clone();

    @Override
    public void erase() {
        this.exponent = null;
        this.modulus = null;
    }
}

