/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.RSAKey;
import com.phaos.crypto.RSAPrivateKey;
import com.phaos.crypto.RSAPublicKey;
import java.math.BigInteger;

public final class RSA {
    private RSAKey key;

    public void setKey(RSAKey rSAKey) {
        this.key = rSAKey;
    }

    public BigInteger performOp(BigInteger bigInteger) {
        if (this.key instanceof RSAPublicKey) {
            return bigInteger.modPow(this.key.getExponent(), this.key.getModulus());
        }
        if (this.key instanceof RSAPrivateKey) {
            BigInteger bigInteger2;
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)this.key;
            BigInteger bigInteger3 = rSAPrivateKey.getModulus();
            BigInteger bigInteger4 = rSAPrivateKey.getPrimeP();
            BigInteger bigInteger5 = rSAPrivateKey.getPrimeQ();
            BigInteger bigInteger6 = rSAPrivateKey.getPrimeExponentP();
            BigInteger bigInteger7 = rSAPrivateKey.getPrimeExponentQ();
            BigInteger bigInteger8 = rSAPrivateKey.getCrtCoefficient();
            if (bigInteger4 == null || bigInteger5 == null || bigInteger6 == null || bigInteger7 == null || bigInteger8 == null) {
                return bigInteger.modPow(rSAPrivateKey.getExponent(), bigInteger3);
            }
            BigInteger bigInteger9 = bigInteger.mod(bigInteger4).modPow(bigInteger6, bigInteger4);
            BigInteger bigInteger10 = bigInteger9.subtract(bigInteger2 = bigInteger.mod(bigInteger5).modPow(bigInteger7, bigInteger5));
            if (bigInteger10.signum() == -1) {
                bigInteger10 = bigInteger10.add(bigInteger4);
            }
            bigInteger10 = (bigInteger10 = bigInteger10.multiply(bigInteger8)).signum() >= 0 ? bigInteger10.mod(bigInteger4) : bigInteger4.subtract(bigInteger10.negate().mod(bigInteger4));
            if ((bigInteger10 = bigInteger10.multiply(bigInteger5).add(bigInteger2)).compareTo(bigInteger3) >= 0) {
                bigInteger10 = bigInteger10.subtract(bigInteger3);
            }
            return bigInteger10;
        }
        throw new IllegalStateException("Unknown key class");
    }
}

