/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.BlockCipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.Key;
import com.phaos.crypto.Padding;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;

public final class RC2
extends BlockCipher {
    private static final int BLOCK_SIZE = 8;
    private static final byte[] sBox = new byte[]{-39, 120, -7, -60, 25, -35, -75, -19, 40, -23, -3, 121, 74, -96, -40, -99, -58, 126, 55, -125, 43, 118, 83, -114, 98, 76, 100, -120, 68, -117, -5, -94, 23, -102, 89, -11, -121, -77, 79, 19, 97, 69, 109, -115, 9, -127, 125, 50, -67, -113, 64, -21, -122, -73, 123, 11, -16, -107, 33, 34, 92, 107, 78, -126, 84, -42, 101, -109, -50, 96, -78, 28, 115, 86, -64, 20, -89, -116, -15, -36, 18, 117, -54, 31, 59, -66, -28, -47, 66, 61, -44, 48, -93, 60, -74, 38, 111, -65, 14, -38, 70, 105, 7, 87, 39, -14, 29, -101, -68, -108, 67, 3, -8, 17, -57, -10, -112, -17, 62, -25, 6, -61, -43, 47, -56, 102, 30, -41, 8, -24, -22, -34, -128, 82, -18, -9, -124, -86, 114, -84, 53, 77, 106, 42, -106, 26, -46, 113, 90, 21, 73, 116, 75, -97, -48, 94, 4, 24, -92, -20, -62, -32, 65, 110, 15, 81, -53, -52, 36, -111, -81, 80, -95, -12, 112, 57, -103, 124, 58, -123, 35, -72, -76, 122, -4, 2, 54, 91, 37, 85, -105, 49, 45, 93, -6, -104, -29, -118, -110, -82, 5, -33, 41, 16, 103, 108, -70, -55, -45, 0, -26, -49, -31, -98, -88, 44, 99, 22, 1, 63, 88, -30, -119, -87, 13, 56, 52, 27, -85, 51, -1, -80, -69, 72, 12, 95, -71, -79, -51, 46, -59, -13, -37, 71, -27, -91, -100, 119, 10, -90, 32, 104, -2, 127, -63, -83};
    private int effectiveKeyLength;
    private boolean effectiveKeyLength_specified = false;
    private short[] expKey;

    public RC2() {
        super(8);
        this.mode = 1;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, Key key) throws AlgorithmIdentifierException, InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("The key is not an instance of SymmetricKey");
        }
        if (key == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        this.init(algorithmIdentifier);
        super.setKey((SymmetricKey)key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        this.paddingID = Padding.NONE;
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, SymmetricKey symmetricKey, Padding.ID iD) throws AlgorithmIdentifierException, InvalidKeyException, CipherException {
        if (symmetricKey == null) {
            throw new InvalidKeyException("Key cannot be null");
        }
        if (iD == null) {
            throw new CipherException("The paddingID parameter cannot be null");
        }
        this.init(algorithmIdentifier);
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.rbs = null;
        this.paddingID = iD;
    }

    private void init(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.effectiveKeyLength_specified = false;
        this.effectiveKeyLength = 0;
        if (algorithmIdentifier.getOID().equals(AlgID.RC2_CBC.getOID())) {
            byte[] byArray = null;
            RC2AlgorithmIdentifier rC2AlgorithmIdentifier = null;
            rC2AlgorithmIdentifier = !(algorithmIdentifier instanceof RC2AlgorithmIdentifier) ? new RC2AlgorithmIdentifier(algorithmIdentifier.getOID(), algorithmIdentifier.getParameters()) : (RC2AlgorithmIdentifier)algorithmIdentifier;
            byArray = rC2AlgorithmIdentifier.getIV();
            int n = rC2AlgorithmIdentifier.getEffectiveKeyLength();
            if (n > 0) {
                this.setEffectiveKeyLength(n);
            } else if (this.key != null) {
                try {
                    this.setKeyMaterial((SymmetricKey)this.key);
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new AlgorithmIdentifierException(invalidKeyException.getMessage());
                }
            }
            if (byArray == null) {
                byArray = new byte[this.blockSize];
                this.getRBS().randomBytes(byArray);
            }
            try {
                this.setIV(byArray);
            }
            catch (CipherException cipherException) {
                throw new AlgorithmIdentifierException(cipherException.toString());
            }
        }
        throw new AlgorithmIdentifierException("Unknown AlgorithmIdentifier " + algorithmIdentifier + " for RC2");
        this.paddingID = Padding.PKCS5;
    }

    private void setKeyMaterial(SymmetricKey symmetricKey) throws InvalidKeyException {
        int n;
        int n2 = Math.min(symmetricKey.getBytes().length, 128);
        if (n2 < 1) {
            throw new InvalidKeyException("Invalid RC2 key.");
        }
        if (!this.effectiveKeyLength_specified) {
            this.effectiveKeyLength = n2 * 8;
        }
        int n3 = (this.effectiveKeyLength + 7) / 8;
        int n4 = 255 >> 8 * n3 - this.effectiveKeyLength;
        byte[] byArray = new byte[128];
        System.arraycopy(symmetricKey.getBytes(), 0, byArray, 0, n2);
        for (n = n2; n < 128; ++n) {
            byArray[n] = sBox[byArray[n - 1] + byArray[n - n2] & 0xFF];
        }
        byArray[128 - n3] = sBox[byArray[128 - n3] & n4 & 0xFF];
        for (n = 127 - n3; n >= 0; --n) {
            byArray[n] = sBox[(byArray[n + 1] ^ byArray[n + n3]) & 0xFF];
        }
        this.expKey = new short[64];
        for (n = 0; n < 128; n += 2) {
            this.expKey[n / 2] = (short)(byArray[n + 1] << 8 | byArray[n] & 0xFF);
        }
    }

    @Override
    protected void decryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        short s = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s2 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s3 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s4 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        int n3 = 63;
        while (n3 >= 0) {
            if (n3 == 19 | n3 == 43) {
                s4 = (short)(s4 - this.expKey[s3 & 0x3F]);
                s3 = (short)(s3 - this.expKey[s2 & 0x3F]);
                s2 = (short)(s2 - this.expKey[s & 0x3F]);
                s = (short)(s - this.expKey[s4 & 0x3F]);
            }
            s4 = (short)(Utils.rotrShort(s4, 5) - (s & ~s3) - (s2 & s3) - this.expKey[n3--]);
            s3 = (short)(Utils.rotrShort(s3, 3) - (s4 & ~s2) - (s & s2) - this.expKey[n3--]);
            s2 = (short)(Utils.rotrShort(s2, 2) - (s3 & ~s) - (s4 & s) - this.expKey[n3--]);
            s = (short)(Utils.rotrShort(s, 1) - (s2 & ~s4) - (s3 & s4) - this.expKey[n3--]);
        }
        byArray2[n2++] = (byte)s;
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s2;
        byArray2[n2++] = (byte)(s2 >>> 8);
        byArray2[n2++] = (byte)s3;
        byArray2[n2++] = (byte)(s3 >>> 8);
        byArray2[n2++] = (byte)s4;
        byArray2[n2++] = (byte)(s4 >>> 8);
    }

    @Override
    protected void encryptBlock(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        short s = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s2 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s3 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s4 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        int n3 = 0;
        while (n3 < 64) {
            s = Utils.rotlShort(s + (s2 & ~s4) + (s3 & s4) + this.expKey[n3++], 1);
            s2 = Utils.rotlShort(s2 + (s3 & ~s) + (s4 & s) + this.expKey[n3++], 2);
            s3 = Utils.rotlShort(s3 + (s4 & ~s2) + (s & s2) + this.expKey[n3++], 3);
            s4 = Utils.rotlShort(s4 + (s & ~s3) + (s2 & s3) + this.expKey[n3++], 5);
            if (!(n3 == 20 | n3 == 44)) continue;
            s = (short)(s + this.expKey[s4 & 0x3F]);
            s2 = (short)(s2 + this.expKey[s & 0x3F]);
            s3 = (short)(s3 + this.expKey[s2 & 0x3F]);
            s4 = (short)(s4 + this.expKey[s3 & 0x3F]);
        }
        byArray2[n2++] = (byte)s;
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s2;
        byArray2[n2++] = (byte)(s2 >>> 8);
        byArray2[n2++] = (byte)s3;
        byArray2[n2++] = (byte)(s3 >>> 8);
        byArray2[n2++] = (byte)s4;
        byArray2[n2++] = (byte)(s4 >>> 8);
    }

    @Override
    public String algName() {
        return "RC2";
    }

    @Override
    public void erase() {
        super.erase();
        Utils.setArray(this.expKey, (short)0);
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return new RC2AlgorithmIdentifier(this.getIV(), this.effectiveKeyLength);
    }

    public int getEffectiveKeyLength() {
        return this.effectiveKeyLength;
    }

    public String toString() {
        return "(RC2){Key=" + Utils.toHexString(((SymmetricKey)this.key).getBytes()) + ", effectiveKeyLength_specified=" + this.effectiveKeyLength_specified + ", effectiveKeyLength=" + this.effectiveKeyLength + "}";
    }

    @Override
    public void setAlgID(AlgorithmIdentifier algorithmIdentifier) throws AlgorithmIdentifierException {
        this.init(algorithmIdentifier);
    }

    @Override
    public void decryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertDecryption();
        short s = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s2 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s3 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s4 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        int n3 = 63;
        while (n3 >= 0) {
            if (n3 == 19 | n3 == 43) {
                s4 = (short)(s4 - this.expKey[s3 & 0x3F]);
                s3 = (short)(s3 - this.expKey[s2 & 0x3F]);
                s2 = (short)(s2 - this.expKey[s & 0x3F]);
                s = (short)(s - this.expKey[s4 & 0x3F]);
            }
            s4 = (short)(Utils.rotrShort(s4, 5) - (s & ~s3) - (s2 & s3) - this.expKey[n3--]);
            s3 = (short)(Utils.rotrShort(s3, 3) - (s4 & ~s2) - (s & s2) - this.expKey[n3--]);
            s2 = (short)(Utils.rotrShort(s2, 2) - (s3 & ~s) - (s4 & s) - this.expKey[n3--]);
            s = (short)(Utils.rotrShort(s, 1) - (s2 & ~s4) - (s3 & s4) - this.expKey[n3--]);
        }
        byArray2[n2++] = (byte)s;
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s2;
        byArray2[n2++] = (byte)(s2 >>> 8);
        byArray2[n2++] = (byte)s3;
        byArray2[n2++] = (byte)(s3 >>> 8);
        byArray2[n2++] = (byte)s4;
        byArray2[n2++] = (byte)(s4 >>> 8);
    }

    @Override
    public void encryptOp(byte[] byArray, int n, byte[] byArray2, int n2) throws CipherException {
        this.assertEncryption();
        short s = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s2 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s3 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        short s4 = (short)(byArray[n++] & 0xFF | byArray[n++] << 8);
        int n3 = 0;
        while (n3 < 64) {
            s = Utils.rotlShort(s + (s2 & ~s4) + (s3 & s4) + this.expKey[n3++], 1);
            s2 = Utils.rotlShort(s2 + (s3 & ~s) + (s4 & s) + this.expKey[n3++], 2);
            s3 = Utils.rotlShort(s3 + (s4 & ~s2) + (s & s2) + this.expKey[n3++], 3);
            s4 = Utils.rotlShort(s4 + (s & ~s3) + (s2 & s3) + this.expKey[n3++], 5);
            if (!(n3 == 20 | n3 == 44)) continue;
            s = (short)(s + this.expKey[s4 & 0x3F]);
            s2 = (short)(s2 + this.expKey[s & 0x3F]);
            s3 = (short)(s3 + this.expKey[s2 & 0x3F]);
            s4 = (short)(s4 + this.expKey[s3 & 0x3F]);
        }
        byArray2[n2++] = (byte)s;
        byArray2[n2++] = (byte)(s >>> 8);
        byArray2[n2++] = (byte)s2;
        byArray2[n2++] = (byte)(s2 >>> 8);
        byArray2[n2++] = (byte)s3;
        byArray2[n2++] = (byte)(s3 >>> 8);
        byArray2[n2++] = (byte)s4;
        byArray2[n2++] = (byte)(s4 >>> 8);
    }

    public void setEffectiveKeyLength(int n) {
        if (n < 0 || n > 1024) {
            throw new IllegalArgumentException("Length out of range");
        }
        this.effectiveKeyLength = n;
        this.effectiveKeyLength_specified = n != 0;
        try {
            if (this.key != null) {
                this.setKeyMaterial((SymmetricKey)this.key);
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IllegalArgumentException(invalidKeyException.getMessage());
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setKey(SymmetricKey symmetricKey) throws InvalidKeyException {
        super.setKey(symmetricKey);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setEncryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the RC2 cipher");
        }
        super.setEncryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setDecryptionKey(Key key) throws InvalidKeyException {
        if (!(key instanceof SymmetricKey)) {
            throw new InvalidKeyException("Key must be an instance of a SymmetricKey to be used with the RC2 cipher");
        }
        super.setDecryptionKey(key);
        this.setKeyMaterial((SymmetricKey)this.key);
        this.releaseOp();
        this.resetLastCipherBlock();
    }

    @Override
    public void setMode(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode for this Cipher");
        }
        if (n != 1) {
            throw new IllegalArgumentException("The value, " + n + ", is not recognized " + "as a valid block mode");
        }
        this.releaseOp();
        this.resetLastCipherBlock();
    }
}

