/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1SequenceInputStream;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.PKCS5;
import com.phaos.crypto.PrivateKey;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.utils.CryptoUtils;
import com.phaos.utils.InvalidInputException;
import com.phaos.utils.OIDManager;
import com.phaos.utils.StreamableOutputException;
import com.phaos.utils.UnsyncByteArrayInputStream;
import com.phaos.utils.Utils;
import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;

public class PrivateKeyPKCS8
implements ASN1Object,
PrivateKey,
Externalizable {
    private PKCS5 pkcs5;
    private byte[] encKey;
    private PrivateKey key;
    private ASN1Sequence contents;
    private RandomBitsSource rbs;

    public PrivateKeyPKCS8() {
        this.pkcs5 = new PKCS5();
    }

    public PrivateKeyPKCS8(int n, RandomBitsSource randomBitsSource) {
        this.pkcs5 = new PKCS5(n, randomBitsSource);
        this.rbs = randomBitsSource;
    }

    public PrivateKeyPKCS8(int n) {
        this(n, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        this(privateKey, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey) {
        this(privateKey, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n, RandomBitsSource randomBitsSource) {
        this(n, randomBitsSource);
        this.key = privateKey;
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, int n) {
        this(privateKey, n, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey, RandomBitsSource randomBitsSource) {
        this(privateKey, string, 3, randomBitsSource);
    }

    public PrivateKeyPKCS8(String string, PrivateKey privateKey) {
        this(string, privateKey, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n, RandomBitsSource randomBitsSource) {
        this(privateKey, n, randomBitsSource);
        this.setPassword(string);
    }

    public PrivateKeyPKCS8(PrivateKey privateKey, String string, int n) {
        this(privateKey, string, n, RandomBitsSource.getDefault());
    }

    public PrivateKeyPKCS8(String string, InputStream inputStream) throws IOException {
        this.pkcs5 = new PKCS5();
        this.pkcs5.setPassword(string);
        this.input(inputStream);
    }

    public PrivateKeyPKCS8(InputStream inputStream) throws IOException {
        this.pkcs5 = new PKCS5();
        this.input(inputStream);
    }

    public PrivateKeyPKCS8(ASN1Sequence aSN1Sequence) throws IOException {
        this(Utils.toStream(aSN1Sequence));
    }

    public PrivateKeyPKCS8(String string, File file) throws IOException, FileNotFoundException {
        this(string, new FileInputStream(file));
    }

    public PrivateKeyPKCS8(String string, ASN1Sequence aSN1Sequence) throws IOException {
        this(string, Utils.toStream(aSN1Sequence));
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        ASN1SequenceInputStream aSN1SequenceInputStream = new ASN1SequenceInputStream(inputStream);
        this.pkcs5.inputAlgID(aSN1SequenceInputStream);
        this.encKey = ASN1OctetString.inputValue(aSN1SequenceInputStream);
        aSN1SequenceInputStream.terminate();
        this.key = null;
        this.contents = null;
        if (this.pkcs5.getPassword() != null) {
            try {
                this.getKey();
            }
            catch (IllegalStateException illegalStateException) {
                throw new InvalidInputException(illegalStateException.toString());
            }
        }
    }

    public void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.input(Utils.toStream(aSN1Sequence));
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        try {
            this.outputASN1().output(outputStream);
        }
        catch (StreamableOutputException streamableOutputException) {
            throw new IOException(streamableOutputException.toString());
        }
    }

    private ASN1Sequence outputASN1() throws StreamableOutputException {
        if (this.contents == null) {
            ASN1Sequence aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.addElement(this.pkcs5.outputAlgIDASN1());
            try {
                aSN1Sequence.addElement(new ASN1OctetString(this.getEncryptedKey()));
            }
            catch (CipherException cipherException) {
                throw new StreamableOutputException(cipherException.toString());
            }
            this.contents = aSN1Sequence;
        }
        return this.contents;
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getEncryptedKey() throws CipherException {
        if (this.encKey == null) {
            PrivateKeyPKCS8 privateKeyPKCS8 = this;
            synchronized (privateKeyPKCS8) {
                if (this.encKey == null) {
                    if (this.key == null) {
                        throw new IllegalStateException("Private key not found for encryption");
                    }
                    this.encKey = this.pkcs5.encrypt(Utils.toBytes(CryptoUtils.privateKeyInfo(this.key)));
                }
            }
        }
        return this.encKey;
    }

    public void setPassword(String string) {
        this.pkcs5.setPassword(string);
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public void setMode(int n) {
        this.pkcs5.setMode(n);
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public int getMode() {
        return this.pkcs5.getMode();
    }

    public void setCount(int n) {
        this.pkcs5.setCount(n);
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    public void setSalt(byte[] byArray) {
        this.pkcs5.setSalt(byArray);
        if (this.key != null) {
            this.encKey = null;
        }
        this.contents = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrivateKey getKey() {
        if (this.key == null) {
            PrivateKeyPKCS8 privateKeyPKCS8 = this;
            synchronized (privateKeyPKCS8) {
                if (this.key == null) {
                    try {
                        if (this.encKey == null) {
                            throw new IllegalStateException("Encrypted private key not found");
                        }
                        byte[] byArray = this.pkcs5.decrypt(this.encKey);
                        this.key = CryptoUtils.inputPrivateKey(new UnsyncByteArrayInputStream(byArray));
                    }
                    catch (CipherException cipherException) {
                        throw new IllegalStateException(cipherException.toString());
                    }
                    catch (IOException iOException) {
                        throw new IllegalStateException(iOException.toString());
                    }
                }
            }
        }
        return this.key;
    }

    public void setKey(PrivateKey privateKey) {
        this.key = privateKey;
        this.encKey = null;
    }

    public String toString() {
        return "pkcs5 = {" + this.pkcs5 + "}, key = {" + this.key + "}";
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        try {
            return this.getKey().getAlgID();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public ASN1Object getContents() {
        return this.outputASN1();
    }

    @Override
    public void initialize(AlgorithmIdentifier algorithmIdentifier, ASN1Object aSN1Object) throws InvalidInputException, AlgorithmIdentifierException {
        if (this.key == null) {
            OIDManager oIDManager = OIDManager.getOIDManager();
            Class clazz = oIDManager.getMapping(algorithmIdentifier.getOID(), "privateKey");
            if (clazz == null) {
                throw new AlgorithmIdentifierException("Unrecognized algorithm OID " + algorithmIdentifier.getOID());
            }
            try {
                PrivateKey privateKey = (PrivateKey)clazz.newInstance();
                privateKey.initialize(algorithmIdentifier, aSN1Object);
                this.key = privateKey;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + illegalAccessException.toString());
            }
            catch (InstantiationException instantiationException) {
                throw new AlgorithmIdentifierException("Unable to instantiate " + clazz + ": " + instantiationException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException("Class does not implement PrivateKey.");
            }
        } else {
            this.key.initialize(algorithmIdentifier, aSN1Object);
        }
        this.encKey = null;
        this.contents = null;
    }

    @Override
    public Object clone() {
        PrivateKeyPKCS8 privateKeyPKCS8 = new PrivateKeyPKCS8();
        if (this.key != null) {
            privateKeyPKCS8.key = (PrivateKey)this.key.clone();
        }
        if (this.encKey != null) {
            privateKeyPKCS8.encKey = (byte[])this.encKey.clone();
        }
        if (this.pkcs5 != null) {
            privateKeyPKCS8.pkcs5 = new PKCS5(this.pkcs5.getMode(), this.rbs);
            privateKeyPKCS8.pkcs5.setCount(this.pkcs5.getCount());
            if (this.pkcs5.getSalt() != null) {
                privateKeyPKCS8.pkcs5.setSalt((byte[])this.pkcs5.getSalt().clone());
            }
            privateKeyPKCS8.pkcs5.setPassword(this.pkcs5.getPassword());
        } else {
            privateKeyPKCS8.pkcs5 = null;
        }
        privateKeyPKCS8.rbs = this.rbs;
        return privateKeyPKCS8;
    }

    @Override
    public void erase() {
        if (this.key != null) {
            this.key.erase();
            this.key = null;
        }
        this.pkcs5 = null;
        this.encKey = null;
        this.contents = null;
        this.rbs = null;
    }

    @Override
    public String getAlgorithm() {
        try {
            return this.getKey().getAlgorithm();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public int getBitLength() {
        try {
            return this.getKey().getBitLength();
        }
        catch (RuntimeException runtimeException) {
            return 0;
        }
    }

    @Override
    public byte[] getEncoded() {
        return Utils.toBytes(this.outputASN1());
    }

    @Override
    public String getFormat() {
        try {
            return this.getKey().getFormat();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new InvalidInputException(classCastException);
        }
        this.input(new UnsyncByteArrayInputStream(byArray));
    }
}

