/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1FormatException;
import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.ASN1.ASN1Utils;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.crypto.CBCAlgorithmIdentifier;
import com.phaos.crypto.Cipher;
import com.phaos.crypto.CipherException;
import com.phaos.crypto.InvalidKeyException;
import com.phaos.crypto.MessageDigest;
import com.phaos.crypto.RC2AlgorithmIdentifier;
import com.phaos.crypto.RandomBitsSource;
import com.phaos.crypto.SymmetricKey;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;

public class PKCS5
implements ASN1Object,
Serializable {
    public static final int NONE = -2;
    public static final int MD2_DES = -1;
    public static final int MD5_DES = 0;
    public static final int SHA_128RC4 = 1;
    public static final int SHA_40RC4 = 2;
    public static final int SHA_3DES = 3;
    public static final int SHA_2DES = 4;
    public static final int SHA_128RC2 = 5;
    public static final int SHA_40RC2 = 6;
    public static final int DEFAULT_SALT_LEN = 8;
    public static final int DEFAULT_ITER_COUNT = 1024;
    private transient String passwd;
    private byte[] salt;
    private int count;
    private int mode;
    private transient ASN1Sequence contents;

    public PKCS5() {
        this(3);
    }

    public PKCS5(int n) {
        this((String)null, (byte[])null, 1024, n);
    }

    public PKCS5(int n, int n2, RandomBitsSource randomBitsSource) {
        this.setMode(n);
        this.setCount(n2);
        this.setSalt(this.makeSalt(randomBitsSource));
    }

    private byte[] makeSalt(RandomBitsSource randomBitsSource) {
        int n = 0;
        switch (this.mode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n = 8;
            }
        }
        return randomBitsSource.randomBytes(new byte[n]);
    }

    public PKCS5(int n, RandomBitsSource randomBitsSource) {
        this(n, 1024, randomBitsSource);
    }

    public PKCS5(RandomBitsSource randomBitsSource) {
        this(3, randomBitsSource);
    }

    public PKCS5(String string, byte[] byArray, int n, int n2) {
        this.passwd = string;
        this.salt = byArray;
        this.count = n;
        this.setMode(n2);
    }

    public PKCS5(String string, byte[] byArray, int n) {
        this(string, byArray, 1024, n);
    }

    public PKCS5(String string, int n, int n2, RandomBitsSource randomBitsSource) {
        this(n, n2, randomBitsSource);
        this.passwd = string;
    }

    public PKCS5(String string, int n, RandomBitsSource randomBitsSource) {
        this(n, randomBitsSource);
        this.passwd = string;
    }

    public PKCS5(String string, RandomBitsSource randomBitsSource) {
        this(randomBitsSource);
        this.passwd = string;
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n, int n2) {
        this.setPassword(byArray);
        this.setSalt(byArray2);
        this.setCount(n);
        this.setMode(n2);
    }

    public PKCS5(byte[] byArray, byte[] byArray2, int n) {
        this(byArray, byArray2, n, 0);
    }

    public byte[] pad(byte[] byArray, int n) throws CipherException {
        if (n < 0 || n > 255) {
            throw new CipherException("Block size has to be between 0 and 255");
        }
        byte[] byArray2 = new byte[n - byArray.length % n];
        Utils.setArray(byArray2, (byte)byArray2.length);
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public byte[] unpad(byte[] byArray) throws CipherException {
        int n = byArray[byArray.length - 1] & 0xFF;
        if (n > byArray.length) {
            throw new CipherException("Invalid padding string (or incorrect password)");
        }
        for (int i = byArray.length - n; i < byArray.length; ++i) {
            if (byArray[i] == n) continue;
            throw new CipherException("Invalid padding string (or incorrect password)");
        }
        byte[] byArray2 = new byte[byArray.length - n];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    public byte[] encrypt(byte[] byArray) throws CipherException {
        if (this.mode == -1 || this.mode == 0) {
            return this.encryptPKCS5(byArray);
        }
        return this.encryptPKCS12(byArray);
    }

    private byte[] encryptPKCS5(byte[] byArray) throws CipherException {
        byte[] byArray2;
        MessageDigest messageDigest;
        try {
            messageDigest = this.mode == 0 ? MessageDigest.getInstance(AlgID.md5) : MessageDigest.getInstance(AlgID.md2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        byte[] byArray3 = new byte[16];
        if (this.passwd == null) {
            throw new CipherException("Encryption password not set");
        }
        try {
            byArray2 = this.passwd.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = this.passwd.getBytes();
        }
        messageDigest.update(byArray2);
        if (this.salt == null) {
            this.salt = this.makeSalt(RandomBitsSource.getDefault());
        }
        messageDigest.update(this.salt);
        messageDigest.computeCurrent();
        System.arraycopy(messageDigest.digestBits, 0, byArray3, 0, byArray3.length);
        int n = this.count - 1;
        for (int i = 0; i < n; ++i) {
            messageDigest.init();
            messageDigest.update(byArray3);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.digestBits, 0, byArray3, 0, byArray3.length);
        }
        byte[] byArray4 = new byte[8];
        byte[] byArray5 = new byte[8];
        System.arraycopy(byArray3, 0, byArray4, 0, 8);
        System.arraycopy(byArray3, 8, byArray5, 0, 8);
        try {
            Cipher cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.desCBC.getOID(), new ASN1OctetString(byArray5)));
            cipher.setKey(new SymmetricKey(byArray4));
            return cipher.encrypt(byArray, true);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
    }

    private byte[] encryptPKCS12(byte[] byArray) throws CipherException {
        int n = 0;
        int n2 = 0;
        AlgorithmIdentifier algorithmIdentifier = null;
        switch (this.mode) {
            case 1: {
                n = 16;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 2: {
                n = 5;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 3: {
                n = 24;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 4: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 5: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 6: {
                n = 5;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
            }
        }
        if (this.passwd == null) {
            throw new CipherException("Encryption password not set");
        }
        if (this.salt == null) {
            this.salt = this.makeSalt(RandomBitsSource.getDefault());
        }
        byte[] byArray2 = PKCS5.pkcs12PseudoRandomBytes((byte)1, n, algorithmIdentifier, this.passwd, this.salt, this.count);
        byte[] byArray3 = null;
        if (n2 != 0) {
            byArray3 = PKCS5.pkcs12PseudoRandomBytes((byte)2, n2, algorithmIdentifier, this.passwd, this.salt, this.count);
        }
        Cipher cipher = null;
        try {
            switch (this.mode) {
                case 1: 
                case 2: {
                    cipher = Cipher.getInstance(AlgID.RC4);
                    break;
                }
                case 3: {
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)));
                    break;
                }
                case 4: {
                    byte[] byArray4 = new byte[24];
                    System.arraycopy(byArray2, 0, byArray4, 0, 16);
                    System.arraycopy(byArray2, 0, byArray4, 16, 8);
                    byArray2 = byArray4;
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)));
                    break;
                }
                case 5: 
                case 6: {
                    cipher = Cipher.getInstance(new RC2AlgorithmIdentifier(byArray3, byArray2.length * 8));
                }
            }
            cipher.setKey(new SymmetricKey(byArray2));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        return cipher.encrypt(byArray, true);
    }

    public static byte[] pkcs12PseudoRandomBytes(byte by, int n, AlgorithmIdentifier algorithmIdentifier, String string, byte[] byArray, int n2) throws CipherException {
        int n3;
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithmIdentifier);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        int n4 = messageDigest.getDigestLength();
        int n5 = 64;
        byte[] byArray2 = new byte[n4];
        if (string == null) {
            throw new CipherException("Encryption password not set");
        }
        byte[] byArray3 = Utils.unicodeToBytes(string);
        byte[] byArray4 = new byte[byArray3.length + 2];
        System.arraycopy(byArray3, 0, byArray4, 0, byArray3.length);
        byArray4[byArray4.length - 1] = 0;
        byArray4[byArray4.length - 2] = 0;
        int n6 = byArray4.length;
        int n7 = byArray.length;
        byte[] byArray5 = new byte[n5];
        Utils.setArray(byArray5, by);
        int n8 = n7 == 0 ? 0 : ((n7 - 1) / n5 + 1) * n5;
        int n9 = n6 == 0 ? 0 : ((n6 - 1) / n5 + 1) * n5;
        byte[] byArray6 = new byte[n8 + n9];
        for (n3 = 0; n3 < n8; n3 += n7) {
            System.arraycopy(byArray, 0, byArray6, n3, Math.min(n8 - n3, n7));
        }
        int n10 = byArray6.length;
        for (n3 = n8; n3 < n10; n3 += n6) {
            System.arraycopy(byArray4, 0, byArray6, n3, Math.min(byArray6.length - n3, n6));
        }
        byte[] byArray7 = new byte[n];
        for (n10 = 0; n10 < n; n10 += n4) {
            messageDigest.init();
            messageDigest.update(byArray5);
            messageDigest.update(byArray6);
            messageDigest.computeCurrent();
            System.arraycopy(messageDigest.digestBits, 0, byArray2, 0, n4);
            int n11 = n2 - 1;
            for (int i = 0; i < n11; ++i) {
                messageDigest.init();
                messageDigest.update(byArray2);
                messageDigest.computeCurrent();
                System.arraycopy(messageDigest.digestBits, 0, byArray2, 0, n4);
            }
            byte[] byArray8 = new byte[n5];
            for (n11 = 0; n11 < n5; n11 += n4) {
                System.arraycopy(messageDigest.digestBits, 0, byArray8, n11, Math.min(n5 - n11, n4));
            }
            BigInteger bigInteger = BigInteger.valueOf(1L);
            BigInteger bigInteger2 = new BigInteger(1, byArray8).add(bigInteger);
            BigInteger bigInteger3 = bigInteger.shiftLeft(n5 * 8).subtract(bigInteger);
            int n12 = byArray6.length;
            for (int i = 0; i < n12; i += n5) {
                byte[] byArray9 = new byte[n5];
                System.arraycopy(byArray6, i, byArray9, 0, n5);
                BigInteger bigInteger4 = new BigInteger(1, byArray9).add(bigInteger2).and(bigInteger3);
                Utils.toByteArray(bigInteger4, byArray6, i, n5);
            }
            System.arraycopy(messageDigest.digestBits, 0, byArray7, n10, Math.min(n - n10, n4));
        }
        return byArray7;
    }

    public byte[] decrypt(byte[] byArray) throws CipherException {
        if (this.mode == -1 || this.mode == 0) {
            return this.decryptPKCS5(byArray);
        }
        return this.decryptPKCS12(byArray);
    }

    private byte[] decryptPKCS5(byte[] byArray) throws CipherException {
        byte[] byArray2;
        MessageDigest messageDigest;
        try {
            messageDigest = this.mode == 0 ? MessageDigest.getInstance(AlgID.md5) : MessageDigest.getInstance(AlgID.md2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        if (this.passwd == null) {
            throw new CipherException("Decryption password not set");
        }
        boolean bl = false;
        try {
            byArray2 = this.passwd.getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray2 = this.passwd.getBytes();
            bl = true;
        }
        try {
            return this.decryptPKCS5(messageDigest, byArray2, this.salt, this.count, byArray);
        }
        catch (CipherException cipherException) {
            if (!bl) {
                Utils.setArray(byArray2, (byte)0);
                byArray2 = this.passwd.getBytes();
                return this.decryptPKCS5(messageDigest, byArray2, this.salt, this.count, byArray);
            }
            throw cipherException;
        }
    }

    private byte[] decryptPKCS5(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws CipherException {
        Cipher cipher;
        messageDigest.init();
        messageDigest.update(byArray);
        messageDigest.update(byArray2);
        messageDigest.computeCurrent();
        byte[] byArray4 = messageDigest.digestBits;
        int n2 = n - 1;
        for (int i = 0; i < n2; ++i) {
            messageDigest.init();
            messageDigest.update(byArray4);
            messageDigest.computeCurrent();
            byArray4 = messageDigest.digestBits;
        }
        byte[] byArray5 = new byte[8];
        byte[] byArray6 = new byte[8];
        System.arraycopy(byArray4, 0, byArray5, 0, 8);
        System.arraycopy(byArray4, 8, byArray6, 0, 8);
        try {
            cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.desCBC.getOID(), new ASN1OctetString(byArray6)));
            cipher.setKey(new SymmetricKey(byArray5));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        return cipher.decrypt(byArray3, true);
    }

    private byte[] decryptPKCS12(byte[] byArray) throws CipherException {
        int n = 0;
        int n2 = 0;
        AlgorithmIdentifier algorithmIdentifier = null;
        switch (this.mode) {
            case 1: {
                n = 16;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 2: {
                n = 5;
                n2 = 0;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 3: {
                n = 24;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 4: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 5: {
                n = 16;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
                break;
            }
            case 6: {
                n = 5;
                n2 = 8;
                algorithmIdentifier = AlgID.sha_1;
            }
        }
        if (this.passwd == null) {
            throw new CipherException("Decryption password not set");
        }
        byte[] byArray2 = PKCS5.pkcs12PseudoRandomBytes((byte)1, n, algorithmIdentifier, this.passwd, this.salt, this.count);
        byte[] byArray3 = null;
        if (n2 != 0) {
            byArray3 = PKCS5.pkcs12PseudoRandomBytes((byte)2, n2, algorithmIdentifier, this.passwd, this.salt, this.count);
        }
        Cipher cipher = null;
        try {
            switch (this.mode) {
                case 1: 
                case 2: {
                    cipher = Cipher.getInstance(AlgID.RC4);
                    break;
                }
                case 3: {
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)));
                    break;
                }
                case 4: {
                    byte[] byArray4 = new byte[24];
                    System.arraycopy(byArray2, 0, byArray4, 0, 16);
                    System.arraycopy(byArray2, 0, byArray4, 16, 8);
                    byArray2 = byArray4;
                    cipher = Cipher.getInstance(new CBCAlgorithmIdentifier(AlgID.DES_EDE3_CBC.getOID(), new ASN1OctetString(byArray3)));
                    break;
                }
                case 5: 
                case 6: {
                    cipher = Cipher.getInstance(new RC2AlgorithmIdentifier(byArray3, byArray2.length * 8));
                }
            }
            cipher.setKey(new SymmetricKey(byArray2));
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new CipherException(algorithmIdentifierException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CipherException(invalidKeyException.toString());
        }
        return cipher.decrypt(byArray, true);
    }

    public int encryptedLength(int n) {
        int n2 = 0;
        switch (this.mode) {
            case -1: 
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 8;
                break;
            }
            case 1: 
            case 2: {
                n2 = 1;
            }
        }
        if (n2 == 1) {
            return n;
        }
        return n + n2 - n % n2;
    }

    public void setMode(int n) {
        this.mode = n;
        if (this.mode < -1 || this.mode > 6) {
            throw new IllegalArgumentException("Unsupported mode " + n);
        }
        this.contents = null;
    }

    public int getMode() {
        return this.mode;
    }

    public void setPassword(String string) {
        this.passwd = string;
    }

    public void setPassword(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((char)(byArray[i] & 0xFF));
        }
        this.passwd = stringBuffer.toString();
    }

    public String getPassword() {
        return this.passwd;
    }

    public void setSalt(byte[] byArray) {
        this.salt = byArray;
        this.contents = null;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public void setCount(int n) {
        this.count = n;
        this.contents = null;
    }

    public int getCount() {
        return this.count;
    }

    public void setMode(ASN1ObjectID aSN1ObjectID) throws IOException {
        if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 5, 1)) {
            this.setMode(-1);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 5, 3)) {
            this.setMode(0);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 1)) {
            this.setMode(1);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 2)) {
            this.setMode(2);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 3)) {
            this.setMode(3);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 4)) {
            this.setMode(4);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 5)) {
            this.setMode(5);
        } else if (aSN1ObjectID.equals(ASN1Utils.pkcsID, 12, 1, 6)) {
            this.setMode(6);
        } else {
            throw new IOException("Unknown PKCS5/12 algorithm");
        }
    }

    public ASN1ObjectID getModeID() {
        switch (this.mode) {
            case -1: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 5, 1);
            }
            case 0: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 5, 3);
            }
            case 1: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 1);
            }
            case 2: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 2);
            }
            case 3: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 3);
            }
            case 4: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 4);
            }
            case 5: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 5);
            }
            case 6: {
                return new ASN1ObjectID(ASN1Utils.pkcsID, 12, 1, 6);
            }
        }
        return null;
    }

    public void outputAlgID(OutputStream outputStream) throws IOException {
        this.outputAlgIDASN1().output(outputStream);
    }

    public ASN1Sequence outputAlgIDASN1() {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(this.getModeID());
        aSN1Sequence.addElement(this.outputASN1());
        return aSN1Sequence;
    }

    @Override
    public void output(OutputStream outputStream) throws IOException {
        this.outputASN1().output(outputStream);
    }

    private ASN1Sequence outputASN1() {
        if (this.contents != null) {
            return this.contents;
        }
        if (this.salt == null) {
            this.salt = this.makeSalt(RandomBitsSource.getDefault());
        }
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1OctetString(this.salt));
        aSN1Sequence.addElement(new ASN1Integer(this.count));
        this.contents = aSN1Sequence;
        return this.contents;
    }

    public void inputAlgID(InputStream inputStream) throws IOException {
        this.inputAlgID(new ASN1Sequence(inputStream));
    }

    public void inputAlgID(ASN1Sequence aSN1Sequence) throws IOException {
        try {
            this.setMode((ASN1ObjectID)aSN1Sequence.elementAt(0));
            this.input((ASN1Sequence)aSN1Sequence.elementAt(1));
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        this.input(new ASN1Sequence(inputStream));
    }

    private void input(ASN1Sequence aSN1Sequence) throws IOException {
        this.contents = aSN1Sequence;
        try {
            this.salt = ((ASN1OctetString)aSN1Sequence.elementAt(0)).getValue();
            this.count = ((ASN1Integer)aSN1Sequence.elementAt(1)).getValue().intValue();
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    @Override
    public int length() {
        return this.outputASN1().length();
    }

    public String algName() {
        return "PKCS5";
    }

    public static String modeString(int n) {
        String[] stringArray = new String[]{"NONE", "MD2_DES", "MD5_DES", "SHA_128RC4", "SHA_40RC4", "SHA_3DES", "SHA_2DES", "SHA_128RC2", "SHA_40RC2"};
        return stringArray[n + 2];
    }

    public String toString() {
        return "mode = " + PKCS5.modeString(this.mode) + ", salt = " + Utils.toHexString(this.salt) + ", count = " + this.count;
    }
}

