/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1Integer;
import com.phaos.ASN1.ASN1Null;
import com.phaos.ASN1.ASN1Object;
import com.phaos.ASN1.ASN1OctetString;
import com.phaos.ASN1.ASN1Sequence;
import com.phaos.crypto.AlgID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.AlgorithmIdentifierException;
import com.phaos.utils.InvalidFormatException;
import com.phaos.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;

public class PBMacAlgID
extends AlgorithmIdentifier {
    private byte[] salt;
    private AlgorithmIdentifier owf;
    private BigInteger count;
    private AlgorithmIdentifier mac;

    public PBMacAlgID() {
        super(AlgID.PasswordBasedMac.getOID());
    }

    public PBMacAlgID(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier2) throws AlgorithmIdentifierException {
        this(PBMacAlgID.makeParameters(byArray, algorithmIdentifier, bigInteger, algorithmIdentifier2));
    }

    public PBMacAlgID(ASN1Object aSN1Object) throws AlgorithmIdentifierException {
        super(AlgID.PasswordBasedMac.getOID(), aSN1Object);
        this.decodeParameters();
    }

    public PBMacAlgID(InputStream inputStream) throws IOException {
        this.input(inputStream);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public AlgorithmIdentifier getOwfAlgID() {
        return this.owf;
    }

    public BigInteger getCount() {
        return this.count;
    }

    public AlgorithmIdentifier getMacAlgID() {
        return this.mac;
    }

    private static ASN1Object makeParameters(byte[] byArray, AlgorithmIdentifier algorithmIdentifier, BigInteger bigInteger, AlgorithmIdentifier algorithmIdentifier2) {
        ASN1Sequence aSN1Sequence = new ASN1Sequence();
        aSN1Sequence.addElement(new ASN1OctetString(byArray));
        aSN1Sequence.addElement(algorithmIdentifier);
        aSN1Sequence.addElement(new ASN1Integer(bigInteger));
        aSN1Sequence.addElement(algorithmIdentifier2);
        return aSN1Sequence;
    }

    private void decodeParameters() throws AlgorithmIdentifierException {
        ASN1Object aSN1Object = this.getParameters();
        if (aSN1Object != null && !(aSN1Object instanceof ASN1Null)) {
            try {
                ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Object;
                this.salt = ((ASN1OctetString)aSN1Sequence.elementAt(0)).getValue();
                this.owf = new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(1)));
                this.count = ((ASN1Integer)aSN1Sequence.elementAt(2)).getValue();
                this.mac = new AlgorithmIdentifier(Utils.toStream(aSN1Sequence.elementAt(3)));
            }
            catch (IOException iOException) {
                throw new AlgorithmIdentifierException(iOException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new AlgorithmIdentifierException(classCastException.toString());
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new AlgorithmIdentifierException(arrayIndexOutOfBoundsException.toString());
            }
        }
    }

    @Override
    public Object clone() {
        PBMacAlgID pBMacAlgID;
        byte[] byArray = null;
        AlgorithmIdentifier algorithmIdentifier = null;
        AlgorithmIdentifier algorithmIdentifier2 = null;
        BigInteger bigInteger = null;
        if (this.salt != null) {
            byArray = (byte[])this.salt.clone();
        }
        if (this.owf != null) {
            algorithmIdentifier = (AlgorithmIdentifier)this.owf.clone();
        }
        if (this.mac != null) {
            algorithmIdentifier2 = (AlgorithmIdentifier)this.mac.clone();
        }
        if (this.count != null) {
            bigInteger = new BigInteger(this.count.toByteArray());
        }
        try {
            pBMacAlgID = new PBMacAlgID(byArray, algorithmIdentifier, this.count, algorithmIdentifier2);
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new InvalidFormatException("Invalid algorotihm identifier.");
        }
        return pBMacAlgID;
    }

    @Override
    public void input(InputStream inputStream) throws IOException {
        super.input(inputStream);
        try {
            this.decodeParameters();
        }
        catch (AlgorithmIdentifierException algorithmIdentifierException) {
            throw new IOException(algorithmIdentifierException.toString());
        }
    }
}

