/*
 * Decompiled with CFR 0.152.
 */
package com.phaos.crypto;

import com.phaos.ASN1.ASN1ObjectID;
import com.phaos.crypto.AlgorithmIdentifier;
import com.phaos.crypto.MessageDigest;
import com.phaos.utils.Utils;

public final class MD4
extends MessageDigest {
    private MD4State state = new MD4State();
    private MD4State old = new MD4State();

    public MD4() {
        this.digestBits = new byte[16];
        this.digestValid = false;
    }

    @Override
    public AlgorithmIdentifier getAlgID() {
        return new AlgorithmIdentifier(new ASN1ObjectID(new int[]{1, 2, 840, 113549, 2, 4}));
    }

    @Override
    public int blockSize() {
        return 64;
    }

    @Override
    public void init() {
        if (this.state != null) {
            this.state.init();
        }
        this.digestValid = false;
    }

    @Override
    public void update(byte by) {
        byte[] byArray = this.state.buf;
        int[] nArray = this.state.M;
        if (this.state.count == 64) {
            this.bytesToWords(byArray, nArray);
            this.transform();
            this.state.count = 0;
        }
        byArray[this.state.count++] = by;
        this.state.length += 8L;
        this.digestValid = false;
    }

    @Override
    public void update(byte[] byArray, int n, int n2) {
        this.digestValid = false;
        byte[] byArray2 = this.state.buf;
        int[] nArray = this.state.M;
        this.state.length += (long)(n2 << 3);
        while (n2 > 0) {
            int n3 = 64 - this.state.count;
            if (n2 < n3) {
                System.arraycopy(byArray, n, byArray2, this.state.count, n2);
                this.state.count += n2;
                n2 = 0;
                continue;
            }
            System.arraycopy(byArray, n, byArray2, this.state.count, n3);
            n2 -= n3;
            n += n3;
            this.bytesToWords(byArray2, nArray);
            this.transform();
            this.state.count = 0;
        }
    }

    @Override
    public void computeCurrent() {
        this.state.copyTo(this.old);
        byte[] byArray = this.state.buf;
        int[] nArray = this.state.M;
        this.pad();
        this.update((byte)this.old.length);
        this.update((byte)(this.old.length >> 8));
        this.update((byte)(this.old.length >> 16));
        this.update((byte)(this.old.length >> 24));
        this.update((byte)(this.old.length >> 32));
        this.update((byte)(this.old.length >> 40));
        this.update((byte)(this.old.length >> 48));
        this.update((byte)(this.old.length >> 56));
        this.bytesToWords(byArray, nArray);
        this.transform();
        this.wordsToBytes(this.state.D, this.digestBits);
        this.digestValid = true;
        MD4State mD4State = this.state;
        this.state = this.old;
        this.old = mD4State;
    }

    @Override
    public String algName() {
        return "MD4";
    }

    @Override
    public int getDigestLength() {
        return 16;
    }

    @Override
    public Object clone() {
        MD4 mD4 = new MD4();
        this.state.copyTo(mD4.state);
        System.arraycopy(this.digestBits, 0, mD4.digestBits, 0, this.digestBits.length);
        mD4.digestValid = this.digestValid;
        return mD4;
    }

    private int bytesToWord(byte by, byte by2, byte by3, byte by4) {
        return by & 0xFF | (by2 & 0xFF) << 8 | (by3 & 0xFF) << 16 | (by4 & 0xFF) << 24;
    }

    private void bytesToWords(byte[] byArray, int[] nArray) {
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            nArray[i] = byArray[n2++] & 0xFF | (byArray[n2++] & 0xFF) << 8 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 24;
        }
    }

    private void wordsToBytes(int[] nArray, byte[] byArray) {
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byArray[n2++] = (byte)nArray[i];
            byArray[n2++] = (byte)(nArray[i] >> 8);
            byArray[n2++] = (byte)(nArray[i] >> 16);
            byArray[n2++] = (byte)(nArray[i] >> 24);
        }
    }

    private static int rotl(int n, int n2) {
        return n << n2 | n >>> 32 - n2;
    }

    private static int FF(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        return MD4.rotl(n + (n2 & n3 | ~n2 & n4) + nArray[n5], n6);
    }

    private static int GG(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        return MD4.rotl(n + (n2 & n3 | n2 & n4 | n3 & n4) + nArray[n5] + 1518500249, n6);
    }

    private static int HH(int n, int n2, int n3, int n4, int[] nArray, int n5, int n6) {
        return MD4.rotl(n + (n2 ^ n3 ^ n4) + nArray[n5] + 1859775393, n6);
    }

    private void pad() {
        this.update((byte)-128);
        if (this.state.count > 56) {
            this.update(new byte[64 - this.state.count + 56]);
        } else if (this.state.count < 56) {
            this.update(new byte[56 - this.state.count]);
        }
    }

    private void transform() {
        int n = this.state.D[0];
        int n2 = this.state.D[1];
        int n3 = this.state.D[2];
        int n4 = this.state.D[3];
        int[] nArray = this.state.M;
        n = MD4.FF(n, n2, n3, n4, nArray, 0, 3);
        n4 = MD4.FF(n4, n, n2, n3, nArray, 1, 7);
        n3 = MD4.FF(n3, n4, n, n2, nArray, 2, 11);
        n2 = MD4.FF(n2, n3, n4, n, nArray, 3, 19);
        n = MD4.FF(n, n2, n3, n4, nArray, 4, 3);
        n4 = MD4.FF(n4, n, n2, n3, nArray, 5, 7);
        n3 = MD4.FF(n3, n4, n, n2, nArray, 6, 11);
        n2 = MD4.FF(n2, n3, n4, n, nArray, 7, 19);
        n = MD4.FF(n, n2, n3, n4, nArray, 8, 3);
        n4 = MD4.FF(n4, n, n2, n3, nArray, 9, 7);
        n3 = MD4.FF(n3, n4, n, n2, nArray, 10, 11);
        n2 = MD4.FF(n2, n3, n4, n, nArray, 11, 19);
        n = MD4.FF(n, n2, n3, n4, nArray, 12, 3);
        n4 = MD4.FF(n4, n, n2, n3, nArray, 13, 7);
        n3 = MD4.FF(n3, n4, n, n2, nArray, 14, 11);
        n2 = MD4.FF(n2, n3, n4, n, nArray, 15, 19);
        n = MD4.GG(n, n2, n3, n4, nArray, 0, 3);
        n4 = MD4.GG(n4, n, n2, n3, nArray, 4, 5);
        n3 = MD4.GG(n3, n4, n, n2, nArray, 8, 9);
        n2 = MD4.GG(n2, n3, n4, n, nArray, 12, 13);
        n = MD4.GG(n, n2, n3, n4, nArray, 1, 3);
        n4 = MD4.GG(n4, n, n2, n3, nArray, 5, 5);
        n3 = MD4.GG(n3, n4, n, n2, nArray, 9, 9);
        n2 = MD4.GG(n2, n3, n4, n, nArray, 13, 13);
        n = MD4.GG(n, n2, n3, n4, nArray, 2, 3);
        n4 = MD4.GG(n4, n, n2, n3, nArray, 6, 5);
        n3 = MD4.GG(n3, n4, n, n2, nArray, 10, 9);
        n2 = MD4.GG(n2, n3, n4, n, nArray, 14, 13);
        n = MD4.GG(n, n2, n3, n4, nArray, 3, 3);
        n4 = MD4.GG(n4, n, n2, n3, nArray, 7, 5);
        n3 = MD4.GG(n3, n4, n, n2, nArray, 11, 9);
        n2 = MD4.GG(n2, n3, n4, n, nArray, 15, 13);
        n = MD4.HH(n, n2, n3, n4, nArray, 0, 3);
        n4 = MD4.HH(n4, n, n2, n3, nArray, 8, 9);
        n3 = MD4.HH(n3, n4, n, n2, nArray, 4, 11);
        n2 = MD4.HH(n2, n3, n4, n, nArray, 12, 15);
        n = MD4.HH(n, n2, n3, n4, nArray, 2, 3);
        n4 = MD4.HH(n4, n, n2, n3, nArray, 10, 9);
        n3 = MD4.HH(n3, n4, n, n2, nArray, 6, 11);
        n2 = MD4.HH(n2, n3, n4, n, nArray, 14, 15);
        n = MD4.HH(n, n2, n3, n4, nArray, 1, 3);
        n4 = MD4.HH(n4, n, n2, n3, nArray, 9, 9);
        n3 = MD4.HH(n3, n4, n, n2, nArray, 5, 11);
        n2 = MD4.HH(n2, n3, n4, n, nArray, 13, 15);
        n = MD4.HH(n, n2, n3, n4, nArray, 3, 3);
        n4 = MD4.HH(n4, n, n2, n3, nArray, 11, 9);
        n3 = MD4.HH(n3, n4, n, n2, nArray, 7, 11);
        n2 = MD4.HH(n2, n3, n4, n, nArray, 15, 15);
        this.state.D[0] = this.state.D[0] + n;
        this.state.D[1] = this.state.D[1] + n2;
        this.state.D[2] = this.state.D[2] + n3;
        this.state.D[3] = this.state.D[3] + n4;
    }

    @Override
    protected MessageDigest.MDState getState() {
        return this.state;
    }

    @Override
    protected void setState(MessageDigest.MDState mDState) {
        mDState.copyTo(this.state);
        this.digestValid = false;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("MD4 Test Suite");
            MD4 mD4 = new MD4();
            System.out.println("MD4[] = 31d6cfe0d16ae931b73c59d7e0c089c0");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest(new byte[0])));
            System.out.println("MD4[a] = bde52cb31de33e46245e05fbdbd6fb24");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("a".getBytes())));
            System.out.println("MD4[abc] = a448017aaf21d8525fc10ae87aa6729d");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("abc".getBytes())));
            System.out.println("MD4[message digest] = d9130a8164549fe818874806e1c7014b");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("message digest".getBytes())));
            System.out.println("MD4[abcdefghijklmnopqrstuvwxyz] = d79e1c308aa5bbcdeea8ed63df412da9");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("abcdefghijklmnopqrstuvwxyz".getBytes())));
            System.out.println("MD4[ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789] = 043f8582f241db351ce627e153e7f0e4");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789".getBytes())));
            System.out.println("MD4[12345678901234567890123456789012345678901234567890123456789012345678901234567890] = e33b4ddc9c38f2199c3e7b164fcc0536");
            mD4.init();
            System.out.println("=> " + Utils.toHexString(mD4.computeDigest("12345678901234567890123456789012345678901234567890123456789012345678901234567890".getBytes())));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    final class MD4State
    extends MessageDigest.MDState {
        byte[] buf;
        int[] M;
        int[] D;
        long length;
        int count;

        MD4State() {
            super(MD4.this);
            this.buf = new byte[64];
            this.M = new int[16];
            this.D = new int[4];
            this.init();
        }

        @Override
        public void init() {
            this.D[0] = 1732584193;
            this.D[1] = -271733879;
            this.D[2] = -1732584194;
            this.D[3] = 271733878;
            this.count = 0;
            this.length = 0;
        }

        @Override
        public Object clone() {
            MD4State mD4State = new MD4State();
            this.copyTo(mD4State);
            return mD4State;
        }

        @Override
        public void copyTo(MessageDigest.MDState mDState) {
            if (this.getClass() != mDState.getClass()) {
                throw new IllegalArgumentException("MD4State required");
            }
            MD4State mD4State = (MD4State)mDState;
            mD4State.length = this.length;
            mD4State.count = this.count;
            System.arraycopy(this.buf, 0, mD4State.buf, 0, 64);
            System.arraycopy(this.D, 0, mD4State.D, 0, 4);
        }
    }
}

